/*
 * Decompiled with CFR 0.152.
 */
package android.text.method;

import android.text.Layout;
import android.text.Spannable;
import android.text.method.MetaKeyKeyListener;
import android.text.method.MovementMethod;
import android.text.method.Touch;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.widget.TextView;

public class ScrollingMovementMethod
implements MovementMethod {
    public static ScrollingMovementMethod sInstance;

    public boolean left(TextView widget, Spannable buffer) {
        Layout layout2 = widget.getLayout();
        int scrolly = widget.getScrollY();
        int scr = widget.getScrollX();
        int em = Math.round(layout2.getPaint().getFontSpacing());
        int padding = widget.getTotalPaddingTop() + widget.getTotalPaddingBottom();
        int top = layout2.getLineForVertical(scrolly);
        int bottom = layout2.getLineForVertical(scrolly + widget.getHeight() - padding);
        int left = Integer.MAX_VALUE;
        for (int i = top; i <= bottom; ++i) {
            left = (int)Math.min((float)left, layout2.getLineLeft(i));
        }
        if (scr > left) {
            int s = Math.max(scr - em, left);
            widget.scrollTo(s, widget.getScrollY());
            return true;
        }
        return false;
    }

    public boolean right(TextView widget, Spannable buffer) {
        Layout layout2 = widget.getLayout();
        int scrolly = widget.getScrollY();
        int scr = widget.getScrollX();
        int em = Math.round(layout2.getPaint().getFontSpacing());
        int padding = widget.getTotalPaddingTop() + widget.getTotalPaddingBottom();
        int top = layout2.getLineForVertical(scrolly);
        int bottom = layout2.getLineForVertical(scrolly + widget.getHeight() - padding);
        int right = 0;
        for (int i = top; i <= bottom; ++i) {
            right = (int)Math.max((float)right, layout2.getLineRight(i));
        }
        padding = widget.getTotalPaddingLeft() + widget.getTotalPaddingRight();
        if (scr < right - (widget.getWidth() - padding)) {
            int s = Math.min(scr + em, right - (widget.getWidth() - padding));
            widget.scrollTo(s, widget.getScrollY());
            return true;
        }
        return false;
    }

    public boolean up(TextView widget, Spannable buffer) {
        int line;
        int linetop;
        Layout layout2 = widget.getLayout();
        int areatop = widget.getScrollY();
        if (areatop == (linetop = layout2.getLineTop(line = layout2.getLineForVertical(areatop)))) {
            --line;
        }
        if (line >= 0) {
            Touch.scrollTo(widget, layout2, widget.getScrollX(), layout2.getLineTop(line));
            return true;
        }
        return false;
    }

    public boolean down(TextView widget, Spannable buffer) {
        Layout layout2 = widget.getLayout();
        int padding = widget.getTotalPaddingTop() + widget.getTotalPaddingBottom();
        int areabot = widget.getScrollY() + widget.getHeight() - padding;
        int line = layout2.getLineForVertical(areabot);
        if (layout2.getLineTop(line + 1) < areabot + 1) {
            ++line;
        }
        if (line <= layout2.getLineCount() - 1) {
            widget.scrollTo(widget.getScrollX(), layout2.getLineTop(line + 1) - (widget.getHeight() - padding));
            Touch.scrollTo(widget, layout2, widget.getScrollX(), widget.getScrollY());
            return true;
        }
        return false;
    }

    public boolean onKeyDown(TextView widget, Spannable buffer, int keyCode, KeyEvent event) {
        return this.executeDown(widget, buffer, keyCode);
    }

    public boolean executeDown(TextView widget, Spannable buffer, int keyCode) {
        boolean handled = false;
        switch (keyCode) {
            case 21: {
                handled |= this.left(widget, buffer);
                break;
            }
            case 22: {
                handled |= this.right(widget, buffer);
                break;
            }
            case 19: {
                handled |= this.up(widget, buffer);
                break;
            }
            case 20: {
                handled |= this.down(widget, buffer);
            }
        }
        return handled;
    }

    public boolean onKeyUp(TextView widget, Spannable buffer, int keyCode, KeyEvent event) {
        return false;
    }

    public boolean onKeyOther(TextView view, Spannable text, KeyEvent event) {
        int code = event.getKeyCode();
        if (code != 0 && event.getAction() == 2) {
            int repeat = event.getRepeatCount();
            boolean first = true;
            boolean handled = false;
            while (--repeat > 0) {
                if (first && this.executeDown(view, text, code)) {
                    handled = true;
                    MetaKeyKeyListener.adjustMetaAfterKeypress(text);
                    MetaKeyKeyListener.resetLockedMeta(text);
                }
                first = false;
            }
            return handled;
        }
        return false;
    }

    public boolean onTrackballEvent(TextView widget, Spannable text, MotionEvent event) {
        return false;
    }

    public boolean onTouchEvent(TextView widget, Spannable buffer, MotionEvent event) {
        return Touch.onTouchEvent(widget, buffer, event);
    }

    public void initialize(TextView widget, Spannable text) {
    }

    public boolean canSelectArbitrarily() {
        return false;
    }

    public void onTakeFocus(TextView widget, Spannable text, int dir) {
        Layout layout2 = widget.getLayout();
        if (layout2 != null && (dir & 2) != 0) {
            widget.scrollTo(widget.getScrollX(), layout2.getLineTop(0));
        }
        if (layout2 != null && (dir & 1) != 0) {
            int padding = widget.getTotalPaddingTop() + widget.getTotalPaddingBottom();
            int line = layout2.getLineCount() - 1;
            widget.scrollTo(widget.getScrollX(), layout2.getLineTop(line + 1) - (widget.getHeight() - padding));
        }
    }

    public static MovementMethod getInstance() {
        if (sInstance == null) {
            sInstance = new ScrollingMovementMethod();
        }
        return sInstance;
    }
}

