/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class DebugUtils {
    public static boolean isObjectSelected(Object object) {
        boolean match = false;
        String s = System.getenv("ANDROID_OBJECT_FILTER");
        if (s != null && s.length() > 0) {
            String[] selectors = s.split("@");
            if (object.getClass().getSimpleName().matches(selectors[0])) {
                for (int i = 1; i < selectors.length; ++i) {
                    String[] pair = selectors[i].split("=");
                    Class<?> klass = object.getClass();
                    try {
                        Method declaredMethod = null;
                        Class<?> parent = klass;
                        do {
                            declaredMethod = parent.getDeclaredMethod("get" + pair[0].substring(0, 1).toUpperCase() + pair[0].substring(1), null);
                        } while ((parent = klass.getSuperclass()) != null && declaredMethod == null);
                        if (declaredMethod == null) continue;
                        Object value = declaredMethod.invoke(object, (Object[])null);
                        match |= (value != null ? value.toString() : "null").matches(pair[1]);
                        continue;
                    }
                    catch (NoSuchMethodException e) {
                        e.printStackTrace();
                        continue;
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                        continue;
                    }
                    catch (InvocationTargetException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return match;
    }
}

