/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import android.util.Log;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class EventLogTags {
    public static final String TAG = "EventLogTags";
    public static final String TAGS_FILE = "/etc/event-log-tags";
    public static final Pattern COMMENT_PATTERN = Pattern.compile("^\\s*(#.*)?$");
    public static final Pattern TAG_PATTERN = Pattern.compile("^\\s*(\\d+)\\s+(\\w+)\\s*(\\(.*\\))?\\s*$");
    public final HashMap<String, Description> mNameMap = new HashMap();
    public final HashMap<Integer, Description> mTagMap = new HashMap();

    public EventLogTags() throws IOException {
        this(new BufferedReader(new FileReader(TAGS_FILE), 256));
    }

    public EventLogTags(BufferedReader input) throws IOException {
        String line;
        while ((line = input.readLine()) != null) {
            Matcher m = COMMENT_PATTERN.matcher(line);
            if (m.matches()) continue;
            m = TAG_PATTERN.matcher(line);
            if (m.matches()) {
                try {
                    int tag = Integer.parseInt(m.group(1));
                    Description d = new Description(tag, m.group(2));
                    this.mNameMap.put(d.mName, d);
                    this.mTagMap.put(d.mTag, d);
                }
                catch (NumberFormatException e) {
                    Log.e(TAG, "Error in event log tags entry: " + line, e);
                }
                continue;
            }
            Log.e(TAG, "Can't parse event log tags entry: " + line);
        }
    }

    public Description get(String name) {
        return this.mNameMap.get(name);
    }

    public Description get(int tag) {
        return this.mTagMap.get(tag);
    }

    public static class Description {
        public final int mTag;
        public final String mName;

        public Description(int tag, String name) {
            this.mTag = tag;
            this.mName = name;
        }
    }
}

