/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import android.util.AttributeSet;
import android.util.XmlPullAttributes;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import org.apache.harmony.xml.ExpatPullParser;
import org.apache.harmony.xml.ExpatReader;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;
import org.xmlpull.v1.XmlSerializer;

public class Xml {
    public static String FEATURE_RELAXED = "http://xmlpull.org/v1/doc/features.html#relaxed";

    public static void parse(String xml2, ContentHandler contentHandler) throws SAXException {
        try {
            ExpatReader reader = new ExpatReader();
            reader.setContentHandler(contentHandler);
            reader.parse(new InputSource(new StringReader(xml2)));
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static void parse(Reader in, ContentHandler contentHandler) throws IOException, SAXException {
        ExpatReader reader = new ExpatReader();
        reader.setContentHandler(contentHandler);
        reader.parse(new InputSource(in));
    }

    public static void parse(InputStream in, Encoding encoding, ContentHandler contentHandler) throws IOException, SAXException {
        try {
            ExpatReader reader = new ExpatReader();
            reader.setContentHandler(contentHandler);
            InputSource source = new InputSource(in);
            source.setEncoding(encoding.expatName);
            reader.parse(source);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static XmlPullParser newPullParser() {
        ExpatPullParser parser = new ExpatPullParser();
        parser.setNamespaceProcessingEnabled(true);
        return parser;
    }

    public static XmlSerializer newSerializer() {
        try {
            return XmlSerializerFactory.instance.newSerializer();
        }
        catch (XmlPullParserException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static Encoding findEncodingByName(String encodingName) throws UnsupportedEncodingException {
        if (encodingName == null) {
            return Encoding.UTF_8;
        }
        for (Encoding encoding : Encoding.values()) {
            if (!encoding.expatName.equalsIgnoreCase(encodingName)) continue;
            return encoding;
        }
        throw new UnsupportedEncodingException(encodingName);
    }

    public static AttributeSet asAttributeSet(XmlPullParser parser) {
        return parser instanceof AttributeSet ? (AttributeSet)((Object)parser) : new XmlPullAttributes(parser);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Encoding {
        US_ASCII("US-ASCII"),
        UTF_8("UTF-8"),
        UTF_16("UTF-16"),
        ISO_8859_1("ISO-8859-1");

        public final String expatName;

        public Encoding(String expatName) {
            this.expatName = expatName;
        }
    }

    public static class XmlSerializerFactory {
        public static final String TYPE = "org.kxml2.io.KXmlParser,org.kxml2.io.KXmlSerializer";
        public static final XmlPullParserFactory instance;

        static {
            try {
                instance = XmlPullParserFactory.newInstance(TYPE, null);
            }
            catch (XmlPullParserException e) {
                throw new AssertionError((Object)e);
            }
        }
    }
}

