/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.content.Context;
import android.util.AttributeSet;
import android.view.InflateException;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.android.layoutlib.api.IProjectCallback;
import com.android.layoutlib.api.IResourceValue;
import com.android.layoutlib.bridge.Bridge;
import com.android.layoutlib.bridge.BridgeContext;
import com.android.layoutlib.bridge.BridgeXmlBlockParser;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import org.kxml2.io.KXmlParser;
import org.xmlpull.v1.XmlPullParser;

public final class BridgeInflater
extends LayoutInflater {
    private final IProjectCallback mProjectCallback;
    private static final String[] sClassPrefixList = new String[]{"android.widget.", "android.webkit."};

    protected BridgeInflater(LayoutInflater original, Context newContext) {
        super(original, newContext);
        this.mProjectCallback = null;
    }

    public BridgeInflater(Context context, IProjectCallback projectCallback) {
        super(context);
        this.mProjectCallback = projectCallback;
        this.mConstructorArgs[0] = context;
    }

    public View onCreateView(String name, AttributeSet attrs) throws ClassNotFoundException {
        View view = null;
        try {
            for (String prefix : sClassPrefixList) {
                try {
                    view = this.createView(name, prefix, attrs);
                    if (view == null) continue;
                    break;
                }
                catch (ClassNotFoundException e) {
                    // empty catch block
                }
            }
            try {
                if (view == null) {
                    view = super.onCreateView(name, attrs);
                }
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
            if (view == null) {
                view = this.loadCustomView(name, attrs);
            }
        }
        catch (Exception e) {
            ClassNotFoundException exception = new ClassNotFoundException("onCreateView", e);
            throw exception;
        }
        this.setupViewInContext(view, attrs);
        return view;
    }

    public View createViewFromTag(String name, AttributeSet attrs) {
        View view = null;
        try {
            view = super.createViewFromTag(name, attrs);
        }
        catch (InflateException e) {
            try {
                view = this.loadCustomView(name, attrs);
            }
            catch (Exception e2) {
                InflateException exception = new InflateException();
                if (!e2.getClass().equals(ClassNotFoundException.class)) {
                    exception.initCause(e2);
                } else {
                    exception.initCause(e);
                }
                throw exception;
            }
        }
        this.setupViewInContext(view, attrs);
        return view;
    }

    public View inflate(int resource, ViewGroup root) {
        Context context = this.getContext();
        if (context instanceof BridgeContext) {
            File f;
            BridgeContext bridgeContext = (BridgeContext)context;
            IResourceValue value = null;
            String[] layoutInfo = Bridge.resolveResourceValue(resource);
            if (layoutInfo != null) {
                value = bridgeContext.getFrameworkResource("layout", layoutInfo[0]);
            } else {
                layoutInfo = this.mProjectCallback.resolveResourceValue(resource);
                if (layoutInfo != null) {
                    value = bridgeContext.getProjectResource("layout", layoutInfo[0]);
                }
            }
            if (value != null && (f = new File(value.getValue())).isFile()) {
                try {
                    KXmlParser parser = new KXmlParser();
                    parser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
                    parser.setInput((Reader)new FileReader(f));
                    BridgeXmlBlockParser bridgeParser = new BridgeXmlBlockParser((XmlPullParser)parser, bridgeContext, false);
                    return this.inflate(bridgeParser, root);
                }
                catch (Exception e) {
                    bridgeContext.getLogger().error((Throwable)e);
                }
            }
        }
        return null;
    }

    private View loadCustomView(String name, AttributeSet attrs) throws ClassNotFoundException, Exception {
        if (this.mProjectCallback != null) {
            if (name.equals("view")) {
                name = attrs.getAttributeValue(null, "class");
            }
            this.mConstructorArgs[1] = attrs;
            Object customView = this.mProjectCallback.loadView(name, mConstructorSignature, this.mConstructorArgs);
            if (customView instanceof View) {
                return (View)customView;
            }
        }
        return null;
    }

    private void setupViewInContext(View view, AttributeSet attrs) {
        if (this.getContext() instanceof BridgeContext) {
            Object viewKey;
            BridgeContext bc = (BridgeContext)this.getContext();
            if (attrs instanceof BridgeXmlBlockParser && (viewKey = ((BridgeXmlBlockParser)attrs).getViewKey()) != null) {
                bc.addViewKey(view, viewKey);
            }
        }
    }

    public LayoutInflater cloneInContext(Context newContext) {
        return new BridgeInflater(this, newContext);
    }
}

