/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.content.Context;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.util.AttributeSet;
import android.util.Xml;
import android.view.InflateException;
import android.view.View;
import android.view.ViewGroup;
import com.android.internal.R;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public abstract class LayoutInflater {
    public final boolean DEBUG = false;
    public final Context mContext;
    public boolean mFactorySet;
    public Factory mFactory;
    public Filter mFilter;
    public final Object[] mConstructorArgs = new Object[2];
    public static final Class[] mConstructorSignature = new Class[]{Context.class, AttributeSet.class};
    public static final HashMap<String, Constructor> sConstructorMap = new HashMap();
    public HashMap<String, Boolean> mFilterMap;
    public static final String TAG_MERGE = "merge";
    public static final String TAG_INCLUDE = "include";
    public static final String TAG_REQUEST_FOCUS = "requestFocus";

    public LayoutInflater(Context context) {
        this.mContext = context;
    }

    public LayoutInflater(LayoutInflater original, Context newContext) {
        this.mContext = newContext;
        this.mFactory = original.mFactory;
        this.mFilter = original.mFilter;
    }

    public static LayoutInflater from(Context context) {
        LayoutInflater LayoutInflater2 = (LayoutInflater)context.getSystemService("layout_inflater");
        if (LayoutInflater2 == null) {
            throw new AssertionError((Object)"LayoutInflater not found.");
        }
        return LayoutInflater2;
    }

    public abstract LayoutInflater cloneInContext(Context var1);

    public Context getContext() {
        return this.mContext;
    }

    public Factory getFactory() {
        return this.mFactory;
    }

    public void setFactory(Factory factory) {
        if (this.mFactorySet) {
            throw new IllegalStateException("A factory has already been set on this LayoutInflater");
        }
        if (factory == null) {
            throw new NullPointerException("Given factory can not be null");
        }
        this.mFactorySet = true;
        this.mFactory = this.mFactory == null ? factory : new FactoryMerger(factory, this.mFactory);
    }

    public Filter getFilter() {
        return this.mFilter;
    }

    public void setFilter(Filter filter) {
        this.mFilter = filter;
        if (filter != null) {
            this.mFilterMap = new HashMap();
        }
    }

    public View inflate(int resource, ViewGroup root) {
        return this.inflate(resource, root, root != null);
    }

    public View inflate(XmlPullParser parser, ViewGroup root) {
        return this.inflate(parser, root, root != null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public View inflate(int resource, ViewGroup root, boolean attachToRoot) {
        XmlResourceParser parser = this.getContext().getResources().getLayout(resource);
        try {
            View view = this.inflate(parser, root, attachToRoot);
            Object var7_6 = null;
            parser.close();
            return view;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            parser.close();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public View inflate(XmlPullParser parser, ViewGroup root, boolean attachToRoot) {
        Object[] objectArray = this.mConstructorArgs;
        synchronized (this.mConstructorArgs) {
            AttributeSet attrs = Xml.asAttributeSet(parser);
            this.mConstructorArgs[0] = this.mContext;
            View result = root;
            try {
                int type;
                while ((type = parser.next()) != 2 && type != 1) {
                }
                if (type != 2) {
                    throw new InflateException(parser.getPositionDescription() + ": No start tag found!");
                }
                String name = parser.getName();
                if (TAG_MERGE.equals(name)) {
                    if (root == null || !attachToRoot) {
                        throw new InflateException("<merge /> can be used only with a valid ViewGroup root and attachToRoot=true");
                    }
                    this.rInflate(parser, root, attrs);
                } else {
                    View temp = this.createViewFromTag(name, attrs);
                    ViewGroup.LayoutParams params = null;
                    if (root != null) {
                        params = root.generateLayoutParams(attrs);
                        if (!attachToRoot) {
                            temp.setLayoutParams(params);
                        }
                    }
                    this.rInflate(parser, temp, attrs);
                    if (root != null && attachToRoot) {
                        root.addView(temp, params);
                    }
                    if (root == null || !attachToRoot) {
                        result = temp;
                    }
                }
            }
            catch (XmlPullParserException e) {
                InflateException ex = new InflateException(e.getMessage());
                ex.initCause(e);
                throw ex;
            }
            catch (IOException e) {
                InflateException ex = new InflateException(parser.getPositionDescription() + ": " + e.getMessage());
                ex.initCause(e);
                throw ex;
            }
            return result;
        }
    }

    public View createView(String name, String prefix, AttributeSet attrs) throws ClassNotFoundException, InflateException {
        Constructor<?> constructor = sConstructorMap.get(name);
        Class<?> clazz = null;
        try {
            if (constructor == null) {
                boolean allowed;
                clazz = this.mContext.getClassLoader().loadClass(prefix != null ? prefix + name : name);
                if (this.mFilter != null && clazz != null && !(allowed = this.mFilter.onLoadClass(clazz))) {
                    this.failNotAllowed(name, prefix, attrs);
                }
                constructor = clazz.getConstructor(mConstructorSignature);
                sConstructorMap.put(name, constructor);
            } else if (this.mFilter != null) {
                Boolean allowedState = this.mFilterMap.get(name);
                if (allowedState == null) {
                    clazz = this.mContext.getClassLoader().loadClass(prefix != null ? prefix + name : name);
                    boolean allowed = clazz != null && this.mFilter.onLoadClass(clazz);
                    this.mFilterMap.put(name, allowed);
                    if (!allowed) {
                        this.failNotAllowed(name, prefix, attrs);
                    }
                } else if (allowedState.equals(Boolean.FALSE)) {
                    this.failNotAllowed(name, prefix, attrs);
                }
            }
            Object[] args = this.mConstructorArgs;
            args[1] = attrs;
            return (View)constructor.newInstance(args);
        }
        catch (NoSuchMethodException e) {
            InflateException ie = new InflateException(attrs.getPositionDescription() + ": Error inflating class " + (prefix != null ? prefix + name : name));
            ie.initCause(e);
            throw ie;
        }
        catch (ClassNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            InflateException ie = new InflateException(attrs.getPositionDescription() + ": Error inflating class " + (clazz == null ? "<unknown>" : clazz.getName()));
            ie.initCause(e);
            throw ie;
        }
    }

    public void failNotAllowed(String name, String prefix, AttributeSet attrs) {
        InflateException ie = new InflateException(attrs.getPositionDescription() + ": Class not allowed to be inflated " + (prefix != null ? prefix + name : name));
        throw ie;
    }

    public View onCreateView(String name, AttributeSet attrs) throws ClassNotFoundException {
        return this.createView(name, "android.view.", attrs);
    }

    public View createViewFromTag(String name, AttributeSet attrs) {
        if (name.equals("view")) {
            name = attrs.getAttributeValue(null, "class");
        }
        try {
            View view;
            View view2 = view = this.mFactory == null ? null : this.mFactory.onCreateView(name, this.mContext, attrs);
            if (view == null) {
                view = -1 == name.indexOf(46) ? this.onCreateView(name, attrs) : this.createView(name, null, attrs);
            }
            return view;
        }
        catch (InflateException e) {
            throw e;
        }
        catch (ClassNotFoundException e) {
            InflateException ie = new InflateException(attrs.getPositionDescription() + ": Error inflating class " + name);
            ie.initCause(e);
            throw ie;
        }
        catch (Exception e) {
            InflateException ie = new InflateException(attrs.getPositionDescription() + ": Error inflating class " + name);
            ie.initCause(e);
            throw ie;
        }
    }

    public void rInflate(XmlPullParser parser, View parent, AttributeSet attrs) throws XmlPullParserException, IOException {
        int type;
        int depth = parser.getDepth();
        while (((type = parser.next()) != 3 || parser.getDepth() > depth) && type != 1) {
            if (type != 2) continue;
            String name = parser.getName();
            if (TAG_REQUEST_FOCUS.equals(name)) {
                this.parseRequestFocus(parser, parent);
                continue;
            }
            if (TAG_INCLUDE.equals(name)) {
                if (parser.getDepth() == 0) {
                    throw new InflateException("<include /> cannot be the root element");
                }
                this.parseInclude(parser, parent, attrs);
                continue;
            }
            if (TAG_MERGE.equals(name)) {
                throw new InflateException("<merge /> must be the root element");
            }
            View view = this.createViewFromTag(name, attrs);
            ViewGroup viewGroup = (ViewGroup)parent;
            ViewGroup.LayoutParams params = viewGroup.generateLayoutParams(attrs);
            this.rInflate(parser, view, attrs);
            viewGroup.addView(view, params);
        }
        parent.onFinishInflate();
    }

    public void parseRequestFocus(XmlPullParser parser, View parent) throws XmlPullParserException, IOException {
        int type;
        parent.requestFocus();
        int currentDepth = parser.getDepth();
        while (((type = parser.next()) != 3 || parser.getDepth() > currentDepth) && type != 1) {
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parseInclude(XmlPullParser parser, View parent, AttributeSet attrs) throws XmlPullParserException, IOException {
        int type;
        if (parent instanceof ViewGroup) {
            int layout2 = attrs.getAttributeResourceValue(null, "layout", 0);
            if (layout2 == 0) {
                String value = attrs.getAttributeValue(null, "layout");
                if (value == null) {
                    throw new InflateException("You must specifiy a layout in the include tag: <include layout=\"@layout/layoutID\" />");
                }
                throw new InflateException("You must specifiy a valid layout reference. The layout ID " + value + " is not valid.");
            }
            XmlResourceParser childParser = this.getContext().getResources().getLayout(layout2);
            try {
                AttributeSet childAttrs = Xml.asAttributeSet(childParser);
                while ((type = childParser.next()) != 2 && type != 1) {
                }
                if (type != 2) {
                    throw new InflateException(childParser.getPositionDescription() + ": No start tag found!");
                }
                String childName = childParser.getName();
                if (TAG_MERGE.equals(childName)) {
                    this.rInflate(childParser, parent, childAttrs);
                } else {
                    View view = this.createViewFromTag(childName, childAttrs);
                    ViewGroup group = (ViewGroup)parent;
                    ViewGroup.LayoutParams params = null;
                    try {
                        Object var14_13;
                        try {
                            params = group.generateLayoutParams(attrs);
                        }
                        catch (RuntimeException e) {
                            params = group.generateLayoutParams(childAttrs);
                            var14_13 = null;
                            if (params != null) {
                                view.setLayoutParams(params);
                            }
                        }
                        var14_13 = null;
                        if (params != null) {
                            view.setLayoutParams(params);
                        }
                    }
                    catch (Throwable throwable) {
                        Object var14_14 = null;
                        if (params != null) {
                            view.setLayoutParams(params);
                        }
                        throw throwable;
                    }
                    this.rInflate(childParser, view, childAttrs);
                    TypedArray a = this.mContext.obtainStyledAttributes(attrs, R.styleable.View, 0, 0);
                    int id2 = a.getResourceId(8, -1);
                    int visibility = a.getInt(20, -1);
                    a.recycle();
                    if (id2 != -1) {
                        view.setId(id2);
                    }
                    switch (visibility) {
                        case 0: {
                            view.setVisibility(0);
                            break;
                        }
                        case 1: {
                            view.setVisibility(4);
                            break;
                        }
                        case 2: {
                            view.setVisibility(8);
                        }
                    }
                    group.addView(view);
                }
                Object var16_20 = null;
                childParser.close();
            }
            catch (Throwable throwable) {
                Object var16_21 = null;
                childParser.close();
                throw throwable;
            }
        }
        throw new InflateException("<include /> can only be used inside of a ViewGroup");
        int currentDepth = parser.getDepth();
        while (((type = parser.next()) != 3 || parser.getDepth() > currentDepth) && type != 1) {
        }
    }

    public static class FactoryMerger
    implements Factory {
        public final Factory mF1;
        public final Factory mF2;

        public FactoryMerger(Factory f1, Factory f2) {
            this.mF1 = f1;
            this.mF2 = f2;
        }

        public View onCreateView(String name, Context context, AttributeSet attrs) {
            View v = this.mF1.onCreateView(name, context, attrs);
            if (v != null) {
                return v;
            }
            return this.mF2.onCreateView(name, context, attrs);
        }
    }

    public static interface Factory {
        public View onCreateView(String var1, Context var2, AttributeSet var3);
    }

    public static interface Filter {
        public boolean onLoadClass(Class var1);
    }
}

