/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.net.ParseException;
import android.net.WebAddress;
import android.util.Log;
import android.webkit.CookieSyncManager;
import android.webkit.HttpDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CookieManager {
    public static CookieManager sRef;
    public static final String LOGTAG = "webkit";
    public static final String DOMAIN = "domain";
    public static final String PATH = "path";
    public static final String EXPIRES = "expires";
    public static final String SECURE = "secure";
    public static final String MAX_AGE = "max-age";
    public static final String HTTP_ONLY = "httponly";
    public static final String HTTPS = "https";
    public static final char PERIOD = '.';
    public static final char COMMA = ',';
    public static final char SEMICOLON = ';';
    public static final char EQUAL = '=';
    public static final char PATH_DELIM = '/';
    public static final char QUESTION_MARK = '?';
    public static final char WHITE_SPACE = ' ';
    public static final char QUOTATION = '\"';
    public static final int SECURE_LENGTH;
    public static final int HTTP_ONLY_LENGTH;
    public static final int MAX_COOKIE_LENGTH = 4096;
    public static final int MAX_COOKIE_COUNT_PER_BASE_DOMAIN = 50;
    public static final int MAX_DOMAIN_COUNT = 200;
    public static final int MAX_RAM_COOKIES_COUNT = 1000;
    public static final int MAX_RAM_DOMAIN_COUNT = 15;
    public Map<String, ArrayList<Cookie>> mCookieMap = new LinkedHashMap<String, ArrayList<Cookie>>(200, 0.75f, true);
    public boolean mAcceptCookie = true;
    public static final String[] BAD_COUNTRY_2LDS;
    public static final CookieComparator COMPARATOR;

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException("doesn't implement Cloneable");
    }

    public static synchronized CookieManager getInstance() {
        if (sRef == null) {
            sRef = new CookieManager();
        }
        return sRef;
    }

    public synchronized void setAcceptCookie(boolean accept) {
        this.mAcceptCookie = accept;
    }

    public synchronized boolean acceptCookie() {
        return this.mAcceptCookie;
    }

    public void setCookie(String url, String value) {
        WebAddress uri;
        try {
            uri = new WebAddress(url);
        }
        catch (ParseException ex) {
            Log.e(LOGTAG, "Bad address: " + url);
            return;
        }
        this.setCookie(uri, value);
    }

    public synchronized void setCookie(WebAddress uri, String value) {
        if (value != null && value.length() > 4096) {
            return;
        }
        if (!this.mAcceptCookie || uri == null) {
            return;
        }
        String[] hostAndPath = this.getHostAndPath(uri);
        if (hostAndPath == null) {
            return;
        }
        if (hostAndPath[1].length() > 1) {
            int index = hostAndPath[1].lastIndexOf(47);
            hostAndPath[1] = hostAndPath[1].substring(0, index > 0 ? index : index + 1);
        }
        ArrayList<Cookie> cookies = null;
        try {
            cookies = this.parseCookie(hostAndPath[0], hostAndPath[1], value);
        }
        catch (RuntimeException ex) {
            Log.e(LOGTAG, "parse cookie failed for: " + value);
        }
        if (cookies == null || cookies.size() == 0) {
            return;
        }
        String baseDomain = this.getBaseDomain(hostAndPath[0]);
        ArrayList<Cookie> cookieList = this.mCookieMap.get(baseDomain);
        if (cookieList == null) {
            cookieList = CookieSyncManager.getInstance().getCookiesForDomain(baseDomain);
            this.mCookieMap.put(baseDomain, cookieList);
        }
        long now = System.currentTimeMillis();
        int size = cookies.size();
        for (int i = 0; i < size; ++i) {
            Cookie cookie = cookies.get(i);
            boolean done = false;
            for (Cookie cookieEntry : cookieList) {
                if (!cookie.exactMatch(cookieEntry)) continue;
                if (cookie.expires < 0L || cookie.expires > now) {
                    if (!cookieEntry.secure || HTTPS.equals(uri.mScheme)) {
                        cookieEntry.value = cookie.value;
                        cookieEntry.expires = cookie.expires;
                        cookieEntry.secure = cookie.secure;
                        cookieEntry.lastAcessTime = now;
                        cookieEntry.lastUpdateTime = now;
                        cookieEntry.mode = (byte)3;
                    }
                } else {
                    cookieEntry.lastUpdateTime = now;
                    cookieEntry.mode = (byte)2;
                }
                done = true;
                break;
            }
            if (done || cookie.expires >= 0L && cookie.expires <= now) continue;
            cookie.lastAcessTime = now;
            cookie.lastUpdateTime = now;
            cookie.mode = 0;
            if (cookieList.size() > 50) {
                Cookie toDelete = new Cookie();
                toDelete.lastAcessTime = now;
                for (Cookie cookieEntry2 : cookieList) {
                    if (cookieEntry2.lastAcessTime >= toDelete.lastAcessTime || cookieEntry2.mode == 2) continue;
                    toDelete = cookieEntry2;
                }
                toDelete.mode = (byte)2;
            }
            cookieList.add(cookie);
        }
    }

    public String getCookie(String url) {
        WebAddress uri;
        try {
            uri = new WebAddress(url);
        }
        catch (ParseException ex) {
            Log.e(LOGTAG, "Bad address: " + url);
            return null;
        }
        return this.getCookie(uri);
    }

    public synchronized String getCookie(WebAddress uri) {
        if (!this.mAcceptCookie || uri == null) {
            return null;
        }
        String[] hostAndPath = this.getHostAndPath(uri);
        if (hostAndPath == null) {
            return null;
        }
        String baseDomain = this.getBaseDomain(hostAndPath[0]);
        ArrayList<Cookie> cookieList = this.mCookieMap.get(baseDomain);
        if (cookieList == null) {
            cookieList = CookieSyncManager.getInstance().getCookiesForDomain(baseDomain);
            this.mCookieMap.put(baseDomain, cookieList);
        }
        long now = System.currentTimeMillis();
        boolean secure = HTTPS.equals(uri.mScheme);
        Iterator<Cookie> iter = cookieList.iterator();
        TreeSet<Cookie> cookieSet = new TreeSet<Cookie>(COMPARATOR);
        while (iter.hasNext()) {
            Cookie cookie = iter.next();
            if (!cookie.domainMatch(hostAndPath[0]) || !cookie.pathMatch(hostAndPath[1]) || cookie.expires >= 0L && cookie.expires <= now || cookie.secure && !secure || cookie.mode == 2) continue;
            cookie.lastAcessTime = now;
            cookieSet.add(cookie);
        }
        StringBuilder ret = new StringBuilder(256);
        for (Cookie cookie : cookieSet) {
            if (ret.length() > 0) {
                ret.append(';');
                ret.append(' ');
            }
            ret.append(cookie.name);
            ret.append('=');
            ret.append(cookie.value);
        }
        if (ret.length() > 0) {
            return ret.toString();
        }
        return null;
    }

    public void removeSessionCookie() {
        Runnable clearCache = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                CookieManager cookieManager = CookieManager.this;
                synchronized (cookieManager) {
                    Collection cookieList = CookieManager.this.mCookieMap.values();
                    for (ArrayList list : cookieList) {
                        Iterator iter = list.iterator();
                        while (iter.hasNext()) {
                            Cookie cookie = (Cookie)iter.next();
                            if (cookie.expires != -1L) continue;
                            iter.remove();
                        }
                    }
                    CookieSyncManager.getInstance().clearSessionCookies();
                }
            }
        };
        new Thread(clearCache).start();
    }

    public void removeAllCookie() {
        Runnable clearCache = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                CookieManager cookieManager = CookieManager.this;
                synchronized (cookieManager) {
                    CookieManager.this.mCookieMap = new LinkedHashMap(200, 0.75f, true);
                    CookieSyncManager.getInstance().clearAllCookies();
                }
            }
        };
        new Thread(clearCache).start();
    }

    public synchronized boolean hasCookies() {
        return CookieSyncManager.getInstance().hasCookies();
    }

    public void removeExpiredCookie() {
        Runnable clearCache = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                CookieManager cookieManager = CookieManager.this;
                synchronized (cookieManager) {
                    long now = System.currentTimeMillis();
                    Collection cookieList = CookieManager.this.mCookieMap.values();
                    for (ArrayList list : cookieList) {
                        Iterator iter = list.iterator();
                        while (iter.hasNext()) {
                            Cookie cookie = (Cookie)iter.next();
                            if (cookie.expires <= 0L || cookie.expires >= now) continue;
                            iter.remove();
                        }
                    }
                    CookieSyncManager.getInstance().clearExpiredCookies(now);
                }
            }
        };
        new Thread(clearCache).start();
    }

    public synchronized ArrayList<Cookie> getUpdatedCookiesSince(long last) {
        ArrayList<Cookie> cookies = new ArrayList<Cookie>();
        Collection<ArrayList<Cookie>> cookieList = this.mCookieMap.values();
        for (ArrayList<Cookie> list : cookieList) {
            for (Cookie cookie : list) {
                if (cookie.lastUpdateTime <= last) continue;
                cookies.add(cookie);
            }
        }
        return cookies;
    }

    public synchronized void deleteACookie(Cookie cookie) {
        String baseDomain;
        ArrayList<Cookie> cookieList;
        if (cookie.mode == 2 && (cookieList = this.mCookieMap.get(baseDomain = this.getBaseDomain(cookie.domain))) != null) {
            cookieList.remove(cookie);
            if (cookieList.isEmpty()) {
                this.mCookieMap.remove(baseDomain);
            }
        }
    }

    public synchronized void syncedACookie(Cookie cookie) {
        cookie.mode = 1;
    }

    public synchronized ArrayList<Cookie> deleteLRUDomain() {
        int count;
        boolean byteCount = false;
        int mapSize = this.mCookieMap.size();
        if (mapSize < 15) {
            ArrayList<Cookie> list;
            Collection<ArrayList<Cookie>> cookieLists = this.mCookieMap.values();
            Iterator<ArrayList<Cookie>> listIter = cookieLists.iterator();
            for (count = 0; listIter.hasNext() && count < 1000; count += list.size()) {
                list = listIter.next();
            }
        }
        ArrayList<Cookie> retlist = new ArrayList<Cookie>();
        if (mapSize >= 15 || count >= 1000) {
            Object[] domains = this.mCookieMap.keySet().toArray();
            int toGo = mapSize / 10 + 1;
            while (toGo-- > 0) {
                String domain = domains[toGo].toString();
                retlist.addAll((Collection<Cookie>)this.mCookieMap.get(domain));
                this.mCookieMap.remove(domain);
            }
        }
        return retlist;
    }

    public String[] getHostAndPath(WebAddress uri) {
        if (uri.mHost != null && uri.mPath != null) {
            String[] ret = new String[]{uri.mHost, uri.mPath};
            int index = ret[0].indexOf(46);
            if (index == -1) {
                if (uri.mScheme.equalsIgnoreCase("file")) {
                    ret[0] = "localhost";
                }
            } else if (index == ret[0].lastIndexOf(46)) {
                ret[0] = '.' + ret[0];
            }
            if (ret[1].charAt(0) != '/') {
                return null;
            }
            index = ret[1].indexOf(63);
            if (index != -1) {
                ret[1] = ret[1].substring(0, index);
            }
            return ret;
        }
        return null;
    }

    public String getBaseDomain(String host) {
        int startIndex = 0;
        int nextIndex = host.indexOf(46);
        int lastIndex = host.lastIndexOf(46);
        while (nextIndex < lastIndex) {
            startIndex = nextIndex + 1;
            nextIndex = host.indexOf(46, startIndex);
        }
        if (startIndex > 0) {
            return host.substring(startIndex);
        }
        return host;
    }

    public ArrayList<Cookie> parseCookie(String host, String path, String cookieString) {
        ArrayList<Cookie> ret = new ArrayList<Cookie>();
        int index = 0;
        int length = cookieString.length();
        while (true) {
            Cookie cookie = null;
            if (index < 0 || index >= length) break;
            if (cookieString.charAt(index) == ' ') {
                ++index;
                continue;
            }
            int semicolonIndex = cookieString.indexOf(59, index);
            int equalIndex = cookieString.indexOf(61, index);
            if (equalIndex == -1 || semicolonIndex > -1 && semicolonIndex < equalIndex) break;
            cookie = new Cookie(host, path);
            cookie.name = cookieString.substring(index, equalIndex);
            if (cookieString.charAt(equalIndex + 1) == '\"' && (index = cookieString.indexOf(34, equalIndex + 2)) == -1) break;
            semicolonIndex = cookieString.indexOf(59, index);
            if (semicolonIndex == -1) {
                semicolonIndex = length;
            }
            cookie.value = semicolonIndex - equalIndex > 4096 ? cookieString.substring(equalIndex + 1, equalIndex + 4096) : (equalIndex + 1 == semicolonIndex || semicolonIndex < equalIndex ? "" : cookieString.substring(equalIndex + 1, semicolonIndex));
            index = semicolonIndex;
            while (index >= 0 && index < length) {
                if (cookieString.charAt(index) == ' ' || cookieString.charAt(index) == ';') {
                    ++index;
                    continue;
                }
                if (cookieString.charAt(index) == ',') {
                    ++index;
                    break;
                }
                if (length - index >= SECURE_LENGTH && cookieString.substring(index, index + SECURE_LENGTH).equalsIgnoreCase(SECURE)) {
                    cookie.secure = true;
                    if ((index += SECURE_LENGTH) == length) break;
                    if (cookieString.charAt(index) != '=') continue;
                    ++index;
                    continue;
                }
                if (length - index >= HTTP_ONLY_LENGTH && cookieString.substring(index, index + HTTP_ONLY_LENGTH).equalsIgnoreCase(HTTP_ONLY)) {
                    if ((index += HTTP_ONLY_LENGTH) == length) break;
                    if (cookieString.charAt(index) != '=') continue;
                    ++index;
                    continue;
                }
                equalIndex = cookieString.indexOf(61, index);
                if (equalIndex > 0) {
                    int endQuote;
                    int comaIndex;
                    String name = cookieString.substring(index, equalIndex).toLowerCase();
                    if (name.equals(EXPIRES) && (comaIndex = cookieString.indexOf(44, equalIndex)) != -1 && comaIndex - equalIndex <= 10) {
                        index = comaIndex + 1;
                    }
                    semicolonIndex = cookieString.indexOf(59, index);
                    int commaIndex = cookieString.indexOf(44, index);
                    index = semicolonIndex == -1 && commaIndex == -1 ? length : (semicolonIndex == -1 ? commaIndex : (commaIndex == -1 ? semicolonIndex : Math.min(semicolonIndex, commaIndex)));
                    String value = cookieString.substring(equalIndex + 1, index);
                    if (value.length() > 2 && value.charAt(0) == '\"' && (endQuote = value.indexOf(34, 1)) > 0) {
                        value = value.substring(1, endQuote);
                    }
                    if (name.equals(EXPIRES)) {
                        try {
                            cookie.expires = HttpDateTime.parse(value);
                        }
                        catch (IllegalArgumentException ex) {
                            Log.e(LOGTAG, "illegal format for expires: " + value);
                        }
                        continue;
                    }
                    if (name.equals(MAX_AGE)) {
                        try {
                            cookie.expires = System.currentTimeMillis() + 1000L * Long.parseLong(value);
                        }
                        catch (NumberFormatException ex) {
                            Log.e(LOGTAG, "illegal format for max-age: " + value);
                        }
                        continue;
                    }
                    if (name.equals(PATH)) {
                        if (value.length() <= 0) continue;
                        cookie.path = value;
                        continue;
                    }
                    if (!name.equals(DOMAIN)) continue;
                    int lastPeriod = value.lastIndexOf(46);
                    if (lastPeriod == 0) {
                        cookie.domain = null;
                        continue;
                    }
                    try {
                        Integer.parseInt(value.substring(lastPeriod + 1));
                        if (value.equals(host)) continue;
                        cookie.domain = null;
                    }
                    catch (NumberFormatException ex) {
                        value = value.toLowerCase();
                        if (value.charAt(0) != '.') {
                            value = '.' + value;
                            ++lastPeriod;
                        }
                        if (host.endsWith(value.substring(1))) {
                            String s;
                            int len = value.length();
                            int hostLen = host.length();
                            if (hostLen > len - 1 && host.charAt(hostLen - len) != '.') {
                                cookie.domain = null;
                                continue;
                            }
                            if (len == lastPeriod + 3 && len >= 6 && len <= 8 && Arrays.binarySearch(BAD_COUNTRY_2LDS, s = value.substring(1, lastPeriod)) >= 0) {
                                cookie.domain = null;
                                continue;
                            }
                            cookie.domain = value;
                            continue;
                        }
                        cookie.domain = null;
                    }
                    continue;
                }
                index = length;
            }
            if (cookie == null || cookie.domain == null) continue;
            ret.add(cookie);
        }
        return ret;
    }

    static {
        SECURE_LENGTH = SECURE.length();
        HTTP_ONLY_LENGTH = HTTP_ONLY.length();
        BAD_COUNTRY_2LDS = new String[]{"ac", "co", "com", "ed", "edu", "go", "gouv", "gov", "info", "lg", "ne", "net", "or", "org"};
        Arrays.sort(BAD_COUNTRY_2LDS);
        COMPARATOR = new CookieComparator(null);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CookieComparator
    implements Comparator<Cookie> {
        public CookieComparator() {
        }

        @Override
        public int compare(Cookie cookie1, Cookie cookie2) {
            int diff = cookie2.path.length() - cookie1.path.length();
            if (diff == 0 && (diff = cookie2.domain.length() - cookie1.domain.length()) == 0 && (diff = cookie2.name.hashCode() - cookie1.name.hashCode()) == 0) {
                Log.w(CookieManager.LOGTAG, "Found two cookies with the same value.cookie1=" + cookie1 + " , cookie2=" + cookie2);
            }
            return diff;
        }

        public /* synthetic */ CookieComparator(1 x0) {
            this();
        }
    }

    public static class Cookie {
        public static final byte MODE_NEW = 0;
        public static final byte MODE_NORMAL = 1;
        public static final byte MODE_DELETED = 2;
        public static final byte MODE_REPLACED = 3;
        public String domain;
        public String path;
        public String name;
        public String value;
        public long expires;
        public long lastAcessTime;
        public long lastUpdateTime;
        public boolean secure;
        public byte mode;

        public Cookie() {
        }

        public Cookie(String defaultDomain, String defaultPath) {
            this.domain = defaultDomain;
            this.path = defaultPath;
            this.expires = -1L;
        }

        public boolean exactMatch(Cookie in) {
            return this.domain.equals(in.domain) && this.path.equals(in.path) && this.name.equals(in.name);
        }

        public boolean domainMatch(String urlHost) {
            if (this.domain.startsWith(".")) {
                if (urlHost.endsWith(this.domain.substring(1))) {
                    int len = this.domain.length();
                    int urlLen = urlHost.length();
                    if (urlLen > len - 1) {
                        return urlHost.charAt(urlLen - len) == '.';
                    }
                    return true;
                }
                return false;
            }
            return urlHost.equals(this.domain);
        }

        public boolean pathMatch(String urlPath) {
            if (urlPath.startsWith(this.path)) {
                int len = this.path.length();
                if (len == 0) {
                    Log.w(CookieManager.LOGTAG, "Empty cookie path");
                    return false;
                }
                int urlLen = urlPath.length();
                if (this.path.charAt(len - 1) != '/' && urlLen > len) {
                    return urlPath.charAt(len) == '/';
                }
                return true;
            }
            return false;
        }

        public String toString() {
            return "domain: " + this.domain + "; path: " + this.path + "; name: " + this.name + "; value: " + this.value;
        }
    }
}

