/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import android.os.Handler;
import android.os.Message;
import android.os.Process;
import android.provider.Checkin;
import android.webkit.BrowserFrame;
import android.webkit.GoogleLocationSettingManager;
import android.webkit.WebView;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.util.Locale;

public class WebSettings {
    public static final int LOAD_DEFAULT = -1;
    public static final int LOAD_NORMAL = 0;
    public static final int LOAD_CACHE_ELSE_NETWORK = 1;
    public static final int LOAD_NO_CACHE = 2;
    public static final int LOAD_CACHE_ONLY = 3;
    public WebView mWebView;
    public BrowserFrame mBrowserFrame;
    public boolean mSyncPending = false;
    public final EventHandler mEventHandler;
    public LayoutAlgorithm mLayoutAlgorithm = LayoutAlgorithm.NARROW_COLUMNS;
    public Context mContext;
    public TextSize mTextSize = TextSize.NORMAL;
    public String mStandardFontFamily = "sans-serif";
    public String mFixedFontFamily = "monospace";
    public String mSansSerifFontFamily = "sans-serif";
    public String mSerifFontFamily = "serif";
    public String mCursiveFontFamily = "cursive";
    public String mFantasyFontFamily = "fantasy";
    public String mDefaultTextEncoding;
    public String mUserAgent;
    public boolean mUseDefaultUserAgent;
    public String mAcceptLanguage;
    public int mMinimumFontSize = 8;
    public int mMinimumLogicalFontSize = 8;
    public int mDefaultFontSize = 16;
    public int mDefaultFixedFontSize = 13;
    public boolean mLoadsImagesAutomatically = true;
    public boolean mBlockNetworkImage = false;
    public boolean mBlockNetworkLoads;
    public boolean mJavaScriptEnabled = false;
    public boolean mPluginsEnabled = false;
    public boolean mJavaScriptCanOpenWindowsAutomatically = false;
    public boolean mUseDoubleTree = false;
    public boolean mUseWideViewport = false;
    public boolean mSupportMultipleWindows = false;
    public boolean mShrinksStandaloneImagesToFit = false;
    public boolean mAppCacheEnabled = false;
    public boolean mDatabaseEnabled = false;
    public boolean mDomStorageEnabled = false;
    public boolean mWorkersEnabled = false;
    public boolean mGeolocationEnabled = true;
    public long mAppCacheMaxSize = Long.MAX_VALUE;
    public String mAppCachePath = "";
    public String mDatabasePath = "";
    public String mGeolocationDatabasePath = "";
    public ZoomDensity mDefaultZoom = ZoomDensity.MEDIUM;
    public RenderPriority mRenderPriority = RenderPriority.NORMAL;
    public int mOverrideCacheMode = -1;
    public boolean mSaveFormData = true;
    public boolean mSavePassword = true;
    public boolean mLightTouchEnabled = false;
    public boolean mNeedInitialFocus = true;
    public boolean mNavDump = false;
    public boolean mSupportZoom = true;
    public boolean mBuiltInZoomControls = false;
    public boolean mAllowFileAccess = true;
    public boolean mLoadWithOverviewMode = false;
    public static int mDoubleTapToastCount = 3;
    public static final String PREF_FILE = "WebViewSettings";
    public static final String DOUBLE_TAP_TOAST_COUNT = "double_tap_toast_count";
    public static final String DESKTOP_USERAGENT = "Mozilla/5.0 (Macintosh; U; Intel Mac OS X 10_5_7; en-us) AppleWebKit/530.17 (KHTML, like Gecko) Version/4.0 Safari/530.17";
    public static final String IPHONE_USERAGENT = "Mozilla/5.0 (iPhone; U; CPU iPhone OS 3_0 like Mac OS X; en-us) AppleWebKit/528.18 (KHTML, like Gecko) Version/4.0 Mobile/7A341 Safari/528.16";
    public static Locale sLocale;
    public static Object sLockForLocaleSettings;

    public WebSettings(Context context, WebView webview) {
        this.mEventHandler = new EventHandler(null);
        this.mContext = context;
        this.mWebView = webview;
        this.mDefaultTextEncoding = context.getString(17039523);
        if (sLockForLocaleSettings == null) {
            sLockForLocaleSettings = new Object();
            sLocale = Locale.getDefault();
        }
        this.mAcceptLanguage = this.getCurrentAcceptLanguage();
        this.mUserAgent = this.getCurrentUserAgent();
        this.mUseDefaultUserAgent = true;
        this.mBlockNetworkLoads = this.mContext.checkPermission("android.permission.INTERNET", Process.myPid(), Process.myUid()) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCurrentAcceptLanguage() {
        Locale locale;
        Object object = sLockForLocaleSettings;
        synchronized (object) {
            locale = sLocale;
        }
        StringBuffer buffer = new StringBuffer();
        String language = locale.getLanguage();
        if (language != null) {
            buffer.append(language);
            String country = locale.getCountry();
            if (country != null) {
                buffer.append("-");
                buffer.append(country);
            }
        }
        if (!locale.equals(Locale.US)) {
            buffer.append(", ");
            Locale us = Locale.US;
            if (us.getLanguage() != null) {
                buffer.append(us.getLanguage());
                String country = us.getCountry();
                if (country != null) {
                    buffer.append("-");
                    buffer.append(country);
                }
            }
        }
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String getCurrentUserAgent() {
        String id2;
        String model;
        Locale locale;
        Object object = sLockForLocaleSettings;
        synchronized (object) {
            locale = sLocale;
        }
        StringBuffer buffer = new StringBuffer();
        String version = Build.VERSION.RELEASE;
        if (version.length() > 0) {
            buffer.append(version);
        } else {
            buffer.append("1.0");
        }
        buffer.append("; ");
        String language = locale.getLanguage();
        if (language != null) {
            buffer.append(language.toLowerCase());
            String country = locale.getCountry();
            if (country != null) {
                buffer.append("-");
                buffer.append(country.toLowerCase());
            }
        } else {
            buffer.append("en");
        }
        if ("REL".equals(Build.VERSION.CODENAME) && (model = Build.MODEL).length() > 0) {
            buffer.append("; ");
            buffer.append(model);
        }
        if ((id2 = Build.ID).length() > 0) {
            buffer.append(" Build/");
            buffer.append(id2);
        }
        String base = ((Object)this.mContext.getResources().getText(17039998)).toString();
        return String.format(base, buffer);
    }

    public void setNavDump(boolean enabled) {
        this.mNavDump = enabled;
    }

    public boolean getNavDump() {
        return this.mNavDump;
    }

    public void setSupportZoom(boolean support) {
        this.mSupportZoom = support;
    }

    public boolean supportZoom() {
        return this.mSupportZoom;
    }

    public void setBuiltInZoomControls(boolean enabled) {
        this.mBuiltInZoomControls = enabled;
    }

    public boolean getBuiltInZoomControls() {
        return this.mBuiltInZoomControls;
    }

    public void setAllowFileAccess(boolean allow) {
        this.mAllowFileAccess = allow;
    }

    public boolean getAllowFileAccess() {
        return this.mAllowFileAccess;
    }

    public void setLoadWithOverviewMode(boolean overview) {
        this.mLoadWithOverviewMode = overview;
    }

    public boolean getLoadWithOverviewMode() {
        return this.mLoadWithOverviewMode;
    }

    public void setSaveFormData(boolean save) {
        this.mSaveFormData = save;
    }

    public boolean getSaveFormData() {
        return this.mSaveFormData;
    }

    public void setSavePassword(boolean save) {
        this.mSavePassword = save;
    }

    public boolean getSavePassword() {
        return this.mSavePassword;
    }

    public synchronized void setTextSize(TextSize t) {
        if (WebView.mLogEvent && this.mTextSize != t) {
            Checkin.updateStats(this.mContext.getContentResolver(), Checkin.Stats.Tag.BROWSER_TEXT_SIZE_CHANGE, 1, 0.0);
        }
        this.mTextSize = t;
        this.postSync();
    }

    public synchronized TextSize getTextSize() {
        return this.mTextSize;
    }

    public void setDefaultZoom(ZoomDensity zoom) {
        if (this.mDefaultZoom != zoom) {
            this.mDefaultZoom = zoom;
            this.mWebView.updateDefaultZoomDensity(zoom.value);
        }
    }

    public ZoomDensity getDefaultZoom() {
        return this.mDefaultZoom;
    }

    public void setLightTouchEnabled(boolean enabled) {
        this.mLightTouchEnabled = enabled;
    }

    public boolean getLightTouchEnabled() {
        return this.mLightTouchEnabled;
    }

    @Deprecated
    public synchronized void setUseDoubleTree(boolean use) {
    }

    @Deprecated
    public synchronized boolean getUseDoubleTree() {
        return false;
    }

    @Deprecated
    public synchronized void setUserAgent(int ua) {
        String uaString = null;
        if (ua == 1) {
            if (DESKTOP_USERAGENT.equals(this.mUserAgent)) {
                return;
            }
            uaString = DESKTOP_USERAGENT;
        } else if (ua == 2) {
            if (IPHONE_USERAGENT.equals(this.mUserAgent)) {
                return;
            }
            uaString = IPHONE_USERAGENT;
        } else if (ua != 0) {
            return;
        }
        this.setUserAgentString(uaString);
    }

    @Deprecated
    public synchronized int getUserAgent() {
        if (DESKTOP_USERAGENT.equals(this.mUserAgent)) {
            return 1;
        }
        if (IPHONE_USERAGENT.equals(this.mUserAgent)) {
            return 2;
        }
        if (this.mUseDefaultUserAgent) {
            return 0;
        }
        return -1;
    }

    public synchronized void setUseWideViewPort(boolean use) {
        if (this.mUseWideViewport != use) {
            this.mUseWideViewport = use;
            this.postSync();
        }
    }

    public synchronized boolean getUseWideViewPort() {
        return this.mUseWideViewport;
    }

    public synchronized void setSupportMultipleWindows(boolean support) {
        if (this.mSupportMultipleWindows != support) {
            this.mSupportMultipleWindows = support;
            this.postSync();
        }
    }

    public synchronized boolean supportMultipleWindows() {
        return this.mSupportMultipleWindows;
    }

    public synchronized void setLayoutAlgorithm(LayoutAlgorithm l) {
        if (this.mLayoutAlgorithm != l) {
            this.mLayoutAlgorithm = l;
            this.postSync();
        }
    }

    public synchronized LayoutAlgorithm getLayoutAlgorithm() {
        return this.mLayoutAlgorithm;
    }

    public synchronized void setStandardFontFamily(String font) {
        if (font != null && !font.equals(this.mStandardFontFamily)) {
            this.mStandardFontFamily = font;
            this.postSync();
        }
    }

    public synchronized String getStandardFontFamily() {
        return this.mStandardFontFamily;
    }

    public synchronized void setFixedFontFamily(String font) {
        if (font != null && !font.equals(this.mFixedFontFamily)) {
            this.mFixedFontFamily = font;
            this.postSync();
        }
    }

    public synchronized String getFixedFontFamily() {
        return this.mFixedFontFamily;
    }

    public synchronized void setSansSerifFontFamily(String font) {
        if (font != null && !font.equals(this.mSansSerifFontFamily)) {
            this.mSansSerifFontFamily = font;
            this.postSync();
        }
    }

    public synchronized String getSansSerifFontFamily() {
        return this.mSansSerifFontFamily;
    }

    public synchronized void setSerifFontFamily(String font) {
        if (font != null && !font.equals(this.mSerifFontFamily)) {
            this.mSerifFontFamily = font;
            this.postSync();
        }
    }

    public synchronized String getSerifFontFamily() {
        return this.mSerifFontFamily;
    }

    public synchronized void setCursiveFontFamily(String font) {
        if (font != null && !font.equals(this.mCursiveFontFamily)) {
            this.mCursiveFontFamily = font;
            this.postSync();
        }
    }

    public synchronized String getCursiveFontFamily() {
        return this.mCursiveFontFamily;
    }

    public synchronized void setFantasyFontFamily(String font) {
        if (font != null && !font.equals(this.mFantasyFontFamily)) {
            this.mFantasyFontFamily = font;
            this.postSync();
        }
    }

    public synchronized String getFantasyFontFamily() {
        return this.mFantasyFontFamily;
    }

    public synchronized void setMinimumFontSize(int size) {
        if (this.mMinimumFontSize != (size = this.pin(size))) {
            this.mMinimumFontSize = size;
            this.postSync();
        }
    }

    public synchronized int getMinimumFontSize() {
        return this.mMinimumFontSize;
    }

    public synchronized void setMinimumLogicalFontSize(int size) {
        if (this.mMinimumLogicalFontSize != (size = this.pin(size))) {
            this.mMinimumLogicalFontSize = size;
            this.postSync();
        }
    }

    public synchronized int getMinimumLogicalFontSize() {
        return this.mMinimumLogicalFontSize;
    }

    public synchronized void setDefaultFontSize(int size) {
        if (this.mDefaultFontSize != (size = this.pin(size))) {
            this.mDefaultFontSize = size;
            this.postSync();
        }
    }

    public synchronized int getDefaultFontSize() {
        return this.mDefaultFontSize;
    }

    public synchronized void setDefaultFixedFontSize(int size) {
        if (this.mDefaultFixedFontSize != (size = this.pin(size))) {
            this.mDefaultFixedFontSize = size;
            this.postSync();
        }
    }

    public synchronized int getDefaultFixedFontSize() {
        return this.mDefaultFixedFontSize;
    }

    public synchronized void setLoadsImagesAutomatically(boolean flag) {
        if (this.mLoadsImagesAutomatically != flag) {
            this.mLoadsImagesAutomatically = flag;
            this.postSync();
        }
    }

    public synchronized boolean getLoadsImagesAutomatically() {
        return this.mLoadsImagesAutomatically;
    }

    public synchronized void setBlockNetworkImage(boolean flag) {
        if (this.mBlockNetworkImage != flag) {
            this.mBlockNetworkImage = flag;
            this.postSync();
        }
    }

    public synchronized boolean getBlockNetworkImage() {
        return this.mBlockNetworkImage;
    }

    public synchronized void setBlockNetworkLoads(boolean flag) {
        if (this.mBlockNetworkLoads != flag) {
            this.mBlockNetworkLoads = flag;
            this.verifyNetworkAccess();
        }
    }

    public synchronized boolean getBlockNetworkLoads() {
        return this.mBlockNetworkLoads;
    }

    public void verifyNetworkAccess() {
        if (!this.mBlockNetworkLoads && this.mContext.checkPermission("android.permission.INTERNET", Process.myPid(), Process.myUid()) != 0) {
            throw new SecurityException("Permission denied - application missing INTERNET permission");
        }
    }

    public synchronized void setJavaScriptEnabled(boolean flag) {
        if (this.mJavaScriptEnabled != flag) {
            this.mJavaScriptEnabled = flag;
            this.postSync();
        }
    }

    public synchronized void setPluginsEnabled(boolean flag) {
        if (this.mPluginsEnabled != flag) {
            this.mPluginsEnabled = flag;
            this.postSync();
        }
    }

    public synchronized void setPluginsPath(String pluginsPath) {
    }

    public synchronized void setDatabasePath(String databasePath) {
        if (databasePath != null && !databasePath.equals(this.mDatabasePath)) {
            this.mDatabasePath = databasePath;
            this.postSync();
        }
    }

    public synchronized void setGeolocationDatabasePath(String databasePath) {
        if (databasePath != null && !databasePath.equals(this.mDatabasePath)) {
            this.mGeolocationDatabasePath = databasePath;
            this.postSync();
        }
    }

    public synchronized void setAppCacheEnabled(boolean flag) {
        if (this.mAppCacheEnabled != flag) {
            this.mAppCacheEnabled = flag;
            this.postSync();
        }
    }

    public synchronized void setAppCachePath(String appCachePath) {
        if (appCachePath != null && !appCachePath.equals(this.mAppCachePath)) {
            this.mAppCachePath = appCachePath;
            this.postSync();
        }
    }

    public synchronized void setAppCacheMaxSize(long appCacheMaxSize) {
        if (appCacheMaxSize != this.mAppCacheMaxSize) {
            this.mAppCacheMaxSize = appCacheMaxSize;
            this.postSync();
        }
    }

    public synchronized void setDatabaseEnabled(boolean flag) {
        if (this.mDatabaseEnabled != flag) {
            this.mDatabaseEnabled = flag;
            this.postSync();
        }
    }

    public synchronized void setDomStorageEnabled(boolean flag) {
        if (this.mDomStorageEnabled != flag) {
            this.mDomStorageEnabled = flag;
            this.postSync();
        }
    }

    public synchronized boolean getDomStorageEnabled() {
        return this.mDomStorageEnabled;
    }

    public synchronized String getDatabasePath() {
        return this.mDatabasePath;
    }

    public synchronized boolean getDatabaseEnabled() {
        return this.mDatabaseEnabled;
    }

    public synchronized void setWorkersEnabled(boolean flag) {
        if (this.mWorkersEnabled != flag) {
            this.mWorkersEnabled = flag;
            this.postSync();
        }
    }

    public synchronized void setGeolocationEnabled(boolean flag) {
        if (this.mGeolocationEnabled != flag) {
            this.mGeolocationEnabled = flag;
            this.postSync();
        }
    }

    public synchronized boolean getJavaScriptEnabled() {
        return this.mJavaScriptEnabled;
    }

    public synchronized boolean getPluginsEnabled() {
        return this.mPluginsEnabled;
    }

    public synchronized String getPluginsPath() {
        return "";
    }

    public synchronized void setJavaScriptCanOpenWindowsAutomatically(boolean flag) {
        if (this.mJavaScriptCanOpenWindowsAutomatically != flag) {
            this.mJavaScriptCanOpenWindowsAutomatically = flag;
            this.postSync();
        }
    }

    public synchronized boolean getJavaScriptCanOpenWindowsAutomatically() {
        return this.mJavaScriptCanOpenWindowsAutomatically;
    }

    public synchronized void setDefaultTextEncodingName(String encoding) {
        if (encoding != null && !encoding.equals(this.mDefaultTextEncoding)) {
            this.mDefaultTextEncoding = encoding;
            this.postSync();
        }
    }

    public synchronized String getDefaultTextEncodingName() {
        return this.mDefaultTextEncoding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setUserAgentString(String ua) {
        if (ua == null || ua.length() == 0) {
            Object object = sLockForLocaleSettings;
            synchronized (object) {
                Locale currentLocale = Locale.getDefault();
                if (!sLocale.equals(currentLocale)) {
                    sLocale = currentLocale;
                    this.mAcceptLanguage = this.getCurrentAcceptLanguage();
                }
            }
            ua = this.getCurrentUserAgent();
            this.mUseDefaultUserAgent = true;
        } else {
            this.mUseDefaultUserAgent = false;
        }
        if (!ua.equals(this.mUserAgent)) {
            this.mUserAgent = ua;
            this.postSync();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String getUserAgentString() {
        if (DESKTOP_USERAGENT.equals(this.mUserAgent) || IPHONE_USERAGENT.equals(this.mUserAgent) || !this.mUseDefaultUserAgent) {
            return this.mUserAgent;
        }
        boolean doPostSync = false;
        Object object = sLockForLocaleSettings;
        synchronized (object) {
            Locale currentLocale = Locale.getDefault();
            if (!sLocale.equals(currentLocale)) {
                sLocale = currentLocale;
                this.mUserAgent = this.getCurrentUserAgent();
                this.mAcceptLanguage = this.getCurrentAcceptLanguage();
                doPostSync = true;
            }
        }
        if (doPostSync) {
            this.postSync();
        }
        return this.mUserAgent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String getAcceptLanguage() {
        Object object = sLockForLocaleSettings;
        synchronized (object) {
            Locale currentLocale = Locale.getDefault();
            if (!sLocale.equals(currentLocale)) {
                sLocale = currentLocale;
                this.mAcceptLanguage = this.getCurrentAcceptLanguage();
            }
        }
        return this.mAcceptLanguage;
    }

    public void setNeedInitialFocus(boolean flag) {
        if (this.mNeedInitialFocus != flag) {
            this.mNeedInitialFocus = flag;
        }
    }

    public boolean getNeedInitialFocus() {
        return this.mNeedInitialFocus;
    }

    public synchronized void setRenderPriority(RenderPriority priority) {
        if (this.mRenderPriority != priority) {
            this.mRenderPriority = priority;
            this.mEventHandler.sendMessage(Message.obtain(null, 1));
        }
    }

    public void setCacheMode(int mode) {
        if (mode != this.mOverrideCacheMode) {
            this.mOverrideCacheMode = mode;
        }
    }

    public int getCacheMode() {
        return this.mOverrideCacheMode;
    }

    public void setShrinksStandaloneImagesToFit(boolean shrink) {
        if (this.mShrinksStandaloneImagesToFit != shrink) {
            this.mShrinksStandaloneImagesToFit = shrink;
            this.postSync();
        }
    }

    public int getDoubleTapToastCount() {
        return mDoubleTapToastCount;
    }

    public void setDoubleTapToastCount(int count) {
        if (mDoubleTapToastCount != count) {
            mDoubleTapToastCount = count;
            this.mEventHandler.sendMessage(Message.obtain(null, 2));
        }
    }

    public synchronized void syncSettingsAndCreateHandler(BrowserFrame frame) {
        this.mBrowserFrame = frame;
        GoogleLocationSettingManager.getInstance().start(this.mContext);
        SharedPreferences sp = this.mContext.getSharedPreferences(PREF_FILE, 0);
        if (mDoubleTapToastCount > 0) {
            mDoubleTapToastCount = sp.getInt(DOUBLE_TAP_TOAST_COUNT, mDoubleTapToastCount);
        }
        this.nativeSync(frame.mNativeFrame);
        this.mSyncPending = false;
        this.mEventHandler.createHandler();
    }

    public synchronized void onDestroyed() {
        GoogleLocationSettingManager.getInstance().stop();
    }

    public int pin(int size) {
        if (size < 1) {
            return 1;
        }
        if (size > 72) {
            return 72;
        }
        return size;
    }

    public synchronized void postSync() {
        if (!this.mSyncPending) {
            this.mSyncPending = this.mEventHandler.sendMessage(Message.obtain(null, 0));
        }
    }

    public void nativeSync(int n) {
        OverrideMethod.invokeV("android.webkit.WebSettings#nativeSync(I)V", true, this);
    }

    public static class 1 {
    }

    public class EventHandler {
        public static final int SYNC = 0;
        public static final int PRIORITY = 1;
        public static final int SET_DOUBLE_TAP_TOAST_COUNT = 2;
        public Handler mHandler;

        public EventHandler() {
        }

        public synchronized void createHandler() {
            this.setRenderPriority();
            this.mHandler = new Handler(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void handleMessage(Message msg) {
                    switch (msg.what) {
                        case 0: {
                            WebSettings webSettings = WebSettings.this;
                            synchronized (webSettings) {
                                if (((WebSettings)WebSettings.this).mBrowserFrame.mNativeFrame != 0) {
                                    WebSettings.this.nativeSync(((WebSettings)WebSettings.this).mBrowserFrame.mNativeFrame);
                                }
                                WebSettings.this.mSyncPending = false;
                                break;
                            }
                        }
                        case 1: {
                            EventHandler.this.setRenderPriority();
                            break;
                        }
                        case 2: {
                            SharedPreferences.Editor editor = WebSettings.this.mContext.getSharedPreferences(WebSettings.PREF_FILE, 0).edit();
                            editor.putInt(WebSettings.DOUBLE_TAP_TOAST_COUNT, mDoubleTapToastCount);
                            editor.commit();
                            break;
                        }
                    }
                }
            };
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setRenderPriority() {
            WebSettings webSettings = WebSettings.this;
            synchronized (webSettings) {
                if (WebSettings.this.mRenderPriority == RenderPriority.NORMAL) {
                    Process.setThreadPriority(0);
                } else if (WebSettings.this.mRenderPriority == RenderPriority.HIGH) {
                    Process.setThreadPriority(-1);
                } else if (WebSettings.this.mRenderPriority == RenderPriority.LOW) {
                    Process.setThreadPriority(10);
                }
            }
        }

        public synchronized boolean sendMessage(Message msg) {
            if (this.mHandler != null) {
                this.mHandler.sendMessage(msg);
                return true;
            }
            return false;
        }

        public /* synthetic */ EventHandler(1 x1) {
            this();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RenderPriority {
        NORMAL,
        HIGH,
        LOW;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ZoomDensity {
        FAR(150),
        MEDIUM(100),
        CLOSE(75);

        public int value;

        public ZoomDensity(int size) {
            this.value = size;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TextSize {
        SMALLEST(50),
        SMALLER(75),
        NORMAL(100),
        LARGER(150),
        LARGEST(200);

        public int value;

        public TextSize(int size) {
            this.value = size;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum LayoutAlgorithm {
        NORMAL,
        SINGLE_COLUMN,
        NARROW_COLUMNS;

    }
}

