/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.database.ContentObserver;
import android.database.Cursor;
import android.database.DataSetObserver;
import android.os.Handler;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.CursorFilter;
import android.widget.Filter;
import android.widget.FilterQueryProvider;
import android.widget.Filterable;

public abstract class CursorAdapter
extends BaseAdapter
implements Filterable,
CursorFilter.CursorFilterClient {
    public boolean mDataValid;
    public boolean mAutoRequery;
    public Cursor mCursor;
    public Context mContext;
    public int mRowIDColumn;
    public ChangeObserver mChangeObserver;
    public DataSetObserver mDataSetObserver = new MyDataSetObserver(null);
    public CursorFilter mCursorFilter;
    public FilterQueryProvider mFilterQueryProvider;

    public CursorAdapter(Context context, Cursor c) {
        this.init(context, c, true);
    }

    public CursorAdapter(Context context, Cursor c, boolean autoRequery) {
        this.init(context, c, autoRequery);
    }

    public void init(Context context, Cursor c, boolean autoRequery) {
        boolean cursorPresent = c != null;
        this.mAutoRequery = autoRequery;
        this.mCursor = c;
        this.mDataValid = cursorPresent;
        this.mContext = context;
        this.mRowIDColumn = cursorPresent ? c.getColumnIndexOrThrow("_id") : -1;
        this.mChangeObserver = new ChangeObserver();
        if (cursorPresent) {
            c.registerContentObserver(this.mChangeObserver);
            c.registerDataSetObserver(this.mDataSetObserver);
        }
    }

    public Cursor getCursor() {
        return this.mCursor;
    }

    public int getCount() {
        if (this.mDataValid && this.mCursor != null) {
            return this.mCursor.getCount();
        }
        return 0;
    }

    public Object getItem(int position) {
        if (this.mDataValid && this.mCursor != null) {
            this.mCursor.moveToPosition(position);
            return this.mCursor;
        }
        return null;
    }

    public long getItemId(int position) {
        if (this.mDataValid && this.mCursor != null) {
            if (this.mCursor.moveToPosition(position)) {
                return this.mCursor.getLong(this.mRowIDColumn);
            }
            return 0L;
        }
        return 0L;
    }

    public boolean hasStableIds() {
        return true;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        if (!this.mDataValid) {
            throw new IllegalStateException("this should only be called when the cursor is valid");
        }
        if (!this.mCursor.moveToPosition(position)) {
            throw new IllegalStateException("couldn't move cursor to position " + position);
        }
        View v = convertView == null ? this.newView(this.mContext, this.mCursor, parent) : convertView;
        this.bindView(v, this.mContext, this.mCursor);
        return v;
    }

    public View getDropDownView(int position, View convertView, ViewGroup parent) {
        if (this.mDataValid) {
            this.mCursor.moveToPosition(position);
            View v = convertView == null ? this.newDropDownView(this.mContext, this.mCursor, parent) : convertView;
            this.bindView(v, this.mContext, this.mCursor);
            return v;
        }
        return null;
    }

    public abstract View newView(Context var1, Cursor var2, ViewGroup var3);

    public View newDropDownView(Context context, Cursor cursor, ViewGroup parent) {
        return this.newView(context, cursor, parent);
    }

    public abstract void bindView(View var1, Context var2, Cursor var3);

    public void changeCursor(Cursor cursor) {
        if (cursor == this.mCursor) {
            return;
        }
        if (this.mCursor != null) {
            this.mCursor.unregisterContentObserver(this.mChangeObserver);
            this.mCursor.unregisterDataSetObserver(this.mDataSetObserver);
            this.mCursor.close();
        }
        this.mCursor = cursor;
        if (cursor != null) {
            cursor.registerContentObserver(this.mChangeObserver);
            cursor.registerDataSetObserver(this.mDataSetObserver);
            this.mRowIDColumn = cursor.getColumnIndexOrThrow("_id");
            this.mDataValid = true;
            this.notifyDataSetChanged();
        } else {
            this.mRowIDColumn = -1;
            this.mDataValid = false;
            this.notifyDataSetInvalidated();
        }
    }

    public CharSequence convertToString(Cursor cursor) {
        return cursor == null ? "" : cursor.toString();
    }

    public Cursor runQueryOnBackgroundThread(CharSequence constraint) {
        if (this.mFilterQueryProvider != null) {
            return this.mFilterQueryProvider.runQuery(constraint);
        }
        return this.mCursor;
    }

    public Filter getFilter() {
        if (this.mCursorFilter == null) {
            this.mCursorFilter = new CursorFilter(this);
        }
        return this.mCursorFilter;
    }

    public FilterQueryProvider getFilterQueryProvider() {
        return this.mFilterQueryProvider;
    }

    public void setFilterQueryProvider(FilterQueryProvider filterQueryProvider) {
        this.mFilterQueryProvider = filterQueryProvider;
    }

    public void onContentChanged() {
        if (this.mAutoRequery && this.mCursor != null && !this.mCursor.isClosed()) {
            this.mDataValid = this.mCursor.requery();
        }
    }

    public static class 1 {
    }

    public class MyDataSetObserver
    extends DataSetObserver {
        public MyDataSetObserver() {
        }

        public void onChanged() {
            CursorAdapter.this.mDataValid = true;
            CursorAdapter.this.notifyDataSetChanged();
        }

        public void onInvalidated() {
            CursorAdapter.this.mDataValid = false;
            CursorAdapter.this.notifyDataSetInvalidated();
        }

        public /* synthetic */ MyDataSetObserver(1 x1) {
            this();
        }
    }

    public class ChangeObserver
    extends ContentObserver {
        public ChangeObserver() {
            super(new Handler());
        }

        public boolean deliverSelfNotifications() {
            return true;
        }

        public void onChange(boolean selfChange) {
            CursorAdapter.this.onContentChanged();
        }
    }
}

