/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.database.ContentObserver;
import android.database.Cursor;
import android.database.DataSetObserver;
import android.os.Handler;
import android.util.SparseArray;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseExpandableListAdapter;
import android.widget.CursorFilter;
import android.widget.Filter;
import android.widget.FilterQueryProvider;
import android.widget.Filterable;

public abstract class CursorTreeAdapter
extends BaseExpandableListAdapter
implements Filterable,
CursorFilter.CursorFilterClient {
    public Context mContext;
    public Handler mHandler;
    public boolean mAutoRequery;
    public MyCursorHelper mGroupCursorHelper;
    public SparseArray<MyCursorHelper> mChildrenCursorHelpers;
    public CursorFilter mCursorFilter;
    public FilterQueryProvider mFilterQueryProvider;

    public CursorTreeAdapter(Cursor cursor, Context context) {
        this.init(cursor, context, true);
    }

    public CursorTreeAdapter(Cursor cursor, Context context, boolean autoRequery) {
        this.init(cursor, context, autoRequery);
    }

    public void init(Cursor cursor, Context context, boolean autoRequery) {
        this.mContext = context;
        this.mHandler = new Handler();
        this.mAutoRequery = autoRequery;
        this.mGroupCursorHelper = new MyCursorHelper(cursor);
        this.mChildrenCursorHelpers = new SparseArray();
    }

    public synchronized MyCursorHelper getChildrenCursorHelper(int groupPosition, boolean requestCursor) {
        MyCursorHelper cursorHelper = this.mChildrenCursorHelpers.get(groupPosition);
        if (cursorHelper == null) {
            if (this.mGroupCursorHelper.moveTo(groupPosition) == null) {
                return null;
            }
            Cursor cursor = this.getChildrenCursor(this.mGroupCursorHelper.getCursor());
            cursorHelper = new MyCursorHelper(cursor);
            this.mChildrenCursorHelpers.put(groupPosition, cursorHelper);
        }
        return cursorHelper;
    }

    public abstract Cursor getChildrenCursor(Cursor var1);

    public void setGroupCursor(Cursor cursor) {
        this.mGroupCursorHelper.changeCursor(cursor, false);
    }

    public void setChildrenCursor(int groupPosition, Cursor childrenCursor) {
        MyCursorHelper childrenCursorHelper = this.getChildrenCursorHelper(groupPosition, false);
        childrenCursorHelper.changeCursor(childrenCursor, false);
    }

    public Cursor getChild(int groupPosition, int childPosition) {
        return this.getChildrenCursorHelper(groupPosition, true).moveTo(childPosition);
    }

    public long getChildId(int groupPosition, int childPosition) {
        return this.getChildrenCursorHelper(groupPosition, true).getId(childPosition);
    }

    public int getChildrenCount(int groupPosition) {
        MyCursorHelper helper = this.getChildrenCursorHelper(groupPosition, true);
        return this.mGroupCursorHelper.isValid() && helper != null ? helper.getCount() : 0;
    }

    public Cursor getGroup(int groupPosition) {
        return this.mGroupCursorHelper.moveTo(groupPosition);
    }

    public int getGroupCount() {
        return this.mGroupCursorHelper.getCount();
    }

    public long getGroupId(int groupPosition) {
        return this.mGroupCursorHelper.getId(groupPosition);
    }

    public View getGroupView(int groupPosition, boolean isExpanded, View convertView, ViewGroup parent) {
        Cursor cursor = this.mGroupCursorHelper.moveTo(groupPosition);
        if (cursor == null) {
            throw new IllegalStateException("this should only be called when the cursor is valid");
        }
        View v = convertView == null ? this.newGroupView(this.mContext, cursor, isExpanded, parent) : convertView;
        this.bindGroupView(v, this.mContext, cursor, isExpanded);
        return v;
    }

    public abstract View newGroupView(Context var1, Cursor var2, boolean var3, ViewGroup var4);

    public abstract void bindGroupView(View var1, Context var2, Cursor var3, boolean var4);

    public View getChildView(int groupPosition, int childPosition, boolean isLastChild, View convertView, ViewGroup parent) {
        MyCursorHelper cursorHelper = this.getChildrenCursorHelper(groupPosition, true);
        Cursor cursor = cursorHelper.moveTo(childPosition);
        if (cursor == null) {
            throw new IllegalStateException("this should only be called when the cursor is valid");
        }
        View v = convertView == null ? this.newChildView(this.mContext, cursor, isLastChild, parent) : convertView;
        this.bindChildView(v, this.mContext, cursor, isLastChild);
        return v;
    }

    public abstract View newChildView(Context var1, Cursor var2, boolean var3, ViewGroup var4);

    public abstract void bindChildView(View var1, Context var2, Cursor var3, boolean var4);

    public boolean isChildSelectable(int groupPosition, int childPosition) {
        return true;
    }

    public boolean hasStableIds() {
        return true;
    }

    public synchronized void releaseCursorHelpers() {
        for (int pos = this.mChildrenCursorHelpers.size() - 1; pos >= 0; --pos) {
            this.mChildrenCursorHelpers.valueAt(pos).deactivate();
        }
        this.mChildrenCursorHelpers.clear();
    }

    public void notifyDataSetChanged() {
        this.notifyDataSetChanged(true);
    }

    public void notifyDataSetChanged(boolean releaseCursors) {
        if (releaseCursors) {
            this.releaseCursorHelpers();
        }
        super.notifyDataSetChanged();
    }

    public void notifyDataSetInvalidated() {
        this.releaseCursorHelpers();
        super.notifyDataSetInvalidated();
    }

    public void onGroupCollapsed(int groupPosition) {
        this.deactivateChildrenCursorHelper(groupPosition);
    }

    public synchronized void deactivateChildrenCursorHelper(int groupPosition) {
        MyCursorHelper cursorHelper = this.getChildrenCursorHelper(groupPosition, true);
        this.mChildrenCursorHelpers.remove(groupPosition);
        cursorHelper.deactivate();
    }

    public String convertToString(Cursor cursor) {
        return cursor == null ? "" : cursor.toString();
    }

    public Cursor runQueryOnBackgroundThread(CharSequence constraint) {
        if (this.mFilterQueryProvider != null) {
            return this.mFilterQueryProvider.runQuery(constraint);
        }
        return this.mGroupCursorHelper.getCursor();
    }

    public Filter getFilter() {
        if (this.mCursorFilter == null) {
            this.mCursorFilter = new CursorFilter(this);
        }
        return this.mCursorFilter;
    }

    public FilterQueryProvider getFilterQueryProvider() {
        return this.mFilterQueryProvider;
    }

    public void setFilterQueryProvider(FilterQueryProvider filterQueryProvider) {
        this.mFilterQueryProvider = filterQueryProvider;
    }

    public void changeCursor(Cursor cursor) {
        this.mGroupCursorHelper.changeCursor(cursor, true);
    }

    public Cursor getCursor() {
        return this.mGroupCursorHelper.getCursor();
    }

    public static class 1 {
    }

    public class MyCursorHelper {
        public Cursor mCursor;
        public boolean mDataValid;
        public int mRowIDColumn;
        public MyContentObserver mContentObserver;
        public MyDataSetObserver mDataSetObserver;

        public MyCursorHelper(Cursor cursor) {
            boolean cursorPresent = cursor != null;
            this.mCursor = cursor;
            this.mDataValid = cursorPresent;
            this.mRowIDColumn = cursorPresent ? cursor.getColumnIndex("_id") : -1;
            this.mContentObserver = new MyContentObserver();
            this.mDataSetObserver = new MyDataSetObserver(null);
            if (cursorPresent) {
                cursor.registerContentObserver(this.mContentObserver);
                cursor.registerDataSetObserver(this.mDataSetObserver);
            }
        }

        public Cursor getCursor() {
            return this.mCursor;
        }

        public int getCount() {
            if (this.mDataValid && this.mCursor != null) {
                return this.mCursor.getCount();
            }
            return 0;
        }

        public long getId(int position) {
            if (this.mDataValid && this.mCursor != null) {
                if (this.mCursor.moveToPosition(position)) {
                    return this.mCursor.getLong(this.mRowIDColumn);
                }
                return 0L;
            }
            return 0L;
        }

        public Cursor moveTo(int position) {
            if (this.mDataValid && this.mCursor != null && this.mCursor.moveToPosition(position)) {
                return this.mCursor;
            }
            return null;
        }

        public void changeCursor(Cursor cursor, boolean releaseCursors) {
            if (cursor == this.mCursor) {
                return;
            }
            this.deactivate();
            this.mCursor = cursor;
            if (cursor != null) {
                cursor.registerContentObserver(this.mContentObserver);
                cursor.registerDataSetObserver(this.mDataSetObserver);
                this.mRowIDColumn = cursor.getColumnIndex("_id");
                this.mDataValid = true;
                CursorTreeAdapter.this.notifyDataSetChanged(releaseCursors);
            } else {
                this.mRowIDColumn = -1;
                this.mDataValid = false;
                CursorTreeAdapter.this.notifyDataSetInvalidated();
            }
        }

        public void deactivate() {
            if (this.mCursor == null) {
                return;
            }
            this.mCursor.unregisterContentObserver(this.mContentObserver);
            this.mCursor.unregisterDataSetObserver(this.mDataSetObserver);
            this.mCursor.deactivate();
            this.mCursor = null;
        }

        public boolean isValid() {
            return this.mDataValid && this.mCursor != null;
        }

        public class MyDataSetObserver
        extends DataSetObserver {
            public MyDataSetObserver() {
            }

            public void onChanged() {
                MyCursorHelper.this.mDataValid = true;
                CursorTreeAdapter.this.notifyDataSetChanged();
            }

            public void onInvalidated() {
                MyCursorHelper.this.mDataValid = false;
                CursorTreeAdapter.this.notifyDataSetInvalidated();
            }

            public /* synthetic */ MyDataSetObserver(1 x1) {
                this();
            }
        }

        public class MyContentObserver
        extends ContentObserver {
            public MyContentObserver() {
                super(CursorTreeAdapter.this.mHandler);
            }

            public boolean deliverSelfNotifications() {
                return true;
            }

            public void onChange(boolean selfChange) {
                if (CursorTreeAdapter.this.mAutoRequery && MyCursorHelper.this.mCursor != null) {
                    MyCursorHelper.this.mDataValid = MyCursorHelper.this.mCursor.requery();
                }
            }
        }
    }
}

