/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.database.DataSetObserver;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.SystemClock;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ExpandableListAdapter;
import android.widget.ExpandableListPosition;
import android.widget.Filter;
import android.widget.Filterable;
import java.util.ArrayList;
import java.util.Collections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpandableListConnector
extends BaseAdapter
implements Filterable {
    public ExpandableListAdapter mExpandableListAdapter;
    public ArrayList<GroupMetadata> mExpGroupMetadataList;
    public int mTotalExpChildrenCount;
    public int mMaxExpGroupCount = Integer.MAX_VALUE;
    public DataSetObserver mDataSetObserver = new MyDataSetObserver();

    public ExpandableListConnector(ExpandableListAdapter expandableListAdapter) {
        this.mExpGroupMetadataList = new ArrayList();
        this.setExpandableListAdapter(expandableListAdapter);
    }

    public void setExpandableListAdapter(ExpandableListAdapter expandableListAdapter) {
        if (this.mExpandableListAdapter != null) {
            this.mExpandableListAdapter.unregisterDataSetObserver(this.mDataSetObserver);
        }
        this.mExpandableListAdapter = expandableListAdapter;
        expandableListAdapter.registerDataSetObserver(this.mDataSetObserver);
    }

    public PositionMetadata getUnflattenedPos(int flPos) {
        ArrayList<GroupMetadata> egml = this.mExpGroupMetadataList;
        int numExpGroups = egml.size();
        int leftExpGroupIndex = 0;
        int rightExpGroupIndex = numExpGroups - 1;
        int midExpGroupIndex = 0;
        if (numExpGroups == 0) {
            return PositionMetadata.obtain(flPos, 2, flPos, -1, null, 0);
        }
        while (leftExpGroupIndex <= rightExpGroupIndex) {
            midExpGroupIndex = (rightExpGroupIndex - leftExpGroupIndex) / 2 + leftExpGroupIndex;
            GroupMetadata midExpGm = egml.get(midExpGroupIndex);
            if (flPos > midExpGm.lastChildFlPos) {
                leftExpGroupIndex = midExpGroupIndex + 1;
                continue;
            }
            if (flPos < midExpGm.flPos) {
                rightExpGroupIndex = midExpGroupIndex - 1;
                continue;
            }
            if (flPos == midExpGm.flPos) {
                return PositionMetadata.obtain(flPos, 2, midExpGm.gPos, -1, midExpGm, midExpGroupIndex);
            }
            if (flPos > midExpGm.lastChildFlPos) continue;
            int childPos = flPos - (midExpGm.flPos + 1);
            return PositionMetadata.obtain(flPos, 1, midExpGm.gPos, childPos, midExpGm, midExpGroupIndex);
        }
        int insertPosition = 0;
        int groupPos = 0;
        if (leftExpGroupIndex > midExpGroupIndex) {
            GroupMetadata leftExpGm = egml.get(leftExpGroupIndex - 1);
            insertPosition = leftExpGroupIndex;
            groupPos = flPos - leftExpGm.lastChildFlPos + leftExpGm.gPos;
        } else if (rightExpGroupIndex < midExpGroupIndex) {
            GroupMetadata rightExpGm = egml.get(++rightExpGroupIndex);
            insertPosition = rightExpGroupIndex;
            groupPos = rightExpGm.gPos - (rightExpGm.flPos - flPos);
        } else {
            throw new RuntimeException("Unknown state");
        }
        return PositionMetadata.obtain(flPos, 2, groupPos, -1, null, insertPosition);
    }

    public PositionMetadata getFlattenedPos(ExpandableListPosition pos) {
        ArrayList<GroupMetadata> egml = this.mExpGroupMetadataList;
        int numExpGroups = egml.size();
        int leftExpGroupIndex = 0;
        int rightExpGroupIndex = numExpGroups - 1;
        int midExpGroupIndex = 0;
        if (numExpGroups == 0) {
            return PositionMetadata.obtain(pos.groupPos, pos.type, pos.groupPos, pos.childPos, null, 0);
        }
        while (leftExpGroupIndex <= rightExpGroupIndex) {
            midExpGroupIndex = (rightExpGroupIndex - leftExpGroupIndex) / 2 + leftExpGroupIndex;
            GroupMetadata midExpGm = egml.get(midExpGroupIndex);
            if (pos.groupPos > midExpGm.gPos) {
                leftExpGroupIndex = midExpGroupIndex + 1;
                continue;
            }
            if (pos.groupPos < midExpGm.gPos) {
                rightExpGroupIndex = midExpGroupIndex - 1;
                continue;
            }
            if (pos.groupPos != midExpGm.gPos) continue;
            if (pos.type == 2) {
                return PositionMetadata.obtain(midExpGm.flPos, pos.type, pos.groupPos, pos.childPos, midExpGm, midExpGroupIndex);
            }
            if (pos.type == 1) {
                return PositionMetadata.obtain(midExpGm.flPos + pos.childPos + 1, pos.type, pos.groupPos, pos.childPos, midExpGm, midExpGroupIndex);
            }
            return null;
        }
        if (pos.type != 2) {
            return null;
        }
        if (leftExpGroupIndex > midExpGroupIndex) {
            GroupMetadata leftExpGm = egml.get(leftExpGroupIndex - 1);
            int flPos = leftExpGm.lastChildFlPos + (pos.groupPos - leftExpGm.gPos);
            return PositionMetadata.obtain(flPos, pos.type, pos.groupPos, pos.childPos, null, leftExpGroupIndex);
        }
        if (rightExpGroupIndex < midExpGroupIndex) {
            GroupMetadata rightExpGm = egml.get(++rightExpGroupIndex);
            int flPos = rightExpGm.flPos - (rightExpGm.gPos - pos.groupPos);
            return PositionMetadata.obtain(flPos, pos.type, pos.groupPos, pos.childPos, null, rightExpGroupIndex);
        }
        return null;
    }

    @Override
    public boolean areAllItemsEnabled() {
        return this.mExpandableListAdapter.areAllItemsEnabled();
    }

    @Override
    public boolean isEnabled(int flatListPos) {
        ExpandableListPosition pos = this.getUnflattenedPos((int)flatListPos).position;
        boolean retValue = pos.type == 1 ? this.mExpandableListAdapter.isChildSelectable(pos.groupPos, pos.childPos) : true;
        pos.recycle();
        return retValue;
    }

    @Override
    public int getCount() {
        return this.mExpandableListAdapter.getGroupCount() + this.mTotalExpChildrenCount;
    }

    @Override
    public Object getItem(int flatListPos) {
        Object retValue;
        PositionMetadata posMetadata = this.getUnflattenedPos(flatListPos);
        if (posMetadata.position.type == 2) {
            retValue = this.mExpandableListAdapter.getGroup(posMetadata.position.groupPos);
        } else if (posMetadata.position.type == 1) {
            retValue = this.mExpandableListAdapter.getChild(posMetadata.position.groupPos, posMetadata.position.childPos);
        } else {
            throw new RuntimeException("Flat list position is of unknown type");
        }
        posMetadata.recycle();
        return retValue;
    }

    @Override
    public long getItemId(int flatListPos) {
        long retValue;
        PositionMetadata posMetadata = this.getUnflattenedPos(flatListPos);
        long groupId = this.mExpandableListAdapter.getGroupId(posMetadata.position.groupPos);
        if (posMetadata.position.type == 2) {
            retValue = this.mExpandableListAdapter.getCombinedGroupId(groupId);
        } else if (posMetadata.position.type == 1) {
            long childId = this.mExpandableListAdapter.getChildId(posMetadata.position.groupPos, posMetadata.position.childPos);
            retValue = this.mExpandableListAdapter.getCombinedChildId(groupId, childId);
        } else {
            throw new RuntimeException("Flat list position is of unknown type");
        }
        posMetadata.recycle();
        return retValue;
    }

    @Override
    public View getView(int flatListPos, View convertView, ViewGroup parent) {
        View retValue;
        PositionMetadata posMetadata = this.getUnflattenedPos(flatListPos);
        if (posMetadata.position.type == 2) {
            retValue = this.mExpandableListAdapter.getGroupView(posMetadata.position.groupPos, posMetadata.isExpanded(), convertView, parent);
        } else if (posMetadata.position.type == 1) {
            boolean isLastChild = posMetadata.groupMetadata.lastChildFlPos == flatListPos;
            retValue = this.mExpandableListAdapter.getChildView(posMetadata.position.groupPos, posMetadata.position.childPos, isLastChild, convertView, parent);
        } else {
            throw new RuntimeException("Flat list position is of unknown type");
        }
        posMetadata.recycle();
        return retValue;
    }

    @Override
    public int getItemViewType(int flatListPos) {
        ExpandableListPosition pos = this.getUnflattenedPos((int)flatListPos).position;
        int retValue = pos.type == 2 ? 0 : 1;
        pos.recycle();
        return retValue;
    }

    @Override
    public int getViewTypeCount() {
        return 2;
    }

    @Override
    public boolean hasStableIds() {
        return this.mExpandableListAdapter.hasStableIds();
    }

    public void refreshExpGroupMetadataList(boolean forceChildrenCountRefresh, boolean syncGroupPositions) {
        ArrayList<GroupMetadata> egml = this.mExpGroupMetadataList;
        int egmlSize = egml.size();
        int curFlPos = 0;
        this.mTotalExpChildrenCount = 0;
        if (syncGroupPositions) {
            boolean positionsChanged = false;
            for (int i = egmlSize - 1; i >= 0; --i) {
                GroupMetadata curGm = egml.get(i);
                int newGPos = this.findGroupPosition(curGm.gId, curGm.gPos);
                if (newGPos == curGm.gPos) continue;
                if (newGPos == -1) {
                    egml.remove(i);
                    --egmlSize;
                }
                curGm.gPos = newGPos;
                if (positionsChanged) continue;
                positionsChanged = true;
            }
            if (positionsChanged) {
                Collections.sort(egml);
            }
        }
        int lastGPos = 0;
        for (int i = 0; i < egmlSize; ++i) {
            GroupMetadata curGm = egml.get(i);
            int gChildrenCount = curGm.lastChildFlPos == -1 || forceChildrenCountRefresh ? this.mExpandableListAdapter.getChildrenCount(curGm.gPos) : curGm.lastChildFlPos - curGm.flPos;
            this.mTotalExpChildrenCount += gChildrenCount;
            lastGPos = curGm.gPos;
            curGm.flPos = curFlPos += curGm.gPos - lastGPos;
            curGm.lastChildFlPos = curFlPos += gChildrenCount;
        }
    }

    public boolean collapseGroup(int groupPos) {
        PositionMetadata pm = this.getFlattenedPos(ExpandableListPosition.obtain(2, groupPos, -1, -1));
        if (pm == null) {
            return false;
        }
        boolean retValue = this.collapseGroup(pm);
        pm.recycle();
        return retValue;
    }

    public boolean collapseGroup(PositionMetadata posMetadata) {
        if (posMetadata.groupMetadata == null) {
            return false;
        }
        this.mExpGroupMetadataList.remove(posMetadata.groupMetadata);
        this.refreshExpGroupMetadataList(false, false);
        this.notifyDataSetChanged();
        this.mExpandableListAdapter.onGroupCollapsed(posMetadata.groupMetadata.gPos);
        return true;
    }

    public boolean expandGroup(int groupPos) {
        PositionMetadata pm = this.getFlattenedPos(ExpandableListPosition.obtain(2, groupPos, -1, -1));
        boolean retValue = this.expandGroup(pm);
        pm.recycle();
        return retValue;
    }

    public boolean expandGroup(PositionMetadata posMetadata) {
        if (posMetadata.position.groupPos < 0) {
            throw new RuntimeException("Need group");
        }
        if (this.mMaxExpGroupCount == 0) {
            return false;
        }
        if (posMetadata.groupMetadata != null) {
            return false;
        }
        if (this.mExpGroupMetadataList.size() >= this.mMaxExpGroupCount) {
            GroupMetadata collapsedGm = this.mExpGroupMetadataList.get(0);
            int collapsedIndex = this.mExpGroupMetadataList.indexOf(collapsedGm);
            this.collapseGroup(collapsedGm.gPos);
            if (posMetadata.groupInsertIndex > collapsedIndex) {
                --posMetadata.groupInsertIndex;
            }
        }
        GroupMetadata expandedGm = GroupMetadata.obtain(-1, -1, posMetadata.position.groupPos, this.mExpandableListAdapter.getGroupId(posMetadata.position.groupPos));
        this.mExpGroupMetadataList.add(posMetadata.groupInsertIndex, expandedGm);
        this.refreshExpGroupMetadataList(false, false);
        this.notifyDataSetChanged();
        this.mExpandableListAdapter.onGroupExpanded(expandedGm.gPos);
        return true;
    }

    public boolean isGroupExpanded(int groupPosition) {
        for (int i = this.mExpGroupMetadataList.size() - 1; i >= 0; --i) {
            GroupMetadata groupMetadata = this.mExpGroupMetadataList.get(i);
            if (groupMetadata.gPos != groupPosition) continue;
            return true;
        }
        return false;
    }

    public void setMaxExpGroupCount(int maxExpGroupCount) {
        this.mMaxExpGroupCount = maxExpGroupCount;
    }

    public ExpandableListAdapter getAdapter() {
        return this.mExpandableListAdapter;
    }

    @Override
    public Filter getFilter() {
        ExpandableListAdapter adapter = this.getAdapter();
        if (adapter instanceof Filterable) {
            return ((Filterable)((Object)adapter)).getFilter();
        }
        return null;
    }

    public ArrayList<GroupMetadata> getExpandedGroupMetadataList() {
        return this.mExpGroupMetadataList;
    }

    public void setExpandedGroupMetadataList(ArrayList<GroupMetadata> expandedGroupMetadataList) {
        if (expandedGroupMetadataList == null || this.mExpandableListAdapter == null) {
            return;
        }
        int numGroups = this.mExpandableListAdapter.getGroupCount();
        for (int i = expandedGroupMetadataList.size() - 1; i >= 0; --i) {
            if (expandedGroupMetadataList.get((int)i).gPos < numGroups) continue;
            return;
        }
        this.mExpGroupMetadataList = expandedGroupMetadataList;
        this.refreshExpGroupMetadataList(true, false);
    }

    @Override
    public boolean isEmpty() {
        ExpandableListAdapter adapter = this.getAdapter();
        return adapter != null ? adapter.isEmpty() : true;
    }

    public int findGroupPosition(long groupIdToMatch, int seedGroupPosition) {
        int count = this.mExpandableListAdapter.getGroupCount();
        if (count == 0) {
            return -1;
        }
        if (groupIdToMatch == Long.MIN_VALUE) {
            return -1;
        }
        seedGroupPosition = Math.max(0, seedGroupPosition);
        seedGroupPosition = Math.min(count - 1, seedGroupPosition);
        long endTime = SystemClock.uptimeMillis() + 100L;
        int first = seedGroupPosition;
        int last = seedGroupPosition;
        boolean next = false;
        ExpandableListAdapter adapter = this.getAdapter();
        if (adapter == null) {
            return -1;
        }
        while (SystemClock.uptimeMillis() <= endTime) {
            boolean hitFirst;
            long rowId = adapter.getGroupId(seedGroupPosition);
            if (rowId == groupIdToMatch) {
                return seedGroupPosition;
            }
            boolean hitLast = last == count - 1;
            boolean bl = hitFirst = first == 0;
            if (hitLast && hitFirst) break;
            if (hitFirst || next && !hitLast) {
                seedGroupPosition = ++last;
                next = false;
                continue;
            }
            if (!hitLast && (next || hitFirst)) continue;
            seedGroupPosition = --first;
            next = true;
        }
        return -1;
    }

    public static class PositionMetadata {
        public static final int MAX_POOL_SIZE = 5;
        public static ArrayList<PositionMetadata> sPool = new ArrayList(5);
        public ExpandableListPosition position;
        public GroupMetadata groupMetadata;
        public int groupInsertIndex;

        public void resetState() {
            this.position = null;
            this.groupMetadata = null;
            this.groupInsertIndex = 0;
        }

        public static PositionMetadata obtain(int flatListPos, int type, int groupPos, int childPos, GroupMetadata groupMetadata, int groupInsertIndex) {
            PositionMetadata pm = PositionMetadata.getRecycledOrCreate();
            pm.position = ExpandableListPosition.obtain(type, groupPos, childPos, flatListPos);
            pm.groupMetadata = groupMetadata;
            pm.groupInsertIndex = groupInsertIndex;
            return pm;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static PositionMetadata getRecycledOrCreate() {
            PositionMetadata pm;
            ArrayList<PositionMetadata> arrayList = sPool;
            synchronized (arrayList) {
                if (sPool.size() <= 0) {
                    return new PositionMetadata();
                }
                pm = sPool.remove(0);
            }
            pm.resetState();
            return pm;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void recycle() {
            ArrayList<PositionMetadata> arrayList = sPool;
            synchronized (arrayList) {
                if (sPool.size() < 5) {
                    sPool.add(this);
                }
            }
        }

        public boolean isExpanded() {
            return this.groupMetadata != null;
        }
    }

    public static class GroupMetadata
    implements Parcelable,
    Comparable {
        public static final int REFRESH = -1;
        public int flPos;
        public int lastChildFlPos;
        public int gPos;
        public long gId;
        public static final Parcelable.Creator<GroupMetadata> CREATOR = new Parcelable.Creator<GroupMetadata>(){

            @Override
            public GroupMetadata createFromParcel(Parcel in) {
                GroupMetadata gm = GroupMetadata.obtain(in.readInt(), in.readInt(), in.readInt(), in.readLong());
                return gm;
            }

            public GroupMetadata[] newArray(int size) {
                return new GroupMetadata[size];
            }
        };

        public static GroupMetadata obtain(int flPos, int lastChildFlPos, int gPos, long gId) {
            GroupMetadata gm = new GroupMetadata();
            gm.flPos = flPos;
            gm.lastChildFlPos = lastChildFlPos;
            gm.gPos = gPos;
            gm.gId = gId;
            return gm;
        }

        public int compareTo(Object another) {
            if (another == null || !(another instanceof GroupMetadata)) {
                throw new ClassCastException();
            }
            return this.gPos - ((GroupMetadata)another).gPos;
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.flPos);
            dest.writeInt(this.lastChildFlPos);
            dest.writeInt(this.gPos);
            dest.writeLong(this.gId);
        }
    }

    public class MyDataSetObserver
    extends DataSetObserver {
        public void onChanged() {
            ExpandableListConnector.this.refreshExpGroupMetadataList(true, true);
            ExpandableListConnector.this.notifyDataSetChanged();
        }

        public void onInvalidated() {
            ExpandableListConnector.this.refreshExpGroupMetadataList(true, true);
            ExpandableListConnector.this.notifyDataSetInvalidated();
        }
    }
}

