/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.ContextMenu;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ExpandableListAdapter;
import android.widget.ExpandableListConnector;
import android.widget.ExpandableListPosition;
import android.widget.ListAdapter;
import android.widget.ListView;
import com.android.internal.R;
import java.util.ArrayList;

public class ExpandableListView
extends ListView {
    public static final int PACKED_POSITION_TYPE_GROUP = 0;
    public static final int PACKED_POSITION_TYPE_CHILD = 1;
    public static final int PACKED_POSITION_TYPE_NULL = 2;
    public static final long PACKED_POSITION_VALUE_NULL = 0xFFFFFFFFL;
    public static final long PACKED_POSITION_MASK_CHILD = 0xFFFFFFFFL;
    public static final long PACKED_POSITION_MASK_GROUP = 0x7FFFFFFF00000000L;
    public static final long PACKED_POSITION_MASK_TYPE = Long.MIN_VALUE;
    public static final long PACKED_POSITION_SHIFT_GROUP = 32L;
    public static final long PACKED_POSITION_SHIFT_TYPE = 63L;
    public static final long PACKED_POSITION_INT_MASK_CHILD = -1L;
    public static final long PACKED_POSITION_INT_MASK_GROUP = Integer.MAX_VALUE;
    public ExpandableListConnector mConnector;
    public ExpandableListAdapter mAdapter;
    public int mIndicatorLeft;
    public int mIndicatorRight;
    public int mChildIndicatorLeft;
    public int mChildIndicatorRight;
    public static final int CHILD_INDICATOR_INHERIT = -1;
    public Drawable mGroupIndicator;
    public Drawable mChildIndicator;
    public static final int[] EMPTY_STATE_SET = new int[0];
    public static final int[] GROUP_EXPANDED_STATE_SET = new int[]{16842920};
    public static final int[] GROUP_EMPTY_STATE_SET = new int[]{16842921};
    public static final int[] GROUP_EXPANDED_EMPTY_STATE_SET = new int[]{16842920, 16842921};
    public static final int[][] GROUP_STATE_SETS = new int[][]{EMPTY_STATE_SET, GROUP_EXPANDED_STATE_SET, GROUP_EMPTY_STATE_SET, GROUP_EXPANDED_EMPTY_STATE_SET};
    public static final int[] CHILD_LAST_STATE_SET = new int[]{16842918};
    public Drawable mChildDivider;
    public boolean mClipChildDivider;
    public final Rect mIndicatorRect = new Rect();
    public OnGroupCollapseListener mOnGroupCollapseListener;
    public OnGroupExpandListener mOnGroupExpandListener;
    public OnGroupClickListener mOnGroupClickListener;
    public OnChildClickListener mOnChildClickListener;

    public ExpandableListView(Context context) {
        this(context, null);
    }

    public ExpandableListView(Context context, AttributeSet attrs) {
        this(context, attrs, 16842863);
    }

    public ExpandableListView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.ExpandableListView, defStyle, 0);
        this.mGroupIndicator = a.getDrawable(0);
        this.mChildIndicator = a.getDrawable(1);
        this.mIndicatorLeft = a.getDimensionPixelSize(2, 0);
        this.mIndicatorRight = a.getDimensionPixelSize(3, 0);
        this.mChildIndicatorLeft = a.getDimensionPixelSize(4, -1);
        this.mChildIndicatorRight = a.getDimensionPixelSize(5, -1);
        this.mChildDivider = a.getDrawable(6);
        a.recycle();
    }

    public void dispatchDraw(Canvas canvas) {
        boolean clipToPadding;
        super.dispatchDraw(canvas);
        if (this.mChildIndicator == null && this.mGroupIndicator == null) {
            return;
        }
        int saveCount = 0;
        boolean bl = clipToPadding = (this.mGroupFlags & 0x22) == 34;
        if (clipToPadding) {
            saveCount = canvas.save();
            int scrollX = this.mScrollX;
            int scrollY = this.mScrollY;
            canvas.clipRect(scrollX + this.mPaddingLeft, scrollY + this.mPaddingTop, scrollX + this.mRight - this.mLeft - this.mPaddingRight, scrollY + this.mBottom - this.mTop - this.mPaddingBottom);
        }
        int headerViewsCount = this.getHeaderViewsCount();
        int lastChildFlPos = this.mItemCount - this.getFooterViewsCount() - headerViewsCount - 1;
        int myB = this.mBottom;
        int lastItemType = -4;
        Rect indicatorRect = this.mIndicatorRect;
        int childCount = this.getChildCount();
        int i = 0;
        int childFlPos = this.mFirstPosition - headerViewsCount;
        while (i < childCount) {
            if (childFlPos >= 0) {
                if (childFlPos > lastChildFlPos) break;
                View item = this.getChildAt(i);
                int t = item.getTop();
                int b = item.getBottom();
                if (b >= 0 && t <= myB) {
                    ExpandableListConnector.PositionMetadata pos = this.mConnector.getUnflattenedPos(childFlPos);
                    if (pos.position.type != lastItemType) {
                        if (pos.position.type == 1) {
                            indicatorRect.left = this.mChildIndicatorLeft == -1 ? this.mIndicatorLeft : this.mChildIndicatorLeft;
                            indicatorRect.right = this.mChildIndicatorRight == -1 ? this.mIndicatorRight : this.mChildIndicatorRight;
                        } else {
                            indicatorRect.left = this.mIndicatorLeft;
                            indicatorRect.right = this.mIndicatorRight;
                        }
                        lastItemType = pos.position.type;
                    }
                    if (indicatorRect.left != indicatorRect.right) {
                        if (this.mStackFromBottom) {
                            indicatorRect.top = t;
                            indicatorRect.bottom = b;
                        } else {
                            indicatorRect.top = t;
                            indicatorRect.bottom = b;
                        }
                        Drawable indicator = this.getIndicator(pos);
                        if (indicator != null) {
                            indicator.setBounds(indicatorRect);
                            indicator.draw(canvas);
                        }
                    }
                    pos.recycle();
                }
            }
            ++i;
            ++childFlPos;
        }
        if (clipToPadding) {
            canvas.restoreToCount(saveCount);
        }
    }

    public Drawable getIndicator(ExpandableListConnector.PositionMetadata pos) {
        Drawable indicator;
        if (pos.position.type == 2) {
            indicator = this.mGroupIndicator;
            if (indicator != null && indicator.isStateful()) {
                boolean isEmpty = pos.groupMetadata == null || pos.groupMetadata.lastChildFlPos == pos.groupMetadata.flPos;
                int stateSetIndex = (pos.isExpanded() ? 1 : 0) | (isEmpty ? 2 : 0);
                indicator.setState(GROUP_STATE_SETS[stateSetIndex]);
            }
        } else {
            indicator = this.mChildIndicator;
            if (indicator != null && indicator.isStateful()) {
                int[] stateSet = pos.position.flatListPos == pos.groupMetadata.lastChildFlPos ? CHILD_LAST_STATE_SET : EMPTY_STATE_SET;
                indicator.setState(stateSet);
            }
        }
        return indicator;
    }

    public void setChildDivider(Drawable childDivider) {
        this.mChildDivider = childDivider;
        this.mClipChildDivider = childDivider != null && childDivider instanceof ColorDrawable;
    }

    public void drawDivider(Canvas canvas, Rect bounds, int childIndex) {
        int flatListPosition = childIndex + this.mFirstPosition;
        if (flatListPosition >= 0) {
            ExpandableListConnector.PositionMetadata pos = this.mConnector.getUnflattenedPos(flatListPosition);
            if (pos.position.type == 1 || pos.isExpanded() && pos.groupMetadata.lastChildFlPos != pos.groupMetadata.flPos) {
                Drawable divider = this.mChildDivider;
                boolean clip = this.mClipChildDivider;
                if (!clip) {
                    divider.setBounds(bounds);
                } else {
                    canvas.save();
                    canvas.clipRect(bounds);
                }
                divider.draw(canvas);
                if (clip) {
                    canvas.restore();
                }
                pos.recycle();
                return;
            }
            pos.recycle();
        }
        super.drawDivider(canvas, bounds, flatListPosition);
    }

    public void setAdapter(ListAdapter adapter) {
        throw new RuntimeException("For ExpandableListView, use setAdapter(ExpandableListAdapter) instead of setAdapter(ListAdapter)");
    }

    public ListAdapter getAdapter() {
        return super.getAdapter();
    }

    public void setOnItemClickListener(AdapterView.OnItemClickListener l) {
        super.setOnItemClickListener(l);
    }

    public void setAdapter(ExpandableListAdapter adapter) {
        this.mAdapter = adapter;
        this.mConnector = adapter != null ? new ExpandableListConnector(adapter) : null;
        super.setAdapter(this.mConnector);
    }

    public ExpandableListAdapter getExpandableListAdapter() {
        return this.mAdapter;
    }

    public boolean performItemClick(View v, int position, long id2) {
        int headerViewsCount = this.getHeaderViewsCount();
        int footerViewsStart = this.mItemCount - this.getFooterViewsCount();
        if (position < headerViewsCount || position >= footerViewsStart) {
            return super.performItemClick(v, position, id2);
        }
        return this.handleItemClick(v, position - headerViewsCount, id2);
    }

    public boolean handleItemClick(View v, int position, long id2) {
        boolean returnValue;
        ExpandableListConnector.PositionMetadata posMetadata = this.mConnector.getUnflattenedPos(position);
        id2 = this.getChildOrGroupId(posMetadata.position);
        if (posMetadata.position.type == 2) {
            if (posMetadata.isExpanded()) {
                this.mConnector.collapseGroup(posMetadata);
                this.playSoundEffect(0);
                if (this.mOnGroupCollapseListener != null) {
                    this.mOnGroupCollapseListener.onGroupCollapse(posMetadata.position.groupPos);
                }
            } else {
                if (this.mOnGroupClickListener != null && this.mOnGroupClickListener.onGroupClick(this, v, posMetadata.position.groupPos, id2)) {
                    posMetadata.recycle();
                    return true;
                }
                this.mConnector.expandGroup(posMetadata);
                this.playSoundEffect(0);
                if (this.mOnGroupExpandListener != null) {
                    this.mOnGroupExpandListener.onGroupExpand(posMetadata.position.groupPos);
                }
            }
            returnValue = true;
        } else {
            if (this.mOnChildClickListener != null) {
                this.playSoundEffect(0);
                return this.mOnChildClickListener.onChildClick(this, v, posMetadata.position.groupPos, posMetadata.position.childPos, id2);
            }
            returnValue = false;
        }
        posMetadata.recycle();
        return returnValue;
    }

    public boolean expandGroup(int groupPos) {
        boolean retValue = this.mConnector.expandGroup(groupPos);
        if (this.mOnGroupExpandListener != null) {
            this.mOnGroupExpandListener.onGroupExpand(groupPos);
        }
        return retValue;
    }

    public boolean collapseGroup(int groupPos) {
        boolean retValue = this.mConnector.collapseGroup(groupPos);
        if (this.mOnGroupCollapseListener != null) {
            this.mOnGroupCollapseListener.onGroupCollapse(groupPos);
        }
        return retValue;
    }

    public void setOnGroupCollapseListener(OnGroupCollapseListener onGroupCollapseListener) {
        this.mOnGroupCollapseListener = onGroupCollapseListener;
    }

    public void setOnGroupExpandListener(OnGroupExpandListener onGroupExpandListener) {
        this.mOnGroupExpandListener = onGroupExpandListener;
    }

    public void setOnGroupClickListener(OnGroupClickListener onGroupClickListener) {
        this.mOnGroupClickListener = onGroupClickListener;
    }

    public void setOnChildClickListener(OnChildClickListener onChildClickListener) {
        this.mOnChildClickListener = onChildClickListener;
    }

    public long getExpandableListPosition(int flatListPosition) {
        ExpandableListConnector.PositionMetadata pm = this.mConnector.getUnflattenedPos(flatListPosition);
        long packedPos = pm.position.getPackedPosition();
        pm.recycle();
        return packedPos;
    }

    public int getFlatListPosition(long packedPosition) {
        ExpandableListConnector.PositionMetadata pm = this.mConnector.getFlattenedPos(ExpandableListPosition.obtainPosition(packedPosition));
        int retValue = pm.position.flatListPos;
        pm.recycle();
        return retValue;
    }

    public long getSelectedPosition() {
        int selectedPos = this.getSelectedItemPosition();
        if (selectedPos == -1) {
            return 0xFFFFFFFFL;
        }
        return this.getExpandableListPosition(selectedPos);
    }

    public long getSelectedId() {
        long packedPos = this.getSelectedPosition();
        if (packedPos == 0xFFFFFFFFL) {
            return -1L;
        }
        int groupPos = ExpandableListView.getPackedPositionGroup(packedPos);
        if (ExpandableListView.getPackedPositionType(packedPos) == 0) {
            return this.mAdapter.getGroupId(groupPos);
        }
        return this.mAdapter.getChildId(groupPos, ExpandableListView.getPackedPositionChild(packedPos));
    }

    public void setSelectedGroup(int groupPosition) {
        ExpandableListPosition elGroupPos = ExpandableListPosition.obtainGroupPosition(groupPosition);
        ExpandableListConnector.PositionMetadata pm = this.mConnector.getFlattenedPos(elGroupPos);
        elGroupPos.recycle();
        super.setSelection(pm.position.flatListPos);
        pm.recycle();
    }

    public boolean setSelectedChild(int groupPosition, int childPosition, boolean shouldExpandGroup) {
        ExpandableListPosition elChildPos = ExpandableListPosition.obtainChildPosition(groupPosition, childPosition);
        ExpandableListConnector.PositionMetadata flatChildPos = this.mConnector.getFlattenedPos(elChildPos);
        if (flatChildPos == null) {
            if (!shouldExpandGroup) {
                return false;
            }
            this.expandGroup(groupPosition);
            flatChildPos = this.mConnector.getFlattenedPos(elChildPos);
            if (flatChildPos == null) {
                throw new IllegalStateException("Could not find child");
            }
        }
        super.setSelection(flatChildPos.position.flatListPos);
        elChildPos.recycle();
        flatChildPos.recycle();
        return true;
    }

    public boolean isGroupExpanded(int groupPosition) {
        return this.mConnector.isGroupExpanded(groupPosition);
    }

    public static int getPackedPositionType(long packedPosition) {
        if (packedPosition == 0xFFFFFFFFL) {
            return 2;
        }
        return (packedPosition & Long.MIN_VALUE) == Long.MIN_VALUE ? 1 : 0;
    }

    public static int getPackedPositionGroup(long packedPosition) {
        if (packedPosition == 0xFFFFFFFFL) {
            return -1;
        }
        return (int)((packedPosition & 0x7FFFFFFF00000000L) >> 32);
    }

    public static int getPackedPositionChild(long packedPosition) {
        if (packedPosition == 0xFFFFFFFFL) {
            return -1;
        }
        if ((packedPosition & Long.MIN_VALUE) != Long.MIN_VALUE) {
            return -1;
        }
        return (int)(packedPosition & 0xFFFFFFFFL);
    }

    public static long getPackedPositionForChild(int groupPosition, int childPosition) {
        return Long.MIN_VALUE | ((long)groupPosition & Integer.MAX_VALUE) << 32 | (long)childPosition & 0xFFFFFFFFFFFFFFFFL;
    }

    public static long getPackedPositionForGroup(int groupPosition) {
        return ((long)groupPosition & Integer.MAX_VALUE) << 32;
    }

    public ContextMenu.ContextMenuInfo createContextMenuInfo(View view, int flatListPosition, long id2) {
        int adjustedPosition = flatListPosition - this.getHeaderViewsCount();
        if (adjustedPosition < 0) {
            return new AdapterView.AdapterContextMenuInfo(view, flatListPosition, id2);
        }
        ExpandableListConnector.PositionMetadata pm = this.mConnector.getUnflattenedPos(adjustedPosition);
        ExpandableListPosition pos = pm.position;
        pm.recycle();
        id2 = this.getChildOrGroupId(pos);
        long packedPosition = pos.getPackedPosition();
        pos.recycle();
        return new ExpandableListContextMenuInfo(view, packedPosition, id2);
    }

    public long getChildOrGroupId(ExpandableListPosition position) {
        if (position.type == 1) {
            return this.mAdapter.getChildId(position.groupPos, position.childPos);
        }
        return this.mAdapter.getGroupId(position.groupPos);
    }

    public void setChildIndicator(Drawable childIndicator) {
        this.mChildIndicator = childIndicator;
    }

    public void setChildIndicatorBounds(int left, int right) {
        this.mChildIndicatorLeft = left;
        this.mChildIndicatorRight = right;
    }

    public void setGroupIndicator(Drawable groupIndicator) {
        this.mGroupIndicator = groupIndicator;
    }

    public void setIndicatorBounds(int left, int right) {
        this.mIndicatorLeft = left;
        this.mIndicatorRight = right;
    }

    public Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        return new SavedState(superState, this.mConnector != null ? this.mConnector.getExpandedGroupMetadataList() : null);
    }

    public void onRestoreInstanceState(Parcelable state) {
        if (!(state instanceof SavedState)) {
            super.onRestoreInstanceState(state);
            return;
        }
        SavedState ss = (SavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        if (this.mConnector != null && ss.expandedGroupMetadataList != null) {
            this.mConnector.setExpandedGroupMetadataList(ss.expandedGroupMetadataList);
        }
    }

    public static class 1 {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SavedState
    extends View.BaseSavedState {
        public ArrayList<ExpandableListConnector.GroupMetadata> expandedGroupMetadataList;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            @Override
            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in, null);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        public SavedState(Parcelable superState, ArrayList<ExpandableListConnector.GroupMetadata> expandedGroupMetadataList) {
            super(superState);
            this.expandedGroupMetadataList = expandedGroupMetadataList;
        }

        public SavedState(Parcel in) {
            super(in);
            this.expandedGroupMetadataList = new ArrayList();
            in.readList(this.expandedGroupMetadataList, ExpandableListConnector.class.getClassLoader());
        }

        @Override
        public void writeToParcel(Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeList(this.expandedGroupMetadataList);
        }

        public /* synthetic */ SavedState(Parcel x0, 1 x1) {
            this(x0);
        }
    }

    public static class ExpandableListContextMenuInfo
    implements ContextMenu.ContextMenuInfo {
        public View targetView;
        public long packedPosition;
        public long id;

        public ExpandableListContextMenuInfo(View targetView, long packedPosition, long id2) {
            this.targetView = targetView;
            this.packedPosition = packedPosition;
            this.id = id2;
        }
    }

    public static interface OnChildClickListener {
        public boolean onChildClick(ExpandableListView var1, View var2, int var3, int var4, long var5);
    }

    public static interface OnGroupClickListener {
        public boolean onGroupClick(ExpandableListView var1, View var2, int var3, long var4);
    }

    public static interface OnGroupExpandListener {
        public void onGroupExpand(int var1);
    }

    public static interface OnGroupCollapseListener {
        public void onGroupCollapse(int var1);
    }
}

