/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.SoundEffectConstants;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.GridLayoutAnimationController;
import android.widget.AbsListView;
import android.widget.AdapterView;
import android.widget.ListAdapter;
import com.android.internal.R;

public class GridView
extends AbsListView {
    public static final int NO_STRETCH = 0;
    public static final int STRETCH_SPACING = 1;
    public static final int STRETCH_COLUMN_WIDTH = 2;
    public static final int STRETCH_SPACING_UNIFORM = 3;
    public static final int AUTO_FIT = -1;
    public int mNumColumns = -1;
    public int mHorizontalSpacing = 0;
    public int mRequestedHorizontalSpacing;
    public int mVerticalSpacing = 0;
    public int mStretchMode = 2;
    public int mColumnWidth;
    public int mRequestedColumnWidth;
    public int mRequestedNumColumns;
    public View mReferenceView = null;
    public View mReferenceViewInSelectedRow = null;
    public int mGravity = 3;
    public final Rect mTempRect = new Rect();

    public GridView(Context context) {
        super(context);
    }

    public GridView(Context context, AttributeSet attrs) {
        this(context, attrs, 0x1010071);
    }

    public GridView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        int columnWidth;
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.GridView, defStyle, 0);
        int hSpacing = a.getDimensionPixelOffset(1, 0);
        this.setHorizontalSpacing(hSpacing);
        int vSpacing = a.getDimensionPixelOffset(2, 0);
        this.setVerticalSpacing(vSpacing);
        int index = a.getInt(3, 2);
        if (index >= 0) {
            this.setStretchMode(index);
        }
        if ((columnWidth = a.getDimensionPixelOffset(4, -1)) > 0) {
            this.setColumnWidth(columnWidth);
        }
        int numColumns = a.getInt(5, 1);
        this.setNumColumns(numColumns);
        index = a.getInt(0, -1);
        if (index >= 0) {
            this.setGravity(index);
        }
        a.recycle();
    }

    public ListAdapter getAdapter() {
        return this.mAdapter;
    }

    public void setAdapter(ListAdapter adapter) {
        if (null != this.mAdapter) {
            this.mAdapter.unregisterDataSetObserver(this.mDataSetObserver);
        }
        this.resetList();
        this.mRecycler.clear();
        this.mAdapter = adapter;
        this.mOldSelectedPosition = -1;
        this.mOldSelectedRowId = Long.MIN_VALUE;
        if (this.mAdapter != null) {
            this.mOldItemCount = this.mItemCount;
            this.mItemCount = this.mAdapter.getCount();
            this.mDataChanged = true;
            this.checkFocus();
            this.mDataSetObserver = new AdapterView.AdapterDataSetObserver();
            this.mAdapter.registerDataSetObserver(this.mDataSetObserver);
            this.mRecycler.setViewTypeCount(this.mAdapter.getViewTypeCount());
            int position = this.mStackFromBottom ? this.lookForSelectablePosition(this.mItemCount - 1, false) : this.lookForSelectablePosition(0, true);
            this.setSelectedPositionInt(position);
            this.setNextSelectedPositionInt(position);
            this.checkSelectionChanged();
        } else {
            this.checkFocus();
            this.checkSelectionChanged();
        }
        this.requestLayout();
    }

    public int lookForSelectablePosition(int position, boolean lookDown) {
        ListAdapter adapter = this.mAdapter;
        if (adapter == null || this.isInTouchMode()) {
            return -1;
        }
        if (position < 0 || position >= this.mItemCount) {
            return -1;
        }
        return position;
    }

    public void fillGap(boolean down) {
        int numColumns = this.mNumColumns;
        int verticalSpacing = this.mVerticalSpacing;
        int count = this.getChildCount();
        if (down) {
            int startOffset = count > 0 ? this.getChildAt(count - 1).getBottom() + verticalSpacing : this.getListPaddingTop();
            int position = this.mFirstPosition + count;
            if (this.mStackFromBottom) {
                position += numColumns - 1;
            }
            this.fillDown(position, startOffset);
            this.correctTooHigh(numColumns, verticalSpacing, this.getChildCount());
        } else {
            int startOffset = count > 0 ? this.getChildAt(0).getTop() - verticalSpacing : this.getHeight() - this.getListPaddingBottom();
            int position = this.mFirstPosition;
            position = !this.mStackFromBottom ? (position -= numColumns) : --position;
            this.fillUp(position, startOffset);
            this.correctTooLow(numColumns, verticalSpacing, this.getChildCount());
        }
    }

    public View fillDown(int pos, int nextTop) {
        View selectedView = null;
        int end = this.mBottom - this.mTop - this.mListPadding.bottom;
        while (nextTop < end && pos < this.mItemCount) {
            View temp = this.makeRow(pos, nextTop, true);
            if (temp != null) {
                selectedView = temp;
            }
            nextTop = this.mReferenceView.getBottom() + this.mVerticalSpacing;
            pos += this.mNumColumns;
        }
        return selectedView;
    }

    public View makeRow(int startPos, int y, boolean flow) {
        int last;
        int columnWidth = this.mColumnWidth;
        int horizontalSpacing = this.mHorizontalSpacing;
        int nextLeft = this.mListPadding.left + (this.mStretchMode == 3 ? horizontalSpacing : 0);
        if (!this.mStackFromBottom) {
            last = Math.min(startPos + this.mNumColumns, this.mItemCount);
        } else {
            last = startPos + 1;
            if (last - (startPos = Math.max(0, startPos - this.mNumColumns + 1)) < this.mNumColumns) {
                nextLeft += (this.mNumColumns - (last - startPos)) * (columnWidth + horizontalSpacing);
            }
        }
        View selectedView = null;
        boolean hasFocus = this.shouldShowSelector();
        boolean inClick = this.touchModeDrawsInPressedState();
        int selectedPosition = this.mSelectedPosition;
        View child = null;
        for (int pos = startPos; pos < last; ++pos) {
            boolean selected = pos == selectedPosition;
            int where = flow ? -1 : pos - startPos;
            child = this.makeAndAddView(pos, y, flow, nextLeft, selected, where);
            nextLeft += columnWidth;
            if (pos < last - 1) {
                nextLeft += horizontalSpacing;
            }
            if (!selected || !hasFocus && !inClick) continue;
            selectedView = child;
        }
        this.mReferenceView = child;
        if (selectedView != null) {
            this.mReferenceViewInSelectedRow = this.mReferenceView;
        }
        return selectedView;
    }

    public View fillUp(int pos, int nextBottom) {
        View selectedView = null;
        int end = this.mListPadding.top;
        while (nextBottom > end && pos >= 0) {
            View temp = this.makeRow(pos, nextBottom, false);
            if (temp != null) {
                selectedView = temp;
            }
            nextBottom = this.mReferenceView.getTop() - this.mVerticalSpacing;
            this.mFirstPosition = pos;
            pos -= this.mNumColumns;
        }
        if (this.mStackFromBottom) {
            this.mFirstPosition = Math.max(0, pos + 1);
        }
        return selectedView;
    }

    public View fillFromTop(int nextTop) {
        this.mFirstPosition = Math.min(this.mFirstPosition, this.mSelectedPosition);
        this.mFirstPosition = Math.min(this.mFirstPosition, this.mItemCount - 1);
        if (this.mFirstPosition < 0) {
            this.mFirstPosition = 0;
        }
        this.mFirstPosition -= this.mFirstPosition % this.mNumColumns;
        return this.fillDown(this.mFirstPosition, nextTop);
    }

    public View fillFromBottom(int lastPosition, int nextBottom) {
        lastPosition = Math.max(lastPosition, this.mSelectedPosition);
        lastPosition = Math.min(lastPosition, this.mItemCount - 1);
        int invertedPosition = this.mItemCount - 1 - lastPosition;
        lastPosition = this.mItemCount - 1 - (invertedPosition - invertedPosition % this.mNumColumns);
        return this.fillUp(lastPosition, nextBottom);
    }

    public View fillSelection(int childrenTop, int childrenBottom) {
        int rowStart;
        int selectedPosition = this.reconcileSelectedPosition();
        int numColumns = this.mNumColumns;
        int verticalSpacing = this.mVerticalSpacing;
        int rowEnd = -1;
        if (!this.mStackFromBottom) {
            rowStart = selectedPosition - selectedPosition % numColumns;
        } else {
            int invertedSelection = this.mItemCount - 1 - selectedPosition;
            rowEnd = this.mItemCount - 1 - (invertedSelection - invertedSelection % numColumns);
            rowStart = Math.max(0, rowEnd - numColumns + 1);
        }
        int fadingEdgeLength = this.getVerticalFadingEdgeLength();
        int topSelectionPixel = this.getTopSelectionPixel(childrenTop, fadingEdgeLength, rowStart);
        View sel = this.makeRow(this.mStackFromBottom ? rowEnd : rowStart, topSelectionPixel, true);
        this.mFirstPosition = rowStart;
        View referenceView = this.mReferenceView;
        if (!this.mStackFromBottom) {
            this.fillDown(rowStart + numColumns, referenceView.getBottom() + verticalSpacing);
            this.pinToBottom(childrenBottom);
            this.fillUp(rowStart - numColumns, referenceView.getTop() - verticalSpacing);
            this.adjustViewsUpOrDown();
        } else {
            int bottomSelectionPixel = this.getBottomSelectionPixel(childrenBottom, fadingEdgeLength, numColumns, rowStart);
            int offset = bottomSelectionPixel - referenceView.getBottom();
            this.offsetChildrenTopAndBottom(offset);
            this.fillUp(rowStart - 1, referenceView.getTop() - verticalSpacing);
            this.pinToTop(childrenTop);
            this.fillDown(rowEnd + numColumns, referenceView.getBottom() + verticalSpacing);
            this.adjustViewsUpOrDown();
        }
        return sel;
    }

    public void pinToTop(int childrenTop) {
        int top;
        int offset;
        if (this.mFirstPosition == 0 && (offset = childrenTop - (top = this.getChildAt(0).getTop())) < 0) {
            this.offsetChildrenTopAndBottom(offset);
        }
    }

    public void pinToBottom(int childrenBottom) {
        int bottom;
        int offset;
        int count = this.getChildCount();
        if (this.mFirstPosition + count == this.mItemCount && (offset = childrenBottom - (bottom = this.getChildAt(count - 1).getBottom())) > 0) {
            this.offsetChildrenTopAndBottom(offset);
        }
    }

    public int findMotionRow(int y) {
        int childCount = this.getChildCount();
        if (childCount > 0) {
            int numColumns = this.mNumColumns;
            if (!this.mStackFromBottom) {
                for (int i = 0; i < childCount; i += numColumns) {
                    if (y > this.getChildAt(i).getBottom()) continue;
                    return this.mFirstPosition + i;
                }
            } else {
                for (int i = childCount - 1; i >= 0; i -= numColumns) {
                    if (y < this.getChildAt(i).getTop()) continue;
                    return this.mFirstPosition + i;
                }
            }
            return this.mFirstPosition + childCount - 1;
        }
        return -1;
    }

    public View fillSpecific(int position, int top) {
        View below;
        View above;
        int motionRowStart;
        int numColumns = this.mNumColumns;
        int motionRowEnd = -1;
        if (!this.mStackFromBottom) {
            motionRowStart = position - position % numColumns;
        } else {
            int invertedSelection = this.mItemCount - 1 - position;
            motionRowEnd = this.mItemCount - 1 - (invertedSelection - invertedSelection % numColumns);
            motionRowStart = Math.max(0, motionRowEnd - numColumns + 1);
        }
        View temp = this.makeRow(this.mStackFromBottom ? motionRowEnd : motionRowStart, top, true);
        this.mFirstPosition = motionRowStart;
        View referenceView = this.mReferenceView;
        if (referenceView == null) {
            return null;
        }
        int verticalSpacing = this.mVerticalSpacing;
        if (!this.mStackFromBottom) {
            above = this.fillUp(motionRowStart - numColumns, referenceView.getTop() - verticalSpacing);
            this.adjustViewsUpOrDown();
            below = this.fillDown(motionRowStart + numColumns, referenceView.getBottom() + verticalSpacing);
            int childCount = this.getChildCount();
            if (childCount > 0) {
                this.correctTooHigh(numColumns, verticalSpacing, childCount);
            }
        } else {
            below = this.fillDown(motionRowEnd + numColumns, referenceView.getBottom() + verticalSpacing);
            this.adjustViewsUpOrDown();
            above = this.fillUp(motionRowStart - 1, referenceView.getTop() - verticalSpacing);
            int childCount = this.getChildCount();
            if (childCount > 0) {
                this.correctTooLow(numColumns, verticalSpacing, childCount);
            }
        }
        if (temp != null) {
            return temp;
        }
        if (above != null) {
            return above;
        }
        return below;
    }

    public void correctTooHigh(int numColumns, int verticalSpacing, int childCount) {
        int lastPosition = this.mFirstPosition + childCount - 1;
        if (lastPosition == this.mItemCount - 1 && childCount > 0) {
            View lastChild = this.getChildAt(childCount - 1);
            int lastBottom = lastChild.getBottom();
            int end = this.mBottom - this.mTop - this.mListPadding.bottom;
            int bottomOffset = end - lastBottom;
            View firstChild = this.getChildAt(0);
            int firstTop = firstChild.getTop();
            if (bottomOffset > 0 && (this.mFirstPosition > 0 || firstTop < this.mListPadding.top)) {
                if (this.mFirstPosition == 0) {
                    bottomOffset = Math.min(bottomOffset, this.mListPadding.top - firstTop);
                }
                this.offsetChildrenTopAndBottom(bottomOffset);
                if (this.mFirstPosition > 0) {
                    this.fillUp(this.mFirstPosition - (this.mStackFromBottom ? 1 : numColumns), firstChild.getTop() - verticalSpacing);
                    this.adjustViewsUpOrDown();
                }
            }
        }
    }

    public void correctTooLow(int numColumns, int verticalSpacing, int childCount) {
        if (this.mFirstPosition == 0 && childCount > 0) {
            View firstChild = this.getChildAt(0);
            int firstTop = firstChild.getTop();
            int start = this.mListPadding.top;
            int end = this.mBottom - this.mTop - this.mListPadding.bottom;
            int topOffset = firstTop - start;
            View lastChild = this.getChildAt(childCount - 1);
            int lastBottom = lastChild.getBottom();
            int lastPosition = this.mFirstPosition + childCount - 1;
            if (topOffset > 0 && (lastPosition < this.mItemCount - 1 || lastBottom > end)) {
                if (lastPosition == this.mItemCount - 1) {
                    topOffset = Math.min(topOffset, lastBottom - end);
                }
                this.offsetChildrenTopAndBottom(-topOffset);
                if (lastPosition < this.mItemCount - 1) {
                    this.fillDown(lastPosition + (!this.mStackFromBottom ? 1 : numColumns), lastChild.getBottom() + verticalSpacing);
                    this.adjustViewsUpOrDown();
                }
            }
        }
    }

    public View fillFromSelection(int selectedTop, int childrenTop, int childrenBottom) {
        int rowStart;
        int fadingEdgeLength = this.getVerticalFadingEdgeLength();
        int selectedPosition = this.mSelectedPosition;
        int numColumns = this.mNumColumns;
        int verticalSpacing = this.mVerticalSpacing;
        int rowEnd = -1;
        if (!this.mStackFromBottom) {
            rowStart = selectedPosition - selectedPosition % numColumns;
        } else {
            int invertedSelection = this.mItemCount - 1 - selectedPosition;
            rowEnd = this.mItemCount - 1 - (invertedSelection - invertedSelection % numColumns);
            rowStart = Math.max(0, rowEnd - numColumns + 1);
        }
        int topSelectionPixel = this.getTopSelectionPixel(childrenTop, fadingEdgeLength, rowStart);
        int bottomSelectionPixel = this.getBottomSelectionPixel(childrenBottom, fadingEdgeLength, numColumns, rowStart);
        View sel = this.makeRow(this.mStackFromBottom ? rowEnd : rowStart, selectedTop, true);
        this.mFirstPosition = rowStart;
        View referenceView = this.mReferenceView;
        this.adjustForTopFadingEdge(referenceView, topSelectionPixel, bottomSelectionPixel);
        this.adjustForBottomFadingEdge(referenceView, topSelectionPixel, bottomSelectionPixel);
        if (!this.mStackFromBottom) {
            this.fillUp(rowStart - numColumns, referenceView.getTop() - verticalSpacing);
            this.adjustViewsUpOrDown();
            this.fillDown(rowStart + numColumns, referenceView.getBottom() + verticalSpacing);
        } else {
            this.fillDown(rowEnd + numColumns, referenceView.getBottom() + verticalSpacing);
            this.adjustViewsUpOrDown();
            this.fillUp(rowStart - 1, referenceView.getTop() - verticalSpacing);
        }
        return sel;
    }

    public int getBottomSelectionPixel(int childrenBottom, int fadingEdgeLength, int numColumns, int rowStart) {
        int bottomSelectionPixel = childrenBottom;
        if (rowStart + numColumns - 1 < this.mItemCount - 1) {
            bottomSelectionPixel -= fadingEdgeLength;
        }
        return bottomSelectionPixel;
    }

    public int getTopSelectionPixel(int childrenTop, int fadingEdgeLength, int rowStart) {
        int topSelectionPixel = childrenTop;
        if (rowStart > 0) {
            topSelectionPixel += fadingEdgeLength;
        }
        return topSelectionPixel;
    }

    public void adjustForBottomFadingEdge(View childInSelectedRow, int topSelectionPixel, int bottomSelectionPixel) {
        if (childInSelectedRow.getBottom() > bottomSelectionPixel) {
            int spaceAbove = childInSelectedRow.getTop() - topSelectionPixel;
            int spaceBelow = childInSelectedRow.getBottom() - bottomSelectionPixel;
            int offset = Math.min(spaceAbove, spaceBelow);
            this.offsetChildrenTopAndBottom(-offset);
        }
    }

    public void adjustForTopFadingEdge(View childInSelectedRow, int topSelectionPixel, int bottomSelectionPixel) {
        if (childInSelectedRow.getTop() < topSelectionPixel) {
            int spaceAbove = topSelectionPixel - childInSelectedRow.getTop();
            int spaceBelow = bottomSelectionPixel - childInSelectedRow.getBottom();
            int offset = Math.min(spaceAbove, spaceBelow);
            this.offsetChildrenTopAndBottom(offset);
        }
    }

    public View moveSelection(int delta, int childrenTop, int childrenBottom) {
        View referenceView;
        View sel;
        int rowStart;
        int oldRowStart;
        int fadingEdgeLength = this.getVerticalFadingEdgeLength();
        int selectedPosition = this.mSelectedPosition;
        int numColumns = this.mNumColumns;
        int verticalSpacing = this.mVerticalSpacing;
        int rowEnd = -1;
        if (!this.mStackFromBottom) {
            oldRowStart = selectedPosition - delta - (selectedPosition - delta) % numColumns;
            rowStart = selectedPosition - selectedPosition % numColumns;
        } else {
            int invertedSelection = this.mItemCount - 1 - selectedPosition;
            rowEnd = this.mItemCount - 1 - (invertedSelection - invertedSelection % numColumns);
            rowStart = Math.max(0, rowEnd - numColumns + 1);
            invertedSelection = this.mItemCount - 1 - (selectedPosition - delta);
            oldRowStart = this.mItemCount - 1 - (invertedSelection - invertedSelection % numColumns);
            oldRowStart = Math.max(0, oldRowStart - numColumns + 1);
        }
        int rowDelta = rowStart - oldRowStart;
        int topSelectionPixel = this.getTopSelectionPixel(childrenTop, fadingEdgeLength, rowStart);
        int bottomSelectionPixel = this.getBottomSelectionPixel(childrenBottom, fadingEdgeLength, numColumns, rowStart);
        this.mFirstPosition = rowStart;
        if (rowDelta > 0) {
            int oldBottom = this.mReferenceViewInSelectedRow == null ? 0 : this.mReferenceViewInSelectedRow.getBottom();
            sel = this.makeRow(this.mStackFromBottom ? rowEnd : rowStart, oldBottom + verticalSpacing, true);
            referenceView = this.mReferenceView;
            this.adjustForBottomFadingEdge(referenceView, topSelectionPixel, bottomSelectionPixel);
        } else if (rowDelta < 0) {
            int oldTop = this.mReferenceViewInSelectedRow == null ? 0 : this.mReferenceViewInSelectedRow.getTop();
            sel = this.makeRow(this.mStackFromBottom ? rowEnd : rowStart, oldTop - verticalSpacing, false);
            referenceView = this.mReferenceView;
            this.adjustForTopFadingEdge(referenceView, topSelectionPixel, bottomSelectionPixel);
        } else {
            int oldTop = this.mReferenceViewInSelectedRow == null ? 0 : this.mReferenceViewInSelectedRow.getTop();
            sel = this.makeRow(this.mStackFromBottom ? rowEnd : rowStart, oldTop, true);
            referenceView = this.mReferenceView;
        }
        if (!this.mStackFromBottom) {
            this.fillUp(rowStart - numColumns, referenceView.getTop() - verticalSpacing);
            this.adjustViewsUpOrDown();
            this.fillDown(rowStart + numColumns, referenceView.getBottom() + verticalSpacing);
        } else {
            this.fillDown(rowEnd + numColumns, referenceView.getBottom() + verticalSpacing);
            this.adjustViewsUpOrDown();
            this.fillUp(rowStart - 1, referenceView.getTop() - verticalSpacing);
        }
        return sel;
    }

    public void determineColumns(int availableSpace) {
        int requestedHorizontalSpacing = this.mRequestedHorizontalSpacing;
        int stretchMode = this.mStretchMode;
        int requestedColumnWidth = this.mRequestedColumnWidth;
        this.mNumColumns = this.mRequestedNumColumns == -1 ? (requestedColumnWidth > 0 ? (availableSpace + requestedHorizontalSpacing) / (requestedColumnWidth + requestedHorizontalSpacing) : 2) : this.mRequestedNumColumns;
        if (this.mNumColumns <= 0) {
            this.mNumColumns = 1;
        }
        block0 : switch (stretchMode) {
            case 0: {
                this.mColumnWidth = requestedColumnWidth;
                this.mHorizontalSpacing = requestedHorizontalSpacing;
                break;
            }
            default: {
                int spaceLeftOver = availableSpace - this.mNumColumns * requestedColumnWidth - (this.mNumColumns - 1) * requestedHorizontalSpacing;
                switch (stretchMode) {
                    case 2: {
                        this.mColumnWidth = requestedColumnWidth + spaceLeftOver / this.mNumColumns;
                        this.mHorizontalSpacing = requestedHorizontalSpacing;
                        break block0;
                    }
                    case 1: {
                        this.mColumnWidth = requestedColumnWidth;
                        if (this.mNumColumns > 1) {
                            this.mHorizontalSpacing = requestedHorizontalSpacing + spaceLeftOver / (this.mNumColumns - 1);
                            break block0;
                        }
                        this.mHorizontalSpacing = requestedHorizontalSpacing + spaceLeftOver;
                        break block0;
                    }
                    case 3: {
                        this.mColumnWidth = requestedColumnWidth;
                        this.mHorizontalSpacing = this.mNumColumns > 1 ? requestedHorizontalSpacing + spaceLeftOver / (this.mNumColumns + 1) : requestedHorizontalSpacing + spaceLeftOver;
                    }
                }
            }
        }
    }

    public void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int widthMode = View.MeasureSpec.getMode(widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode(heightMeasureSpec);
        int widthSize = View.MeasureSpec.getSize(widthMeasureSpec);
        int heightSize = View.MeasureSpec.getSize(heightMeasureSpec);
        if (widthMode == 0) {
            widthSize = this.mColumnWidth > 0 ? this.mColumnWidth + this.mListPadding.left + this.mListPadding.right : this.mListPadding.left + this.mListPadding.right;
            widthSize += this.getVerticalScrollbarWidth();
        }
        int childWidth = widthSize - this.mListPadding.left - this.mListPadding.right;
        this.determineColumns(childWidth);
        int childHeight = 0;
        int count = this.mItemCount = this.mAdapter == null ? 0 : this.mAdapter.getCount();
        if (count > 0) {
            View child = this.obtainView(0);
            AbsListView.LayoutParams p = (AbsListView.LayoutParams)child.getLayoutParams();
            if (p == null) {
                p = new AbsListView.LayoutParams(-1, -2, 0);
                child.setLayoutParams(p);
            }
            p.viewType = this.mAdapter.getItemViewType(0);
            int childHeightSpec = GridView.getChildMeasureSpec(View.MeasureSpec.makeMeasureSpec(0, 0), 0, p.height);
            int childWidthSpec = GridView.getChildMeasureSpec(View.MeasureSpec.makeMeasureSpec(this.mColumnWidth, 0x40000000), 0, p.width);
            child.measure(childWidthSpec, childHeightSpec);
            childHeight = child.getMeasuredHeight();
            if (this.mRecycler.shouldRecycleViewType(p.viewType)) {
                this.mRecycler.addScrapView(child);
            }
        }
        if (heightMode == 0) {
            heightSize = this.mListPadding.top + this.mListPadding.bottom + childHeight + this.getVerticalFadingEdgeLength() * 2;
        }
        if (heightMode == Integer.MIN_VALUE) {
            int ourSize = this.mListPadding.top + this.mListPadding.bottom;
            int numColumns = this.mNumColumns;
            for (int i = 0; i < count; i += numColumns) {
                ourSize += childHeight;
                if (i + numColumns < count) {
                    ourSize += this.mVerticalSpacing;
                }
                if (ourSize < heightSize) continue;
                ourSize = heightSize;
                break;
            }
            heightSize = ourSize;
        }
        this.setMeasuredDimension(widthSize, heightSize);
        this.mWidthMeasureSpec = widthMeasureSpec;
    }

    public void attachLayoutAnimationParameters(View child, ViewGroup.LayoutParams params, int index, int count) {
        GridLayoutAnimationController.AnimationParameters animationParams = (GridLayoutAnimationController.AnimationParameters)params.layoutAnimationParameters;
        if (animationParams == null) {
            animationParams = new GridLayoutAnimationController.AnimationParameters();
            params.layoutAnimationParameters = animationParams;
        }
        animationParams.count = count;
        animationParams.index = index;
        animationParams.columnsCount = this.mNumColumns;
        animationParams.rowsCount = count / this.mNumColumns;
        if (!this.mStackFromBottom) {
            animationParams.column = index % this.mNumColumns;
            animationParams.row = index / this.mNumColumns;
        } else {
            int invertedIndex = count - 1 - index;
            animationParams.column = this.mNumColumns - 1 - invertedIndex % this.mNumColumns;
            animationParams.row = animationParams.rowsCount - 1 - invertedIndex / this.mNumColumns;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void layoutChildren() {
        boolean blockLayoutRequests;
        block33: {
            block32: {
                blockLayoutRequests = this.mBlockLayoutRequests;
                if (!blockLayoutRequests) {
                    this.mBlockLayoutRequests = true;
                }
                try {
                    View sel;
                    boolean dataChanged;
                    super.layoutChildren();
                    this.invalidate();
                    if (this.mAdapter == null) {
                        this.resetList();
                        this.invokeOnItemScrollListener();
                        Object var16_2 = null;
                        if (blockLayoutRequests) return;
                        this.mBlockLayoutRequests = false;
                        return;
                    }
                    int childrenTop = this.mListPadding.top;
                    int childrenBottom = this.mBottom - this.mTop - this.mListPadding.bottom;
                    int childCount = this.getChildCount();
                    int delta = 0;
                    View oldSel = null;
                    View oldFirst = null;
                    View newSel = null;
                    switch (this.mLayoutMode) {
                        case 2: {
                            int index = this.mNextSelectedPosition - this.mFirstPosition;
                            if (index < 0 || index >= childCount) break;
                            newSel = this.getChildAt(index);
                            break;
                        }
                        case 1: 
                        case 3: 
                        case 4: 
                        case 5: {
                            break;
                        }
                        case 6: {
                            if (this.mNextSelectedPosition < 0) break;
                            delta = this.mNextSelectedPosition - this.mSelectedPosition;
                            break;
                        }
                        default: {
                            int index = this.mSelectedPosition - this.mFirstPosition;
                            if (index >= 0 && index < childCount) {
                                oldSel = this.getChildAt(index);
                            }
                            oldFirst = this.getChildAt(0);
                        }
                    }
                    if (dataChanged = this.mDataChanged) {
                        this.handleDataChanged();
                    }
                    if (this.mItemCount == 0) {
                        this.resetList();
                        this.invokeOnItemScrollListener();
                        break block32;
                    }
                    this.setSelectedPositionInt(this.mNextSelectedPosition);
                    int firstPosition = this.mFirstPosition;
                    AbsListView.RecycleBin recycleBin = this.mRecycler;
                    if (dataChanged) {
                        for (int i = 0; i < childCount; ++i) {
                            recycleBin.addScrapView(this.getChildAt(i));
                        }
                    } else {
                        recycleBin.fillActiveViews(childCount, firstPosition);
                    }
                    this.detachAllViewsFromParent();
                    switch (this.mLayoutMode) {
                        case 2: {
                            if (newSel != null) {
                                sel = this.fillFromSelection(newSel.getTop(), childrenTop, childrenBottom);
                                break;
                            }
                            sel = this.fillSelection(childrenTop, childrenBottom);
                            break;
                        }
                        case 1: {
                            this.mFirstPosition = 0;
                            sel = this.fillFromTop(childrenTop);
                            this.adjustViewsUpOrDown();
                            break;
                        }
                        case 3: {
                            sel = this.fillUp(this.mItemCount - 1, childrenBottom);
                            this.adjustViewsUpOrDown();
                            break;
                        }
                        case 4: {
                            sel = this.fillSpecific(this.mSelectedPosition, this.mSpecificTop);
                            break;
                        }
                        case 5: {
                            sel = this.fillSpecific(this.mSyncPosition, this.mSpecificTop);
                            break;
                        }
                        case 6: {
                            sel = this.moveSelection(delta, childrenTop, childrenBottom);
                            break;
                        }
                        default: {
                            if (childCount == 0) {
                                if (!this.mStackFromBottom) {
                                    this.setSelectedPositionInt(0);
                                    sel = this.fillFromTop(childrenTop);
                                    break;
                                }
                                int last = this.mItemCount - 1;
                                this.setSelectedPositionInt(last);
                                sel = this.fillFromBottom(last, childrenBottom);
                                break;
                            }
                            sel = this.mSelectedPosition >= 0 && this.mSelectedPosition < this.mItemCount ? this.fillSpecific(this.mSelectedPosition, oldSel == null ? childrenTop : oldSel.getTop()) : (this.mFirstPosition < this.mItemCount ? this.fillSpecific(this.mFirstPosition, oldFirst == null ? childrenTop : oldFirst.getTop()) : this.fillSpecific(0, childrenTop));
                        }
                    }
                    recycleBin.scrapActiveViews();
                    if (sel != null) {
                        this.positionSelector(sel);
                        this.mSelectedTop = sel.getTop();
                    } else if (this.mTouchMode > 0 && this.mTouchMode < 3) {
                        View child = this.getChildAt(this.mMotionPosition - this.mFirstPosition);
                        if (child != null) {
                            this.positionSelector(child);
                        }
                    } else {
                        this.mSelectedTop = 0;
                        this.mSelectorRect.setEmpty();
                    }
                    this.mLayoutMode = 0;
                    this.mDataChanged = false;
                    this.mNeedSync = false;
                    this.setNextSelectedPositionInt(this.mSelectedPosition);
                    this.updateScrollIndicators();
                    if (this.mItemCount > 0) {
                        this.checkSelectionChanged();
                    }
                    this.invokeOnItemScrollListener();
                    break block33;
                }
                catch (Throwable throwable) {
                    Object var16_5 = null;
                    if (blockLayoutRequests) throw throwable;
                    this.mBlockLayoutRequests = false;
                    throw throwable;
                }
            }
            Object var16_3 = null;
            if (blockLayoutRequests) return;
            this.mBlockLayoutRequests = false;
            return;
        }
        Object var16_4 = null;
        if (blockLayoutRequests) return;
        this.mBlockLayoutRequests = false;
    }

    public View makeAndAddView(int position, int y, boolean flow, int childrenLeft, boolean selected, int where) {
        View child;
        if (!this.mDataChanged && (child = this.mRecycler.getActiveView(position)) != null) {
            this.setupChild(child, position, y, flow, childrenLeft, selected, true, where);
            return child;
        }
        child = this.obtainView(position);
        this.setupChild(child, position, y, flow, childrenLeft, selected, false, where);
        return child;
    }

    public void setupChild(View child, int position, int y, boolean flow, int childrenLeft, boolean selected, boolean recycled, int where) {
        int childLeft;
        boolean isSelected = selected && this.shouldShowSelector();
        boolean updateChildSelected = isSelected != child.isSelected();
        int mode = this.mTouchMode;
        boolean isPressed = mode > 0 && mode < 3 && this.mMotionPosition == position;
        boolean updateChildPressed = isPressed != child.isPressed();
        boolean needToMeasure = !recycled || updateChildSelected || child.isLayoutRequested();
        AbsListView.LayoutParams p = (AbsListView.LayoutParams)child.getLayoutParams();
        if (p == null) {
            p = new AbsListView.LayoutParams(-1, -2, 0);
        }
        p.viewType = this.mAdapter.getItemViewType(position);
        if (recycled) {
            this.attachViewToParent(child, where, p);
        } else {
            this.addViewInLayout(child, where, p, true);
        }
        if (updateChildSelected) {
            child.setSelected(isSelected);
            if (isSelected) {
                this.requestFocus();
            }
        }
        if (updateChildPressed) {
            child.setPressed(isPressed);
        }
        if (needToMeasure) {
            int childHeightSpec = ViewGroup.getChildMeasureSpec(View.MeasureSpec.makeMeasureSpec(0, 0), 0, p.height);
            int childWidthSpec = ViewGroup.getChildMeasureSpec(View.MeasureSpec.makeMeasureSpec(this.mColumnWidth, 0x40000000), 0, p.width);
            child.measure(childWidthSpec, childHeightSpec);
        } else {
            this.cleanupLayoutState(child);
        }
        int w = child.getMeasuredWidth();
        int h = child.getMeasuredHeight();
        int childTop = flow ? y : y - h;
        switch (this.mGravity & 7) {
            case 3: {
                childLeft = childrenLeft;
                break;
            }
            case 1: {
                childLeft = childrenLeft + (this.mColumnWidth - w) / 2;
                break;
            }
            case 5: {
                childLeft = childrenLeft + this.mColumnWidth - w;
                break;
            }
            default: {
                childLeft = childrenLeft;
            }
        }
        if (needToMeasure) {
            int childRight = childLeft + w;
            int childBottom = childTop + h;
            child.layout(childLeft, childTop, childRight, childBottom);
        } else {
            child.offsetLeftAndRight(childLeft - child.getLeft());
            child.offsetTopAndBottom(childTop - child.getTop());
        }
        if (this.mCachingStarted) {
            child.setDrawingCacheEnabled(true);
        }
    }

    public void setSelection(int position) {
        if (!this.isInTouchMode()) {
            this.setNextSelectedPositionInt(position);
        } else {
            this.mResurrectToPosition = position;
        }
        this.mLayoutMode = 2;
        this.requestLayout();
    }

    public void setSelectionInt(int position) {
        int previousSelectedPosition = this.mNextSelectedPosition;
        this.setNextSelectedPositionInt(position);
        this.layoutChildren();
        int next = this.mStackFromBottom ? this.mItemCount - 1 - this.mNextSelectedPosition : this.mNextSelectedPosition;
        int previous = this.mStackFromBottom ? this.mItemCount - 1 - previousSelectedPosition : previousSelectedPosition;
        int nextRow = next / this.mNumColumns;
        int previousRow = previous / this.mNumColumns;
        if (nextRow != previousRow) {
            this.awakenScrollBars();
        }
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        return this.commonKey(keyCode, 1, event);
    }

    public boolean onKeyMultiple(int keyCode, int repeatCount, KeyEvent event) {
        return this.commonKey(keyCode, repeatCount, event);
    }

    public boolean onKeyUp(int keyCode, KeyEvent event) {
        return this.commonKey(keyCode, 1, event);
    }

    public boolean commonKey(int keyCode, int count, KeyEvent event) {
        if (this.mAdapter == null) {
            return false;
        }
        if (this.mDataChanged) {
            this.layoutChildren();
        }
        boolean handled = false;
        int action = event.getAction();
        if (action != 1) {
            if (this.mSelectedPosition < 0) {
                switch (keyCode) {
                    case 19: 
                    case 20: 
                    case 21: 
                    case 22: 
                    case 23: 
                    case 62: 
                    case 66: {
                        this.resurrectSelection();
                        return true;
                    }
                }
            }
            switch (keyCode) {
                case 21: {
                    handled = this.arrowScroll(17);
                    break;
                }
                case 22: {
                    handled = this.arrowScroll(66);
                    break;
                }
                case 19: {
                    if (!event.isAltPressed()) {
                        handled = this.arrowScroll(33);
                        break;
                    }
                    handled = this.fullScroll(33);
                    break;
                }
                case 20: {
                    if (!event.isAltPressed()) {
                        handled = this.arrowScroll(130);
                        break;
                    }
                    handled = this.fullScroll(130);
                    break;
                }
                case 23: 
                case 66: {
                    if (this.getChildCount() > 0 && event.getRepeatCount() == 0) {
                        this.keyPressed();
                    }
                    return true;
                }
                case 62: {
                    if (this.mPopup != null && this.mPopup.isShowing()) break;
                    handled = !event.isShiftPressed() ? this.pageScroll(130) : this.pageScroll(33);
                }
            }
        }
        if (!handled) {
            handled = this.sendToTextFilter(keyCode, count, event);
        }
        if (handled) {
            return true;
        }
        switch (action) {
            case 0: {
                return super.onKeyDown(keyCode, event);
            }
            case 1: {
                return super.onKeyUp(keyCode, event);
            }
            case 2: {
                return super.onKeyMultiple(keyCode, count, event);
            }
        }
        return false;
    }

    public boolean pageScroll(int direction) {
        int nextPage = -1;
        if (direction == 33) {
            nextPage = Math.max(0, this.mSelectedPosition - this.getChildCount() - 1);
        } else if (direction == 130) {
            nextPage = Math.min(this.mItemCount - 1, this.mSelectedPosition + this.getChildCount() - 1);
        }
        if (nextPage >= 0) {
            this.setSelectionInt(nextPage);
            this.invokeOnItemScrollListener();
            this.awakenScrollBars();
            return true;
        }
        return false;
    }

    public boolean fullScroll(int direction) {
        boolean moved = false;
        if (direction == 33) {
            this.mLayoutMode = 2;
            this.setSelectionInt(0);
            this.invokeOnItemScrollListener();
            moved = true;
        } else if (direction == 130) {
            this.mLayoutMode = 2;
            this.setSelectionInt(this.mItemCount - 1);
            this.invokeOnItemScrollListener();
            moved = true;
        }
        if (moved) {
            this.awakenScrollBars();
        }
        return moved;
    }

    public boolean arrowScroll(int direction) {
        int endOfRowPos;
        int startOfRowPos;
        int selectedPosition = this.mSelectedPosition;
        int numColumns = this.mNumColumns;
        boolean moved = false;
        if (!this.mStackFromBottom) {
            startOfRowPos = selectedPosition / numColumns * numColumns;
            endOfRowPos = Math.min(startOfRowPos + numColumns - 1, this.mItemCount - 1);
        } else {
            int invertedSelection = this.mItemCount - 1 - selectedPosition;
            endOfRowPos = this.mItemCount - 1 - invertedSelection / numColumns * numColumns;
            startOfRowPos = Math.max(0, endOfRowPos - numColumns + 1);
        }
        switch (direction) {
            case 33: {
                if (startOfRowPos <= 0) break;
                this.mLayoutMode = 6;
                this.setSelectionInt(Math.max(0, selectedPosition - numColumns));
                moved = true;
                break;
            }
            case 130: {
                if (endOfRowPos >= this.mItemCount - 1) break;
                this.mLayoutMode = 6;
                this.setSelectionInt(Math.min(selectedPosition + numColumns, this.mItemCount - 1));
                moved = true;
                break;
            }
            case 17: {
                if (selectedPosition <= startOfRowPos) break;
                this.mLayoutMode = 6;
                this.setSelectionInt(Math.max(0, selectedPosition - 1));
                moved = true;
                break;
            }
            case 66: {
                if (selectedPosition >= endOfRowPos) break;
                this.mLayoutMode = 6;
                this.setSelectionInt(Math.min(selectedPosition + 1, this.mItemCount - 1));
                moved = true;
            }
        }
        if (moved) {
            this.playSoundEffect(SoundEffectConstants.getContantForFocusDirection(direction));
            this.invokeOnItemScrollListener();
        }
        if (moved) {
            this.awakenScrollBars();
        }
        return moved;
    }

    public void onFocusChanged(boolean gainFocus, int direction, Rect previouslyFocusedRect) {
        super.onFocusChanged(gainFocus, direction, previouslyFocusedRect);
        int closestChildIndex = -1;
        if (gainFocus && previouslyFocusedRect != null) {
            previouslyFocusedRect.offset(this.mScrollX, this.mScrollY);
            Rect otherRect = this.mTempRect;
            int minDistance = Integer.MAX_VALUE;
            int childCount = this.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                if (!this.isCandidateSelection(i, direction)) continue;
                View other = this.getChildAt(i);
                other.getDrawingRect(otherRect);
                this.offsetDescendantRectToMyCoords(other, otherRect);
                int distance = GridView.getDistance(previouslyFocusedRect, otherRect, direction);
                if (distance >= minDistance) continue;
                minDistance = distance;
                closestChildIndex = i;
            }
        }
        if (closestChildIndex >= 0) {
            this.setSelection(closestChildIndex + this.mFirstPosition);
        } else {
            this.requestLayout();
        }
    }

    public boolean isCandidateSelection(int childIndex, int direction) {
        int rowEnd;
        int rowStart;
        int count = this.getChildCount();
        int invertedIndex = count - 1 - childIndex;
        if (!this.mStackFromBottom) {
            rowStart = childIndex - childIndex % this.mNumColumns;
            rowEnd = Math.max(rowStart + this.mNumColumns - 1, count);
        } else {
            rowEnd = count - 1 - (invertedIndex - invertedIndex % this.mNumColumns);
            rowStart = Math.max(0, rowEnd - this.mNumColumns + 1);
        }
        switch (direction) {
            case 66: {
                return childIndex == rowStart;
            }
            case 130: {
                return rowStart == 0;
            }
            case 17: {
                return childIndex == rowEnd;
            }
            case 33: {
                return rowEnd == count - 1;
            }
        }
        throw new IllegalArgumentException("direction must be one of {FOCUS_UP, FOCUS_DOWN, FOCUS_LEFT, FOCUS_RIGHT}.");
    }

    public void setGravity(int gravity) {
        if (this.mGravity != gravity) {
            this.mGravity = gravity;
            this.requestLayoutIfNecessary();
        }
    }

    public void setHorizontalSpacing(int horizontalSpacing) {
        if (horizontalSpacing != this.mRequestedHorizontalSpacing) {
            this.mRequestedHorizontalSpacing = horizontalSpacing;
            this.requestLayoutIfNecessary();
        }
    }

    public void setVerticalSpacing(int verticalSpacing) {
        if (verticalSpacing != this.mVerticalSpacing) {
            this.mVerticalSpacing = verticalSpacing;
            this.requestLayoutIfNecessary();
        }
    }

    public void setStretchMode(int stretchMode) {
        if (stretchMode != this.mStretchMode) {
            this.mStretchMode = stretchMode;
            this.requestLayoutIfNecessary();
        }
    }

    public int getStretchMode() {
        return this.mStretchMode;
    }

    public void setColumnWidth(int columnWidth) {
        if (columnWidth != this.mRequestedColumnWidth) {
            this.mRequestedColumnWidth = columnWidth;
            this.requestLayoutIfNecessary();
        }
    }

    public void setNumColumns(int numColumns) {
        if (numColumns != this.mRequestedNumColumns) {
            this.mRequestedNumColumns = numColumns;
            this.requestLayoutIfNecessary();
        }
    }

    public void adjustViewsUpOrDown() {
        int childCount = this.getChildCount();
        if (childCount > 0) {
            int delta;
            if (!this.mStackFromBottom) {
                View child = this.getChildAt(0);
                delta = child.getTop() - this.mListPadding.top;
                if (this.mFirstPosition != 0) {
                    delta -= this.mVerticalSpacing;
                }
                if (delta < 0) {
                    delta = 0;
                }
            } else {
                View child = this.getChildAt(childCount - 1);
                delta = child.getBottom() - (this.getHeight() - this.mListPadding.bottom);
                if (this.mFirstPosition + childCount < this.mItemCount) {
                    delta += this.mVerticalSpacing;
                }
                if (delta > 0) {
                    delta = 0;
                }
            }
            if (delta != 0) {
                this.offsetChildrenTopAndBottom(-delta);
            }
        }
    }

    public int computeVerticalScrollExtent() {
        int count = this.getChildCount();
        if (count > 0) {
            int numColumns = this.mNumColumns;
            int rowCount = (count + numColumns - 1) / numColumns;
            int extent = rowCount * 100;
            View view = this.getChildAt(0);
            int top = view.getTop();
            int height = view.getHeight();
            if (height > 0) {
                extent += top * 100 / height;
            }
            view = this.getChildAt(count - 1);
            int bottom = view.getBottom();
            height = view.getHeight();
            if (height > 0) {
                extent -= (bottom - this.getHeight()) * 100 / height;
            }
            return extent;
        }
        return 0;
    }

    public int computeVerticalScrollOffset() {
        if (this.mFirstPosition >= 0 && this.getChildCount() > 0) {
            View view = this.getChildAt(0);
            int top = view.getTop();
            int height = view.getHeight();
            if (height > 0) {
                int whichRow = this.mFirstPosition / this.mNumColumns;
                return Math.max(whichRow * 100 - top * 100 / height, 0);
            }
        }
        return 0;
    }

    public int computeVerticalScrollRange() {
        int numColumns = this.mNumColumns;
        int rowCount = (this.mItemCount + numColumns - 1) / numColumns;
        return Math.max(rowCount * 100, 0);
    }
}

