/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.Shader;
import android.graphics.drawable.Animatable;
import android.graphics.drawable.AnimationDrawable;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.ClipDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.StateListDrawable;
import android.graphics.drawable.shapes.RoundRectShape;
import android.graphics.drawable.shapes.Shape;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.SystemClock;
import android.util.AttributeSet;
import android.view.RemotableViewMethod;
import android.view.View;
import android.view.animation.AlphaAnimation;
import android.view.animation.AnimationUtils;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import android.view.animation.Transformation;
import android.widget.RemoteViews;
import com.android.internal.R;

@RemoteViews.RemoteView
public class ProgressBar
extends View {
    public static final int MAX_LEVEL = 10000;
    public static final int ANIMATION_RESOLUTION = 200;
    public int mMinWidth;
    public int mMaxWidth;
    public int mMinHeight;
    public int mMaxHeight;
    public int mProgress;
    public int mSecondaryProgress;
    public int mMax;
    public int mBehavior;
    public int mDuration;
    public boolean mIndeterminate;
    public boolean mOnlyIndeterminate;
    public Transformation mTransformation;
    public AlphaAnimation mAnimation;
    public Drawable mIndeterminateDrawable;
    public Drawable mProgressDrawable;
    public Drawable mCurrentDrawable;
    public Bitmap mSampleTile;
    public boolean mNoInvalidate;
    public Interpolator mInterpolator;
    public RefreshProgressRunnable mRefreshProgressRunnable;
    public long mUiThreadId = Thread.currentThread().getId();
    public boolean mShouldStartAnimationDrawable;
    public long mLastDrawTime;
    public boolean mInDrawing;

    public ProgressBar(Context context) {
        this(context, null);
    }

    public ProgressBar(Context context, AttributeSet attrs) {
        this(context, attrs, 0x1010077);
    }

    public ProgressBar(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initProgressBar();
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.ProgressBar, defStyle, 0);
        this.mNoInvalidate = true;
        Drawable drawable2 = a.getDrawable(8);
        if (drawable2 != null) {
            drawable2 = this.tileify(drawable2, false);
            this.setProgressDrawable(drawable2);
        }
        this.mDuration = a.getInt(9, this.mDuration);
        this.mMinWidth = a.getDimensionPixelSize(11, this.mMinWidth);
        this.mMaxWidth = a.getDimensionPixelSize(0, this.mMaxWidth);
        this.mMinHeight = a.getDimensionPixelSize(12, this.mMinHeight);
        this.mMaxHeight = a.getDimensionPixelSize(1, this.mMaxHeight);
        this.mBehavior = a.getInt(10, this.mBehavior);
        int resID = a.getResourceId(13, 17432587);
        if (resID > 0) {
            this.setInterpolator(context, resID);
        }
        this.setMax(a.getInt(2, this.mMax));
        this.setProgress(a.getInt(3, this.mProgress));
        this.setSecondaryProgress(a.getInt(4, this.mSecondaryProgress));
        drawable2 = a.getDrawable(7);
        if (drawable2 != null) {
            drawable2 = this.tileifyIndeterminate(drawable2);
            this.setIndeterminateDrawable(drawable2);
        }
        this.mOnlyIndeterminate = a.getBoolean(6, this.mOnlyIndeterminate);
        this.mNoInvalidate = false;
        this.setIndeterminate(this.mOnlyIndeterminate || a.getBoolean(5, this.mIndeterminate));
        a.recycle();
    }

    public Drawable tileify(Drawable drawable2, boolean clip) {
        if (drawable2 instanceof LayerDrawable) {
            LayerDrawable background = (LayerDrawable)drawable2;
            int N = background.getNumberOfLayers();
            Drawable[] outDrawables = new Drawable[N];
            for (int i = 0; i < N; ++i) {
                int id2 = background.getId(i);
                outDrawables[i] = this.tileify(background.getDrawable(i), id2 == 16908301 || id2 == 16908303);
            }
            LayerDrawable newBg = new LayerDrawable(outDrawables);
            for (int i = 0; i < N; ++i) {
                newBg.setId(i, background.getId(i));
            }
            return newBg;
        }
        if (drawable2 instanceof StateListDrawable) {
            StateListDrawable in = (StateListDrawable)drawable2;
            StateListDrawable out = new StateListDrawable();
            int numStates = in.getStateCount();
            for (int i = 0; i < numStates; ++i) {
                out.addState(in.getStateSet(i), this.tileify(in.getStateDrawable(i), clip));
            }
            return out;
        }
        if (drawable2 instanceof BitmapDrawable) {
            Bitmap tileBitmap = ((BitmapDrawable)drawable2).getBitmap();
            if (this.mSampleTile == null) {
                this.mSampleTile = tileBitmap;
            }
            ShapeDrawable shapeDrawable = new ShapeDrawable(this.getDrawableShape());
            BitmapShader bitmapShader = new BitmapShader(tileBitmap, Shader.TileMode.REPEAT, Shader.TileMode.CLAMP);
            shapeDrawable.getPaint().setShader(bitmapShader);
            return clip ? new ClipDrawable(shapeDrawable, 3, 1) : shapeDrawable;
        }
        return drawable2;
    }

    public Shape getDrawableShape() {
        float[] roundedCorners = new float[]{5.0f, 5.0f, 5.0f, 5.0f, 5.0f, 5.0f, 5.0f, 5.0f};
        return new RoundRectShape(roundedCorners, null, null);
    }

    public Drawable tileifyIndeterminate(Drawable drawable2) {
        if (drawable2 instanceof AnimationDrawable) {
            AnimationDrawable background = (AnimationDrawable)drawable2;
            int N = background.getNumberOfFrames();
            AnimationDrawable newBg = new AnimationDrawable();
            newBg.setOneShot(background.isOneShot());
            for (int i = 0; i < N; ++i) {
                Drawable frame = this.tileify(background.getFrame(i), true);
                frame.setLevel(10000);
                newBg.addFrame(frame, background.getDuration(i));
            }
            newBg.setLevel(10000);
            drawable2 = newBg;
        }
        return drawable2;
    }

    public void initProgressBar() {
        this.mMax = 100;
        this.mProgress = 0;
        this.mSecondaryProgress = 0;
        this.mIndeterminate = false;
        this.mOnlyIndeterminate = false;
        this.mDuration = 4000;
        this.mBehavior = 1;
        this.mMinWidth = 24;
        this.mMaxWidth = 48;
        this.mMinHeight = 24;
        this.mMaxHeight = 48;
    }

    public synchronized boolean isIndeterminate() {
        return this.mIndeterminate;
    }

    @RemotableViewMethod
    public synchronized void setIndeterminate(boolean indeterminate) {
        if (!(this.mOnlyIndeterminate && this.mIndeterminate || indeterminate == this.mIndeterminate)) {
            this.mIndeterminate = indeterminate;
            if (indeterminate) {
                this.mCurrentDrawable = this.mIndeterminateDrawable;
                this.startAnimation();
            } else {
                this.mCurrentDrawable = this.mProgressDrawable;
                this.stopAnimation();
            }
        }
    }

    public Drawable getIndeterminateDrawable() {
        return this.mIndeterminateDrawable;
    }

    public void setIndeterminateDrawable(Drawable d) {
        if (d != null) {
            d.setCallback(this);
        }
        this.mIndeterminateDrawable = d;
        if (this.mIndeterminate) {
            this.mCurrentDrawable = d;
            this.postInvalidate();
        }
    }

    public Drawable getProgressDrawable() {
        return this.mProgressDrawable;
    }

    public void setProgressDrawable(Drawable d) {
        if (d != null) {
            d.setCallback(this);
        }
        this.mProgressDrawable = d;
        if (!this.mIndeterminate) {
            this.mCurrentDrawable = d;
            this.postInvalidate();
        }
    }

    public Drawable getCurrentDrawable() {
        return this.mCurrentDrawable;
    }

    public boolean verifyDrawable(Drawable who) {
        return who == this.mProgressDrawable || who == this.mIndeterminateDrawable || super.verifyDrawable(who);
    }

    public void postInvalidate() {
        if (!this.mNoInvalidate) {
            super.postInvalidate();
        }
    }

    public synchronized void doRefreshProgress(int id2, int progress, boolean fromUser) {
        float scale = this.mMax > 0 ? (float)progress / (float)this.mMax : 0.0f;
        Drawable d = this.mCurrentDrawable;
        if (d != null) {
            Drawable progressDrawable = null;
            if (d instanceof LayerDrawable) {
                progressDrawable = ((LayerDrawable)d).findDrawableByLayerId(id2);
            }
            int level = (int)(scale * 10000.0f);
            (progressDrawable != null ? progressDrawable : d).setLevel(level);
        } else {
            this.invalidate();
        }
        if (id2 == 16908301) {
            this.onProgressRefresh(scale, fromUser);
        }
    }

    public void onProgressRefresh(float scale, boolean fromUser) {
    }

    public synchronized void refreshProgress(int id2, int progress, boolean fromUser) {
        if (this.mUiThreadId == Thread.currentThread().getId()) {
            this.doRefreshProgress(id2, progress, fromUser);
        } else {
            RefreshProgressRunnable r;
            if (this.mRefreshProgressRunnable != null) {
                r = this.mRefreshProgressRunnable;
                this.mRefreshProgressRunnable = null;
                r.setup(id2, progress, fromUser);
            } else {
                r = new RefreshProgressRunnable(id2, progress, fromUser);
            }
            this.post(r);
        }
    }

    @RemotableViewMethod
    public synchronized void setProgress(int progress) {
        this.setProgress(progress, false);
    }

    @RemotableViewMethod
    public synchronized void setProgress(int progress, boolean fromUser) {
        if (this.mIndeterminate) {
            return;
        }
        if (progress < 0) {
            progress = 0;
        }
        if (progress > this.mMax) {
            progress = this.mMax;
        }
        if (progress != this.mProgress) {
            this.mProgress = progress;
            this.refreshProgress(16908301, this.mProgress, fromUser);
        }
    }

    @RemotableViewMethod
    public synchronized void setSecondaryProgress(int secondaryProgress) {
        if (this.mIndeterminate) {
            return;
        }
        if (secondaryProgress < 0) {
            secondaryProgress = 0;
        }
        if (secondaryProgress > this.mMax) {
            secondaryProgress = this.mMax;
        }
        if (secondaryProgress != this.mSecondaryProgress) {
            this.mSecondaryProgress = secondaryProgress;
            this.refreshProgress(16908303, this.mSecondaryProgress, false);
        }
    }

    public synchronized int getProgress() {
        return this.mIndeterminate ? 0 : this.mProgress;
    }

    public synchronized int getSecondaryProgress() {
        return this.mIndeterminate ? 0 : this.mSecondaryProgress;
    }

    public synchronized int getMax() {
        return this.mMax;
    }

    @RemotableViewMethod
    public synchronized void setMax(int max) {
        if (max < 0) {
            max = 0;
        }
        if (max != this.mMax) {
            this.mMax = max;
            this.postInvalidate();
            if (this.mProgress > max) {
                this.mProgress = max;
                this.refreshProgress(16908301, this.mProgress, false);
            }
        }
    }

    public synchronized void incrementProgressBy(int diff) {
        this.setProgress(this.mProgress + diff);
    }

    public synchronized void incrementSecondaryProgressBy(int diff) {
        this.setSecondaryProgress(this.mSecondaryProgress + diff);
    }

    public void startAnimation() {
        int visibility = this.getVisibility();
        if (visibility != 0) {
            return;
        }
        if (this.mIndeterminateDrawable instanceof Animatable) {
            this.mShouldStartAnimationDrawable = true;
            this.mAnimation = null;
        } else {
            if (this.mInterpolator == null) {
                this.mInterpolator = new LinearInterpolator();
            }
            this.mTransformation = new Transformation();
            this.mAnimation = new AlphaAnimation(0.0f, 1.0f);
            this.mAnimation.setRepeatMode(this.mBehavior);
            this.mAnimation.setRepeatCount(-1);
            this.mAnimation.setDuration(this.mDuration);
            this.mAnimation.setInterpolator(this.mInterpolator);
            this.mAnimation.setStartTime(-1L);
            this.postInvalidate();
        }
    }

    public void stopAnimation() {
        this.mAnimation = null;
        this.mTransformation = null;
        if (this.mIndeterminateDrawable instanceof Animatable) {
            ((Animatable)((Object)this.mIndeterminateDrawable)).stop();
            this.mShouldStartAnimationDrawable = false;
        }
    }

    public void setInterpolator(Context context, int resID) {
        this.setInterpolator(AnimationUtils.loadInterpolator(context, resID));
    }

    public void setInterpolator(Interpolator interpolator) {
        this.mInterpolator = interpolator;
    }

    public Interpolator getInterpolator() {
        return this.mInterpolator;
    }

    public void setVisibility(int v) {
        if (this.getVisibility() != v) {
            super.setVisibility(v);
            if (this.mIndeterminate) {
                if (v == 8 || v == 4) {
                    this.stopAnimation();
                } else if (v == 0) {
                    this.startAnimation();
                }
            }
        }
    }

    public void invalidateDrawable(Drawable dr) {
        if (!this.mInDrawing) {
            if (this.verifyDrawable(dr)) {
                Rect dirty = dr.getBounds();
                int scrollX = this.mScrollX + this.mPaddingLeft;
                int scrollY = this.mScrollY + this.mPaddingTop;
                this.invalidate(dirty.left + scrollX, dirty.top + scrollY, dirty.right + scrollX, dirty.bottom + scrollY);
            } else {
                super.invalidateDrawable(dr);
            }
        }
    }

    public void onSizeChanged(int w, int h, int oldw, int oldh) {
        int right = w - this.mPaddingRight - this.mPaddingLeft;
        int bottom = h - this.mPaddingBottom - this.mPaddingTop;
        if (this.mIndeterminateDrawable != null) {
            this.mIndeterminateDrawable.setBounds(0, 0, right, bottom);
        }
        if (this.mProgressDrawable != null) {
            this.mProgressDrawable.setBounds(0, 0, right, bottom);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        Drawable d = this.mCurrentDrawable;
        if (d != null) {
            canvas.save();
            canvas.translate(this.mPaddingLeft, this.mPaddingTop);
            long time = this.getDrawingTime();
            if (this.mAnimation != null) {
                this.mAnimation.getTransformation(time, this.mTransformation);
                float scale = this.mTransformation.getAlpha();
                try {
                    this.mInDrawing = true;
                    d.setLevel((int)(scale * 10000.0f));
                    Object var7_5 = null;
                    this.mInDrawing = false;
                }
                catch (Throwable throwable) {
                    Object var7_6 = null;
                    this.mInDrawing = false;
                    throw throwable;
                }
                if (SystemClock.uptimeMillis() - this.mLastDrawTime >= 200L) {
                    this.mLastDrawTime = SystemClock.uptimeMillis();
                    this.postInvalidateDelayed(200L);
                }
            }
            d.draw(canvas);
            canvas.restore();
            if (this.mShouldStartAnimationDrawable && d instanceof Animatable) {
                ((Animatable)((Object)d)).start();
                this.mShouldStartAnimationDrawable = false;
            }
        }
    }

    public synchronized void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        Drawable d = this.mCurrentDrawable;
        int dw = 0;
        int dh = 0;
        if (d != null) {
            dw = Math.max(this.mMinWidth, Math.min(this.mMaxWidth, d.getIntrinsicWidth()));
            dh = Math.max(this.mMinHeight, Math.min(this.mMaxHeight, d.getIntrinsicHeight()));
        }
        this.setMeasuredDimension(ProgressBar.resolveSize(dw += this.mPaddingLeft + this.mPaddingRight, widthMeasureSpec), ProgressBar.resolveSize(dh += this.mPaddingTop + this.mPaddingBottom, heightMeasureSpec));
    }

    public void drawableStateChanged() {
        super.drawableStateChanged();
        int[] state = this.getDrawableState();
        if (this.mProgressDrawable != null && this.mProgressDrawable.isStateful()) {
            this.mProgressDrawable.setState(state);
        }
        if (this.mIndeterminateDrawable != null && this.mIndeterminateDrawable.isStateful()) {
            this.mIndeterminateDrawable.setState(state);
        }
    }

    public Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedState ss = new SavedState(superState);
        ss.progress = this.mProgress;
        ss.secondaryProgress = this.mSecondaryProgress;
        return ss;
    }

    public void onRestoreInstanceState(Parcelable state) {
        SavedState ss = (SavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        this.setProgress(ss.progress);
        this.setSecondaryProgress(ss.secondaryProgress);
    }

    public static class 1 {
    }

    public static class SavedState
    extends View.BaseSavedState {
        public int progress;
        public int secondaryProgress;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            @Override
            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in, null);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        public SavedState(Parcelable superState) {
            super(superState);
        }

        public SavedState(Parcel in) {
            super(in);
            this.progress = in.readInt();
            this.secondaryProgress = in.readInt();
        }

        public void writeToParcel(Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeInt(this.progress);
            out.writeInt(this.secondaryProgress);
        }

        public /* synthetic */ SavedState(Parcel x0, 1 x1) {
            this(x0);
        }
    }

    public class RefreshProgressRunnable
    implements Runnable {
        public int mId;
        public int mProgress;
        public boolean mFromUser;

        public RefreshProgressRunnable(int id2, int progress, boolean fromUser) {
            this.mId = id2;
            this.mProgress = progress;
            this.mFromUser = fromUser;
        }

        public void run() {
            ProgressBar.this.doRefreshProgress(this.mId, this.mProgress, this.mFromUser);
            ProgressBar.this.mRefreshProgressRunnable = this;
        }

        public void setup(int id2, int progress, boolean fromUser) {
            this.mId = id2;
            this.mProgress = progress;
            this.mFromUser = fromUser;
        }
    }
}

