/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.view.ViewConfiguration;
import android.view.animation.AnimationUtils;
import android.view.animation.Interpolator;

public class Scroller {
    public int mMode;
    public int mStartX;
    public int mStartY;
    public int mFinalX;
    public int mFinalY;
    public int mMinX;
    public int mMaxX;
    public int mMinY;
    public int mMaxY;
    public int mCurrX;
    public int mCurrY;
    public long mStartTime;
    public int mDuration;
    public float mDurationReciprocal;
    public float mDeltaX;
    public float mDeltaY;
    public float mViscousFluidScale;
    public float mViscousFluidNormalize;
    public boolean mFinished = true;
    public Interpolator mInterpolator;
    public float mCoeffX = 0.0f;
    public float mCoeffY = 1.0f;
    public float mVelocity;
    public static final int DEFAULT_DURATION = 250;
    public static final int SCROLL_MODE = 0;
    public static final int FLING_MODE = 1;
    public final float mDeceleration;

    public Scroller(Context context) {
        this(context, null);
    }

    public Scroller(Context context, Interpolator interpolator) {
        this.mInterpolator = interpolator;
        float ppi = context.getResources().getDisplayMetrics().density * 160.0f;
        this.mDeceleration = 386.0878f * ppi * ViewConfiguration.getScrollFriction();
    }

    public boolean isFinished() {
        return this.mFinished;
    }

    public void forceFinished(boolean finished) {
        this.mFinished = finished;
    }

    public int getDuration() {
        return this.mDuration;
    }

    public int getCurrX() {
        return this.mCurrX;
    }

    public int getCurrY() {
        return this.mCurrY;
    }

    public float getCurrVelocity() {
        return this.mVelocity - this.mDeceleration * (float)this.timePassed() / 2000.0f;
    }

    public int getStartX() {
        return this.mStartX;
    }

    public int getStartY() {
        return this.mStartY;
    }

    public int getFinalX() {
        return this.mFinalX;
    }

    public int getFinalY() {
        return this.mFinalY;
    }

    public boolean computeScrollOffset() {
        if (this.mFinished) {
            return false;
        }
        int timePassed = (int)(AnimationUtils.currentAnimationTimeMillis() - this.mStartTime);
        if (timePassed < this.mDuration) {
            switch (this.mMode) {
                case 0: {
                    float x = (float)timePassed * this.mDurationReciprocal;
                    x = this.mInterpolator == null ? this.viscousFluid(x) : this.mInterpolator.getInterpolation(x);
                    this.mCurrX = this.mStartX + Math.round(x * this.mDeltaX);
                    this.mCurrY = this.mStartY + Math.round(x * this.mDeltaY);
                    if (this.mCurrX != this.mFinalX || this.mCurrY != this.mFinalY) break;
                    this.mFinished = true;
                    break;
                }
                case 1: {
                    float timePassedSeconds = (float)timePassed / 1000.0f;
                    float distance = this.mVelocity * timePassedSeconds - this.mDeceleration * timePassedSeconds * timePassedSeconds / 2.0f;
                    this.mCurrX = this.mStartX + Math.round(distance * this.mCoeffX);
                    this.mCurrX = Math.min(this.mCurrX, this.mMaxX);
                    this.mCurrX = Math.max(this.mCurrX, this.mMinX);
                    this.mCurrY = this.mStartY + Math.round(distance * this.mCoeffY);
                    this.mCurrY = Math.min(this.mCurrY, this.mMaxY);
                    this.mCurrY = Math.max(this.mCurrY, this.mMinY);
                    if (this.mCurrX != this.mFinalX || this.mCurrY != this.mFinalY) break;
                    this.mFinished = true;
                }
            }
        } else {
            this.mCurrX = this.mFinalX;
            this.mCurrY = this.mFinalY;
            this.mFinished = true;
        }
        return true;
    }

    public void startScroll(int startX, int startY, int dx, int dy) {
        this.startScroll(startX, startY, dx, dy, 250);
    }

    public void startScroll(int startX, int startY, int dx, int dy, int duration) {
        this.mMode = 0;
        this.mFinished = false;
        this.mDuration = duration;
        this.mStartTime = AnimationUtils.currentAnimationTimeMillis();
        this.mStartX = startX;
        this.mStartY = startY;
        this.mFinalX = startX + dx;
        this.mFinalY = startY + dy;
        this.mDeltaX = dx;
        this.mDeltaY = dy;
        this.mDurationReciprocal = 1.0f / (float)this.mDuration;
        this.mViscousFluidScale = 8.0f;
        this.mViscousFluidNormalize = 1.0f;
        this.mViscousFluidNormalize = 1.0f / this.viscousFluid(1.0f);
    }

    public void fling(int startX, int startY, int velocityX, int velocityY, int minX, int maxX, int minY, int maxY) {
        float velocity;
        this.mMode = 1;
        this.mFinished = false;
        this.mVelocity = velocity = (float)Math.hypot(velocityX, velocityY);
        this.mDuration = (int)(1000.0f * velocity / this.mDeceleration);
        this.mStartTime = AnimationUtils.currentAnimationTimeMillis();
        this.mStartX = startX;
        this.mStartY = startY;
        this.mCoeffX = velocity == 0.0f ? 1.0f : (float)velocityX / velocity;
        this.mCoeffY = velocity == 0.0f ? 1.0f : (float)velocityY / velocity;
        int totalDistance = (int)(velocity * velocity / (2.0f * this.mDeceleration));
        this.mMinX = minX;
        this.mMaxX = maxX;
        this.mMinY = minY;
        this.mMaxY = maxY;
        this.mFinalX = startX + Math.round((float)totalDistance * this.mCoeffX);
        this.mFinalX = Math.min(this.mFinalX, this.mMaxX);
        this.mFinalX = Math.max(this.mFinalX, this.mMinX);
        this.mFinalY = startY + Math.round((float)totalDistance * this.mCoeffY);
        this.mFinalY = Math.min(this.mFinalY, this.mMaxY);
        this.mFinalY = Math.max(this.mFinalY, this.mMinY);
    }

    public float viscousFluid(float x) {
        if ((x *= this.mViscousFluidScale) < 1.0f) {
            x -= 1.0f - (float)Math.exp(-x);
        } else {
            float start = 0.36787945f;
            x = 1.0f - (float)Math.exp(1.0f - x);
            x = start + x * (1.0f - start);
        }
        return x *= this.mViscousFluidNormalize;
    }

    public void abortAnimation() {
        this.mCurrX = this.mFinalX;
        this.mCurrY = this.mFinalY;
        this.mFinished = true;
    }

    public void extendDuration(int extend) {
        int passed = this.timePassed();
        this.mDuration = passed + extend;
        this.mDurationReciprocal = 1.0f / (float)this.mDuration;
        this.mFinished = false;
    }

    public int timePassed() {
        return (int)(AnimationUtils.currentAnimationTimeMillis() - this.mStartTime);
    }

    public void setFinalX(int newX) {
        this.mFinalX = newX;
        this.mDeltaX = this.mFinalX - this.mStartX;
        this.mFinished = false;
    }

    public void setFinalY(int newY) {
        this.mFinalY = newY;
        this.mDeltaY = this.mFinalY - this.mStartY;
        this.mFinished = false;
    }
}

