/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Handler;
import android.os.Message;
import android.util.AttributeSet;
import android.view.RemotableViewMethod;
import android.widget.ViewAnimator;
import com.android.internal.R;

public class ViewFlipper
extends ViewAnimator {
    public int mFlipInterval = 3000;
    public boolean mKeepFlipping = false;
    public final int FLIP_MSG = 1;
    public final Handler mHandler = new Handler(){

        public void handleMessage(Message msg) {
            if (msg.what == 1 && ViewFlipper.this.mKeepFlipping) {
                ViewFlipper.this.showNext();
                msg = this.obtainMessage(1);
                this.sendMessageDelayed(msg, ViewFlipper.this.mFlipInterval);
            }
        }
    };

    public ViewFlipper(Context context) {
        super(context);
    }

    public ViewFlipper(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.ViewFlipper);
        this.mFlipInterval = a.getInt(0, 3000);
        a.recycle();
    }

    @RemotableViewMethod
    public void setFlipInterval(int milliseconds) {
        this.mFlipInterval = milliseconds;
    }

    public void startFlipping() {
        if (!this.mKeepFlipping) {
            this.mKeepFlipping = true;
            this.showOnly(this.mWhichChild);
            Message msg = this.mHandler.obtainMessage(1);
            this.mHandler.sendMessageDelayed(msg, this.mFlipInterval);
        }
    }

    public void stopFlipping() {
        this.mKeepFlipping = false;
    }

    public boolean isFlipping() {
        return this.mKeepFlipping;
    }
}

