/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.os.SystemProperties;
import android.util.Log;
import dalvik.system.SamplingProfiler;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;

public class SamplingProfilerIntegration {
    public static final String TAG = "SamplingProfilerIntegration";
    public static final boolean enabled = "1".equals(SystemProperties.get("persist.sampling_profiler"));
    public static final Executor snapshotWriter;
    public static boolean dirMade;
    public static volatile boolean pending;

    public static boolean isEnabled() {
        return enabled;
    }

    public static void start() {
        if (!enabled) {
            return;
        }
        SamplingProfiler.getInstance().start(10);
    }

    public static void writeSnapshot(final String name) {
        if (!enabled) {
            return;
        }
        if (!pending) {
            pending = true;
            snapshotWriter.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    String dir = "/sdcard/snapshots";
                    if (!dirMade) {
                        new File(dir).mkdirs();
                        if (new File(dir).isDirectory()) {
                            dirMade = true;
                        } else {
                            Log.w(SamplingProfilerIntegration.TAG, "Creation of " + dir + " failed.");
                            return;
                        }
                    }
                    try {
                        SamplingProfilerIntegration.writeSnapshot(dir, name);
                        Object var3_2 = null;
                        pending = false;
                    }
                    catch (Throwable throwable) {
                        Object var3_3 = null;
                        pending = false;
                        throw throwable;
                    }
                }
            });
        }
    }

    public static void writeZygoteSnapshot() {
        if (!enabled) {
            return;
        }
        String dir = "/data/zygote/snapshots";
        new File(dir).mkdirs();
        SamplingProfilerIntegration.writeSnapshot(dir, "zygote");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeSnapshot(String dir, String name) {
        byte[] snapshot = SamplingProfiler.getInstance().snapshot();
        if (snapshot == null) {
            return;
        }
        long start = System.currentTimeMillis();
        String path = dir + "/" + name.replace(':', '.') + "-" + System.currentTimeMillis() + ".snapshot";
        try {
            FileOutputStream out;
            int count = 0;
            while (true) {
                try {
                    out = new FileOutputStream(path);
                }
                catch (FileNotFoundException e) {
                    if (++count > 3) {
                        Log.e(TAG, "Could not open " + path + ".");
                        return;
                    }
                    try {
                        Thread.sleep(2500L);
                    }
                    catch (InterruptedException e1) {}
                    continue;
                }
                break;
            }
            try {
                out.write(snapshot);
                Object var11_11 = null;
            }
            catch (Throwable throwable) {
                Object var11_12 = null;
                out.close();
                throw throwable;
            }
            out.close();
            long elapsed = System.currentTimeMillis() - start;
            Log.i(TAG, "Wrote snapshot for " + name + " in " + elapsed + "ms.");
        }
        catch (IOException e) {
            Log.e(TAG, "Error writing snapshot.", e);
        }
    }

    static {
        if (enabled) {
            snapshotWriter = Executors.newSingleThreadExecutor();
            Log.i(TAG, "Profiler is enabled.");
        } else {
            snapshotWriter = null;
            Log.i(TAG, "Profiler is disabled.");
        }
        dirMade = false;
    }
}

