/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.util.Log;

public class CommandException
extends RuntimeException {
    public Error e;

    public CommandException(Error e) {
        super(e.toString());
        this.e = e;
    }

    public static CommandException fromRilErrno(int ril_errno) {
        switch (ril_errno) {
            case 0: {
                return null;
            }
            case -1: {
                return new CommandException(Error.INVALID_RESPONSE);
            }
            case 1: {
                return new CommandException(Error.RADIO_NOT_AVAILABLE);
            }
            case 2: {
                return new CommandException(Error.GENERIC_FAILURE);
            }
            case 3: {
                return new CommandException(Error.PASSWORD_INCORRECT);
            }
            case 4: {
                return new CommandException(Error.SIM_PIN2);
            }
            case 5: {
                return new CommandException(Error.SIM_PUK2);
            }
            case 6: {
                return new CommandException(Error.REQUEST_NOT_SUPPORTED);
            }
            case 8: {
                return new CommandException(Error.OP_NOT_ALLOWED_DURING_VOICE_CALL);
            }
            case 9: {
                return new CommandException(Error.OP_NOT_ALLOWED_BEFORE_REG_NW);
            }
            case 10: {
                return new CommandException(Error.SMS_FAIL_RETRY);
            }
        }
        Log.e("GSM", "Unrecognized RIL errno " + ril_errno);
        return new CommandException(Error.INVALID_RESPONSE);
    }

    public Error getCommandError() {
        return this.e;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Error {
        INVALID_RESPONSE,
        RADIO_NOT_AVAILABLE,
        GENERIC_FAILURE,
        PASSWORD_INCORRECT,
        SIM_PIN2,
        SIM_PUK2,
        REQUEST_NOT_SUPPORTED,
        OP_NOT_ALLOWED_DURING_VOICE_CALL,
        OP_NOT_ALLOWED_BEFORE_REG_NW,
        SMS_FAIL_RETRY;

    }
}

