/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.telephony.PhoneNumberUtils;
import android.util.Log;
import com.android.internal.telephony.ATParseEx;
import com.android.internal.telephony.ATResponseParser;
import com.android.internal.telephony.Connection;

public class DriverCall
implements Comparable {
    public static final String LOG_TAG = "RILB";
    public int index;
    public boolean isMT;
    public State state;
    public boolean isMpty;
    public String number;
    public int TOA;
    public boolean isVoice;
    public boolean isVoicePrivacy;
    public int als;
    public int numberPresentation;
    public String name;
    public int namePresentation;

    public static DriverCall fromCLCCLine(String line) {
        DriverCall ret = new DriverCall();
        ATResponseParser p = new ATResponseParser(line);
        try {
            ret.index = p.nextInt();
            ret.isMT = p.nextBoolean();
            ret.state = DriverCall.stateFromCLCC(p.nextInt());
            ret.isVoice = 0 == p.nextInt();
            ret.isMpty = p.nextBoolean();
            ret.numberPresentation = Connection.PRESENTATION_ALLOWED;
            if (p.hasMore()) {
                ret.number = PhoneNumberUtils.extractNetworkPortion(p.nextString());
                if (ret.number.length() == 0) {
                    ret.number = null;
                }
                ret.TOA = p.nextInt();
                ret.number = PhoneNumberUtils.stringFromStringAndTOA(ret.number, ret.TOA);
            }
        }
        catch (ATParseEx ex) {
            Log.e(LOG_TAG, "Invalid CLCC line: '" + line + "'");
            return null;
        }
        return ret;
    }

    public String toString() {
        return "id=" + this.index + "," + (Object)((Object)this.state) + "," + "toa=" + this.TOA + "," + (this.isMpty ? "conf" : "norm") + "," + (this.isMT ? "mt" : "mo") + "," + this.als + "," + (this.isVoice ? "voc" : "nonvoc") + "," + (this.isVoicePrivacy ? "evp" : "noevp") + "," + ",cli=" + this.numberPresentation + "," + "," + this.namePresentation;
    }

    public static State stateFromCLCC(int state) throws ATParseEx {
        switch (state) {
            case 0: {
                return State.ACTIVE;
            }
            case 1: {
                return State.HOLDING;
            }
            case 2: {
                return State.DIALING;
            }
            case 3: {
                return State.ALERTING;
            }
            case 4: {
                return State.INCOMING;
            }
            case 5: {
                return State.WAITING;
            }
        }
        throw new ATParseEx("illegal call state " + state);
    }

    public static int presentationFromCLIP(int cli) throws ATParseEx {
        switch (cli) {
            case 0: {
                return Connection.PRESENTATION_ALLOWED;
            }
            case 1: {
                return Connection.PRESENTATION_RESTRICTED;
            }
            case 2: {
                return Connection.PRESENTATION_UNKNOWN;
            }
            case 3: {
                return Connection.PRESENTATION_PAYPHONE;
            }
        }
        throw new ATParseEx("illegal presentation " + cli);
    }

    public int compareTo(Object o) {
        DriverCall dc = (DriverCall)o;
        if (this.index < dc.index) {
            return -1;
        }
        if (this.index == dc.index) {
            return 0;
        }
        return 1;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        ACTIVE,
        HOLDING,
        DIALING,
        ALERTING,
        INCOMING,
        WAITING;

    }
}

