/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.os.AsyncResult;
import android.os.Handler;
import android.os.Message;
import com.android.internal.telephony.IccConstants;
import com.android.internal.telephony.IccException;
import com.android.internal.telephony.IccFileTypeMismatch;
import com.android.internal.telephony.IccIoResult;
import com.android.internal.telephony.IccUtils;
import com.android.internal.telephony.PhoneBase;
import java.util.ArrayList;

public abstract class IccFileHandler
extends Handler
implements IccConstants {
    public static final int COMMAND_READ_BINARY = 176;
    public static final int COMMAND_UPDATE_BINARY = 214;
    public static final int COMMAND_READ_RECORD = 178;
    public static final int COMMAND_UPDATE_RECORD = 220;
    public static final int COMMAND_SEEK = 162;
    public static final int COMMAND_GET_RESPONSE = 192;
    public static final int READ_RECORD_MODE_ABSOLUTE = 4;
    public static final int EF_TYPE_TRANSPARENT = 0;
    public static final int EF_TYPE_LINEAR_FIXED = 1;
    public static final int EF_TYPE_CYCLIC = 3;
    public static final int TYPE_RFU = 0;
    public static final int TYPE_MF = 1;
    public static final int TYPE_DF = 2;
    public static final int TYPE_EF = 4;
    public static final int GET_RESPONSE_EF_SIZE_BYTES = 15;
    public static final int GET_RESPONSE_EF_IMG_SIZE_BYTES = 10;
    public static final int RESPONSE_DATA_RFU_1 = 0;
    public static final int RESPONSE_DATA_RFU_2 = 1;
    public static final int RESPONSE_DATA_FILE_SIZE_1 = 2;
    public static final int RESPONSE_DATA_FILE_SIZE_2 = 3;
    public static final int RESPONSE_DATA_FILE_ID_1 = 4;
    public static final int RESPONSE_DATA_FILE_ID_2 = 5;
    public static final int RESPONSE_DATA_FILE_TYPE = 6;
    public static final int RESPONSE_DATA_RFU_3 = 7;
    public static final int RESPONSE_DATA_ACCESS_CONDITION_1 = 8;
    public static final int RESPONSE_DATA_ACCESS_CONDITION_2 = 9;
    public static final int RESPONSE_DATA_ACCESS_CONDITION_3 = 10;
    public static final int RESPONSE_DATA_FILE_STATUS = 11;
    public static final int RESPONSE_DATA_LENGTH = 12;
    public static final int RESPONSE_DATA_STRUCTURE = 13;
    public static final int RESPONSE_DATA_RECORD_LENGTH = 14;
    public static final int EVENT_GET_BINARY_SIZE_DONE = 4;
    public static final int EVENT_READ_BINARY_DONE = 5;
    public static final int EVENT_GET_RECORD_SIZE_DONE = 6;
    public static final int EVENT_READ_RECORD_DONE = 7;
    public static final int EVENT_GET_EF_LINEAR_RECORD_SIZE_DONE = 8;
    public static final int EVENT_READ_IMG_DONE = 9;
    public static final int EVENT_READ_ICON_DONE = 10;
    public PhoneBase phone;

    public IccFileHandler(PhoneBase phone) {
        this.phone = phone;
    }

    public void dispose() {
    }

    public void loadEFLinearFixed(int fileid, int recordNum, Message onLoaded) {
        Message response = this.obtainMessage(6, new LoadLinearFixedContext(fileid, recordNum, onLoaded));
        this.phone.mCM.iccIO(192, fileid, this.getEFPath(fileid), 0, 0, 15, null, null, response);
    }

    public void loadEFImgLinearFixed(int recordNum, Message onLoaded) {
        Message response = this.obtainMessage(9, new LoadLinearFixedContext(20256, recordNum, onLoaded));
        this.phone.mCM.iccIO(192, 20256, "img", recordNum, 4, 10, null, null, response);
    }

    public void getEFLinearRecordSize(int fileid, Message onLoaded) {
        Message response = this.obtainMessage(8, new LoadLinearFixedContext(fileid, onLoaded));
        this.phone.mCM.iccIO(192, fileid, this.getEFPath(fileid), 0, 0, 15, null, null, response);
    }

    public void loadEFLinearFixedAll(int fileid, Message onLoaded) {
        Message response = this.obtainMessage(6, new LoadLinearFixedContext(fileid, onLoaded));
        this.phone.mCM.iccIO(192, fileid, this.getEFPath(fileid), 0, 0, 15, null, null, response);
    }

    public void loadEFTransparent(int fileid, Message onLoaded) {
        Message response = this.obtainMessage(4, fileid, 0, onLoaded);
        this.phone.mCM.iccIO(192, fileid, this.getEFPath(fileid), 0, 0, 15, null, null, response);
    }

    public void loadEFImgTransparent(int fileid, int highOffset, int lowOffset, int length, Message onLoaded) {
        Message response = this.obtainMessage(10, fileid, 0, onLoaded);
        this.phone.mCM.iccIO(176, fileid, "img", highOffset, lowOffset, length, null, null, response);
    }

    public void updateEFLinearFixed(int fileid, int recordNum, byte[] data, String pin2, Message onComplete) {
        this.phone.mCM.iccIO(220, fileid, this.getEFPath(fileid), recordNum, 4, data.length, IccUtils.bytesToHexString(data), pin2, onComplete);
    }

    public void updateEFTransparent(int fileid, byte[] data, Message onComplete) {
        this.phone.mCM.iccIO(214, fileid, this.getEFPath(fileid), 0, 0, data.length, IccUtils.bytesToHexString(data), null, onComplete);
    }

    public void sendResult(Message response, Object result, Throwable ex) {
        if (response == null) {
            return;
        }
        AsyncResult.forMessage(response, result, ex);
        response.sendToTarget();
    }

    public void handleMessage(Message msg) {
        Message response = null;
        try {
            switch (msg.what) {
                case 9: {
                    AsyncResult ar = (AsyncResult)msg.obj;
                    LoadLinearFixedContext lc = (LoadLinearFixedContext)ar.userObj;
                    IccIoResult result = (IccIoResult)ar.result;
                    response = lc.onLoaded;
                    IccException iccException = result.getException();
                    if (iccException == null) break;
                    this.sendResult(response, result.payload, ar.exception);
                    break;
                }
                case 10: {
                    AsyncResult ar = (AsyncResult)msg.obj;
                    response = (Message)ar.userObj;
                    IccIoResult result = (IccIoResult)ar.result;
                    IccException iccException = result.getException();
                    if (iccException == null) break;
                    this.sendResult(response, result.payload, ar.exception);
                    break;
                }
                case 8: {
                    int[] recordSize;
                    AsyncResult ar = (AsyncResult)msg.obj;
                    LoadLinearFixedContext lc = (LoadLinearFixedContext)ar.userObj;
                    IccIoResult result = (IccIoResult)ar.result;
                    response = lc.onLoaded;
                    if (ar.exception != null) {
                        this.sendResult(response, null, ar.exception);
                        break;
                    }
                    IccException iccException = result.getException();
                    if (iccException != null) {
                        this.sendResult(response, null, iccException);
                        break;
                    }
                    byte[] data = result.payload;
                    if (4 != data[6] || 1 != data[13]) {
                        throw new IccFileTypeMismatch();
                    }
                    recordSize = new int[]{data[14] & 0xFF, ((data[2] & 0xFF) << 8) + (data[3] & 0xFF), recordSize[1] / recordSize[0]};
                    this.sendResult(response, recordSize, null);
                    break;
                }
                case 6: {
                    AsyncResult ar = (AsyncResult)msg.obj;
                    LoadLinearFixedContext lc = (LoadLinearFixedContext)ar.userObj;
                    IccIoResult result = (IccIoResult)ar.result;
                    response = lc.onLoaded;
                    if (ar.exception != null) {
                        this.sendResult(response, null, ar.exception);
                        break;
                    }
                    IccException iccException = result.getException();
                    if (iccException != null) {
                        this.sendResult(response, null, iccException);
                        break;
                    }
                    byte[] data = result.payload;
                    int fileid = lc.efid;
                    int recordNum = lc.recordNum;
                    if (4 != data[6]) {
                        throw new IccFileTypeMismatch();
                    }
                    if (1 != data[13]) {
                        throw new IccFileTypeMismatch();
                    }
                    lc.recordSize = data[14] & 0xFF;
                    int size = ((data[2] & 0xFF) << 8) + (data[3] & 0xFF);
                    lc.countRecords = size / lc.recordSize;
                    if (lc.loadAll) {
                        lc.results = new ArrayList(lc.countRecords);
                    }
                    this.phone.mCM.iccIO(178, lc.efid, this.getEFPath(lc.efid), lc.recordNum, 4, lc.recordSize, null, null, this.obtainMessage(7, lc));
                    break;
                }
                case 4: {
                    AsyncResult ar = (AsyncResult)msg.obj;
                    response = (Message)ar.userObj;
                    IccIoResult result = (IccIoResult)ar.result;
                    if (ar.exception != null) {
                        this.sendResult(response, null, ar.exception);
                        break;
                    }
                    IccException iccException = result.getException();
                    if (iccException != null) {
                        this.sendResult(response, null, iccException);
                        break;
                    }
                    byte[] data = result.payload;
                    int fileid = msg.arg1;
                    if (4 != data[6]) {
                        throw new IccFileTypeMismatch();
                    }
                    if (0 != data[13]) {
                        throw new IccFileTypeMismatch();
                    }
                    int size = ((data[2] & 0xFF) << 8) + (data[3] & 0xFF);
                    this.phone.mCM.iccIO(176, fileid, this.getEFPath(fileid), 0, 0, size, null, null, this.obtainMessage(5, fileid, 0, response));
                    break;
                }
                case 7: {
                    AsyncResult ar = (AsyncResult)msg.obj;
                    LoadLinearFixedContext lc = (LoadLinearFixedContext)ar.userObj;
                    IccIoResult result = (IccIoResult)ar.result;
                    response = lc.onLoaded;
                    if (ar.exception != null) {
                        this.sendResult(response, null, ar.exception);
                        break;
                    }
                    IccException iccException = result.getException();
                    if (iccException != null) {
                        this.sendResult(response, null, iccException);
                        break;
                    }
                    if (!lc.loadAll) {
                        this.sendResult(response, result.payload, null);
                        break;
                    }
                    lc.results.add(result.payload);
                    ++lc.recordNum;
                    if (lc.recordNum > lc.countRecords) {
                        this.sendResult(response, lc.results, null);
                        break;
                    }
                    this.phone.mCM.iccIO(178, lc.efid, this.getEFPath(lc.efid), lc.recordNum, 4, lc.recordSize, null, null, this.obtainMessage(7, lc));
                    break;
                }
                case 5: {
                    AsyncResult ar = (AsyncResult)msg.obj;
                    response = (Message)ar.userObj;
                    IccIoResult result = (IccIoResult)ar.result;
                    if (ar.exception != null) {
                        this.sendResult(response, null, ar.exception);
                        break;
                    }
                    IccException iccException = result.getException();
                    if (iccException != null) {
                        this.sendResult(response, null, iccException);
                        break;
                    }
                    this.sendResult(response, result.payload, null);
                }
            }
        }
        catch (Exception exc) {
            if (response != null) {
                this.sendResult(response, null, exc);
            }
            this.loge("uncaught exception" + exc);
        }
    }

    public String getCommonIccEFPath(int efid) {
        switch (efid) {
            case 28474: 
            case 28475: 
            case 28480: 
            case 28489: 
            case 28490: 
            case 28491: 
            case 28492: {
                return "3F007F10";
            }
            case 12258: {
                return "3F00";
            }
            case 20256: {
                return "3F007F105F50";
            }
        }
        return null;
    }

    public abstract String getEFPath(int var1);

    public abstract void logd(String var1);

    public abstract void loge(String var1);

    public static class LoadLinearFixedContext {
        public int efid;
        public int recordNum;
        public int recordSize;
        public int countRecords;
        public boolean loadAll;
        public Message onLoaded;
        public ArrayList<byte[]> results;

        public LoadLinearFixedContext(int efid, int recordNum, Message onLoaded) {
            this.efid = efid;
            this.recordNum = recordNum;
            this.onLoaded = onLoaded;
            this.loadAll = false;
        }

        public LoadLinearFixedContext(int efid, Message onLoaded) {
            this.efid = efid;
            this.recordNum = 1;
            this.loadAll = true;
            this.onLoaded = onLoaded;
        }
    }
}

