/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.app.ActivityManagerNative;
import android.app.IActivityManager;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.res.Configuration;
import android.net.wifi.WifiManager;
import android.os.AsyncResult;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.RegistrantList;
import android.os.SystemProperties;
import android.preference.PreferenceManager;
import android.provider.Settings;
import android.telephony.ServiceState;
import android.text.TextUtils;
import android.util.Log;
import com.android.internal.telephony.CommandsInterface;
import com.android.internal.telephony.Connection;
import com.android.internal.telephony.DataConnectionTracker;
import com.android.internal.telephony.IccFileHandler;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.PhoneNotifier;
import com.android.internal.telephony.PhoneProxy;
import com.android.internal.telephony.gsm.PdpConnection;
import com.android.internal.telephony.test.SimulatedRadioControl;
import java.util.List;
import java.util.Locale;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PhoneBase
extends Handler
implements Phone {
    public static final String LOG_TAG = "PHONE";
    public static final boolean LOCAL_DEBUG = true;
    public static final String NETWORK_SELECTION_KEY = "network_selection_key";
    public static final String NETWORK_SELECTION_NAME_KEY = "network_selection_name_key";
    public static final String DATA_DISABLED_ON_BOOT_KEY = "disabled_on_boot_key";
    public static final int EVENT_RADIO_AVAILABLE = 1;
    public static final int EVENT_SSN = 2;
    public static final int EVENT_SIM_RECORDS_LOADED = 3;
    public static final int EVENT_MMI_DONE = 4;
    public static final int EVENT_RADIO_ON = 5;
    public static final int EVENT_GET_BASEBAND_VERSION_DONE = 6;
    public static final int EVENT_USSD = 7;
    public static final int EVENT_RADIO_OFF_OR_NOT_AVAILABLE = 8;
    public static final int EVENT_GET_IMEI_DONE = 9;
    public static final int EVENT_GET_IMEISV_DONE = 10;
    public static final int EVENT_GET_SIM_STATUS_DONE = 11;
    public static final int EVENT_SET_CALL_FORWARD_DONE = 12;
    public static final int EVENT_GET_CALL_FORWARD_DONE = 13;
    public static final int EVENT_CALL_RING = 14;
    public static final int EVENT_CALL_RING_CONTINUE = 15;
    public static final int EVENT_SET_NETWORK_MANUAL_COMPLETE = 16;
    public static final int EVENT_SET_NETWORK_AUTOMATIC_COMPLETE = 17;
    public static final int EVENT_SET_CLIR_COMPLETE = 18;
    public static final int EVENT_REGISTERED_TO_NETWORK = 19;
    public static final int EVENT_SET_VM_NUMBER_DONE = 20;
    public static final int EVENT_GET_DEVICE_IDENTITY_DONE = 21;
    public static final int EVENT_RUIM_RECORDS_LOADED = 22;
    public static final int EVENT_NV_READY = 23;
    public static final int EVENT_SET_ENHANCED_VP = 24;
    public static final int EVENT_EMERGENCY_CALLBACK_MODE_ENTER = 25;
    public static final int EVENT_EXIT_EMERGENCY_CALLBACK_RESPONSE = 26;
    public static final String CLIR_KEY = "clir_key";
    public static final String DNS_SERVER_CHECK_DISABLED_KEY = "dns_server_check_disabled_key";
    public CommandsInterface mCM;
    public IccFileHandler mIccFileHandler;
    public boolean mDnsCheckDisabled = false;
    public DataConnectionTracker mDataConnection;
    public boolean mDoesRilSendMultipleCallRing;
    public int mCallRingContinueToken = 0;
    public int mCallRingDelay;
    public final RegistrantList mPreciseCallStateRegistrants = new RegistrantList();
    public final RegistrantList mNewRingingConnectionRegistrants = new RegistrantList();
    public final RegistrantList mIncomingRingRegistrants = new RegistrantList();
    public final RegistrantList mDisconnectRegistrants = new RegistrantList();
    public final RegistrantList mServiceStateRegistrants = new RegistrantList();
    public final RegistrantList mMmiCompleteRegistrants = new RegistrantList();
    public final RegistrantList mMmiRegistrants = new RegistrantList();
    public final RegistrantList mUnknownConnectionRegistrants = new RegistrantList();
    public final RegistrantList mSuppServiceFailedRegistrants = new RegistrantList();
    public Looper mLooper;
    public Context mContext;
    public PhoneNotifier mNotifier;
    public SimulatedRadioControl mSimulatedRadioControl;
    public boolean mUnitTestMode;

    public void setSystemProperty(String property, String value) {
        if (this.getUnitTestMode()) {
            return;
        }
        SystemProperties.set(property, value);
    }

    public PhoneBase(PhoneNotifier notifier, Context context, CommandsInterface ci) {
        this(notifier, context, ci, false);
    }

    public PhoneBase(PhoneNotifier notifier, Context context, CommandsInterface ci, boolean unitTestMode) {
        this.mNotifier = notifier;
        this.mContext = context;
        this.mLooper = Looper.myLooper();
        this.mCM = ci;
        this.setPropertiesByCarrier();
        this.setUnitTestMode(unitTestMode);
        SharedPreferences sp = PreferenceManager.getDefaultSharedPreferences(context);
        this.mDnsCheckDisabled = sp.getBoolean(DNS_SERVER_CHECK_DISABLED_KEY, false);
        this.mCM.setOnCallRing(this, 14, null);
        this.mDoesRilSendMultipleCallRing = SystemProperties.getBoolean("ro.telephony.call_ring.multiple", true);
        Log.d(LOG_TAG, "mDoesRilSendMultipleCallRing=" + this.mDoesRilSendMultipleCallRing);
        this.mCallRingDelay = SystemProperties.getInt("ro.telephony.call_ring.delay", 3000);
        Log.d(LOG_TAG, "mCallRingDelay=" + this.mCallRingDelay);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Object object = PhoneProxy.lockForRadioTechnologyChange;
        synchronized (object) {
            this.mCM.unSetOnCallRing(this);
        }
    }

    @Override
    public void handleMessage(Message msg) {
        switch (msg.what) {
            case 14: {
                Log.d(LOG_TAG, "Event EVENT_CALL_RING Received state=" + (Object)((Object)this.getState()));
                AsyncResult ar = (AsyncResult)msg.obj;
                if (ar.exception != null) break;
                Phone.State state = this.getState();
                if (!(this.mDoesRilSendMultipleCallRing || state != Phone.State.RINGING && state != Phone.State.IDLE)) {
                    ++this.mCallRingContinueToken;
                    this.sendIncomingCallRingNotification(this.mCallRingContinueToken);
                    break;
                }
                this.notifyIncomingRing();
                break;
            }
            case 15: {
                Log.d(LOG_TAG, "Event EVENT_CALL_RING_CONTINUE Received stat=" + (Object)((Object)this.getState()));
                if (this.getState() != Phone.State.RINGING) break;
                this.sendIncomingCallRingNotification(msg.arg1);
                break;
            }
            default: {
                throw new RuntimeException("unexpected event not handled");
            }
        }
    }

    @Override
    public Context getContext() {
        return this.mContext;
    }

    @Override
    public void disableDnsCheck(boolean b) {
        this.mDnsCheckDisabled = b;
        SharedPreferences sp = PreferenceManager.getDefaultSharedPreferences(this.getContext());
        SharedPreferences.Editor editor = sp.edit();
        editor.putBoolean(DNS_SERVER_CHECK_DISABLED_KEY, b);
        editor.commit();
    }

    @Override
    public boolean isDnsCheckDisabled() {
        return this.mDnsCheckDisabled;
    }

    @Override
    public void registerForPreciseCallStateChanged(Handler h, int what, Object obj) {
        this.checkCorrectThread(h);
        this.mPreciseCallStateRegistrants.addUnique(h, what, obj);
    }

    @Override
    public void unregisterForPreciseCallStateChanged(Handler h) {
        this.mPreciseCallStateRegistrants.remove(h);
    }

    public void notifyPreciseCallStateChangedP() {
        AsyncResult ar = new AsyncResult(null, this, null);
        this.mPreciseCallStateRegistrants.notifyRegistrants(ar);
    }

    @Override
    public void registerForUnknownConnection(Handler h, int what, Object obj) {
        this.checkCorrectThread(h);
        this.mUnknownConnectionRegistrants.addUnique(h, what, obj);
    }

    @Override
    public void unregisterForUnknownConnection(Handler h) {
        this.mUnknownConnectionRegistrants.remove(h);
    }

    @Override
    public void registerForNewRingingConnection(Handler h, int what, Object obj) {
        this.checkCorrectThread(h);
        this.mNewRingingConnectionRegistrants.addUnique(h, what, obj);
    }

    @Override
    public void unregisterForNewRingingConnection(Handler h) {
        this.mNewRingingConnectionRegistrants.remove(h);
    }

    @Override
    public void registerForInCallVoicePrivacyOn(Handler h, int what, Object obj) {
        this.mCM.registerForInCallVoicePrivacyOn(h, what, obj);
    }

    @Override
    public void unregisterForInCallVoicePrivacyOn(Handler h) {
        this.mCM.unregisterForInCallVoicePrivacyOn(h);
    }

    @Override
    public void registerForInCallVoicePrivacyOff(Handler h, int what, Object obj) {
        this.mCM.registerForInCallVoicePrivacyOff(h, what, obj);
    }

    @Override
    public void unregisterForInCallVoicePrivacyOff(Handler h) {
        this.mCM.unregisterForInCallVoicePrivacyOff(h);
    }

    @Override
    public void registerForIncomingRing(Handler h, int what, Object obj) {
        this.checkCorrectThread(h);
        this.mIncomingRingRegistrants.addUnique(h, what, obj);
    }

    @Override
    public void unregisterForIncomingRing(Handler h) {
        this.mIncomingRingRegistrants.remove(h);
    }

    @Override
    public void registerForDisconnect(Handler h, int what, Object obj) {
        this.checkCorrectThread(h);
        this.mDisconnectRegistrants.addUnique(h, what, obj);
    }

    @Override
    public void unregisterForDisconnect(Handler h) {
        this.mDisconnectRegistrants.remove(h);
    }

    @Override
    public void registerForSuppServiceFailed(Handler h, int what, Object obj) {
        this.checkCorrectThread(h);
        this.mSuppServiceFailedRegistrants.addUnique(h, what, obj);
    }

    @Override
    public void unregisterForSuppServiceFailed(Handler h) {
        this.mSuppServiceFailedRegistrants.remove(h);
    }

    @Override
    public void registerForMmiInitiate(Handler h, int what, Object obj) {
        this.checkCorrectThread(h);
        this.mMmiRegistrants.addUnique(h, what, obj);
    }

    @Override
    public void unregisterForMmiInitiate(Handler h) {
        this.mMmiRegistrants.remove(h);
    }

    @Override
    public void registerForMmiComplete(Handler h, int what, Object obj) {
        this.checkCorrectThread(h);
        this.mMmiCompleteRegistrants.addUnique(h, what, obj);
    }

    @Override
    public void unregisterForMmiComplete(Handler h) {
        this.checkCorrectThread(h);
        this.mMmiCompleteRegistrants.remove(h);
    }

    public String getSavedNetworkSelection() {
        SharedPreferences sp = PreferenceManager.getDefaultSharedPreferences(this.getContext());
        return sp.getString(NETWORK_SELECTION_KEY, "");
    }

    public void restoreSavedNetworkSelection(Message response) {
        String networkSelection = this.getSavedNetworkSelection();
        if (TextUtils.isEmpty(networkSelection)) {
            this.mCM.setNetworkSelectionModeAutomatic(response);
        } else {
            this.mCM.setNetworkSelectionModeManual(networkSelection, response);
        }
    }

    @Override
    public void setUnitTestMode(boolean f) {
        this.mUnitTestMode = f;
    }

    @Override
    public boolean getUnitTestMode() {
        return this.mUnitTestMode;
    }

    public void notifyDisconnectP(Connection cn) {
        AsyncResult ar = new AsyncResult(null, cn, null);
        this.mDisconnectRegistrants.notifyRegistrants(ar);
    }

    @Override
    public void registerForServiceStateChanged(Handler h, int what, Object obj) {
        this.checkCorrectThread(h);
        this.mServiceStateRegistrants.add(h, what, obj);
    }

    @Override
    public void unregisterForServiceStateChanged(Handler h) {
        this.mServiceStateRegistrants.remove(h);
    }

    @Override
    public void registerForRingbackTone(Handler h, int what, Object obj) {
        this.mCM.registerForRingbackTone(h, what, obj);
    }

    @Override
    public void unregisterForRingbackTone(Handler h) {
        this.mCM.unregisterForRingbackTone(h);
    }

    public void notifyServiceStateChangedP(ServiceState ss) {
        AsyncResult ar = new AsyncResult(null, ss, null);
        this.mServiceStateRegistrants.notifyRegistrants(ar);
        this.mNotifier.notifyServiceState(this);
    }

    @Override
    public SimulatedRadioControl getSimulatedRadioControl() {
        return this.mSimulatedRadioControl;
    }

    public void checkCorrectThread(Handler h) {
        if (h.getLooper() != this.mLooper) {
            throw new RuntimeException("com.android.internal.telephony.Phone must be used from within one thread");
        }
    }

    public void setPropertiesByCarrier() {
        String carrier = SystemProperties.get("ro.carrier");
        if (null == carrier || 0 == carrier.length()) {
            return;
        }
        CharSequence[] carrierLocales = this.mContext.getResources().getTextArray(0x1070017);
        for (int i = 0; i < carrierLocales.length; i += 3) {
            String c = ((Object)carrierLocales[i]).toString();
            if (!carrier.equals(c)) continue;
            String l = ((Object)carrierLocales[i + 1]).toString();
            int wifiChannels = 0;
            try {
                wifiChannels = Integer.parseInt(((Object)carrierLocales[i + 2]).toString());
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            String language = l.substring(0, 2);
            String country = "";
            if (l.length() >= 5) {
                country = l.substring(3, 5);
            }
            this.setSystemLocale(language, country);
            if (wifiChannels != 0) {
                try {
                    Settings.Secure.getInt(this.mContext.getContentResolver(), "wifi_num_allowed_channels");
                }
                catch (Settings.SettingNotFoundException e) {
                    WifiManager wM = (WifiManager)this.mContext.getSystemService("wifi");
                    wM.setNumAllowedChannels(wifiChannels, false);
                }
            }
            return;
        }
    }

    public void setSystemLocale(String language, String country) {
        String l = SystemProperties.get("persist.sys.language");
        String c = SystemProperties.get("persist.sys.country");
        if (null == language) {
            return;
        }
        language = language.toLowerCase();
        if (null == country) {
            country = "";
        }
        country = country.toUpperCase();
        if (!(null != l && 0 != l.length() || null != c && 0 != c.length())) {
            try {
                String[] locales = this.mContext.getAssets().getLocales();
                int N = locales.length;
                String bestMatch = null;
                for (int i = 0; i < N; ++i) {
                    if (locales[i] == null || locales[i].length() < 5 || !locales[i].substring(0, 2).equals(language)) continue;
                    if (locales[i].substring(3, 5).equals(country)) {
                        bestMatch = locales[i];
                        break;
                    }
                    if (null != bestMatch) continue;
                    bestMatch = locales[i];
                }
                if (null != bestMatch) {
                    IActivityManager am = ActivityManagerNative.getDefault();
                    Configuration config = am.getConfiguration();
                    config.locale = new Locale(bestMatch.substring(0, 2), bestMatch.substring(3, 5));
                    config.userSetLocale = true;
                    am.updateConfiguration(config);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    @Override
    public abstract Phone.State getState();

    public abstract IccFileHandler getIccFileHandler();

    public Handler getHandler() {
        return this;
    }

    @Override
    public void queryCdmaRoamingPreference(Message response) {
        this.mCM.queryCdmaRoamingPreference(response);
    }

    @Override
    public void setCdmaRoamingPreference(int cdmaRoamingType, Message response) {
        this.mCM.setCdmaRoamingPreference(cdmaRoamingType, response);
    }

    @Override
    public void setCdmaSubscription(int cdmaSubscriptionType, Message response) {
        this.mCM.setCdmaSubscription(cdmaSubscriptionType, response);
    }

    @Override
    public void setPreferredNetworkType(int networkType, Message response) {
        this.mCM.setPreferredNetworkType(networkType, response);
    }

    @Override
    public void getPreferredNetworkType(Message response) {
        this.mCM.getPreferredNetworkType(response);
    }

    @Override
    public void getSmscAddress(Message result) {
        this.mCM.getSmscAddress(result);
    }

    @Override
    public void setSmscAddress(String address, Message result) {
        this.mCM.setSmscAddress(address, result);
    }

    @Override
    public void setTTYMode(int ttyMode, Message onComplete) {
        Log.e(LOG_TAG, "Error! This function should never be executed, inactive CDMAPhone.");
    }

    @Override
    public void queryTTYMode(Message onComplete) {
        Log.e(LOG_TAG, "Error! This function should never be executed, inactive CDMAPhone.");
    }

    @Override
    public List<PdpConnection> getCurrentPdpList() {
        return null;
    }

    @Override
    public void enableEnhancedVoicePrivacy(boolean enable, Message onComplete) {
        Log.e(LOG_TAG, "Error! This function should never be executed, inactive CDMAPhone.");
    }

    @Override
    public void getEnhancedVoicePrivacy(Message onComplete) {
        Log.e(LOG_TAG, "Error! This function should never be executed, inactive CDMAPhone.");
    }

    @Override
    public void setBandMode(int bandMode, Message response) {
        this.mCM.setBandMode(bandMode, response);
    }

    @Override
    public void queryAvailableBandMode(Message response) {
        this.mCM.queryAvailableBandMode(response);
    }

    @Override
    public void invokeOemRilRequestRaw(byte[] data, Message response) {
        this.mCM.invokeOemRilRequestRaw(data, response);
    }

    @Override
    public void invokeOemRilRequestStrings(String[] strings, Message response) {
        this.mCM.invokeOemRilRequestStrings(strings, response);
    }

    @Override
    public void notifyDataActivity() {
        this.mNotifier.notifyDataActivity(this);
    }

    public void notifyMessageWaitingIndicator() {
        this.mNotifier.notifyMessageWaitingChanged(this);
    }

    public void notifyDataConnection(String reason) {
        this.mNotifier.notifyDataConnection(this, reason);
    }

    @Override
    public abstract String getPhoneName();

    @Override
    public abstract int getPhoneType();

    @Override
    public int getVoiceMessageCount() {
        return 0;
    }

    @Override
    public int getCdmaEriIconIndex() {
        Log.e(LOG_TAG, "Error! getCdmaEriIconIndex should never be executed in GSM mode");
        return -1;
    }

    @Override
    public int getCdmaEriIconMode() {
        Log.e(LOG_TAG, "Error! getCdmaEriIconMode should never be executed in GSM mode");
        return -1;
    }

    @Override
    public String getCdmaEriText() {
        Log.e(LOG_TAG, "Error! getCdmaEriText should never be executed in GSM mode");
        return "GSM nw, no ERI";
    }

    @Override
    public String getCdmaMin() {
        Log.e(LOG_TAG, "Error! This function should never be executed, inactive CDMAPhone.");
        return null;
    }

    @Override
    public boolean isMinInfoReady() {
        Log.e(LOG_TAG, "Error! This function should never be executed, inactive CDMAPhone.");
        return false;
    }

    @Override
    public String getCdmaPrlVersion() {
        Log.e(LOG_TAG, "Error! This function should never be executed, inactive CDMAPhone.");
        return null;
    }

    @Override
    public void sendBurstDtmf(String dtmfString, int on, int off, Message onComplete) {
        Log.e(LOG_TAG, "Error! This function should never be executed, inactive CDMAPhone.");
    }

    @Override
    public void exitEmergencyCallbackMode() {
        Log.e(LOG_TAG, "Error! This function should never be executed, inactive CDMAPhone.");
    }

    @Override
    public void registerForCdmaOtaStatusChange(Handler h, int what, Object obj) {
        Log.e(LOG_TAG, "Error! This function should never be executed, inactive CDMAPhone.");
    }

    @Override
    public void unregisterForCdmaOtaStatusChange(Handler h) {
        Log.e(LOG_TAG, "Error! This function should never be executed, inactive CDMAPhone.");
    }

    @Override
    public void registerForSubscriptionInfoReady(Handler h, int what, Object obj) {
        Log.e(LOG_TAG, "Error! This function should never be executed, inactive CDMAPhone.");
    }

    @Override
    public void unregisterForSubscriptionInfoReady(Handler h) {
        Log.e(LOG_TAG, "Error! This function should never be executed, inactive CDMAPhone.");
    }

    @Override
    public boolean isOtaSpNumber(String dialStr) {
        Log.e(LOG_TAG, "Error! This function should never be executed, inactive CDMAPhone.");
        return false;
    }

    @Override
    public void registerForCallWaiting(Handler h, int what, Object obj) {
        Log.e(LOG_TAG, "Error! This function should never be executed, inactive CDMAPhone.");
    }

    @Override
    public void unregisterForCallWaiting(Handler h) {
        Log.e(LOG_TAG, "Error! This function should never be executed, inactive CDMAPhone.");
    }

    @Override
    public void registerForEcmTimerReset(Handler h, int what, Object obj) {
        Log.e(LOG_TAG, "Error! This function should never be executed, inactive CDMAPhone.");
    }

    @Override
    public void unregisterForEcmTimerReset(Handler h) {
        Log.e(LOG_TAG, "Error! This function should never be executed, inactive CDMAPhone.");
    }

    @Override
    public void registerForSignalInfo(Handler h, int what, Object obj) {
        this.mCM.registerForSignalInfo(h, what, obj);
    }

    @Override
    public void unregisterForSignalInfo(Handler h) {
        this.mCM.unregisterForSignalInfo(h);
    }

    @Override
    public void registerForDisplayInfo(Handler h, int what, Object obj) {
        this.mCM.registerForDisplayInfo(h, what, obj);
    }

    @Override
    public void unregisterForDisplayInfo(Handler h) {
        this.mCM.unregisterForDisplayInfo(h);
    }

    @Override
    public void registerForNumberInfo(Handler h, int what, Object obj) {
        this.mCM.registerForNumberInfo(h, what, obj);
    }

    @Override
    public void unregisterForNumberInfo(Handler h) {
        this.mCM.unregisterForNumberInfo(h);
    }

    @Override
    public void registerForRedirectedNumberInfo(Handler h, int what, Object obj) {
        this.mCM.registerForRedirectedNumberInfo(h, what, obj);
    }

    @Override
    public void unregisterForRedirectedNumberInfo(Handler h) {
        this.mCM.unregisterForRedirectedNumberInfo(h);
    }

    @Override
    public void registerForLineControlInfo(Handler h, int what, Object obj) {
        this.mCM.registerForLineControlInfo(h, what, obj);
    }

    @Override
    public void unregisterForLineControlInfo(Handler h) {
        this.mCM.unregisterForLineControlInfo(h);
    }

    @Override
    public void registerFoT53ClirlInfo(Handler h, int what, Object obj) {
        this.mCM.registerFoT53ClirlInfo(h, what, obj);
    }

    @Override
    public void unregisterForT53ClirInfo(Handler h) {
        this.mCM.unregisterForT53ClirInfo(h);
    }

    @Override
    public void registerForT53AudioControlInfo(Handler h, int what, Object obj) {
        this.mCM.registerForT53AudioControlInfo(h, what, obj);
    }

    @Override
    public void unregisterForT53AudioControlInfo(Handler h) {
        this.mCM.unregisterForT53AudioControlInfo(h);
    }

    @Override
    public void setOnEcbModeExitResponse(Handler h, int what, Object obj) {
        Log.e(LOG_TAG, "Error! This function should never be executed, inactive CDMAPhone.");
    }

    @Override
    public void unsetOnEcbModeExitResponse(Handler h) {
        Log.e(LOG_TAG, "Error! This function should never be executed, inactive CDMAPhone.");
    }

    @Override
    public String getInterfaceName(String apnType) {
        return this.mDataConnection.getInterfaceName(apnType);
    }

    @Override
    public String getIpAddress(String apnType) {
        return this.mDataConnection.getIpAddress(apnType);
    }

    @Override
    public boolean isDataConnectivityEnabled() {
        return this.mDataConnection.getDataEnabled();
    }

    @Override
    public String getGateway(String apnType) {
        return this.mDataConnection.getGateway(apnType);
    }

    @Override
    public String[] getDnsServers(String apnType) {
        return this.mDataConnection.getDnsServers(apnType);
    }

    @Override
    public String[] getActiveApnTypes() {
        return this.mDataConnection.getActiveApnTypes();
    }

    @Override
    public String getActiveApn() {
        return this.mDataConnection.getActiveApnString();
    }

    @Override
    public int enableApnType(String type) {
        return this.mDataConnection.enableApnType(type);
    }

    @Override
    public int disableApnType(String type) {
        return this.mDataConnection.disableApnType(type);
    }

    public void simulateDataConnection(Phone.DataState state) {
        DataConnectionTracker.State dcState;
        switch (state) {
            case CONNECTED: {
                dcState = DataConnectionTracker.State.CONNECTED;
                break;
            }
            case SUSPENDED: {
                dcState = DataConnectionTracker.State.CONNECTED;
                break;
            }
            case DISCONNECTED: {
                dcState = DataConnectionTracker.State.FAILED;
                break;
            }
            default: {
                dcState = DataConnectionTracker.State.CONNECTING;
            }
        }
        this.mDataConnection.setState(dcState);
        this.notifyDataConnection(null);
    }

    public void notifyNewRingingConnectionP(Connection cn) {
        AsyncResult ar = new AsyncResult(null, cn, null);
        this.mNewRingingConnectionRegistrants.notifyRegistrants(ar);
    }

    public void notifyIncomingRing() {
        AsyncResult ar = new AsyncResult(null, this, null);
        this.mIncomingRingRegistrants.notifyRegistrants(ar);
    }

    public void sendIncomingCallRingNotification(int token) {
        if (!this.mDoesRilSendMultipleCallRing && token == this.mCallRingContinueToken) {
            Log.d(LOG_TAG, "Sending notifyIncomingRing");
            this.notifyIncomingRing();
            this.sendMessageDelayed(this.obtainMessage(15, token, 0), this.mCallRingDelay);
        } else {
            Log.d(LOG_TAG, "Ignoring ring notification request, mDoesRilSendMultipleCallRing=" + this.mDoesRilSendMultipleCallRing + " token=" + token + " mCallRingContinueToken=" + this.mCallRingContinueToken);
        }
    }
}

