/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.cdma;

import android.app.AlarmManager;
import android.content.ContentResolver;
import android.content.Intent;
import android.database.ContentObserver;
import android.os.AsyncResult;
import android.os.Handler;
import android.os.Message;
import android.os.PowerManager;
import android.os.Registrant;
import android.os.RegistrantList;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.provider.Checkin;
import android.provider.Settings;
import android.telephony.ServiceState;
import android.telephony.SignalStrength;
import android.telephony.cdma.CdmaCellLocation;
import android.text.TextUtils;
import android.util.EventLog;
import android.util.Log;
import android.util.TimeUtils;
import com.android.internal.telephony.CommandException;
import com.android.internal.telephony.CommandsInterface;
import com.android.internal.telephony.DataConnectionTracker;
import com.android.internal.telephony.MccTable;
import com.android.internal.telephony.ServiceStateTracker;
import com.android.internal.telephony.cdma.CDMAPhone;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class CdmaServiceStateTracker
extends ServiceStateTracker {
    public static final String LOG_TAG = "CDMA";
    public CDMAPhone phone;
    public CdmaCellLocation cellLoc;
    public CdmaCellLocation newCellLoc;
    public static final int NITZ_UPDATE_SPACING_DEFAULT = 600000;
    public int mNitzUpdateSpacing = SystemProperties.getInt("ro.nitz_update_spacing", 600000);
    public static final int NITZ_UPDATE_DIFF_DEFAULT = 2000;
    public int mNitzUpdateDiff = SystemProperties.getInt("ro.nitz_update_diff", 2000);
    public int networkType = 0;
    public int newNetworkType = 0;
    public boolean mCdmaRoaming = false;
    public int mRoamingIndicator;
    public boolean mIsInPrl;
    public int mDefaultRoamingIndicator;
    public int cdmaDataConnectionState = 1;
    public int newCdmaDataConnectionState = 1;
    public int mRegistrationState = -1;
    public RegistrantList cdmaDataConnectionAttachedRegistrants = new RegistrantList();
    public RegistrantList cdmaDataConnectionDetachedRegistrants = new RegistrantList();
    public RegistrantList cdmaForSubscriptionInfoReadyRegistrants = new RegistrantList();
    public boolean mNeedFixZone = false;
    public int mZoneOffset;
    public boolean mZoneDst;
    public long mZoneTime;
    public boolean mGotCountryCode = false;
    public String mSavedTimeZone;
    public long mSavedTime;
    public long mSavedAtTime;
    public boolean mNeedToRegForRuimLoaded = false;
    public PowerManager.WakeLock mWakeLock;
    public static final String WAKELOCK_TAG = "ServiceStateTracker";
    public String curSpn = null;
    public int curSpnRule = 0;
    public String curPlmn = null;
    public String mMdn;
    public int[] mHomeSystemId = null;
    public int[] mHomeNetworkId = null;
    public String mMin;
    public String mPrlVersion;
    public boolean mIsMinInfoReady = false;
    public boolean isEriTextLoaded = false;
    public boolean isSubscriptionFromRuim = false;
    public boolean mPendingRadioPowerOffAfterDataOff = false;
    public String mRegistrationDeniedReason;
    public ContentResolver cr;
    public String currentCarrier = null;
    public ContentObserver mAutoTimeObserver = new ContentObserver(new Handler()){

        public void onChange(boolean selfChange) {
            Log.i("CdmaServiceStateTracker", "Auto time state called ...");
            CdmaServiceStateTracker.this.revertToNitz();
        }
    };

    public CdmaServiceStateTracker(CDMAPhone phone) {
        this.phone = phone;
        this.cr = phone.getContext().getContentResolver();
        this.cm = phone.mCM;
        this.ss = new ServiceState();
        this.newSS = new ServiceState();
        this.cellLoc = new CdmaCellLocation();
        this.newCellLoc = new CdmaCellLocation();
        this.mSignalStrength = new SignalStrength();
        PowerManager powerManager = (PowerManager)phone.getContext().getSystemService("power");
        this.mWakeLock = powerManager.newWakeLock(1, WAKELOCK_TAG);
        this.cm.registerForAvailable(this, 13, null);
        this.cm.registerForRadioStateChanged(this, 1, null);
        this.cm.registerForNetworkStateChanged(this, 30, null);
        this.cm.setOnNITZTime(this, 11, null);
        this.cm.setOnSignalStrengthUpdate(this, 12, null);
        this.cm.registerForRUIMReady(this, 26, null);
        this.cm.registerForNVReady(this, 35, null);
        phone.registerForEriFileLoaded(this, 36, null);
        this.cm.registerForCdmaOtaProvision(this, 37, null);
        int airplaneMode = Settings.System.getInt(this.cr, "airplane_mode_on", 0);
        this.mDesiredPowerState = airplaneMode <= 0;
        this.cr.registerContentObserver(Settings.System.getUriFor("auto_time"), true, this.mAutoTimeObserver);
        this.setSignalStrengthDefaultValues();
        this.mNeedToRegForRuimLoaded = true;
    }

    public void dispose() {
        this.cm.unregisterForAvailable(this);
        this.cm.unregisterForRadioStateChanged(this);
        this.cm.unregisterForNetworkStateChanged(this);
        this.cm.unregisterForRUIMReady(this);
        this.cm.unregisterForNVReady(this);
        this.cm.unregisterForCdmaOtaProvision(this);
        this.phone.unregisterForEriFileLoaded(this);
        this.phone.mRuimRecords.unregisterForRecordsLoaded(this);
        this.cm.unSetOnSignalStrengthUpdate(this);
        this.cm.unSetOnNITZTime(this);
        this.cr.unregisterContentObserver(this.mAutoTimeObserver);
    }

    public void finalize() {
        this.log("CdmaServiceStateTracker finalized");
    }

    public void registerForNetworkAttach(Handler h, int what, Object obj) {
        Registrant r = new Registrant(h, what, obj);
        this.networkAttachedRegistrants.add(r);
        if (this.ss.getState() == 0) {
            r.notifyRegistrant();
        }
    }

    public void unregisterForNetworkAttach(Handler h) {
        this.networkAttachedRegistrants.remove(h);
    }

    public void registerForCdmaDataConnectionAttached(Handler h, int what, Object obj) {
        Registrant r = new Registrant(h, what, obj);
        this.cdmaDataConnectionAttachedRegistrants.add(r);
        if (this.cdmaDataConnectionState == 0) {
            r.notifyRegistrant();
        }
    }

    public void unregisterForCdmaDataConnectionAttached(Handler h) {
        this.cdmaDataConnectionAttachedRegistrants.remove(h);
    }

    public void registerForCdmaDataConnectionDetached(Handler h, int what, Object obj) {
        Registrant r = new Registrant(h, what, obj);
        this.cdmaDataConnectionDetachedRegistrants.add(r);
        if (this.cdmaDataConnectionState != 0) {
            r.notifyRegistrant();
        }
    }

    public void unregisterForCdmaDataConnectionDetached(Handler h) {
        this.cdmaDataConnectionDetachedRegistrants.remove(h);
    }

    public void registerForSubscriptionInfoReady(Handler h, int what, Object obj) {
        Registrant r = new Registrant(h, what, obj);
        this.cdmaForSubscriptionInfoReadyRegistrants.add(r);
        if (this.isMinInfoReady()) {
            r.notifyRegistrant();
        }
    }

    public void unregisterForSubscriptionInfoReady(Handler h) {
        this.cdmaForSubscriptionInfoReadyRegistrants.remove(h);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleMessage(Message msg) {
        switch (msg.what) {
            case 13: {
                break;
            }
            case 26: {
                this.isSubscriptionFromRuim = true;
                if (this.mNeedToRegForRuimLoaded) {
                    this.phone.mRuimRecords.registerForRecordsLoaded(this, 27, null);
                    this.mNeedToRegForRuimLoaded = false;
                }
                this.cm.getCDMASubscription(this.obtainMessage(34));
                this.log("Receive EVENT_RUIM_READY and Send Request getCDMASubscription.");
                this.pollState();
                this.queueNextSignalStrengthPoll();
                break;
            }
            case 35: {
                this.isSubscriptionFromRuim = false;
                this.cm.getCDMASubscription(this.obtainMessage(34));
                this.pollState();
                this.queueNextSignalStrengthPoll();
                break;
            }
            case 1: {
                this.setPowerStateToDesired();
                this.pollState();
                break;
            }
            case 30: {
                this.pollState();
                break;
            }
            case 3: {
                if (!this.cm.getRadioState().isOn() || this.cm.getRadioState().isGsm()) {
                    return;
                }
                AsyncResult ar = (AsyncResult)msg.obj;
                this.onSignalStrengthResult(ar);
                this.queueNextSignalStrengthPoll();
                break;
            }
            case 31: {
                AsyncResult ar = (AsyncResult)msg.obj;
                if (ar.exception == null) {
                    String[] states = (String[])ar.result;
                    int baseStationId = -1;
                    int baseStationLatitude = Integer.MAX_VALUE;
                    int baseStationLongitude = Integer.MAX_VALUE;
                    int systemId = -1;
                    int networkId = -1;
                    if (states.length > 9) {
                        try {
                            if (states[4] != null) {
                                baseStationId = Integer.parseInt(states[4]);
                            }
                            if (states[5] != null) {
                                baseStationLatitude = Integer.parseInt(states[5]);
                            }
                            if (states[6] != null) {
                                baseStationLongitude = Integer.parseInt(states[6]);
                            }
                            if (states[8] != null) {
                                systemId = Integer.parseInt(states[8]);
                            }
                            if (states[9] != null) {
                                networkId = Integer.parseInt(states[9]);
                            }
                        }
                        catch (NumberFormatException ex) {
                            Log.w(LOG_TAG, "error parsing cell location data: " + ex);
                        }
                    }
                    this.cellLoc.setCellLocationData(baseStationId, baseStationLatitude, baseStationLongitude, systemId, networkId);
                    this.phone.notifyLocationChanged();
                }
                this.disableSingleLocationUpdate();
                break;
            }
            case 24: 
            case 25: {
                AsyncResult ar = (AsyncResult)msg.obj;
                this.handlePollStateResult(msg.what, ar);
                break;
            }
            case 34: {
                AsyncResult ar = (AsyncResult)msg.obj;
                if (ar.exception != null) break;
                String[] cdmaSubscription = (String[])ar.result;
                if (cdmaSubscription != null && cdmaSubscription.length >= 5) {
                    int i;
                    this.mMdn = cdmaSubscription[0];
                    if (cdmaSubscription[1] != null) {
                        String[] sid = cdmaSubscription[1].split(",");
                        this.mHomeSystemId = new int[sid.length];
                        for (i = 0; i < sid.length; ++i) {
                            try {
                                this.mHomeSystemId[i] = Integer.parseInt(sid[i]);
                                continue;
                            }
                            catch (NumberFormatException ex) {
                                Log.e(LOG_TAG, "error parsing system id: ", ex);
                            }
                        }
                    }
                    Log.d(LOG_TAG, "GET_CDMA_SUBSCRIPTION SID=" + cdmaSubscription[1]);
                    if (cdmaSubscription[2] != null) {
                        String[] nid = cdmaSubscription[2].split(",");
                        this.mHomeNetworkId = new int[nid.length];
                        for (i = 0; i < nid.length; ++i) {
                            try {
                                this.mHomeNetworkId[i] = Integer.parseInt(nid[i]);
                                continue;
                            }
                            catch (NumberFormatException ex) {
                                Log.e(LOG_TAG, "error parsing network id: ", ex);
                            }
                        }
                    }
                    Log.d(LOG_TAG, "GET_CDMA_SUBSCRIPTION NID=" + cdmaSubscription[2]);
                    this.mMin = cdmaSubscription[3];
                    this.mPrlVersion = cdmaSubscription[4];
                    Log.d(LOG_TAG, "GET_CDMA_SUBSCRIPTION MDN=" + this.mMdn);
                    if (this.cdmaForSubscriptionInfoReadyRegistrants != null) {
                        this.cdmaForSubscriptionInfoReadyRegistrants.notifyRegistrants();
                    }
                    if (!this.mIsMinInfoReady) {
                        this.mIsMinInfoReady = true;
                    }
                    this.phone.getIccCard().broadcastIccStateChangedIntent("IMSI", null);
                    break;
                }
                Log.w(LOG_TAG, "error parsing cdmaSubscription params num=" + cdmaSubscription.length);
                break;
            }
            case 10: {
                this.cm.getSignalStrength(this.obtainMessage(3));
                break;
            }
            case 11: {
                AsyncResult ar = (AsyncResult)msg.obj;
                String nitzString = (String)((Object[])ar.result)[0];
                long nitzReceiveTime = (Long)((Object[])ar.result)[1];
                this.setTimeFromNITZString(nitzString, nitzReceiveTime);
                break;
            }
            case 12: {
                AsyncResult ar = (AsyncResult)msg.obj;
                this.dontPollSignalStrength = true;
                this.onSignalStrengthResult(ar);
                break;
            }
            case 27: {
                this.updateSpnDisplay();
                break;
            }
            case 18: {
                AsyncResult ar = (AsyncResult)msg.obj;
                if (ar.exception != null) break;
                this.cm.getRegistrationState(this.obtainMessage(31, null));
                break;
            }
            case 36: {
                this.log("[CdmaServiceStateTracker] ERI file has been loaded, repolling.");
                this.pollState();
                break;
            }
            case 37: {
                AsyncResult ar = (AsyncResult)msg.obj;
                if (ar.exception != null) break;
                int[] ints = (int[])ar.result;
                int otaStatus = ints[0];
                if (otaStatus != 8) {
                    if (otaStatus != 10) break;
                }
                Log.d(LOG_TAG, "Received OTA_PROGRAMMING Complete,Reload MDN ");
                this.cm.getCDMASubscription(this.obtainMessage(34));
                break;
            }
            case 38: {
                CdmaServiceStateTracker cdmaServiceStateTracker = this;
                synchronized (cdmaServiceStateTracker) {
                    if (this.mPendingRadioPowerOffAfterDataOff) {
                        this.log("EVENT_SET_RADIO_OFF, turn radio off now.");
                        this.cm.setRadioPower(false, null);
                        this.mPendingRadioPowerOffAfterDataOff = false;
                    }
                    break;
                }
            }
            default: {
                Log.e(LOG_TAG, "Unhandled message with number: " + msg.what);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPowerStateToDesired() {
        if (this.mDesiredPowerState && this.cm.getRadioState() == CommandsInterface.RadioState.RADIO_OFF) {
            this.cm.setRadioPower(true, null);
        } else if (!this.mDesiredPowerState && this.cm.getRadioState().isOn()) {
            DataConnectionTracker dcTracker = this.phone.mDataConnection;
            if (!dcTracker.isDataConnectionAsDesired()) {
                EventLog.List val = new EventLog.List(dcTracker.getStateInString(), dcTracker.getAnyDataEnabled() ? 1 : 0);
                EventLog.writeEvent(50108, val);
            }
            Message msg = dcTracker.obtainMessage(34);
            msg.arg1 = 1;
            msg.obj = "radioTurnedOff";
            dcTracker.sendMessage(msg);
            CdmaServiceStateTracker cdmaServiceStateTracker = this;
            synchronized (cdmaServiceStateTracker) {
                if (!this.mPendingRadioPowerOffAfterDataOff) {
                    DataConnectionTracker.State currentState = dcTracker.getState();
                    if (currentState != DataConnectionTracker.State.CONNECTED && currentState != DataConnectionTracker.State.DISCONNECTING && currentState != DataConnectionTracker.State.INITING) {
                        this.log("Data disconnected, turn off radio right away.");
                        this.cm.setRadioPower(false, null);
                    } else if (this.sendEmptyMessageDelayed(38, 30000L)) {
                        this.log("Wait up to 30 sec for data to disconnect, then turn off radio.");
                        this.mPendingRadioPowerOffAfterDataOff = true;
                    } else {
                        Log.w(LOG_TAG, "Cannot send delayed Msg, turn off radio right away.");
                        this.cm.setRadioPower(false, null);
                    }
                }
            }
        }
    }

    public void updateSpnDisplay() {
        String spn = "";
        boolean showSpn = false;
        String plmn = "";
        boolean showPlmn = false;
        int rule = 0;
        if (this.cm.getRadioState().isRUIMReady()) {
            plmn = this.ss.getOperatorAlphaLong();
            showPlmn = true;
        } else {
            plmn = this.ss.getOperatorAlphaLong();
            showPlmn = true;
        }
        if (rule != this.curSpnRule || !TextUtils.equals(spn, this.curSpn) || !TextUtils.equals(plmn, this.curPlmn)) {
            Intent intent = new Intent("android.provider.Telephony.SPN_STRINGS_UPDATED");
            intent.putExtra("showSpn", showSpn);
            intent.putExtra("spn", spn);
            intent.putExtra("showPlmn", showPlmn);
            intent.putExtra("plmn", plmn);
            this.phone.getContext().sendStickyBroadcast(intent);
        }
        this.curSpnRule = rule;
        this.curSpn = spn;
        this.curPlmn = plmn;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void handlePollStateResult(int what, AsyncResult ar) {
        if (ar.userObj != this.pollingContext) {
            return;
        }
        if (ar.exception != null) {
            CommandException.Error err = null;
            if (ar.exception instanceof CommandException) {
                err = ((CommandException)ar.exception).getCommandError();
            }
            if (err == CommandException.Error.RADIO_NOT_AVAILABLE) {
                this.cancelPollState();
                return;
            }
            if (!this.cm.getRadioState().isOn()) {
                this.cancelPollState();
                return;
            }
            if (err != CommandException.Error.OP_NOT_ALLOWED_BEFORE_REG_NW && err != CommandException.Error.OP_NOT_ALLOWED_BEFORE_REG_NW) {
                Log.e(LOG_TAG, "RIL implementation has returned an error where it must succeed", ar.exception);
            }
        } else {
            try {
                switch (what) {
                    case 24: {
                        String[] states = (String[])ar.result;
                        int registrationState = 4;
                        int radioTechnology = -1;
                        int baseStationId = -1;
                        int baseStationLatitude = Integer.MAX_VALUE;
                        int baseStationLongitude = Integer.MAX_VALUE;
                        int cssIndicator = 0;
                        int systemId = 0;
                        int networkId = 0;
                        int roamingIndicator = -1;
                        int systemIsInPrl = 0;
                        int defaultRoamingIndicator = 0;
                        int reasonForDenial = 0;
                        if (states.length != 14) {
                            throw new RuntimeException("Warning! Wrong number of parameters returned from RIL_REQUEST_REGISTRATION_STATE: expected 14 got " + states.length);
                        }
                        try {
                            if (states[0] != null) {
                                registrationState = Integer.parseInt(states[0]);
                            }
                            if (states[3] != null) {
                                radioTechnology = Integer.parseInt(states[3]);
                            }
                            if (states[4] != null) {
                                baseStationId = Integer.parseInt(states[4]);
                            }
                            if (states[5] != null) {
                                baseStationLatitude = Integer.parseInt(states[5]);
                            }
                            if (states[6] != null) {
                                baseStationLongitude = Integer.parseInt(states[6]);
                            }
                            if (states[7] != null) {
                                cssIndicator = Integer.parseInt(states[7]);
                            }
                            if (states[8] != null) {
                                systemId = Integer.parseInt(states[8]);
                            }
                            if (states[9] != null) {
                                networkId = Integer.parseInt(states[9]);
                            }
                            if (states[10] != null) {
                                roamingIndicator = Integer.parseInt(states[10]);
                            }
                            if (states[11] != null) {
                                systemIsInPrl = Integer.parseInt(states[11]);
                            }
                            if (states[12] != null) {
                                defaultRoamingIndicator = Integer.parseInt(states[12]);
                            }
                            if (states[13] != null) {
                                reasonForDenial = Integer.parseInt(states[13]);
                            }
                        }
                        catch (NumberFormatException ex) {
                            Log.w(LOG_TAG, "error parsing RegistrationState: " + ex);
                        }
                        this.mRegistrationState = registrationState;
                        this.mCdmaRoaming = this.regCodeIsRoaming(registrationState) && !this.isRoamIndForHomeSystem(states[10]);
                        this.newSS.setState(this.regCodeToServiceState(registrationState));
                        this.newCdmaDataConnectionState = this.radioTechnologyToDataServiceState(radioTechnology);
                        this.newSS.setRadioTechnology(radioTechnology);
                        this.newNetworkType = radioTechnology;
                        this.newSS.setCssIndicator(cssIndicator);
                        this.newSS.setSystemAndNetworkId(systemId, networkId);
                        this.mRoamingIndicator = roamingIndicator;
                        this.mIsInPrl = systemIsInPrl != 0;
                        this.mDefaultRoamingIndicator = defaultRoamingIndicator;
                        this.newCellLoc.setCellLocationData(baseStationId, baseStationLatitude, baseStationLongitude, systemId, networkId);
                        this.mRegistrationDeniedReason = reasonForDenial == 0 ? "General" : (reasonForDenial == 1 ? "Authentication Failure" : "");
                        if (this.mRegistrationState != 3) break;
                        this.log("Registration denied, " + this.mRegistrationDeniedReason);
                        break;
                    }
                    case 25: {
                        String[] opNames = (String[])ar.result;
                        if (opNames != null && opNames.length >= 3) {
                            if (this.cm.getRadioState().isNVReady()) {
                                this.newSS.setOperatorName(null, opNames[1], opNames[2]);
                                break;
                            }
                            this.newSS.setOperatorName(opNames[0], opNames[1], opNames[2]);
                            break;
                        }
                        Log.w(LOG_TAG, "error parsing opNames");
                        break;
                    }
                    default: {
                        Log.e(LOG_TAG, "RIL response handle in wrong phone! Expected CDMA RIL request and get GSM RIL request.");
                        break;
                    }
                }
            }
            catch (RuntimeException ex) {
                Log.e(LOG_TAG, "Exception while polling service state. Probably malformed RIL response.", ex);
            }
        }
        this.pollingContext[0] = this.pollingContext[0] - 1;
        if (this.pollingContext[0] == 0) {
            boolean namMatch = false;
            if (!this.isSidsAllZeros() && this.isHomeSid(this.newSS.getSystemId())) {
                namMatch = true;
            }
            if (this.isSubscriptionFromRuim) {
                this.newSS.setRoaming(this.isRoamingBetweenOperators(this.mCdmaRoaming, this.newSS));
            } else {
                this.newSS.setRoaming(this.mCdmaRoaming);
            }
            this.newSS.setCdmaDefaultRoamingIndicator(this.mDefaultRoamingIndicator);
            this.newSS.setCdmaRoamingIndicator(this.mRoamingIndicator);
            boolean isPrlLoaded = true;
            if (TextUtils.isEmpty(this.mPrlVersion)) {
                isPrlLoaded = false;
            }
            if (!isPrlLoaded) {
                this.newSS.setCdmaRoamingIndicator(2);
            } else if (!this.isSidsAllZeros()) {
                if (!namMatch && !this.mIsInPrl) {
                    this.newSS.setCdmaRoamingIndicator(this.mDefaultRoamingIndicator);
                } else if (namMatch && !this.mIsInPrl) {
                    this.newSS.setCdmaRoamingIndicator(2);
                } else if (!namMatch && this.mIsInPrl) {
                    this.newSS.setCdmaRoamingIndicator(this.mRoamingIndicator);
                } else if (this.mRoamingIndicator <= 2) {
                    this.newSS.setCdmaRoamingIndicator(1);
                } else {
                    this.newSS.setCdmaRoamingIndicator(this.mRoamingIndicator);
                }
            }
            this.log("Set CDMA Roaming Indicator to: " + this.newSS.getCdmaRoamingIndicator() + ". mCdmaRoaming = " + this.mCdmaRoaming + ", isPrlLoaded = " + isPrlLoaded + ". namMatch = " + namMatch + " , mIsInPrl = " + this.mIsInPrl + ", mRoamingIndicator = " + this.mRoamingIndicator + ", mDefaultRoamingIndicator= " + this.mDefaultRoamingIndicator);
            this.pollStateDone();
        }
    }

    public void setSignalStrengthDefaultValues() {
        this.mSignalStrength = new SignalStrength(99, -1, -1, -1, -1, -1, -1, false);
    }

    public void pollState() {
        this.pollingContext = new int[1];
        this.pollingContext[0] = 0;
        switch (this.cm.getRadioState()) {
            case RADIO_UNAVAILABLE: {
                this.newSS.setStateOutOfService();
                this.newCellLoc.setStateInvalid();
                this.setSignalStrengthDefaultValues();
                this.mGotCountryCode = false;
                this.pollStateDone();
                break;
            }
            case RADIO_OFF: {
                this.newSS.setStateOff();
                this.newCellLoc.setStateInvalid();
                this.setSignalStrengthDefaultValues();
                this.mGotCountryCode = false;
                this.pollStateDone();
                break;
            }
            case SIM_NOT_READY: 
            case SIM_LOCKED_OR_ABSENT: 
            case SIM_READY: {
                this.log("Radio Technology Change ongoing, setting SS to off");
                this.newSS.setStateOff();
                this.newCellLoc.setStateInvalid();
                this.setSignalStrengthDefaultValues();
                this.mGotCountryCode = false;
                break;
            }
            default: {
                this.pollingContext[0] = this.pollingContext[0] + 1;
                this.cm.getOperator(this.obtainMessage(25, this.pollingContext));
                this.pollingContext[0] = this.pollingContext[0] + 1;
                this.cm.getRegistrationState(this.obtainMessage(24, this.pollingContext));
            }
        }
    }

    public static String networkTypeToString(int type) {
        String ret = "unknown";
        switch (type) {
            case 4: 
            case 5: {
                ret = LOG_TAG;
                break;
            }
            case 6: {
                ret = "CDMA - 1xRTT";
                break;
            }
            case 7: {
                ret = "CDMA - EvDo rev. 0";
                break;
            }
            case 8: {
                ret = "CDMA - EvDo rev. A";
                break;
            }
            default: {
                Log.e(LOG_TAG, "Wrong network. Can not return a string.");
            }
        }
        return ret;
    }

    public void fixTimeZone(String isoCountryCode) {
        TimeZone zone = null;
        String zoneName = SystemProperties.get("persist.sys.timezone");
        if (this.mZoneOffset == 0 && !this.mZoneDst && zoneName != null && zoneName.length() > 0 && Arrays.binarySearch(GMT_COUNTRY_CODES, isoCountryCode) < 0) {
            zone = TimeZone.getDefault();
            long tzOffset = zone.getOffset(System.currentTimeMillis());
            if (this.getAutoTime()) {
                this.setAndBroadcastNetworkSetTime(System.currentTimeMillis() - tzOffset);
            } else {
                this.mSavedTime -= tzOffset;
            }
        } else {
            zone = isoCountryCode.equals("") ? this.getNitzTimeZone(this.mZoneOffset, this.mZoneDst, this.mZoneTime) : TimeUtils.getTimeZone(this.mZoneOffset, this.mZoneDst, this.mZoneTime, isoCountryCode);
        }
        this.mNeedFixZone = false;
        if (zone != null) {
            if (this.getAutoTime()) {
                this.setAndBroadcastNetworkSetTimeZone(zone.getID());
            }
            this.saveNitzTimeZone(zone.getID());
        }
    }

    public void pollStateDone() {
        this.log("Poll ServiceState done: oldSS=[" + this.ss + "] newSS=[" + this.newSS + "]");
        boolean hasRegistered = this.ss.getState() != 0 && this.newSS.getState() == 0;
        boolean hasDeregistered = this.ss.getState() == 0 && this.newSS.getState() != 0;
        boolean hasCdmaDataConnectionAttached = this.cdmaDataConnectionState != 0 && this.newCdmaDataConnectionState == 0;
        boolean hasCdmaDataConnectionDetached = this.cdmaDataConnectionState == 0 && this.newCdmaDataConnectionState != 0;
        boolean hasCdmaDataConnectionChanged = this.cdmaDataConnectionState != this.newCdmaDataConnectionState;
        boolean hasNetworkTypeChanged = this.networkType != this.newNetworkType;
        boolean hasChanged = !this.newSS.equals(this.ss);
        boolean hasRoamingOn = !this.ss.getRoaming() && this.newSS.getRoaming();
        boolean hasRoamingOff = this.ss.getRoaming() && !this.newSS.getRoaming();
        boolean hasLocationChanged = !this.newCellLoc.equals(this.cellLoc);
        ServiceState tss = this.ss;
        this.ss = this.newSS;
        this.newSS = tss;
        this.newSS.setStateOutOfService();
        CdmaCellLocation tcl = this.cellLoc;
        this.cellLoc = this.newCellLoc;
        this.newCellLoc = tcl;
        this.cdmaDataConnectionState = this.newCdmaDataConnectionState;
        this.networkType = this.newNetworkType;
        this.newSS.setStateOutOfService();
        if (hasNetworkTypeChanged) {
            this.phone.setSystemProperty("gsm.network.type", CdmaServiceStateTracker.networkTypeToString(this.networkType));
        }
        if (hasRegistered) {
            Checkin.updateStats(this.cr, Checkin.Stats.Tag.PHONE_CDMA_REGISTERED, 1, 0.0);
            this.networkAttachedRegistrants.notifyRegistrants();
        }
        if (hasChanged) {
            if (this.cm.getRadioState().isNVReady()) {
                String eriText = this.ss.getState() == 0 ? this.phone.getCdmaEriText() : ((Object)this.phone.getContext().getText(17039591)).toString();
                this.ss.setCdmaEriText(eriText);
            }
            this.phone.setSystemProperty("gsm.operator.alpha", this.ss.getOperatorAlphaLong());
            String operatorNumeric = this.ss.getOperatorNumeric();
            this.phone.setSystemProperty("gsm.operator.numeric", operatorNumeric);
            if (operatorNumeric == null) {
                this.phone.setSystemProperty("gsm.operator.iso-country", "");
            } else {
                String isoCountryCode = "";
                try {
                    isoCountryCode = MccTable.countryCodeForMcc(Integer.parseInt(operatorNumeric.substring(0, 3)));
                }
                catch (NumberFormatException ex) {
                    Log.w(LOG_TAG, "countryCodeForMcc error" + ex);
                }
                catch (StringIndexOutOfBoundsException ex) {
                    Log.w(LOG_TAG, "countryCodeForMcc error" + ex);
                }
                this.phone.setSystemProperty("gsm.operator.iso-country", isoCountryCode);
                this.mGotCountryCode = true;
                if (this.mNeedFixZone) {
                    this.fixTimeZone(isoCountryCode);
                }
            }
            this.phone.setSystemProperty("gsm.operator.isroaming", this.ss.getRoaming() ? "true" : "false");
            this.updateSpnDisplay();
            this.phone.notifyServiceStateChanged(this.ss);
        }
        if (hasCdmaDataConnectionAttached) {
            this.cdmaDataConnectionAttachedRegistrants.notifyRegistrants();
        }
        if (hasCdmaDataConnectionDetached) {
            this.cdmaDataConnectionDetachedRegistrants.notifyRegistrants();
        }
        if (hasCdmaDataConnectionChanged || hasNetworkTypeChanged) {
            this.phone.notifyDataConnection(null);
        }
        if (hasRoamingOn) {
            this.roamingOnRegistrants.notifyRegistrants();
        }
        if (hasRoamingOff) {
            this.roamingOffRegistrants.notifyRegistrants();
        }
        if (hasLocationChanged) {
            this.phone.notifyLocationChanged();
        }
    }

    public TimeZone getNitzTimeZone(int offset, boolean dst, long when) {
        TimeZone guess = this.findTimeZone(offset, dst, when);
        if (guess == null) {
            guess = this.findTimeZone(offset, !dst, when);
        }
        this.log("getNitzTimeZone returning " + (guess == null ? guess : guess.getID()));
        return guess;
    }

    public TimeZone findTimeZone(int offset, boolean dst, long when) {
        int rawOffset = offset;
        if (dst) {
            rawOffset -= 3600000;
        }
        String[] zones = TimeZone.getAvailableIDs(rawOffset);
        TimeZone guess = null;
        Date d = new Date(when);
        for (String zone : zones) {
            TimeZone tz = TimeZone.getTimeZone(zone);
            if (tz.getOffset(when) != offset || tz.inDaylightTime(d) != dst) continue;
            guess = tz;
            break;
        }
        return guess;
    }

    public void queueNextSignalStrengthPoll() {
        if (this.dontPollSignalStrength || this.cm.getRadioState().isGsm()) {
            return;
        }
        Message msg = this.obtainMessage();
        msg.what = 10;
        this.sendMessageDelayed(msg, 20000L);
    }

    public void onSignalStrengthResult(AsyncResult ar) {
        SignalStrength oldSignalStrength = this.mSignalStrength;
        if (ar.exception != null) {
            this.setSignalStrengthDefaultValues();
        } else {
            int[] ints = (int[])ar.result;
            int offset = 2;
            int cdmaDbm = ints[offset] > 0 ? -ints[offset] : -120;
            int cdmaEcio = ints[offset + 1] > 0 ? -ints[offset + 1] : -160;
            int evdoRssi = -1;
            int evdoEcio = -1;
            int evdoSnr = -1;
            if (this.networkType == 7 || this.networkType == 8) {
                evdoRssi = ints[offset + 2] > 0 ? -ints[offset + 2] : -120;
                evdoEcio = ints[offset + 3] > 0 ? -ints[offset + 3] : -1;
                evdoSnr = ints[offset + 4] > 0 && ints[offset + 4] <= 8 ? ints[offset + 4] : -1;
            }
            this.mSignalStrength = new SignalStrength(99, -1, cdmaDbm, cdmaEcio, evdoRssi, evdoEcio, evdoSnr, false);
        }
        if (!this.mSignalStrength.equals(oldSignalStrength)) {
            try {
                this.phone.notifySignalStrength();
            }
            catch (NullPointerException ex) {
                this.log("onSignalStrengthResult() Phone already destroyed: " + ex + "SignalStrength not notified");
            }
        }
    }

    public int radioTechnologyToDataServiceState(int code) {
        int retVal = 1;
        switch (code) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                retVal = 0;
                break;
            }
            default: {
                Log.e(LOG_TAG, "Wrong radioTechnology code.");
            }
        }
        return retVal;
    }

    public int regCodeToServiceState(int code) {
        switch (code) {
            case 0: {
                return 1;
            }
            case 1: {
                return 0;
            }
            case 2: 
            case 3: 
            case 4: {
                return 1;
            }
            case 5: {
                return 0;
            }
        }
        Log.w(LOG_TAG, "unexpected service state " + code);
        return 1;
    }

    public int getCurrentCdmaDataConnectionState() {
        return this.cdmaDataConnectionState;
    }

    public boolean regCodeIsRoaming(int code) {
        return 5 == code;
    }

    public boolean isRoamIndForHomeSystem(String roamInd) {
        String homeRoamIndcators = SystemProperties.get("ro.cdma.homesystem");
        if (!TextUtils.isEmpty(homeRoamIndcators)) {
            for (String homeRoamInd : homeRoamIndcators.split(",")) {
                if (!homeRoamInd.equals(roamInd)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean isRoamingBetweenOperators(boolean cdmaRoaming, ServiceState s) {
        String spn = SystemProperties.get("gsm.sim.operator.alpha", "empty");
        String onsl = s.getOperatorAlphaLong();
        String onss = s.getOperatorAlphaShort();
        boolean equalsOnsl = onsl != null && spn.equals(onsl);
        boolean equalsOnss = onss != null && spn.equals(onss);
        return cdmaRoaming && !equalsOnsl && !equalsOnss;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setTimeFromNITZString(String nitz, long nitzReceiveTime) {
        long start = SystemClock.elapsedRealtime();
        Log.i(LOG_TAG, "NITZ: " + nitz + "," + nitzReceiveTime + " start=" + start + " delay=" + (start - nitzReceiveTime));
        try {
            block17: {
                block16: {
                    block15: {
                        block14: {
                            String ignore;
                            Calendar c = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
                            c.clear();
                            c.set(16, 0);
                            String[] nitzSubs = nitz.split("[/:,+-]");
                            int year = 2000 + Integer.parseInt(nitzSubs[0]);
                            c.set(1, year);
                            int month = Integer.parseInt(nitzSubs[1]) - 1;
                            c.set(2, month);
                            int date = Integer.parseInt(nitzSubs[2]);
                            c.set(5, date);
                            int hour = Integer.parseInt(nitzSubs[3]);
                            c.set(10, hour);
                            int minute = Integer.parseInt(nitzSubs[4]);
                            c.set(12, minute);
                            int second = Integer.parseInt(nitzSubs[5]);
                            c.set(13, second);
                            boolean sign = nitz.indexOf(45) == -1;
                            int tzOffset = Integer.parseInt(nitzSubs[6]);
                            int dst = nitzSubs.length >= 8 ? Integer.parseInt(nitzSubs[7]) : 0;
                            tzOffset = (sign ? 1 : -1) * tzOffset * 15 * 60 * 1000;
                            TimeZone zone = null;
                            if (nitzSubs.length >= 9) {
                                String tzname = nitzSubs[8].replace('!', '/');
                                zone = TimeZone.getTimeZone(tzname);
                            }
                            String iso = SystemProperties.get("gsm.operator.iso-country");
                            if (zone == null && this.mGotCountryCode) {
                                zone = iso != null && iso.length() > 0 ? TimeUtils.getTimeZone(tzOffset, dst != 0, c.getTimeInMillis(), iso) : this.getNitzTimeZone(tzOffset, dst != 0, c.getTimeInMillis());
                            }
                            if (zone == null) {
                                this.mNeedFixZone = true;
                                this.mZoneOffset = tzOffset;
                                this.mZoneDst = dst != 0;
                                this.mZoneTime = c.getTimeInMillis();
                            }
                            if (zone != null) {
                                if (this.getAutoTime()) {
                                    this.setAndBroadcastNetworkSetTimeZone(zone.getID());
                                }
                                this.saveNitzTimeZone(zone.getID());
                            }
                            if ((ignore = SystemProperties.get("gsm.ignore-nitz")) != null && ignore.equals("yes")) {
                                Log.i(LOG_TAG, "NITZ: Not setting clock because gsm.ignore-nitz is set");
                                return;
                            }
                            try {
                                this.mWakeLock.acquire();
                                long millisSinceNitzReceived = SystemClock.elapsedRealtime() - nitzReceiveTime;
                                if (millisSinceNitzReceived < 0L) {
                                    Log.i(LOG_TAG, "NITZ: not setting time, clock has rolled backwards since NITZ time was received, " + nitz);
                                    Object var29_20 = null;
                                    break block14;
                                }
                                if (millisSinceNitzReceived > Integer.MAX_VALUE) {
                                    Log.i(LOG_TAG, "NITZ: not setting time, processing has taken " + millisSinceNitzReceived / 86400000L + " days");
                                    break block15;
                                }
                                c.add(14, (int)millisSinceNitzReceived);
                                if (this.getAutoTime()) {
                                    long gained = c.getTimeInMillis() - System.currentTimeMillis();
                                    long timeSinceLastUpdate = SystemClock.elapsedRealtime() - this.mSavedAtTime;
                                    int nitzUpdateSpacing = Settings.Gservices.getInt(this.cr, "nitz_update_spacing", this.mNitzUpdateSpacing);
                                    int nitzUpdateDiff = Settings.Gservices.getInt(this.cr, "nitz_update_diff", this.mNitzUpdateDiff);
                                    if (this.mSavedAtTime != 0L && timeSinceLastUpdate <= (long)nitzUpdateSpacing && Math.abs(gained) <= (long)nitzUpdateDiff) {
                                        Log.i(LOG_TAG, "NITZ: ignore, a previous update was " + timeSinceLastUpdate + "ms ago and gained=" + gained + "ms");
                                        break block16;
                                    }
                                    Log.i(LOG_TAG, "NITZ: Auto updating time of day to " + c.getTime() + " NITZ receive delay=" + millisSinceNitzReceived + "ms gained=" + gained + "ms from " + nitz);
                                    this.setAndBroadcastNetworkSetTime(c.getTimeInMillis());
                                }
                                Log.i(LOG_TAG, "NITZ: update nitz time property");
                                SystemProperties.set("gsm.nitz.time", String.valueOf(c.getTimeInMillis()));
                                this.mSavedTime = c.getTimeInMillis();
                                this.mSavedAtTime = SystemClock.elapsedRealtime();
                                break block17;
                            }
                            catch (Throwable throwable) {
                                Object var29_24 = null;
                                long end = SystemClock.elapsedRealtime();
                                Log.i(LOG_TAG, "NITZ: end=" + end + " dur=" + (end - start));
                                this.mWakeLock.release();
                                throw throwable;
                            }
                        }
                        long end = SystemClock.elapsedRealtime();
                        Log.i(LOG_TAG, "NITZ: end=" + end + " dur=" + (end - start));
                        this.mWakeLock.release();
                        return;
                    }
                    Object var29_21 = null;
                    long end = SystemClock.elapsedRealtime();
                    Log.i(LOG_TAG, "NITZ: end=" + end + " dur=" + (end - start));
                    this.mWakeLock.release();
                    return;
                }
                Object var29_22 = null;
                long end = SystemClock.elapsedRealtime();
                Log.i(LOG_TAG, "NITZ: end=" + end + " dur=" + (end - start));
                this.mWakeLock.release();
                return;
            }
            Object var29_23 = null;
            long end = SystemClock.elapsedRealtime();
            Log.i(LOG_TAG, "NITZ: end=" + end + " dur=" + (end - start));
            this.mWakeLock.release();
            return;
        }
        catch (RuntimeException ex) {
            Log.e(LOG_TAG, "NITZ: Parsing NITZ time " + nitz, ex);
        }
    }

    public boolean getAutoTime() {
        try {
            return Settings.System.getInt(this.cr, "auto_time") > 0;
        }
        catch (Settings.SettingNotFoundException snfe) {
            return true;
        }
    }

    public void saveNitzTimeZone(String zoneId) {
        this.mSavedTimeZone = zoneId;
    }

    public void setAndBroadcastNetworkSetTimeZone(String zoneId) {
        AlarmManager alarm = (AlarmManager)this.phone.getContext().getSystemService("alarm");
        alarm.setTimeZone(zoneId);
        Intent intent = new Intent("android.intent.action.NETWORK_SET_TIMEZONE");
        intent.putExtra("time-zone", zoneId);
        this.phone.getContext().sendStickyBroadcast(intent);
    }

    public void setAndBroadcastNetworkSetTime(long time) {
        SystemClock.setCurrentTimeMillis(time);
        Intent intent = new Intent("android.intent.action.NETWORK_SET_TIME");
        intent.putExtra("time", time);
        this.phone.getContext().sendStickyBroadcast(intent);
    }

    public void revertToNitz() {
        if (Settings.System.getInt(this.cr, "auto_time", 0) == 0) {
            return;
        }
        Log.d(LOG_TAG, "Reverting to NITZ: tz='" + this.mSavedTimeZone + "' mSavedTime=" + this.mSavedTime + " mSavedAtTime=" + this.mSavedAtTime);
        if (this.mSavedTimeZone != null && this.mSavedTime != 0L && this.mSavedAtTime != 0L) {
            this.setAndBroadcastNetworkSetTimeZone(this.mSavedTimeZone);
            this.setAndBroadcastNetworkSetTime(this.mSavedTime + (SystemClock.elapsedRealtime() - this.mSavedAtTime));
        }
    }

    public boolean isSidsAllZeros() {
        if (this.mHomeSystemId != null) {
            for (int i = 0; i < this.mHomeSystemId.length; ++i) {
                if (this.mHomeSystemId[i] == 0) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isHomeSid(int sid) {
        if (this.mHomeSystemId != null) {
            for (int i = 0; i < this.mHomeSystemId.length; ++i) {
                if (sid != this.mHomeSystemId[i]) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isConcurrentVoiceAndData() {
        return false;
    }

    public void log(String s) {
        Log.d(LOG_TAG, "[CdmaServiceStateTracker] " + s);
    }

    public String getMdnNumber() {
        return this.mMdn;
    }

    public String getCdmaMin() {
        return this.mMin;
    }

    public String getPrlVersion() {
        return this.mPrlVersion;
    }

    public String getImsi() {
        String operatorNumeric = SystemProperties.get("gsm.sim.operator.numeric", "");
        if (!TextUtils.isEmpty(operatorNumeric) && this.getCdmaMin() != null) {
            return operatorNumeric + this.getCdmaMin();
        }
        return null;
    }

    public boolean isMinInfoReady() {
        return this.mIsMinInfoReady;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean processPendingRadioPowerOffAfterDataOff() {
        CdmaServiceStateTracker cdmaServiceStateTracker = this;
        synchronized (cdmaServiceStateTracker) {
            if (this.mPendingRadioPowerOffAfterDataOff) {
                this.log("Process pending request to turn radio off.");
                this.removeMessages(38);
                this.cm.setRadioPower(false, null);
                this.mPendingRadioPowerOffAfterDataOff = false;
                return true;
            }
            return false;
        }
    }
}

