/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.cdma;

import android.content.Context;
import android.os.AsyncResult;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import com.android.internal.telephony.IccSmsInterfaceManager;
import com.android.internal.telephony.IccUtils;
import com.android.internal.telephony.SmsRawData;
import com.android.internal.telephony.cdma.CDMAPhone;
import com.android.internal.telephony.cdma.CdmaSMSDispatcher;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuimSmsInterfaceManager
extends IccSmsInterfaceManager {
    public static final String LOG_TAG = "CDMA";
    public static final boolean DBG = true;
    public final Object mLock = new Object();
    public boolean mSuccess;
    public List<SmsRawData> mSms;
    public static final int EVENT_LOAD_DONE = 1;
    public static final int EVENT_UPDATE_DONE = 2;
    public Handler mHandler = new Handler(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 2: {
                    AsyncResult ar = (AsyncResult)msg.obj;
                    Object object = RuimSmsInterfaceManager.this.mLock;
                    synchronized (object) {
                        RuimSmsInterfaceManager.this.mSuccess = ar.exception == null;
                        RuimSmsInterfaceManager.this.mLock.notifyAll();
                        break;
                    }
                }
                case 1: {
                    AsyncResult ar = (AsyncResult)msg.obj;
                    Object object = RuimSmsInterfaceManager.this.mLock;
                    synchronized (object) {
                        if (ar.exception == null) {
                            RuimSmsInterfaceManager.this.mSms = RuimSmsInterfaceManager.this.buildValidRawData((ArrayList)ar.result);
                        } else {
                            RuimSmsInterfaceManager.this.log("Cannot load Sms records");
                            if (RuimSmsInterfaceManager.this.mSms != null) {
                                RuimSmsInterfaceManager.this.mSms.clear();
                            }
                        }
                        RuimSmsInterfaceManager.this.mLock.notifyAll();
                        break;
                    }
                }
            }
        }
    };

    public RuimSmsInterfaceManager(CDMAPhone phone) {
        super(phone);
        this.mDispatcher = new CdmaSMSDispatcher(phone);
    }

    public void dispose() {
    }

    @Override
    public void finalize() {
        Log.d(LOG_TAG, "RuimSmsInterfaceManager finalized");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean updateMessageOnIccEf(int index, int status, byte[] pdu) {
        this.log("updateMessageOnIccEf: index=" + index + " status=" + status + " ==> " + "(" + pdu + ")");
        this.enforceReceiveAndSend("Updating message on RUIM");
        Object object = this.mLock;
        synchronized (object) {
            this.mSuccess = false;
            Message response = this.mHandler.obtainMessage(2);
            if (status == 0) {
                this.mPhone.mCM.deleteSmsOnRuim(index, response);
            } else {
                byte[] record = this.makeSmsRecordData(status, pdu);
                this.mPhone.getIccFileHandler().updateEFLinearFixed(28476, index, record, null, response);
            }
            try {
                this.mLock.wait();
            }
            catch (InterruptedException e) {
                this.log("interrupted while trying to update by index");
            }
        }
        return this.mSuccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean copyMessageToIccEf(int status, byte[] pdu, byte[] smsc) {
        this.log("copyMessageToIccEf: status=" + status + " ==> " + "pdu=(" + pdu + ")");
        this.enforceReceiveAndSend("Copying message to RUIM");
        Object object = this.mLock;
        synchronized (object) {
            this.mSuccess = false;
            Message response = this.mHandler.obtainMessage(2);
            this.mPhone.mCM.writeSmsToRuim(status, IccUtils.bytesToHexString(pdu), response);
            try {
                this.mLock.wait();
            }
            catch (InterruptedException e) {
                this.log("interrupted while trying to update by index");
            }
        }
        return this.mSuccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<SmsRawData> getAllMessagesFromIccEf() {
        this.log("getAllMessagesFromEF");
        Context context = this.mPhone.getContext();
        context.enforceCallingPermission("android.permission.RECEIVE_SMS", "Reading messages from RUIM");
        Object object = this.mLock;
        synchronized (object) {
            Message response = this.mHandler.obtainMessage(1);
            this.mPhone.getIccFileHandler().loadEFLinearFixedAll(28476, response);
            try {
                this.mLock.wait();
            }
            catch (InterruptedException e) {
                this.log("interrupted while trying to load from the RUIM");
            }
        }
        return this.mSms;
    }

    @Override
    public void log(String msg) {
        Log.d(LOG_TAG, "[RuimSmsInterfaceManager] " + msg);
    }
}

