/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.gsm;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.database.ContentObserver;
import android.database.Cursor;
import android.net.NetworkInfo;
import android.net.Uri;
import android.os.AsyncResult;
import android.os.INetStatService;
import android.os.Message;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.preference.PreferenceManager;
import android.provider.Checkin;
import android.provider.Settings;
import android.provider.Telephony;
import android.telephony.TelephonyManager;
import android.telephony.gsm.GsmCellLocation;
import android.text.TextUtils;
import android.util.EventLog;
import android.util.Log;
import com.android.internal.telephony.DataCallState;
import com.android.internal.telephony.DataConnection;
import com.android.internal.telephony.DataConnectionTracker;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.RetryManager;
import com.android.internal.telephony.gsm.ApnSetting;
import com.android.internal.telephony.gsm.GSMPhone;
import com.android.internal.telephony.gsm.PdpConnection;
import java.io.IOException;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GsmDataConnectionTracker
extends DataConnectionTracker {
    public final String LOG_TAG = "GSM";
    public GSMPhone mGsmPhone;
    public INetStatService netstat;
    public boolean noAutoAttach = false;
    public boolean mReregisterOnReconnectFailure = false;
    public ContentResolver mResolver;
    public boolean mPingTestActive = false;
    public int mPdpResetCount = 0;
    public boolean mIsScreenOn = true;
    public static final int APN_DELAY_MILLIS = 5000;
    public boolean failNextConnect = false;
    public ArrayList<ApnSetting> allApns = null;
    public ArrayList<ApnSetting> waitingApns = null;
    public ApnSetting preferredApn = null;
    public ApnSetting mActiveApn;
    public ArrayList<DataConnection> pdpList;
    public PdpConnection mActivePdp;
    public boolean mIsPsRestricted = false;
    public static final int PDP_CONNECTION_POOL_SIZE = 1;
    public static final int POLL_PDP_MILLIS = 5000;
    public static final String INTENT_RECONNECT_ALARM = "com.android.internal.telephony.gprs-reconnect";
    public static final String INTENT_RECONNECT_ALARM_EXTRA_REASON = "reason";
    public static final Uri PREFERAPN_URI = Uri.parse("content://telephony/carriers/preferapn");
    public static final String APN_ID = "apn_id";
    public boolean canSetPreferApn = false;
    public RetryManager mDefaultRetryManager;
    public RetryManager mSecondaryRetryManager;
    public BroadcastReceiver mIntentReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if (action.equals("android.intent.action.SCREEN_ON")) {
                GsmDataConnectionTracker.this.mIsScreenOn = true;
                GsmDataConnectionTracker.this.stopNetStatPoll();
                GsmDataConnectionTracker.this.startNetStatPoll();
            } else if (action.equals("android.intent.action.SCREEN_OFF")) {
                GsmDataConnectionTracker.this.mIsScreenOn = false;
                GsmDataConnectionTracker.this.stopNetStatPoll();
                GsmDataConnectionTracker.this.startNetStatPoll();
            } else if (action.equals(GsmDataConnectionTracker.INTENT_RECONNECT_ALARM)) {
                Log.d("GSM", "GPRS reconnect alarm. Previous state was " + (Object)((Object)GsmDataConnectionTracker.this.state));
                String reason = intent.getStringExtra(GsmDataConnectionTracker.INTENT_RECONNECT_ALARM_EXTRA_REASON);
                if (GsmDataConnectionTracker.this.state == DataConnectionTracker.State.FAILED) {
                    Message msg = GsmDataConnectionTracker.this.obtainMessage(34);
                    msg.arg1 = 0;
                    msg.obj = reason;
                    GsmDataConnectionTracker.this.sendMessage(msg);
                }
                GsmDataConnectionTracker.this.sendMessage(GsmDataConnectionTracker.this.obtainMessage(5));
            } else if (action.equals("android.net.wifi.STATE_CHANGE")) {
                NetworkInfo networkInfo = (NetworkInfo)intent.getParcelableExtra("networkInfo");
                GsmDataConnectionTracker.this.mIsWifiConnected = networkInfo != null && networkInfo.isConnected();
            } else if (action.equals("android.net.wifi.WIFI_STATE_CHANGED")) {
                boolean enabled;
                boolean bl = enabled = intent.getIntExtra("wifi_state", 4) == 3;
                if (!enabled) {
                    GsmDataConnectionTracker.this.mIsWifiConnected = false;
                }
            }
        }
    };
    public ApnChangeObserver apnObserver;
    public Runnable mPollNetStat = new Runnable(){

        public void run() {
            long preTxPkts = -1L;
            long preRxPkts = -1L;
            preTxPkts = GsmDataConnectionTracker.this.txPkts;
            preRxPkts = GsmDataConnectionTracker.this.rxPkts;
            try {
                GsmDataConnectionTracker.this.txPkts = GsmDataConnectionTracker.this.netstat.getMobileTxPackets();
                GsmDataConnectionTracker.this.rxPkts = GsmDataConnectionTracker.this.netstat.getMobileRxPackets();
            }
            catch (RemoteException e) {
                GsmDataConnectionTracker.this.txPkts = 0L;
                GsmDataConnectionTracker.this.rxPkts = 0L;
            }
            if (GsmDataConnectionTracker.this.netStatPollEnabled && (preTxPkts > 0L || preRxPkts > 0L)) {
                DataConnectionTracker.Activity newActivity;
                long sent = GsmDataConnectionTracker.this.txPkts - preTxPkts;
                long received = GsmDataConnectionTracker.this.rxPkts - preRxPkts;
                if (sent > 0L && received > 0L) {
                    GsmDataConnectionTracker.this.sentSinceLastRecv = 0L;
                    newActivity = DataConnectionTracker.Activity.DATAINANDOUT;
                    GsmDataConnectionTracker.this.mPdpResetCount = 0;
                } else if (sent > 0L && received == 0L) {
                    if (GsmDataConnectionTracker.this.phone.getState() == Phone.State.IDLE) {
                        GsmDataConnectionTracker.this.sentSinceLastRecv += sent;
                    } else {
                        GsmDataConnectionTracker.this.sentSinceLastRecv = 0L;
                    }
                    newActivity = DataConnectionTracker.Activity.DATAOUT;
                } else if (sent == 0L && received > 0L) {
                    GsmDataConnectionTracker.this.sentSinceLastRecv = 0L;
                    newActivity = DataConnectionTracker.Activity.DATAIN;
                    GsmDataConnectionTracker.this.mPdpResetCount = 0;
                } else if (sent == 0L && received == 0L) {
                    newActivity = DataConnectionTracker.Activity.NONE;
                } else {
                    GsmDataConnectionTracker.this.sentSinceLastRecv = 0L;
                    newActivity = DataConnectionTracker.Activity.NONE;
                }
                if (GsmDataConnectionTracker.this.activity != newActivity && GsmDataConnectionTracker.this.mIsScreenOn) {
                    GsmDataConnectionTracker.this.activity = newActivity;
                    GsmDataConnectionTracker.this.phone.notifyDataActivity();
                }
            }
            int watchdogTrigger = Settings.Gservices.getInt(GsmDataConnectionTracker.this.mResolver, "pdp_watchdog_trigger_packet_count", 10);
            if (GsmDataConnectionTracker.this.sentSinceLastRecv >= (long)watchdogTrigger) {
                if (GsmDataConnectionTracker.this.mNoRecvPollCount == 0) {
                    EventLog.writeEvent(50101, GsmDataConnectionTracker.this.sentSinceLastRecv);
                }
                int noRecvPollLimit = Settings.Gservices.getInt(GsmDataConnectionTracker.this.mResolver, "pdp_watchdog_error_poll_count", 24);
                if (GsmDataConnectionTracker.this.mNoRecvPollCount < noRecvPollLimit) {
                    GsmDataConnectionTracker.this.log("no DATAIN in a while; polling PDP");
                    ((GsmDataConnectionTracker)GsmDataConnectionTracker.this).phone.mCM.getDataCallList(GsmDataConnectionTracker.this.obtainMessage(11));
                    GsmDataConnectionTracker.this.mNoRecvPollCount++;
                    GsmDataConnectionTracker.this.netStatPollPeriod = Settings.Gservices.getInt(GsmDataConnectionTracker.this.mResolver, "pdp_watchdog_error_poll_interval_ms", 5000);
                } else {
                    GsmDataConnectionTracker.this.log("Sent " + String.valueOf(GsmDataConnectionTracker.this.sentSinceLastRecv) + " pkts since last received");
                    GsmDataConnectionTracker.this.stopNetStatPoll();
                    Thread pingTest = new Thread(){

                        public void run() {
                            GsmDataConnectionTracker.this.runPingTest();
                        }
                    };
                    GsmDataConnectionTracker.this.mPingTestActive = true;
                    pingTest.start();
                }
            } else {
                GsmDataConnectionTracker.this.mNoRecvPollCount = 0;
                if (GsmDataConnectionTracker.this.mIsScreenOn) {
                    GsmDataConnectionTracker.this.netStatPollPeriod = Settings.Gservices.getInt(GsmDataConnectionTracker.this.mResolver, "pdp_watchdog_poll_interval_ms", 1000);
                } else {
                    GsmDataConnectionTracker.this.netStatPollPeriod = Settings.Gservices.getInt(GsmDataConnectionTracker.this.mResolver, "pdp_watchdog_long_poll_interval_ms", 600000);
                }
            }
            if (GsmDataConnectionTracker.this.netStatPollEnabled) {
                GsmDataConnectionTracker.this.mDataConnectionTracker.postDelayed(this, GsmDataConnectionTracker.this.netStatPollPeriod);
            }
        }
    };

    public GsmDataConnectionTracker(GSMPhone p) {
        super(p);
        this.mGsmPhone = p;
        p.mCM.registerForAvailable(this, 3, null);
        p.mCM.registerForOffOrNotAvailable(this, 12, null);
        p.mSIMRecords.registerForRecordsLoaded(this, 4, null);
        p.mCM.registerForDataStateChanged(this, 6, null);
        p.mCT.registerForVoiceCallEnded(this, 15, null);
        p.mCT.registerForVoiceCallStarted(this, 14, null);
        p.mSST.registerForGprsAttached(this, 26, null);
        p.mSST.registerForGprsDetached(this, 19, null);
        p.mSST.registerForRoamingOn(this, 21, null);
        p.mSST.registerForRoamingOff(this, 22, null);
        p.mSST.registerForPsRestrictedEnabled(this, 32, null);
        p.mSST.registerForPsRestrictedDisabled(this, 33, null);
        this.netstat = INetStatService.Stub.asInterface(ServiceManager.getService("netstat"));
        IntentFilter filter = new IntentFilter();
        filter.addAction(INTENT_RECONNECT_ALARM);
        filter.addAction("android.intent.action.SCREEN_ON");
        filter.addAction("android.intent.action.SCREEN_OFF");
        filter.addAction("android.net.wifi.STATE_CHANGE");
        filter.addAction("android.net.wifi.WIFI_STATE_CHANGED");
        p.getContext().registerReceiver(this.mIntentReceiver, filter, null, p);
        this.mDataConnectionTracker = this;
        this.mResolver = this.phone.getContext().getContentResolver();
        this.apnObserver = new ApnChangeObserver();
        p.getContext().getContentResolver().registerContentObserver(Telephony.Carriers.CONTENT_URI, true, this.apnObserver);
        this.createAllPdpList();
        SharedPreferences sp = PreferenceManager.getDefaultSharedPreferences(this.phone.getContext());
        boolean bl = this.dataEnabled[0] = !sp.getBoolean("disabled_on_boot_key", false);
        if (this.dataEnabled[0]) {
            ++this.enabledCount;
        }
        boolean bl2 = this.noAutoAttach = !this.dataEnabled[0];
        if (!this.mRetryMgr.configure(SystemProperties.get("ro.gsm.data_retry_config")) && !this.mRetryMgr.configure("default_randomization=2000,5000,10000,20000,40000,80000:5000,160000:5000,320000:5000,640000:5000,1280000:5000,1800000:5000")) {
            Log.e("GSM", "Could not configure using DEFAULT_DATA_RETRY_CONFIG=default_randomization=2000,5000,10000,20000,40000,80000:5000,160000:5000,320000:5000,640000:5000,1280000:5000,1800000:5000");
            this.mRetryMgr.configure(20, 2000, 1000);
        }
        this.mDefaultRetryManager = this.mRetryMgr;
        this.mSecondaryRetryManager = new RetryManager();
        if (!this.mSecondaryRetryManager.configure(SystemProperties.get("ro.gsm.2nd_data_retry_config")) && !this.mSecondaryRetryManager.configure("max_retries=3, 5000, 5000, 5000")) {
            Log.e("GSM", "Could note configure using SECONDARY_DATA_RETRY_CONFIG=max_retries=3, 5000, 5000, 5000");
            this.mSecondaryRetryManager.configure("max_retries=3, 333, 333, 333");
        }
    }

    @Override
    public void dispose() {
        this.phone.mCM.unregisterForAvailable(this);
        this.phone.mCM.unregisterForOffOrNotAvailable(this);
        this.mGsmPhone.mSIMRecords.unregisterForRecordsLoaded(this);
        this.phone.mCM.unregisterForDataStateChanged(this);
        this.mGsmPhone.mCT.unregisterForVoiceCallEnded(this);
        this.mGsmPhone.mCT.unregisterForVoiceCallStarted(this);
        this.mGsmPhone.mSST.unregisterForGprsAttached(this);
        this.mGsmPhone.mSST.unregisterForGprsDetached(this);
        this.mGsmPhone.mSST.unregisterForRoamingOn(this);
        this.mGsmPhone.mSST.unregisterForRoamingOff(this);
        this.mGsmPhone.mSST.unregisterForPsRestrictedEnabled(this);
        this.mGsmPhone.mSST.unregisterForPsRestrictedDisabled(this);
        this.phone.getContext().unregisterReceiver(this.mIntentReceiver);
        this.phone.getContext().getContentResolver().unregisterContentObserver(this.apnObserver);
        this.destroyAllPdpList();
    }

    public void finalize() {
        Log.d("GSM", "GsmDataConnectionTracker finalized");
    }

    @Override
    public void setState(DataConnectionTracker.State s) {
        this.log("setState: " + (Object)((Object)s));
        if (this.state != s) {
            if (s == DataConnectionTracker.State.INITING) {
                Checkin.updateStats(this.phone.getContext().getContentResolver(), Checkin.Stats.Tag.PHONE_GPRS_ATTEMPTED, 1, 0.0);
            }
            if (s == DataConnectionTracker.State.CONNECTED) {
                Checkin.updateStats(this.phone.getContext().getContentResolver(), Checkin.Stats.Tag.PHONE_GPRS_CONNECTED, 1, 0.0);
            }
        }
        this.state = s;
        if (this.state == DataConnectionTracker.State.FAILED && this.waitingApns != null) {
            this.waitingApns.clear();
        }
    }

    @Override
    public String[] getActiveApnTypes() {
        String[] result = this.mActiveApn != null ? this.mActiveApn.types : new String[]{"default"};
        return result;
    }

    @Override
    public String getActiveApnString() {
        String result = null;
        if (this.mActiveApn != null) {
            result = this.mActiveApn.apn;
        }
        return result;
    }

    @Override
    public boolean isDataConnectionAsDesired() {
        boolean roaming = this.phone.getServiceState().getRoaming();
        if (!(!this.mGsmPhone.mSIMRecords.getRecordsLoaded() || this.mGsmPhone.mSST.getCurrentGprsState() != 0 || roaming && !this.getDataOnRoamingEnabled() || this.mIsWifiConnected || this.mIsPsRestricted)) {
            return this.state == DataConnectionTracker.State.CONNECTED;
        }
        return true;
    }

    @Override
    public boolean isApnTypeActive(String type) {
        return this.mActiveApn != null && this.mActiveApn.canHandleType(type);
    }

    @Override
    public boolean isApnTypeAvailable(String type) {
        if (this.allApns != null) {
            for (ApnSetting apn : this.allApns) {
                if (!apn.canHandleType(type)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public ArrayList<DataConnection> getAllDataConnections() {
        ArrayList pdps = (ArrayList)this.pdpList.clone();
        return pdps;
    }

    public boolean isDataAllowed() {
        boolean roaming = this.phone.getServiceState().getRoaming();
        return this.getAnyDataEnabled() && (!roaming || this.getDataOnRoamingEnabled()) && this.mMasterDataEnabled;
    }

    public void onGprsDetached() {
        this.stopNetStatPoll();
        this.phone.notifyDataConnection("gprsDetached");
    }

    public void onGprsAttached() {
        if (this.state == DataConnectionTracker.State.CONNECTED) {
            this.startNetStatPoll();
            this.phone.notifyDataConnection("gprsAttached");
        } else {
            if (this.state == DataConnectionTracker.State.FAILED) {
                this.cleanUpConnection(false, "gprsAttached");
                this.mRetryMgr.resetRetryCount();
            }
            this.trySetupData("gprsAttached");
        }
    }

    public boolean trySetupData(String reason) {
        this.log("***trySetupData due to " + (reason == null ? "(unspecified)" : reason));
        Log.d("GSM", "[DSAC DEB] trySetupData with mIsPsRestricted=" + this.mIsPsRestricted);
        if (this.phone.getSimulatedRadioControl() != null) {
            this.setState(DataConnectionTracker.State.CONNECTED);
            this.phone.notifyDataConnection(reason);
            Log.i("GSM", "(fix?) We're on the simulator; assuming data is connected");
            return true;
        }
        int gprsState = this.mGsmPhone.mSST.getCurrentGprsState();
        boolean desiredPowerState = this.mGsmPhone.mSST.getDesiredPowerState();
        if ((this.state == DataConnectionTracker.State.IDLE || this.state == DataConnectionTracker.State.SCANNING) && (gprsState == 0 || this.noAutoAttach) && this.mGsmPhone.mSIMRecords.getRecordsLoaded() && this.phone.getState() == Phone.State.IDLE && this.isDataAllowed() && !this.mIsPsRestricted && desiredPowerState) {
            if (this.state == DataConnectionTracker.State.IDLE) {
                this.waitingApns = this.buildWaitingApns();
                if (this.waitingApns.isEmpty()) {
                    this.log("No APN found");
                    this.notifyNoData(DataConnection.FailCause.MISSING_UKNOWN_APN);
                    return false;
                }
                this.log("Create from allApns : " + this.apnListToString(this.allApns));
            }
            this.log("Setup waitngApns : " + this.apnListToString(this.waitingApns));
            return this.setupData(reason);
        }
        this.log("trySetupData: Not ready for data:  dataState=" + (Object)((Object)this.state) + " gprsState=" + gprsState + " sim=" + this.mGsmPhone.mSIMRecords.getRecordsLoaded() + " UMTS=" + this.mGsmPhone.mSST.isConcurrentVoiceAndData() + " phoneState=" + (Object)((Object)this.phone.getState()) + " isDataAllowed=" + this.isDataAllowed() + " dataEnabled=" + this.getAnyDataEnabled() + " roaming=" + this.phone.getServiceState().getRoaming() + " dataOnRoamingEnable=" + this.getDataOnRoamingEnabled() + " ps restricted=" + this.mIsPsRestricted + " desiredPowerState=" + desiredPowerState + " MasterDataEnabled=" + this.mMasterDataEnabled);
        return false;
    }

    public void cleanUpConnection(boolean tearDown, String reason) {
        this.log("Clean up connection due to " + reason);
        if (this.mReconnectIntent != null) {
            AlarmManager am = (AlarmManager)this.phone.getContext().getSystemService("alarm");
            am.cancel(this.mReconnectIntent);
            this.mReconnectIntent = null;
        }
        this.setState(DataConnectionTracker.State.DISCONNECTING);
        for (DataConnection conn : this.pdpList) {
            PdpConnection pdp = (PdpConnection)conn;
            if (tearDown) {
                Message msg = this.obtainMessage(25, reason);
                pdp.disconnect(msg);
                continue;
            }
            pdp.clearSettings();
        }
        this.stopNetStatPoll();
        if (!tearDown) {
            this.setState(DataConnectionTracker.State.IDLE);
            this.phone.notifyDataConnection(reason);
            this.mActiveApn = null;
        }
    }

    public String[] parseTypes(String types) {
        String[] result = types == null || types.equals("") ? new String[]{"*"} : types.split(",");
        return result;
    }

    public ArrayList<ApnSetting> createApnList(Cursor cursor) {
        ArrayList<ApnSetting> result = new ArrayList<ApnSetting>();
        if (cursor.moveToFirst()) {
            do {
                String[] types = this.parseTypes(cursor.getString(cursor.getColumnIndexOrThrow("type")));
                ApnSetting apn = new ApnSetting(cursor.getInt(cursor.getColumnIndexOrThrow("_id")), cursor.getString(cursor.getColumnIndexOrThrow("numeric")), cursor.getString(cursor.getColumnIndexOrThrow("name")), cursor.getString(cursor.getColumnIndexOrThrow("apn")), cursor.getString(cursor.getColumnIndexOrThrow("proxy")), cursor.getString(cursor.getColumnIndexOrThrow("port")), cursor.getString(cursor.getColumnIndexOrThrow("mmsc")), cursor.getString(cursor.getColumnIndexOrThrow("mmsproxy")), cursor.getString(cursor.getColumnIndexOrThrow("mmsport")), cursor.getString(cursor.getColumnIndexOrThrow("user")), cursor.getString(cursor.getColumnIndexOrThrow("password")), cursor.getInt(cursor.getColumnIndexOrThrow("authtype")), types);
                result.add(apn);
            } while (cursor.moveToNext());
        }
        return result;
    }

    public PdpConnection findFreePdp() {
        for (DataConnection conn : this.pdpList) {
            PdpConnection pdp = (PdpConnection)conn;
            if (pdp.getState() != DataConnection.State.INACTIVE) continue;
            return pdp;
        }
        return null;
    }

    public boolean setupData(String reason) {
        ApnSetting apn = this.getNextApn();
        if (apn == null) {
            return false;
        }
        PdpConnection pdp = this.findFreePdp();
        if (pdp == null) {
            this.log("setupData: No free PdpConnection found!");
            return false;
        }
        this.mActiveApn = apn;
        this.mActivePdp = pdp;
        Message msg = this.obtainMessage();
        msg.what = 1;
        msg.obj = reason;
        pdp.connect(apn, msg);
        this.setState(DataConnectionTracker.State.INITING);
        this.phone.notifyDataConnection(reason);
        return true;
    }

    @Override
    public String getInterfaceName(String apnType) {
        if (this.mActivePdp != null && (apnType == null || this.mActiveApn != null && this.mActiveApn.canHandleType(apnType))) {
            return this.mActivePdp.getInterface();
        }
        return null;
    }

    @Override
    public String getIpAddress(String apnType) {
        if (this.mActivePdp != null && (apnType == null || this.mActiveApn != null && this.mActiveApn.canHandleType(apnType))) {
            return this.mActivePdp.getIpAddress();
        }
        return null;
    }

    @Override
    public String getGateway(String apnType) {
        if (this.mActivePdp != null && (apnType == null || this.mActiveApn != null && this.mActiveApn.canHandleType(apnType))) {
            return this.mActivePdp.getGatewayAddress();
        }
        return null;
    }

    @Override
    public String[] getDnsServers(String apnType) {
        if (this.mActivePdp != null && (apnType == null || this.mActiveApn != null && this.mActiveApn.canHandleType(apnType))) {
            return this.mActivePdp.getDnsServers();
        }
        return null;
    }

    public boolean pdpStatesHasCID(ArrayList<DataCallState> states, int cid) {
        int s = states.size();
        for (int i = 0; i < s; ++i) {
            if (states.get((int)i).cid != cid) continue;
            return true;
        }
        return false;
    }

    public boolean pdpStatesHasActiveCID(ArrayList<DataCallState> states, int cid) {
        int s = states.size();
        for (int i = 0; i < s; ++i) {
            if (states.get((int)i).cid != cid || states.get((int)i).active == 0) continue;
            return true;
        }
        return false;
    }

    public void onApnChanged() {
        boolean isConnected = this.state != DataConnectionTracker.State.IDLE && this.state != DataConnectionTracker.State.FAILED;
        this.mGsmPhone.updateCurrentCarrierInProvider();
        this.createAllApnList();
        if (this.state != DataConnectionTracker.State.DISCONNECTING) {
            this.cleanUpConnection(isConnected, "apnChanged");
            if (!isConnected) {
                this.mRetryMgr.resetRetryCount();
                this.mReregisterOnReconnectFailure = false;
                this.trySetupData("apnChanged");
            }
        }
    }

    public void onPdpStateChanged(AsyncResult ar, boolean explicitPoll) {
        ArrayList pdpStates = (ArrayList)ar.result;
        if (ar.exception != null) {
            return;
        }
        if (this.state == DataConnectionTracker.State.CONNECTED) {
            if (!this.pdpStatesHasCID(pdpStates, this.cidActive)) {
                Log.i("GSM", "PDP connection has dropped. Reconnecting");
                int cid = -1;
                GsmCellLocation loc = (GsmCellLocation)this.phone.getCellLocation();
                if (loc != null) {
                    cid = loc.getCid();
                }
                EventLog.List val = new EventLog.List(cid, TelephonyManager.getDefault().getNetworkType());
                EventLog.writeEvent(50109, val);
                this.cleanUpConnection(true, null);
                return;
            }
            if (!this.pdpStatesHasActiveCID(pdpStates, this.cidActive)) {
                if (!explicitPoll) {
                    this.phone.mCM.getPDPContextList(this.obtainMessage(11));
                } else {
                    Log.i("GSM", "PDP connection has dropped (active=false case).  Reconnecting");
                    int cid = -1;
                    GsmCellLocation loc = (GsmCellLocation)this.phone.getCellLocation();
                    if (loc != null) {
                        cid = loc.getCid();
                    }
                    EventLog.List val = new EventLog.List(cid, TelephonyManager.getDefault().getNetworkType());
                    EventLog.writeEvent(50109, val);
                    this.cleanUpConnection(true, null);
                }
            }
        }
    }

    public void notifyDefaultData(String reason) {
        this.setupDnsProperties();
        this.setState(DataConnectionTracker.State.CONNECTED);
        this.phone.notifyDataConnection(reason);
        this.startNetStatPoll();
        this.mRetryMgr.resetRetryCount();
        this.mReregisterOnReconnectFailure = false;
    }

    public void setupDnsProperties() {
        String propVal;
        int i;
        int mypid = android.os.Process.myPid();
        String[] servers = this.getDnsServers(null);
        int count = 0;
        for (i = 0; i < servers.length; ++i) {
            String serverAddr = servers[i];
            if (TextUtils.equals(serverAddr, "0.0.0.0")) continue;
            SystemProperties.set("net.dns" + (i + 1) + "." + mypid, serverAddr);
            ++count;
        }
        for (i = count + 1; i <= 4; ++i) {
            String propName = "net.dns" + i + "." + mypid;
            propVal = SystemProperties.get(propName);
            if (propVal.length() == 0) continue;
            SystemProperties.set(propName, "");
        }
        propVal = SystemProperties.get("net.dnschange");
        if (propVal.length() != 0) {
            try {
                int n = Integer.parseInt(propVal);
                SystemProperties.set("net.dnschange", "" + (n + 1));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
    }

    public void startPeriodicPdpPoll() {
        this.removeMessages(7);
        this.sendMessageDelayed(this.obtainMessage(7), 5000L);
    }

    public void resetPollStats() {
        this.txPkts = -1L;
        this.rxPkts = -1L;
        this.sentSinceLastRecv = 0L;
        this.netStatPollPeriod = 1000;
        this.mNoRecvPollCount = 0;
    }

    public void doRecovery() {
        if (this.state == DataConnectionTracker.State.CONNECTED) {
            int maxPdpReset = Settings.Gservices.getInt(this.mResolver, "pdp_watchdog_max_pdp_reset_fail_count", 3);
            if (this.mPdpResetCount < maxPdpReset) {
                ++this.mPdpResetCount;
                EventLog.writeEvent(50103, this.sentSinceLastRecv);
                this.cleanUpConnection(true, "pdpReset");
            } else {
                this.mPdpResetCount = 0;
                EventLog.writeEvent(50104, this.sentSinceLastRecv);
                this.mGsmPhone.mSST.reRegisterNetwork(null);
            }
        }
    }

    @Override
    public void startNetStatPoll() {
        if (this.state == DataConnectionTracker.State.CONNECTED && !this.mPingTestActive && !this.netStatPollEnabled) {
            Log.d("GSM", "[DataConnection] Start poll NetStat");
            this.resetPollStats();
            this.netStatPollEnabled = true;
            this.mPollNetStat.run();
        }
    }

    @Override
    public void stopNetStatPoll() {
        this.netStatPollEnabled = false;
        this.removeCallbacks(this.mPollNetStat);
        Log.d("GSM", "[DataConnection] Stop poll NetStat");
    }

    @Override
    public void restartRadio() {
        Log.d("GSM", "************TURN OFF RADIO**************");
        this.cleanUpConnection(true, "radioTurnedOff");
        this.phone.mCM.setRadioPower(false, null);
        int reset = Integer.parseInt(SystemProperties.get("net.ppp.reset-by-timeout", "0"));
        SystemProperties.set("net.ppp.reset-by-timeout", String.valueOf(reset + 1));
    }

    public void runPingTest() {
        int status = -1;
        try {
            String address = Settings.Gservices.getString(this.mResolver, "pdp_watchdog_ping_address");
            int deadline = Settings.Gservices.getInt(this.mResolver, "pdp_watchdog_ping_deadline", 5);
            this.log("pinging " + address + " for " + deadline + "s");
            if (address != null && !"0.0.0.0".equals(address)) {
                Process p = Runtime.getRuntime().exec("ping -c 1 -i 1 -w " + deadline + " " + address);
                status = p.waitFor();
            }
        }
        catch (IOException e) {
            Log.w("GSM", "ping failed: IOException");
        }
        catch (Exception e) {
            Log.w("GSM", "exception trying to ping");
        }
        if (status == 0) {
            EventLog.writeEvent(50103, -1);
            this.mPdpResetCount = 0;
            this.sendMessage(this.obtainMessage(27));
        } else {
            this.sendMessage(this.obtainMessage(28));
        }
    }

    public boolean shouldPostNotification(DataConnection.FailCause cause) {
        boolean shouldPost = true;
        return shouldPost && cause != DataConnection.FailCause.UNKNOWN;
    }

    public boolean retryAfterDisconnected(String reason) {
        boolean retry = true;
        if ("radioTurnedOff".equals(reason)) {
            retry = false;
        }
        return retry;
    }

    public void reconnectAfterFail(DataConnection.FailCause lastFailCauseCode, String reason) {
        if (this.state == DataConnectionTracker.State.FAILED) {
            if (!this.mRetryMgr.isRetryNeeded()) {
                if (!this.mRequestedApnType.equals("default")) {
                    this.phone.notifyDataConnection("apnFailed");
                    this.onEnableApn(this.apnTypeToId(this.mRequestedApnType), 0);
                    return;
                }
                if (this.mReregisterOnReconnectFailure) {
                    this.mRetryMgr.retryForeverUsingLastTimeout();
                } else {
                    Log.d("GSM", "PDP activate failed, Reregistering to the network");
                    this.mReregisterOnReconnectFailure = true;
                    this.mGsmPhone.mSST.reRegisterNetwork(null);
                    this.mRetryMgr.resetRetryCount();
                    return;
                }
            }
            int nextReconnectDelay = this.mRetryMgr.getRetryTimer();
            Log.d("GSM", "PDP activate failed. Scheduling next attempt for " + nextReconnectDelay / 1000 + "s");
            AlarmManager am = (AlarmManager)this.phone.getContext().getSystemService("alarm");
            Intent intent = new Intent(INTENT_RECONNECT_ALARM);
            intent.putExtra(INTENT_RECONNECT_ALARM_EXTRA_REASON, reason);
            this.mReconnectIntent = PendingIntent.getBroadcast(this.phone.getContext(), 0, intent, 0);
            am.set(2, SystemClock.elapsedRealtime() + (long)nextReconnectDelay, this.mReconnectIntent);
            this.mRetryMgr.increaseRetryCount();
            if (!this.shouldPostNotification(lastFailCauseCode)) {
                Log.d("GSM", "NOT Posting GPRS Unavailable notification -- likely transient error");
            } else {
                this.notifyNoData(lastFailCauseCode);
            }
        }
    }

    public void notifyNoData(DataConnection.FailCause lastFailCauseCode) {
        this.setState(DataConnectionTracker.State.FAILED);
    }

    public void onRecordsLoaded() {
        this.createAllApnList();
        if (this.state == DataConnectionTracker.State.FAILED) {
            this.cleanUpConnection(false, null);
        }
        this.sendMessage(this.obtainMessage(5, "simLoaded"));
    }

    @Override
    public void onEnableNewApn() {
        this.mRetryMgr = this.mRequestedApnType.equals("default") ? this.mDefaultRetryManager : this.mSecondaryRetryManager;
        this.mRetryMgr.resetRetryCount();
        this.cleanUpConnection(true, "apnSwitched");
    }

    @Override
    public boolean onTrySetupData(String reason) {
        return this.trySetupData(reason);
    }

    @Override
    public void onRoamingOff() {
        this.trySetupData("roamingOff");
    }

    @Override
    public void onRoamingOn() {
        if (this.getDataOnRoamingEnabled()) {
            this.trySetupData("roamingOn");
        } else {
            this.log("Tear down data connection on roaming.");
            this.cleanUpConnection(true, "roamingOn");
        }
    }

    @Override
    public void onRadioAvailable() {
        if (this.phone.getSimulatedRadioControl() != null) {
            this.setState(DataConnectionTracker.State.CONNECTED);
            this.phone.notifyDataConnection(null);
            Log.i("GSM", "We're on the simulator; assuming data is connected");
        }
        if (this.state != DataConnectionTracker.State.IDLE) {
            this.cleanUpConnection(true, null);
        }
    }

    @Override
    public void onRadioOffOrNotAvailable() {
        this.mRetryMgr.resetRetryCount();
        this.mReregisterOnReconnectFailure = false;
        if (this.phone.getSimulatedRadioControl() != null) {
            Log.i("GSM", "We're on the simulator; assuming radio off is meaningless");
        } else {
            this.log("Radio is off and clean up all connection");
            this.cleanUpConnection(false, "radioTurnedOff");
        }
    }

    @Override
    public void onDataSetupComplete(AsyncResult ar) {
        String reason = null;
        if (ar.userObj instanceof String) {
            reason = (String)ar.userObj;
        }
        if (ar.exception == null) {
            if (this.isApnTypeActive("default")) {
                SystemProperties.set("gsm.defaultpdpcontext.active", "true");
                if (this.canSetPreferApn && this.preferredApn == null) {
                    Log.d("GSM", "PREFERED APN is null");
                    this.preferredApn = this.mActiveApn;
                    this.setPreferredApn(this.preferredApn.id);
                }
            } else {
                SystemProperties.set("gsm.defaultpdpcontext.active", "false");
            }
            this.notifyDefaultData(reason);
        } else {
            DataConnection.FailCause cause = (DataConnection.FailCause)((Object)ar.result);
            this.log("PDP setup failed " + (Object)((Object)cause));
            if (cause.isEventLoggable()) {
                int cid = -1;
                GsmCellLocation loc = (GsmCellLocation)this.phone.getCellLocation();
                if (loc != null) {
                    cid = loc.getCid();
                }
                EventLog.List val = new EventLog.List(cause.ordinal(), cid, TelephonyManager.getDefault().getNetworkType());
                EventLog.writeEvent(50105, val);
            }
            if (cause.isPermanentFail()) {
                this.notifyNoData(cause);
                if (!this.mRequestedApnType.equals("default")) {
                    this.phone.notifyDataConnection("apnFailed");
                    this.onEnableApn(this.apnTypeToId(this.mRequestedApnType), 0);
                }
                return;
            }
            this.waitingApns.remove(0);
            if (this.waitingApns.isEmpty()) {
                this.startDelayedRetry(cause, reason);
            } else {
                this.setState(DataConnectionTracker.State.SCANNING);
                this.sendMessageDelayed(this.obtainMessage(5, reason), 5000L);
            }
        }
    }

    @Override
    public void onDisconnectDone(AsyncResult ar) {
        String reason = null;
        this.log("EVENT_DISCONNECT_DONE");
        if (ar.userObj instanceof String) {
            reason = (String)ar.userObj;
        }
        this.setState(DataConnectionTracker.State.IDLE);
        this.phone.notifyDataConnection(reason);
        this.mActiveApn = null;
        if (this.retryAfterDisconnected(reason)) {
            this.trySetupData(reason);
        }
    }

    public void onPollPdp() {
        if (this.state == DataConnectionTracker.State.CONNECTED) {
            this.phone.mCM.getPDPContextList(this.obtainMessage(11));
            this.sendMessageDelayed(this.obtainMessage(7), 5000L);
        }
    }

    @Override
    public void onVoiceCallStarted() {
        if (this.state == DataConnectionTracker.State.CONNECTED && !this.mGsmPhone.mSST.isConcurrentVoiceAndData()) {
            this.stopNetStatPoll();
            this.phone.notifyDataConnection("2GVoiceCallStarted");
        }
    }

    @Override
    public void onVoiceCallEnded() {
        if (this.state == DataConnectionTracker.State.CONNECTED) {
            if (!this.mGsmPhone.mSST.isConcurrentVoiceAndData()) {
                this.startNetStatPoll();
                this.phone.notifyDataConnection("2GVoiceCallEnded");
            } else {
                this.resetPollStats();
            }
        } else {
            this.mRetryMgr.resetRetryCount();
            this.mReregisterOnReconnectFailure = false;
            this.trySetupData("2GVoiceCallEnded");
        }
    }

    @Override
    public void onCleanUpConnection(boolean tearDown, String reason) {
        this.cleanUpConnection(tearDown, reason);
    }

    public void createAllApnList() {
        this.allApns = new ArrayList();
        String operator = this.mGsmPhone.mSIMRecords.getSIMOperatorNumeric();
        if (operator != null) {
            String selection = "numeric = '" + operator + "'";
            Cursor cursor = this.phone.getContext().getContentResolver().query(Telephony.Carriers.CONTENT_URI, null, selection, null, null);
            if (cursor != null) {
                if (cursor.getCount() > 0) {
                    this.allApns = this.createApnList(cursor);
                }
                cursor.close();
            }
        }
        if (this.allApns.isEmpty()) {
            this.log("No APN found for carrier: " + operator);
            this.preferredApn = null;
            this.notifyNoData(DataConnection.FailCause.MISSING_UKNOWN_APN);
        } else {
            this.preferredApn = this.getPreferredApn();
            Log.d("GSM", "Get PreferredAPN");
            if (this.preferredApn != null && !this.preferredApn.numeric.equals(operator)) {
                this.preferredApn = null;
                this.setPreferredApn(-1);
            }
        }
    }

    public void createAllPdpList() {
        this.pdpList = new ArrayList();
        for (int i = 0; i < 1; ++i) {
            PdpConnection pdp = new PdpConnection(this.mGsmPhone);
            this.pdpList.add(pdp);
        }
    }

    public void destroyAllPdpList() {
        if (this.pdpList != null) {
            this.pdpList.removeAll(this.pdpList);
        }
    }

    public ArrayList<ApnSetting> buildWaitingApns() {
        ArrayList<ApnSetting> apnList = new ArrayList<ApnSetting>();
        String operator = this.mGsmPhone.mSIMRecords.getSIMOperatorNumeric();
        if (this.mRequestedApnType.equals("default") && this.canSetPreferApn && this.preferredApn != null) {
            Log.i("GSM", "Preferred APN:" + operator + ":" + this.preferredApn.numeric + ":" + this.preferredApn);
            if (this.preferredApn.numeric.equals(operator)) {
                Log.i("GSM", "Waiting APN set to preferred APN");
                apnList.add(this.preferredApn);
                return apnList;
            }
            this.setPreferredApn(-1);
            this.preferredApn = null;
        }
        if (this.allApns != null) {
            for (ApnSetting apn : this.allApns) {
                if (!apn.canHandleType(this.mRequestedApnType)) continue;
                apnList.add(apn);
            }
        }
        return apnList;
    }

    public ApnSetting getNextApn() {
        ArrayList<ApnSetting> list = this.waitingApns;
        ApnSetting apn = null;
        if (list != null && !list.isEmpty()) {
            apn = list.get(0);
        }
        return apn;
    }

    public String apnListToString(ArrayList<ApnSetting> apns) {
        StringBuilder result = new StringBuilder();
        int size = apns.size();
        for (int i = 0; i < size; ++i) {
            result.append('[').append(apns.get(i).toString()).append(']');
        }
        return result.toString();
    }

    public void startDelayedRetry(DataConnection.FailCause cause, String reason) {
        this.notifyNoData(cause);
        this.reconnectAfterFail(cause, reason);
    }

    public void setPreferredApn(int pos) {
        if (!this.canSetPreferApn) {
            return;
        }
        ContentResolver resolver = this.phone.getContext().getContentResolver();
        resolver.delete(PREFERAPN_URI, null, null);
        if (pos >= 0) {
            ContentValues values = new ContentValues();
            values.put(APN_ID, pos);
            resolver.insert(PREFERAPN_URI, values);
        }
    }

    public ApnSetting getPreferredApn() {
        if (this.allApns.isEmpty()) {
            return null;
        }
        Cursor cursor = this.phone.getContext().getContentResolver().query(PREFERAPN_URI, new String[]{"_id", "name", "apn"}, null, null, "name ASC");
        this.canSetPreferApn = cursor != null;
        if (this.canSetPreferApn && cursor.getCount() > 0) {
            cursor.moveToFirst();
            int pos = cursor.getInt(cursor.getColumnIndexOrThrow("_id"));
            for (ApnSetting p : this.allApns) {
                if (p.id != pos || !p.canHandleType(this.mRequestedApnType)) continue;
                cursor.close();
                return p;
            }
        }
        if (cursor != null) {
            cursor.close();
        }
        return null;
    }

    @Override
    public void handleMessage(Message msg) {
        Log.d("GSM", "GSMDataConnTrack handleMessage " + msg);
        switch (msg.what) {
            case 4: {
                this.onRecordsLoaded();
                break;
            }
            case 19: {
                this.onGprsDetached();
                break;
            }
            case 26: {
                this.onGprsAttached();
                break;
            }
            case 6: {
                this.onPdpStateChanged((AsyncResult)msg.obj, false);
                break;
            }
            case 11: {
                this.onPdpStateChanged((AsyncResult)msg.obj, true);
                break;
            }
            case 7: {
                this.onPollPdp();
                break;
            }
            case 27: {
                this.mPingTestActive = false;
                this.startNetStatPoll();
                break;
            }
            case 28: {
                this.mPingTestActive = false;
                this.doRecovery();
                break;
            }
            case 29: {
                this.onApnChanged();
                break;
            }
            case 32: {
                Log.d("GSM", "[DSAC DEB] EVENT_PS_RESTRICT_ENABLED " + this.mIsPsRestricted);
                this.stopNetStatPoll();
                this.mIsPsRestricted = true;
                break;
            }
            case 33: {
                Log.d("GSM", "[DSAC DEB] EVENT_PS_RESTRICT_DISABLED " + this.mIsPsRestricted);
                this.mIsPsRestricted = false;
                if (this.state == DataConnectionTracker.State.CONNECTED) {
                    this.startNetStatPoll();
                    break;
                }
                if (this.state == DataConnectionTracker.State.FAILED) {
                    this.cleanUpConnection(false, "psRestrictEnabled");
                    this.mRetryMgr.resetRetryCount();
                    this.mReregisterOnReconnectFailure = false;
                }
                this.trySetupData("psRestrictEnabled");
                break;
            }
            default: {
                super.handleMessage(msg);
            }
        }
    }

    @Override
    public void log(String s) {
        Log.d("GSM", "[GsmDataConnectionTracker] " + s);
    }

    public class ApnChangeObserver
    extends ContentObserver {
        public ApnChangeObserver() {
            super(GsmDataConnectionTracker.this.mDataConnectionTracker);
        }

        public void onChange(boolean selfChange) {
            GsmDataConnectionTracker.this.sendMessage(GsmDataConnectionTracker.this.obtainMessage(29));
        }
    }
}

