/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.gsm;

import android.content.Context;
import android.os.AsyncResult;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import com.android.internal.telephony.IccSmsInterfaceManager;
import com.android.internal.telephony.IccUtils;
import com.android.internal.telephony.SmsRawData;
import com.android.internal.telephony.gsm.GSMPhone;
import com.android.internal.telephony.gsm.GsmSMSDispatcher;
import com.android.internal.telephony.gsm.SIMFileHandler;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimSmsInterfaceManager
extends IccSmsInterfaceManager {
    public static final String LOG_TAG = "GSM";
    public static final boolean DBG = true;
    public final Object mLock = new Object();
    public boolean mSuccess;
    public List<SmsRawData> mSms;
    public static final int EVENT_LOAD_DONE = 1;
    public static final int EVENT_UPDATE_DONE = 2;
    public Handler mHandler = new Handler(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 2: {
                    AsyncResult ar = (AsyncResult)msg.obj;
                    Object object = SimSmsInterfaceManager.this.mLock;
                    synchronized (object) {
                        SimSmsInterfaceManager.this.mSuccess = ar.exception == null;
                        SimSmsInterfaceManager.this.mLock.notifyAll();
                        break;
                    }
                }
                case 1: {
                    AsyncResult ar = (AsyncResult)msg.obj;
                    Object object = SimSmsInterfaceManager.this.mLock;
                    synchronized (object) {
                        if (ar.exception == null) {
                            SimSmsInterfaceManager.this.mSms = SimSmsInterfaceManager.this.buildValidRawData((ArrayList)ar.result);
                        } else {
                            SimSmsInterfaceManager.this.log("Cannot load Sms records");
                            if (SimSmsInterfaceManager.this.mSms != null) {
                                SimSmsInterfaceManager.this.mSms.clear();
                            }
                        }
                        SimSmsInterfaceManager.this.mLock.notifyAll();
                        break;
                    }
                }
            }
        }
    };

    public SimSmsInterfaceManager(GSMPhone phone) {
        super(phone);
        this.mDispatcher = new GsmSMSDispatcher(phone);
    }

    public void dispose() {
    }

    @Override
    public void finalize() {
        Log.d(LOG_TAG, "SimSmsInterfaceManager finalized");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean updateMessageOnIccEf(int index, int status, byte[] pdu) {
        this.log("updateMessageOnIccEf: index=" + index + " status=" + status + " ==> " + "(" + pdu + ")");
        this.enforceReceiveAndSend("Updating message on SIM");
        Object object = this.mLock;
        synchronized (object) {
            this.mSuccess = false;
            Message response = this.mHandler.obtainMessage(2);
            if (status == 0) {
                this.mPhone.mCM.deleteSmsOnSim(index, response);
            } else {
                byte[] record = this.makeSmsRecordData(status, pdu);
                ((SIMFileHandler)this.mPhone.getIccFileHandler()).updateEFLinearFixed(28476, index, record, null, response);
            }
            try {
                this.mLock.wait();
            }
            catch (InterruptedException e) {
                this.log("interrupted while trying to update by index");
            }
        }
        return this.mSuccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean copyMessageToIccEf(int status, byte[] pdu, byte[] smsc) {
        this.log("copyMessageToIccEf: status=" + status + " ==> " + "pdu=(" + pdu + "), smsm=(" + smsc + ")");
        this.enforceReceiveAndSend("Copying message to SIM");
        Object object = this.mLock;
        synchronized (object) {
            this.mSuccess = false;
            Message response = this.mHandler.obtainMessage(2);
            this.mPhone.mCM.writeSmsToSim(status, IccUtils.bytesToHexString(smsc), IccUtils.bytesToHexString(pdu), response);
            try {
                this.mLock.wait();
            }
            catch (InterruptedException e) {
                this.log("interrupted while trying to update by index");
            }
        }
        return this.mSuccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<SmsRawData> getAllMessagesFromIccEf() {
        this.log("getAllMessagesFromEF");
        Context context = this.mPhone.getContext();
        context.enforceCallingPermission("android.permission.RECEIVE_SMS", "Reading messages from SIM");
        Object object = this.mLock;
        synchronized (object) {
            Message response = this.mHandler.obtainMessage(1);
            ((SIMFileHandler)this.mPhone.getIccFileHandler()).loadEFLinearFixedAll(28476, response);
            try {
                this.mLock.wait();
            }
            catch (InterruptedException e) {
                this.log("interrupted while trying to load from the SIM");
            }
        }
        return this.mSms;
    }

    @Override
    public void log(String msg) {
        Log.d(LOG_TAG, "[SimSmsInterfaceManager] " + msg);
    }
}

