/*
 * Decompiled with CFR 0.152.
 */
package com.android.layoutlib.bridge;

import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.util.TypedValue;
import com.android.layoutlib.api.IDensityBasedResourceValue;
import com.android.layoutlib.api.IResourceValue;
import com.android.layoutlib.bridge.Bridge;
import com.android.layoutlib.bridge.BridgeContext;
import com.android.layoutlib.bridge.BridgeXmlBlockParser;
import com.android.layoutlib.bridge.NinePatchDrawable;
import com.android.ninepatch.NinePatch;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.kxml2.io.KXmlParser;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public final class ResourceHelper {
    private static final Pattern sFloatPattern = Pattern.compile("(-?[0-9]+(?:\\.[0-9]+)?)(.*)");
    private static final float[] sFloatOut = new float[1];
    private static final TypedValue mValue = new TypedValue();
    private static final UnitEntry[] sUnitNames = new UnitEntry[]{new UnitEntry("px", 5, 0, 1.0f), new UnitEntry("dip", 5, 1, 1.0f), new UnitEntry("dp", 5, 1, 1.0f), new UnitEntry("sp", 5, 2, 1.0f), new UnitEntry("pt", 5, 3, 1.0f), new UnitEntry("in", 5, 4, 1.0f), new UnitEntry("mm", 5, 5, 1.0f), new UnitEntry("%", 6, 0, 0.01f), new UnitEntry("%p", 6, 1, 0.01f)};

    static int getColor(String value) {
        if (value != null) {
            if (!value.startsWith("#")) {
                throw new NumberFormatException();
            }
            if ((value = value.substring(1)).length() > 8) {
                throw new NumberFormatException();
            }
            if (value.length() == 3) {
                char[] color2 = new char[8];
                color2[1] = 70;
                color2[0] = 70;
                color2[2] = color2[3] = value.charAt(0);
                color2[4] = color2[5] = value.charAt(1);
                color2[6] = color2[7] = value.charAt(2);
                value = new String(color2);
            } else if (value.length() == 4) {
                char[] color3 = new char[8];
                color3[0] = color3[1] = value.charAt(0);
                color3[2] = color3[3] = value.charAt(1);
                color3[4] = color3[5] = value.charAt(2);
                color3[6] = color3[7] = value.charAt(3);
                value = new String(color3);
            } else if (value.length() == 6) {
                value = "FF" + value;
            }
            return (int)Long.parseLong(value, 16);
        }
        throw new NumberFormatException();
    }

    public static Drawable getDrawable(IResourceValue value, BridgeContext context, boolean isFramework) {
        Drawable d = null;
        String stringValue = value.getValue();
        String lowerCaseValue = stringValue.toLowerCase();
        if (lowerCaseValue.endsWith(".9.png")) {
            File file = new File(stringValue);
            if (file.isFile()) {
                NinePatch ninePatch = Bridge.getCached9Patch(stringValue, isFramework ? null : context.getProjectKey());
                if (ninePatch == null) {
                    try {
                        ninePatch = NinePatch.load((URL)file.toURL(), (boolean)false);
                        Bridge.setCached9Patch(stringValue, ninePatch, isFramework ? null : context.getProjectKey());
                    }
                    catch (MalformedURLException e) {
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                if (ninePatch != null) {
                    return new NinePatchDrawable(ninePatch);
                }
            }
            return null;
        }
        if (lowerCaseValue.endsWith(".xml")) {
            File f = new File(stringValue);
            if (f.isFile()) {
                try {
                    KXmlParser parser = new KXmlParser();
                    parser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
                    parser.setInput((Reader)new FileReader(f));
                    d = Drawable.createFromXml(context.getResources(), new BridgeXmlBlockParser((XmlPullParser)parser, context, false));
                    return d;
                }
                catch (XmlPullParserException e) {
                    context.getLogger().error((Throwable)e);
                }
                catch (FileNotFoundException e) {
                }
                catch (IOException e) {
                    context.getLogger().error((Throwable)e);
                }
            }
            return null;
        }
        File bmpFile = new File(stringValue);
        if (bmpFile.isFile()) {
            try {
                Bitmap bitmap = Bridge.getCachedBitmap(stringValue, isFramework ? null : context.getProjectKey());
                if (bitmap == null) {
                    bitmap = new Bitmap(bmpFile);
                    try {
                        bitmap.setDensity(IDensityBasedResourceValue.Density.MEDIUM.getValue());
                    }
                    catch (NoClassDefFoundError error) {
                        // empty catch block
                    }
                    Bridge.setCachedBitmap(stringValue, bitmap, isFramework ? null : context.getProjectKey());
                }
                try {
                    IDensityBasedResourceValue.Density density;
                    if (value instanceof IDensityBasedResourceValue && (density = ((IDensityBasedResourceValue)value).getDensity()) != IDensityBasedResourceValue.Density.MEDIUM) {
                        bitmap = Bitmap.createBitmap(bitmap);
                        bitmap.setDensity(density.getValue());
                    }
                }
                catch (NoClassDefFoundError error) {
                    // empty catch block
                }
                return new BitmapDrawable(context.getResources(), bitmap);
            }
            catch (IOException e) {}
        } else {
            try {
                int color2 = ResourceHelper.getColor(stringValue);
                return new ColorDrawable(color2);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return null;
    }

    public static TypedValue getValue(String s) {
        if (ResourceHelper.stringToFloat(s, mValue)) {
            return mValue;
        }
        return null;
    }

    public static boolean stringToFloat(String s, TypedValue outValue) {
        s.trim();
        int len = s.length();
        if (len <= 0) {
            return false;
        }
        char[] buf = s.toCharArray();
        for (int i = 0; i < len; ++i) {
            if (buf[i] <= '\u00ff') continue;
            return false;
        }
        if (buf[0] < '0' && buf[0] > '9' && buf[0] != '.') {
            return false;
        }
        Matcher m = sFloatPattern.matcher(s);
        if (m.matches()) {
            float f;
            String f_str = m.group(1);
            String end = m.group(2);
            try {
                f = Float.parseFloat(f_str);
            }
            catch (NumberFormatException e) {
                return false;
            }
            if (end.length() > 0 && end.charAt(0) != ' ') {
                if (ResourceHelper.parseUnit(end, outValue, sFloatOut)) {
                    int shift;
                    int radix;
                    long bits;
                    boolean neg;
                    boolean bl = neg = (f *= sFloatOut[0]) < 0.0f;
                    if (neg) {
                        f = -f;
                    }
                    if (((bits = (long)(f * 8388608.0f + 0.5f)) & 0x7FFFFFL) == 0L) {
                        radix = 0;
                        shift = 23;
                    } else if ((bits & 0xFFFFFFFFFF800000L) == 0L) {
                        radix = 3;
                        shift = 0;
                    } else if ((bits & Integer.MIN_VALUE) == 0L) {
                        radix = 2;
                        shift = 8;
                    } else if ((bits & 0xFFFFFF8000000000L) == 0L) {
                        radix = 1;
                        shift = 16;
                    } else {
                        radix = 0;
                        shift = 23;
                    }
                    int mantissa = (int)(bits >> shift & 0xFFFFFFL);
                    if (neg) {
                        mantissa = -mantissa & 0xFFFFFF;
                    }
                    outValue.data |= radix << 4 | mantissa << 8;
                    return true;
                }
                return false;
            }
            if ((end = end.trim()).length() == 0 && outValue != null) {
                outValue.type = 4;
                outValue.data = Float.floatToIntBits(f);
                return true;
            }
        }
        return false;
    }

    private static boolean parseUnit(String str, TypedValue outValue, float[] outScale) {
        str = str.trim();
        for (UnitEntry unit : sUnitNames) {
            if (!unit.name.equals(str)) continue;
            outValue.type = unit.type;
            outValue.data = unit.unit << 0;
            outScale[0] = unit.scale;
            return true;
        }
        return false;
    }

    private static final class UnitEntry {
        String name;
        int type;
        int unit;
        float scale;

        UnitEntry(String name, int type, int unit, float scale) {
            this.name = name;
            this.type = type;
            this.unit = unit;
            this.scale = scale;
        }
    }
}

