/*
 * Decompiled with CFR 0.152.
 */
package dalvik.system;

import com.android.tools.layoutlib.create.OverrideMethod;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.logging.Logger;

public class SamplingProfiler {
    public static final Logger logger = Logger.getLogger(SamplingProfiler.class.getName());
    public static final boolean DEBUG = false;
    public int pointer = 0;
    public Thread samplingThread;
    public volatile int delay;
    public int totalThreadsSampled = 0;
    public long totalSampleTime = 0L;
    public volatile State state = State.PAUSED;
    public static final SamplingProfiler instance = new SamplingProfiler();

    public boolean isRunning() {
        return this.state == State.RUNNING;
    }

    public synchronized void start(int samplesPerSecond) {
        if (samplesPerSecond < 1) {
            throw new IllegalArgumentException("samplesPerSecond < 1");
        }
        this.ensureNotShuttingDown();
        this.delay = 1000 / samplesPerSecond;
        if (!this.isRunning()) {
            this.state = State.RUNNING;
            if (this.samplingThread == null) {
                this.samplingThread = new Thread((Runnable)new Sampler(), "SamplingProfiler");
                this.samplingThread.setDaemon(true);
                this.samplingThread.start();
            } else {
                this.notifyAll();
            }
        }
    }

    public synchronized void pause() {
        if (this.isRunning()) {
            this.state = State.PAUSED;
        }
    }

    public synchronized byte[] snapshot() {
        this.ensureNotShuttingDown();
        if (this.pointer == 0 || this.totalThreadsSampled == 0) {
            return null;
        }
        this.totalThreadsSampled = 0;
        return SamplingProfiler.snapshot(this.pointer);
    }

    public synchronized void setEventThread(Thread eventThread) {
        this.ensureNotShuttingDown();
        if (this.pointer == 0) {
            this.pointer = SamplingProfiler.allocate();
        }
        SamplingProfiler.setEventThread(this.pointer, eventThread);
    }

    public void ensureNotShuttingDown() {
        if (this.state == State.SHUTTING_DOWN) {
            throw new IllegalStateException("Profiler is shutting down.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutDown() {
        Thread toStop;
        SamplingProfiler samplingProfiler = this;
        synchronized (samplingProfiler) {
            this.ensureNotShuttingDown();
            toStop = this.samplingThread;
            if (toStop == null) {
                throw new IllegalStateException("The profiler was never started.");
            }
            this.state = State.SHUTTING_DOWN;
            this.samplingThread = null;
            this.notifyAll();
        }
        toStop.interrupt();
        while (true) {
            try {
                toStop.join();
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
        samplingProfiler = this;
        synchronized (samplingProfiler) {
            if (this.pointer != 0) {
                SamplingProfiler.free(this.pointer);
                this.pointer = 0;
            }
            this.totalThreadsSampled = 0;
            this.totalSampleTime = 0L;
            this.state = State.PAUSED;
        }
    }

    public static int sample(int n) {
        return OverrideMethod.invokeI("dalvik.system.SamplingProfiler#sample(I)I", true, null);
    }

    public static int allocate() {
        return OverrideMethod.invokeI("dalvik.system.SamplingProfiler#allocate()I", true, null);
    }

    public static void free(int n) {
        OverrideMethod.invokeV("dalvik.system.SamplingProfiler#free(I)V", true, null);
    }

    public static int size(int n) {
        return OverrideMethod.invokeI("dalvik.system.SamplingProfiler#size(I)I", true, null);
    }

    public static int collisions(int n) {
        return OverrideMethod.invokeI("dalvik.system.SamplingProfiler#collisions(I)I", true, null);
    }

    public static byte[] snapshot(int n) {
        return (byte[])OverrideMethod.invokeA("dalvik.system.SamplingProfiler#snapshot(I)[B", true, null);
    }

    public static void setEventThread(int n, Thread thread) {
        OverrideMethod.invokeV("dalvik.system.SamplingProfiler#setEventThread(ILjava/lang/Thread;)V", true, null);
    }

    public static void logSnapshot(byte[] snapshot) {
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(snapshot));
        try {
            int version = in.readUnsignedShort();
            int classCount = in.readUnsignedShort();
            StringBuilder sb = new StringBuilder();
            sb.append("version=").append(version).append(' ').append("classes=").append(classCount).append('\n');
            logger.info(sb.toString());
            for (int i = 0; i < classCount; ++i) {
                sb = new StringBuilder();
                sb.append("class ").append(in.readUTF()).append('\n');
                int methodCount = in.readUnsignedShort();
                for (int m = 0; m < methodCount; ++m) {
                    sb.append("  ").append(in.readUTF()).append(":\n");
                    sb.append("    event:\n");
                    SamplingProfiler.appendCounts(in, sb);
                    sb.append("    other:\n");
                    SamplingProfiler.appendCounts(in, sb);
                }
                logger.info(sb.toString());
            }
        }
        catch (IOException e) {
            logger.warning(e.toString());
        }
    }

    public static void appendCounts(DataInputStream in, StringBuilder sb) throws IOException {
        sb.append("      running:\n");
        sb.append("        caller: ").append(in.readShort()).append('\n');
        sb.append("        leaf: ").append(in.readShort()).append('\n');
        sb.append("      suspended:\n");
        sb.append("        caller: ").append(in.readShort()).append('\n');
        sb.append("        leaf: ").append(in.readShort()).append('\n');
    }

    public static synchronized SamplingProfiler getInstance() {
        return instance;
    }

    public class Sampler
    implements Runnable {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            boolean firstSample = true;
            while (true) {
                SamplingProfiler samplingProfiler = SamplingProfiler.this;
                synchronized (samplingProfiler) {
                    if (!SamplingProfiler.this.isRunning()) {
                        while (!SamplingProfiler.this.isRunning()) {
                            if (SamplingProfiler.this.state == State.SHUTTING_DOWN) {
                                return;
                            }
                            try {
                                SamplingProfiler.this.wait();
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                        firstSample = true;
                    }
                    if (SamplingProfiler.this.pointer == 0) {
                        SamplingProfiler.this.pointer = SamplingProfiler.allocate();
                    }
                    if (firstSample) {
                        firstSample = false;
                    }
                    SamplingProfiler.this.totalThreadsSampled += SamplingProfiler.sample(SamplingProfiler.this.pointer);
                }
                try {
                    Thread.sleep(SamplingProfiler.this.delay);
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        PAUSED,
        RUNNING,
        SHUTTING_DOWN;

    }
}

