/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.luni.util;

import java.lang.ref.SoftReference;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Logger;

public class MsgHelp {
    public static HashMap<String, SoftReference<ResourceBundle>> sRefMap = null;

    public static synchronized ResourceBundle loadBundle(String resource) {
        SoftReference<ResourceBundle> bundleRef;
        if (sRefMap == null) {
            sRefMap = new HashMap();
        }
        if ((bundleRef = sRefMap.get(resource)) == null || bundleRef.get() == null) {
            try {
                ResourceBundle bundle = MsgHelp.setLocale(Locale.getDefault(), resource);
                bundleRef = new SoftReference<ResourceBundle>(bundle);
                sRefMap.put(resource, bundleRef);
                return bundle;
            }
            catch (Throwable e) {
                Logger.global.warning("Got Throwable " + e + " loading messages");
                return null;
            }
        }
        return bundleRef.get();
    }

    public static String getString(String resource, String msg) {
        ResourceBundle bundle = MsgHelp.loadBundle(resource);
        if (bundle == null) {
            return msg;
        }
        try {
            return bundle.getString(msg);
        }
        catch (MissingResourceException e) {
            return "Missing message: " + msg;
        }
    }

    public static String getString(String resource, String msg, Object[] args) {
        String format = msg;
        ResourceBundle bundle = MsgHelp.loadBundle(resource);
        if (bundle != null) {
            try {
                format = bundle.getString(msg);
            }
            catch (MissingResourceException e) {
                // empty catch block
            }
        }
        return MsgHelp.format(format, args);
    }

    public static String format(String format, Object[] args) {
        StringBuilder answer = new StringBuilder(format.length() + args.length * 20);
        String[] argStrings = new String[args.length];
        for (int i = 0; i < args.length; ++i) {
            argStrings[i] = args[i] == null ? "<null>" : args[i].toString();
        }
        int lastI = 0;
        int i = format.indexOf(123, 0);
        while (i >= 0) {
            if (i != 0 && format.charAt(i - 1) == '\\') {
                if (i != 1) {
                    answer.append(format.substring(lastI, i - 1));
                }
                answer.append('{');
                lastI = i + 1;
            } else if (i > format.length() - 3) {
                answer.append(format.substring(lastI, format.length()));
                lastI = format.length();
            } else {
                byte argnum = (byte)Character.digit(format.charAt(i + 1), 10);
                if (argnum < 0 || format.charAt(i + 2) != '}') {
                    answer.append(format.substring(lastI, i + 1));
                    lastI = i + 1;
                } else {
                    answer.append(format.substring(lastI, i));
                    if (argnum >= argStrings.length) {
                        answer.append("<missing argument>");
                    } else {
                        answer.append(argStrings[argnum]);
                    }
                    lastI = i + 3;
                }
            }
            i = format.indexOf(123, lastI);
        }
        if (lastI < format.length()) {
            answer.append(format.substring(lastI, format.length()));
        }
        return answer.toString();
    }

    public static ResourceBundle setLocale(final Locale locale, final String resource) {
        try {
            return (ResourceBundle)AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    return ResourceBundle.getBundle(resource, locale, ClassLoader.getSystemClassLoader());
                }
            });
        }
        catch (MissingResourceException missingResourceException) {
            return null;
        }
    }
}

