/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.security.asn1;

import java.io.IOException;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Iterator;
import java.util.TreeMap;
import org.apache.harmony.security.asn1.ASN1Any;
import org.apache.harmony.security.asn1.ASN1Exception;
import org.apache.harmony.security.asn1.ASN1Type;
import org.apache.harmony.security.asn1.BerInputStream;
import org.apache.harmony.security.asn1.BerOutputStream;
import org.apache.harmony.security.internal.nls.Messages;

public abstract class ASN1Choice
extends ASN1Type {
    public final ASN1Type[] type;
    public final int[][] identifiers;

    public ASN1Choice(ASN1Type[] type) {
        super(0);
        if (type.length == 0) {
            throw new IllegalArgumentException(Messages.getString("security.10E", this.getClass().getName()));
        }
        TreeMap map = new TreeMap();
        for (int index = 0; index < type.length; ++index) {
            ASN1Type t = type[index];
            if (t instanceof ASN1Any) {
                throw new IllegalArgumentException(Messages.getString("security.10F", this.getClass().getName()));
            }
            if (t instanceof ASN1Choice) {
                int[][] choiceToAdd = ((ASN1Choice)t).identifiers;
                for (int j = 0; j < choiceToAdd[0].length; ++j) {
                    this.addIdentifier(map, choiceToAdd[0][j], index);
                }
                continue;
            }
            if (t.checkTag(t.id)) {
                this.addIdentifier(map, t.id, index);
            }
            if (!t.checkTag(t.constrId)) continue;
            this.addIdentifier(map, t.constrId, index);
        }
        int size = map.size();
        this.identifiers = new int[2][size];
        Iterator it = map.keySet().iterator();
        for (int i = 0; i < size; ++i) {
            BigInteger identifier = (BigInteger)it.next();
            this.identifiers[0][i] = identifier.intValue();
            this.identifiers[1][i] = ((BigInteger)map.get(identifier)).intValue();
        }
        this.type = type;
    }

    public void addIdentifier(TreeMap map, int identifier, int index) {
        if (map.put(BigInteger.valueOf(identifier), BigInteger.valueOf(index)) != null) {
            throw new IllegalArgumentException(Messages.getString("security.10F", this.getClass().getName()));
        }
    }

    public boolean checkTag(int identifier) {
        return Arrays.binarySearch(this.identifiers[0], identifier) >= 0;
    }

    public Object decode(BerInputStream in) throws IOException {
        int index = Arrays.binarySearch(this.identifiers[0], in.tag);
        if (index < 0) {
            throw new ASN1Exception(Messages.getString("security.110", this.getClass().getName()));
        }
        index = this.identifiers[1][index];
        in.content = this.type[index].decode(in);
        in.choiceIndex = index;
        if (in.isVerify) {
            return null;
        }
        return this.getDecodedObject(in);
    }

    public void encodeASN(BerOutputStream out) {
        this.encodeContent(out);
    }

    public void encodeContent(BerOutputStream out) {
        out.encodeChoice(this);
    }

    public abstract int getIndex(Object var1);

    public abstract Object getObjectToEncode(Object var1);

    public void setEncodingContent(BerOutputStream out) {
        out.getChoiceLength(this);
    }
}

