/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.security.asn1;

import java.io.IOException;
import org.apache.harmony.security.asn1.ASN1Any;
import org.apache.harmony.security.asn1.ASN1Choice;
import org.apache.harmony.security.asn1.ASN1Exception;
import org.apache.harmony.security.asn1.ASN1Type;
import org.apache.harmony.security.asn1.BerInputStream;
import org.apache.harmony.security.asn1.BerOutputStream;
import org.apache.harmony.security.internal.nls.Messages;

public class ASN1Implicit
extends ASN1Type {
    public static final int TAGGING_PRIMITIVE = 0;
    public static final int TAGGING_CONSTRUCTED = 1;
    public static final int TAGGING_STRING = 2;
    public final ASN1Type type;
    public final int taggingType;

    public ASN1Implicit(int tagNumber, ASN1Type type) {
        this(128, tagNumber, type);
    }

    public ASN1Implicit(int tagClass, int tagNumber, ASN1Type type) {
        super(tagClass, tagNumber);
        if (type instanceof ASN1Choice || type instanceof ASN1Any) {
            throw new IllegalArgumentException(Messages.getString("security.9F"));
        }
        this.type = type;
        this.taggingType = type.checkTag(type.id) ? (type.checkTag(type.constrId) ? 2 : 0) : 1;
    }

    public boolean checkTag(int identifier) {
        switch (this.taggingType) {
            case 0: {
                return this.id == identifier;
            }
            case 1: {
                return this.constrId == identifier;
            }
        }
        return this.id == identifier || this.constrId == identifier;
    }

    public Object decode(BerInputStream in) throws IOException {
        if (!this.checkTag(in.tag)) {
            throw new ASN1Exception(Messages.getString("security.100", new Object[]{in.tagOffset, Integer.toHexString(this.id), Integer.toHexString(in.tag)}));
        }
        in.tag = this.id == in.tag ? this.type.id : this.type.constrId;
        in.content = this.type.decode(in);
        if (in.isVerify) {
            return null;
        }
        return this.getDecodedObject(in);
    }

    public void encodeASN(BerOutputStream out) {
        if (this.taggingType == 1) {
            out.encodeTag(this.constrId);
        } else {
            out.encodeTag(this.id);
        }
        this.encodeContent(out);
    }

    public void encodeContent(BerOutputStream out) {
        this.type.encodeContent(out);
    }

    public void setEncodingContent(BerOutputStream out) {
        this.type.setEncodingContent(out);
    }
}

