/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.xnet.provider.jsse;

import java.io.PrintStream;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class Logger {
    public static String[] names;

    public static Stream getStream(String name) {
        for (int i = 0; i < names.length; ++i) {
            if (!names[i].equals(name)) continue;
            return new Stream(name);
        }
        return null;
    }

    static {
        try {
            names = AccessController.doPrivileged(new PrivilegedAction<String[]>(){

                @Override
                public String[] run() {
                    return System.getProperty("jsse", "").split(",");
                }
            });
        }
        catch (Exception e) {
            names = new String[0];
        }
    }

    public static class Stream
    extends PrintStream {
        public final String prefix;
        public static int indent = 0;

        public Stream(String name) {
            super(System.err);
            this.prefix = name + "[" + Thread.currentThread().getName() + "] ";
        }

        public void print(String msg) {
            for (int i = 0; i < indent; ++i) {
                super.print("  ");
            }
            super.print(msg);
        }

        public void newIndent() {
            ++indent;
        }

        public void endIndent() {
            --indent;
        }

        public void println(String msg) {
            this.print(this.prefix);
            super.println(msg);
        }

        public void print(byte[] data) {
            this.printAsHex(16, " ", "", data, 0, data.length);
        }

        public void print(byte[] data, int offset, int len) {
            this.printAsHex(16, " ", "", data, offset, len);
        }

        public void printAsHex(int perLine, String prefix, String delimiter, byte[] data) {
            this.printAsHex(perLine, prefix, delimiter, data, 0, data.length);
        }

        public void printAsHex(int perLine, String prefix, String delimiter, byte[] data, int offset, int len) {
            String line = "";
            for (int i = 0; i < len; ++i) {
                String tail = Integer.toHexString(0xFF & data[i + offset]).toUpperCase();
                if (tail.length() == 1) {
                    tail = "0" + tail;
                }
                line = line + prefix + tail + delimiter;
                if ((i + 1) % perLine != 0) continue;
                super.println(line);
                line = "";
            }
            super.println(line);
        }
    }
}

