/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.xnet.provider.jsse;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.security.KeyManagementException;
import javax.net.ssl.SSLServerSocketFactory;
import org.apache.harmony.xnet.provider.jsse.OpenSSLServerSocketImpl;
import org.apache.harmony.xnet.provider.jsse.SSLParameters;

public class OpenSSLServerSocketFactoryImpl
extends SSLServerSocketFactory {
    public SSLParameters sslParameters;
    public IOException instantiationException;

    public OpenSSLServerSocketFactoryImpl() {
        try {
            this.sslParameters = SSLParameters.getDefault();
            this.sslParameters.setUseClientMode(false);
        }
        catch (KeyManagementException e) {
            this.instantiationException = new IOException("Delayed instantiation exception:");
            this.instantiationException.initCause(e);
        }
    }

    public OpenSSLServerSocketFactoryImpl(SSLParameters sslParameters) {
        this.sslParameters = sslParameters;
    }

    public String[] getDefaultCipherSuites() {
        return OpenSSLServerSocketImpl.nativegetsupportedciphersuites();
    }

    public String[] getSupportedCipherSuites() {
        return OpenSSLServerSocketImpl.nativegetsupportedciphersuites();
    }

    public ServerSocket createServerSocket() throws IOException {
        return new OpenSSLServerSocketImpl((SSLParameters)this.sslParameters.clone());
    }

    public ServerSocket createServerSocket(int port) throws IOException {
        return new OpenSSLServerSocketImpl(port, (SSLParameters)this.sslParameters.clone());
    }

    public ServerSocket createServerSocket(int port, int backlog) throws IOException {
        return new OpenSSLServerSocketImpl(port, backlog, (SSLParameters)this.sslParameters.clone());
    }

    public ServerSocket createServerSocket(int port, int backlog, InetAddress iAddress) throws IOException {
        return new OpenSSLServerSocketImpl(port, backlog, iAddress, (SSLParameters)this.sslParameters.clone());
    }
}

