/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.xnet.provider.jsse;

import com.android.tools.layoutlib.create.OverrideMethod;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.security.PrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.security.cert.CertificateException;
import javax.security.cert.X509Certificate;
import org.apache.harmony.security.provider.cert.X509CertImpl;
import org.apache.harmony.xnet.provider.jsse.AlertException;
import org.apache.harmony.xnet.provider.jsse.ClientSessionContext;
import org.apache.harmony.xnet.provider.jsse.OpenSSLSessionImpl;
import org.apache.harmony.xnet.provider.jsse.SSLParameters;
import org.apache.harmony.xnet.provider.jsse.SSLSessionImpl;
import org.apache.harmony.xnet.provider.jsse.ServerSessionContext;
import org.bouncycastle.openssl.PEMWriter;

public class OpenSSLSocketImpl
extends SSLSocket {
    public int ssl_ctx;
    public int ssl;
    public InputStream is;
    public OutputStream os;
    public final Object handshakeLock = new Object();
    public Object readLock = new Object();
    public Object writeLock = new Object();
    public SSLParameters sslParameters;
    public OpenSSLSessionImpl sslSession;
    public Socket socket;
    public boolean autoClose;
    public boolean handshakeStarted = false;
    public ArrayList<HandshakeCompletedListener> listeners;
    public long ssl_op_no = 0L;
    public int timeout = 0;
    public InetSocketAddress address;
    public static final String[] supportedProtocols = new String[]{"SSLv3", "TLSv1"};
    public static final AtomicInteger instanceCount = new AtomicInteger(0);
    public static long SSL_OP_NO_SSLv3;
    public static long SSL_OP_NO_TLSv1;

    public static int getInstanceCount() {
        return instanceCount.get();
    }

    public static void updateInstanceCount(int amount) {
        instanceCount.addAndGet(amount);
    }

    public static void nativeinitstatic() {
        OverrideMethod.invokeV("org.apache.harmony.xnet.provider.jsse.OpenSSLSocketImpl#nativeinitstatic()V", true, null);
    }

    public void nativeinit(String string2, String string3, byte[] byArray) {
        OverrideMethod.invokeV("org.apache.harmony.xnet.provider.jsse.OpenSSLSocketImpl#nativeinit(Ljava/lang/String;Ljava/lang/String;[B)V", true, this);
    }

    public void init() throws IOException {
        String alias = this.sslParameters.getKeyManager().chooseClientAlias(new String[]{"RSA"}, null, null);
        if (alias != null) {
            PrivateKey privateKey = this.sslParameters.getKeyManager().getPrivateKey(alias);
            java.security.cert.X509Certificate[] certificates = this.sslParameters.getKeyManager().getCertificateChain(alias);
            ByteArrayOutputStream privateKeyOS = new ByteArrayOutputStream();
            PEMWriter privateKeyPEMWriter = new PEMWriter(new OutputStreamWriter(privateKeyOS));
            privateKeyPEMWriter.writeObject(privateKey);
            privateKeyPEMWriter.close();
            ByteArrayOutputStream certificateOS = new ByteArrayOutputStream();
            PEMWriter certificateWriter = new PEMWriter(new OutputStreamWriter(certificateOS));
            for (int i = 0; i < certificates.length; ++i) {
                certificateWriter.writeObject(certificates[i]);
            }
            certificateWriter.close();
            this.nativeinit(privateKeyOS.toString(), certificateOS.toString(), this.sslParameters.getSecureRandomMember() != null ? this.sslParameters.getSecureRandomMember().generateSeed(1024) : null);
        } else {
            this.nativeinit(null, null, this.sslParameters.getSecureRandomMember() != null ? this.sslParameters.getSecureRandomMember().generateSeed(1024) : null);
        }
    }

    public OpenSSLSocketImpl(SSLParameters sslParameters, long ssl_op_no) throws IOException {
        this.sslParameters = sslParameters;
        this.ssl_op_no = ssl_op_no;
        OpenSSLSocketImpl.updateInstanceCount(1);
    }

    public OpenSSLSocketImpl(SSLParameters sslParameters) throws IOException {
        this.sslParameters = sslParameters;
        this.init();
        OpenSSLSocketImpl.updateInstanceCount(1);
    }

    public OpenSSLSocketImpl(String host, int port, SSLParameters sslParameters) throws IOException {
        super(host, port);
        this.sslParameters = sslParameters;
        this.init();
        OpenSSLSocketImpl.updateInstanceCount(1);
    }

    public OpenSSLSocketImpl(InetAddress address, int port, SSLParameters sslParameters) throws IOException {
        super(address, port);
        this.sslParameters = sslParameters;
        this.init();
        OpenSSLSocketImpl.updateInstanceCount(1);
    }

    public OpenSSLSocketImpl(String host, int port, InetAddress clientAddress, int clientPort, SSLParameters sslParameters) throws IOException {
        super(host, port, clientAddress, clientPort);
        this.sslParameters = sslParameters;
        this.init();
        OpenSSLSocketImpl.updateInstanceCount(1);
    }

    public OpenSSLSocketImpl(InetAddress address, int port, InetAddress clientAddress, int clientPort, SSLParameters sslParameters) throws IOException {
        super(address, port, clientAddress, clientPort);
        this.sslParameters = sslParameters;
        this.init();
        OpenSSLSocketImpl.updateInstanceCount(1);
    }

    public OpenSSLSocketImpl(Socket socket, String host, int port, boolean autoClose, SSLParameters sslParameters) throws IOException {
        this.socket = socket;
        this.timeout = socket.getSoTimeout();
        this.address = new InetSocketAddress(host, port);
        this.autoClose = autoClose;
        this.sslParameters = sslParameters;
        this.init();
        OpenSSLSocketImpl.updateInstanceCount(1);
    }

    public boolean nativeconnect(int n, Socket socket, boolean bl, int n2) throws IOException {
        return OverrideMethod.invokeI("org.apache.harmony.xnet.provider.jsse.OpenSSLSocketImpl#nativeconnect(ILjava/net/Socket;ZI)Z", true, this) != 0;
    }

    public int nativegetsslsession(int n) {
        return OverrideMethod.invokeI("org.apache.harmony.xnet.provider.jsse.OpenSSLSocketImpl#nativegetsslsession(I)I", true, this);
    }

    public String nativecipherauthenticationmethod() {
        return (String)OverrideMethod.invokeA("org.apache.harmony.xnet.provider.jsse.OpenSSLSocketImpl#nativecipherauthenticationmethod()Ljava/lang/String;", true, this);
    }

    public OpenSSLSessionImpl getCachedClientSession() {
        if (super.getInetAddress() == null || super.getInetAddress().getHostAddress() == null || super.getInetAddress().getHostName() == null) {
            return null;
        }
        ClientSessionContext sessionContext = this.sslParameters.getClientSessionContext();
        return (OpenSSLSessionImpl)sessionContext.getSession(super.getInetAddress().getHostName(), super.getPort());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public synchronized void startHandshake() throws IOException {
        Object object = this.handshakeLock;
        // MONITORENTER : object
        if (this.handshakeStarted) {
            // MONITOREXIT : object
            return;
        }
        this.handshakeStarted = true;
        // MONITOREXIT : object
        OpenSSLSessionImpl session = this.getCachedClientSession();
        if (session == null && !this.sslParameters.getEnableSessionCreation()) {
            throw new SSLHandshakeException("SSL Session may not be created");
        }
        Socket socket = this.socket != null ? this.socket : this;
        int sessionId = session != null ? session.session : 0;
        Class<OpenSSLSocketImpl> clazz = OpenSSLSocketImpl.class;
        // MONITORENTER : org.apache.harmony.xnet.provider.jsse.OpenSSLSocketImpl.class
        boolean reusedSession = this.nativeconnect(this.ssl_ctx, socket, this.sslParameters.getUseClientMode(), sessionId);
        // MONITOREXIT : clazz
        if (reusedSession) {
            session.lastAccessedTime = System.currentTimeMillis();
            this.sslSession = session;
            LoggerHolder.logger.fine("Reused cached session for " + this.getInetAddress().getHostName() + ".");
        } else {
            if (session != null) {
                LoggerHolder.logger.fine("Reuse of cached session for " + this.getInetAddress().getHostName() + " failed.");
            } else {
                LoggerHolder.logger.fine("Created new session for " + this.getInetAddress().getHostName() + ".");
            }
            ClientSessionContext sessionContext = this.sslParameters.getClientSessionContext();
            Class<OpenSSLSocketImpl> clazz2 = OpenSSLSocketImpl.class;
            // MONITORENTER : org.apache.harmony.xnet.provider.jsse.OpenSSLSocketImpl.class
            sessionId = this.nativegetsslsession(this.ssl);
            // MONITOREXIT : clazz2
            this.sslSession = this.address == null ? new OpenSSLSessionImpl(sessionId, this.sslParameters, super.getInetAddress().getHostName(), super.getPort(), sessionContext) : new OpenSSLSessionImpl(sessionId, this.sslParameters, this.address.getHostName(), this.address.getPort(), sessionContext);
            try {
                java.security.cert.X509Certificate[] peerCertificates = (java.security.cert.X509Certificate[])this.sslSession.getPeerCertificates();
                if (peerCertificates == null) throw new SSLException("Server sends no certificate");
                if (peerCertificates.length == 0) {
                    throw new SSLException("Server sends no certificate");
                }
                Class<OpenSSLSocketImpl> clazz3 = OpenSSLSocketImpl.class;
                // MONITORENTER : org.apache.harmony.xnet.provider.jsse.OpenSSLSocketImpl.class
                String authMethod = this.nativecipherauthenticationmethod();
                // MONITOREXIT : clazz3
                this.sslParameters.getTrustManager().checkServerTrusted(peerCertificates, authMethod);
                sessionContext.putSession(this.sslSession);
            }
            catch (java.security.cert.CertificateException e) {
                throw new SSLException("Not trusted server certificate", e);
            }
        }
        if (this.listeners == null) return;
        HandshakeCompletedEvent event = new HandshakeCompletedEvent(this, this.sslSession);
        int size = this.listeners.size();
        int i = 0;
        while (i < size) {
            this.listeners.get(i).handshakeCompleted(event);
            ++i;
        }
    }

    public synchronized void nativeaccept(Socket socket, int n, boolean bl) {
        OverrideMethod.invokeV("org.apache.harmony.xnet.provider.jsse.OpenSSLSocketImpl#nativeaccept(Ljava/net/Socket;IZ)V", true, this);
    }

    public void accept(int m_ctx, boolean client_mode) throws IOException {
        this.handshakeStarted = true;
        this.nativeaccept(this, m_ctx, client_mode);
        ServerSessionContext sessionContext = this.sslParameters.getServerSessionContext();
        this.sslSession = new OpenSSLSessionImpl(this.nativegetsslsession(this.ssl), this.sslParameters, super.getInetAddress().getHostName(), super.getPort(), sessionContext);
        this.sslSession.lastAccessedTime = System.currentTimeMillis();
        sessionContext.putSession(this.sslSession);
    }

    public int verify_callback(byte[][] bytes) {
        try {
            java.security.cert.X509Certificate[] peerCertificateChain = new java.security.cert.X509Certificate[bytes.length];
            for (int i = 0; i < bytes.length; ++i) {
                peerCertificateChain[i] = new X509CertImpl(X509Certificate.getInstance(bytes[i]).getEncoded());
            }
            try {
                this.sslParameters.getTrustManager().checkClientTrusted(peerCertificateChain, "null");
            }
            catch (java.security.cert.CertificateException e) {
                throw new AlertException(42, new SSLException("Not trusted server certificate", e));
            }
        }
        catch (CertificateException e) {
            return 0;
        }
        catch (IOException e) {
            return 0;
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getInputStream() throws IOException {
        OpenSSLSocketImpl openSSLSocketImpl = this;
        synchronized (openSSLSocketImpl) {
            if (this.is == null) {
                this.is = new SSLInputStream();
            }
            return this.is;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OutputStream getOutputStream() throws IOException {
        OpenSSLSocketImpl openSSLSocketImpl = this;
        synchronized (openSSLSocketImpl) {
            if (this.os == null) {
                this.os = new SSLOutputStream();
            }
            return this.os;
        }
    }

    public void shutdownInput() throws IOException {
        throw new UnsupportedOperationException("Method shutdownInput() is not supported.");
    }

    public void shutdownOutput() throws IOException {
        throw new UnsupportedOperationException("Method shutdownOutput() is not supported.");
    }

    public int nativeread(int n) throws IOException {
        return OverrideMethod.invokeI("org.apache.harmony.xnet.provider.jsse.OpenSSLSocketImpl#nativeread(I)I", true, this);
    }

    public int nativeread(byte[] byArray, int n, int n2, int n3) throws IOException {
        return OverrideMethod.invokeI("org.apache.harmony.xnet.provider.jsse.OpenSSLSocketImpl#nativeread([BIII)I", true, this);
    }

    public void nativewrite(int n) throws IOException {
        OverrideMethod.invokeV("org.apache.harmony.xnet.provider.jsse.OpenSSLSocketImpl#nativewrite(I)V", true, this);
    }

    public void nativewrite(byte[] byArray, int n, int n2) throws IOException {
        OverrideMethod.invokeV("org.apache.harmony.xnet.provider.jsse.OpenSSLSocketImpl#nativewrite([BII)V", true, this);
    }

    public SSLSession getSession() {
        try {
            this.startHandshake();
        }
        catch (IOException e) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "Error negotiating SSL connection.", e);
            return SSLSessionImpl.NULL_SESSION;
        }
        return this.sslSession;
    }

    public void addHandshakeCompletedListener(HandshakeCompletedListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Provided listener is null");
        }
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        this.listeners.add(listener);
    }

    public void removeHandshakeCompletedListener(HandshakeCompletedListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Provided listener is null");
        }
        if (this.listeners == null) {
            throw new IllegalArgumentException("Provided listener is not registered");
        }
        if (!this.listeners.remove(listener)) {
            throw new IllegalArgumentException("Provided listener is not registered");
        }
    }

    public boolean getEnableSessionCreation() {
        return this.sslParameters.getEnableSessionCreation();
    }

    public void setEnableSessionCreation(boolean flag) {
        this.sslParameters.setEnableSessionCreation(flag);
    }

    public static String[] nativegetsupportedciphersuites() {
        return (String[])OverrideMethod.invokeA("org.apache.harmony.xnet.provider.jsse.OpenSSLSocketImpl#nativegetsupportedciphersuites()[Ljava/lang/String;", true, null);
    }

    public String[] getSupportedCipherSuites() {
        return OpenSSLSocketImpl.nativegetsupportedciphersuites();
    }

    public String[] nativegetenabledciphersuites() {
        return (String[])OverrideMethod.invokeA("org.apache.harmony.xnet.provider.jsse.OpenSSLSocketImpl#nativegetenabledciphersuites()[Ljava/lang/String;", true, this);
    }

    public String[] getEnabledCipherSuites() {
        return this.nativegetenabledciphersuites();
    }

    public void nativesetenabledciphersuites(String string2) {
        OverrideMethod.invokeV("org.apache.harmony.xnet.provider.jsse.OpenSSLSocketImpl#nativesetenabledciphersuites(Ljava/lang/String;)V", true, this);
    }

    public boolean findSuite(String suite) {
        String[] supportedCipherSuites = OpenSSLSocketImpl.nativegetsupportedciphersuites();
        for (int i = 0; i < supportedCipherSuites.length; ++i) {
            if (!supportedCipherSuites[i].equals(suite)) continue;
            return true;
        }
        throw new IllegalArgumentException("Protocol " + suite + " is not supported.");
    }

    public void setEnabledCipherSuites(String[] suites) {
        if (suites == null) {
            throw new IllegalArgumentException("Provided parameter is null");
        }
        String controlString = "";
        for (int i = 0; i < suites.length; ++i) {
            this.findSuite(suites[i]);
            controlString = i == 0 ? suites[i] : controlString + ":" + suites[i];
        }
        this.nativesetenabledciphersuites(controlString);
    }

    public String[] getSupportedProtocols() {
        return (String[])supportedProtocols.clone();
    }

    public String[] getEnabledProtocols() {
        ArrayList<String> array2 = new ArrayList<String>();
        if ((this.ssl_op_no & SSL_OP_NO_SSLv3) == 0L) {
            array2.add(supportedProtocols[1]);
        }
        if ((this.ssl_op_no & SSL_OP_NO_TLSv1) == 0L) {
            array2.add(supportedProtocols[2]);
        }
        return array2.toArray(new String[array2.size()]);
    }

    public void nativesetenabledprotocols(long l) {
        OverrideMethod.invokeV("org.apache.harmony.xnet.provider.jsse.OpenSSLSocketImpl#nativesetenabledprotocols(J)V", true, this);
    }

    public synchronized void setEnabledProtocols(String[] protocols) {
        if (protocols == null) {
            throw new IllegalArgumentException("Provided parameter is null");
        }
        this.ssl_op_no = SSL_OP_NO_SSLv3 | SSL_OP_NO_TLSv1;
        for (int i = 0; i < protocols.length; ++i) {
            if (protocols[i].equals("SSLv3")) {
                this.ssl_op_no ^= SSL_OP_NO_SSLv3;
                continue;
            }
            if (protocols[i].equals("TLSv1")) {
                this.ssl_op_no ^= SSL_OP_NO_TLSv1;
                continue;
            }
            throw new IllegalArgumentException("Protocol " + protocols[i] + " is not supported.");
        }
        this.nativesetenabledprotocols(this.ssl_op_no);
    }

    public boolean getUseClientMode() {
        return this.sslParameters.getUseClientMode();
    }

    public synchronized void setUseClientMode(boolean mode) {
        if (this.handshakeStarted) {
            throw new IllegalArgumentException("Could not change the mode after the initial handshake has begun.");
        }
        this.sslParameters.setUseClientMode(mode);
    }

    public boolean getWantClientAuth() {
        return this.sslParameters.getWantClientAuth();
    }

    public boolean getNeedClientAuth() {
        return this.sslParameters.getNeedClientAuth();
    }

    public void setNeedClientAuth(boolean need) {
        this.sslParameters.setNeedClientAuth(need);
    }

    public void setWantClientAuth(boolean want) {
        this.sslParameters.setWantClientAuth(want);
    }

    public void sendUrgentData(int data) throws IOException {
        throw new SocketException("Method sendUrgentData() is not supported.");
    }

    public void setOOBInline(boolean on) throws SocketException {
        throw new SocketException("Methods sendUrgentData, setOOBInline are not supported.");
    }

    public synchronized void setSoTimeout(int timeout) throws SocketException {
        super.setSoTimeout(timeout);
        this.timeout = timeout;
    }

    public void nativeinterrupt() throws IOException {
        OverrideMethod.invokeV("org.apache.harmony.xnet.provider.jsse.OpenSSLSocketImpl#nativeinterrupt()V", true, this);
    }

    public void nativeclose() throws IOException {
        OverrideMethod.invokeV("org.apache.harmony.xnet.provider.jsse.OpenSSLSocketImpl#nativeclose()V", true, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        Object object = this.handshakeLock;
        synchronized (object) {
            if (!this.handshakeStarted) {
                this.handshakeStarted = true;
                OpenSSLSocketImpl openSSLSocketImpl = this;
                synchronized (openSSLSocketImpl) {
                    this.nativefree();
                    if (this.socket != null) {
                        if (this.autoClose && !this.socket.isClosed()) {
                            this.socket.close();
                        }
                    } else if (!super.isClosed()) {
                        super.close();
                    }
                }
                return;
            }
        }
        this.nativeinterrupt();
        object = this;
        synchronized (object) {
            Object object2 = this.writeLock;
            synchronized (object2) {
                Object object3 = this.readLock;
                synchronized (object3) {
                    IOException pendingException = null;
                    try {
                        if (this.handshakeStarted) {
                            this.nativeclose();
                        }
                    }
                    catch (IOException ex) {
                        pendingException = ex;
                    }
                    this.nativefree();
                    if (this.socket != null) {
                        if (this.autoClose && !this.socket.isClosed()) {
                            this.socket.close();
                        }
                    } else if (!super.isClosed()) {
                        super.close();
                    }
                    if (pendingException != null) {
                        throw pendingException;
                    }
                }
            }
        }
    }

    public void nativefree() {
        OverrideMethod.invokeV("org.apache.harmony.xnet.provider.jsse.OpenSSLSocketImpl#nativefree()V", true, this);
    }

    public void finalize() throws IOException {
        OpenSSLSocketImpl.updateInstanceCount(-1);
        if (this.ssl == 0) {
            return;
        }
        Socket underlyingSocket = this.socket;
        Finalizer f = new Finalizer(null);
        f.setDaemon(true);
        f.start();
        try {
            f.join(1000L);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        if (f.isAlive()) {
            f.interrupt();
            Logger.global.log(Level.SEVERE, "Slow finalization of SSL socket (" + this + ", for " + underlyingSocket + ")");
            if (underlyingSocket != null && !underlyingSocket.isClosed()) {
                underlyingSocket.close();
            }
        }
    }

    public static boolean verifySignature(byte[] message, byte[] signature, String algorithm, RSAPublicKey key) {
        byte[] exponent;
        byte[] modulus = key.getModulus().toByteArray();
        return OpenSSLSocketImpl.nativeverifysignature(message, signature, algorithm, modulus, exponent = key.getPublicExponent().toByteArray()) == 1;
    }

    public static int nativeverifysignature(byte[] byArray, byte[] byArray2, String string2, byte[] byArray3, byte[] byArray4) {
        return OverrideMethod.invokeI("org.apache.harmony.xnet.provider.jsse.OpenSSLSocketImpl#nativeverifysignature([B[BLjava/lang/String;[B[B)I", true, null);
    }

    static {
        OpenSSLSocketImpl.nativeinitstatic();
        SSL_OP_NO_SSLv3 = 0x2000000L;
        SSL_OP_NO_TLSv1 = 0x4000000L;
    }

    public static class 1 {
    }

    public class Finalizer
    extends Thread {
        public Finalizer() {
        }

        public void run() {
            Socket underlyingSocket = OpenSSLSocketImpl.this.socket;
            try {
                OpenSSLSocketImpl.this.close();
            }
            catch (IOException ex) {
                Thread.interrupted();
                Logger.global.log(Level.SEVERE, "Trouble finalizing SSL socket (" + OpenSSLSocketImpl.this + ", for " + underlyingSocket + ")", ex);
            }
        }

        public /* synthetic */ Finalizer(1 x1) {
            this();
        }
    }

    public class SSLOutputStream
    extends OutputStream {
        public SSLOutputStream() throws IOException {
            OpenSSLSocketImpl.this.startHandshake();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(int b) throws IOException {
            Object object = OpenSSLSocketImpl.this.writeLock;
            synchronized (object) {
                OpenSSLSocketImpl.this.nativewrite(b);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(byte[] b, int start, int len) throws IOException {
            Object object = OpenSSLSocketImpl.this.writeLock;
            synchronized (object) {
                OpenSSLSocketImpl.this.nativewrite(b, start, len);
            }
        }
    }

    public class SSLInputStream
    extends InputStream {
        public SSLInputStream() throws IOException {
            OpenSSLSocketImpl.this.startHandshake();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int read() throws IOException {
            Object object = OpenSSLSocketImpl.this.readLock;
            synchronized (object) {
                return OpenSSLSocketImpl.this.nativeread(OpenSSLSocketImpl.this.timeout);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int read(byte[] b, int off, int len) throws IOException {
            Object object = OpenSSLSocketImpl.this.readLock;
            synchronized (object) {
                return OpenSSLSocketImpl.this.nativeread(b, off, len, OpenSSLSocketImpl.this.timeout);
            }
        }
    }

    public static class LoggerHolder {
        public static final Logger logger = Logger.getLogger(OpenSSLSocketImpl.class.getName());
    }
}

