/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.xnet.provider.jsse;

import java.security.KeyManagementException;
import java.security.SecureRandom;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContextSpi;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.apache.harmony.xnet.provider.jsse.ClientSessionContext;
import org.apache.harmony.xnet.provider.jsse.OpenSSLServerSocketFactoryImpl;
import org.apache.harmony.xnet.provider.jsse.OpenSSLSocketFactoryImpl;
import org.apache.harmony.xnet.provider.jsse.SSLClientSessionCache;
import org.apache.harmony.xnet.provider.jsse.SSLEngineImpl;
import org.apache.harmony.xnet.provider.jsse.SSLParameters;
import org.apache.harmony.xnet.provider.jsse.SSLServerSessionCache;
import org.apache.harmony.xnet.provider.jsse.ServerSessionContext;

public class SSLContextImpl
extends SSLContextSpi {
    public ClientSessionContext clientSessionContext;
    public ServerSessionContext serverSessionContext;
    public SSLParameters sslParameters;

    public void engineInit(KeyManager[] kms, TrustManager[] tms, SecureRandom sr) throws KeyManagementException {
        this.engineInit(kms, tms, sr, null, null);
    }

    public void engineInit(KeyManager[] kms, TrustManager[] tms, SecureRandom sr, SSLClientSessionCache clientCache, SSLServerSessionCache serverCache) throws KeyManagementException {
        this.sslParameters = new SSLParameters(kms, tms, sr, clientCache, serverCache);
        this.clientSessionContext = this.sslParameters.getClientSessionContext();
        this.serverSessionContext = this.sslParameters.getServerSessionContext();
    }

    public SSLSocketFactory engineGetSocketFactory() {
        if (this.sslParameters == null) {
            throw new IllegalStateException("SSLContext is not initiallized.");
        }
        return new OpenSSLSocketFactoryImpl(this.sslParameters);
    }

    public SSLServerSocketFactory engineGetServerSocketFactory() {
        if (this.sslParameters == null) {
            throw new IllegalStateException("SSLContext is not initiallized.");
        }
        return new OpenSSLServerSocketFactoryImpl(this.sslParameters);
    }

    public SSLEngine engineCreateSSLEngine(String host, int port) {
        if (this.sslParameters == null) {
            throw new IllegalStateException("SSLContext is not initiallized.");
        }
        return new SSLEngineImpl(host, port, (SSLParameters)this.sslParameters.clone());
    }

    public SSLEngine engineCreateSSLEngine() {
        if (this.sslParameters == null) {
            throw new IllegalStateException("SSLContext is not initiallized.");
        }
        return new SSLEngineImpl((SSLParameters)this.sslParameters.clone());
    }

    public ServerSessionContext engineGetServerSessionContext() {
        return this.serverSessionContext;
    }

    public ClientSessionContext engineGetClientSessionContext() {
        return this.clientSessionContext;
    }
}

