/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.xnet.provider.jsse;

import java.nio.ByteBuffer;
import org.apache.harmony.xnet.provider.jsse.DataStream;

public class SSLEngineDataStream
implements DataStream {
    public ByteBuffer[] srcs;
    public int offset;
    public int limit;
    public int available;
    public int consumed;

    public void setSourceBuffers(ByteBuffer[] srcs, int offset, int length) {
        this.srcs = srcs;
        this.offset = offset;
        this.limit = offset + length;
        this.consumed = 0;
        this.available = 0;
        for (int i = offset; i < this.limit; ++i) {
            if (srcs[i] == null) {
                throw new IllegalStateException("Some of the input parameters are null");
            }
            this.available += srcs[i].remaining();
        }
    }

    public int available() {
        return this.available;
    }

    public boolean hasData() {
        return this.available > 0;
    }

    public byte[] getData(int length) {
        int len = length < this.available ? length : this.available;
        this.available -= len;
        this.consumed += len;
        byte[] res = new byte[len];
        int pos = 0;
        block0: while (this.offset < this.limit) {
            while (this.srcs[this.offset].hasRemaining()) {
                res[pos++] = this.srcs[this.offset].get();
                if (--len != 0) continue;
                break block0;
            }
            ++this.offset;
        }
        return res;
    }

    public int consumed() {
        return this.consumed;
    }
}

