/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ConcurrentModificationException;
import java.util.Enumeration;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROutputStream;

public abstract class ASN1Collection
extends DERObject {
    public int size;
    public DEREncodable obj0;
    public DEREncodable obj1;
    public DEREncodable obj2;
    public DEREncodable obj3;
    public DEREncodable[] rest;

    public DEREncodable getObjectAt(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException(Integer.toString(index));
        }
        switch (index) {
            case 0: {
                return this.obj0;
            }
            case 1: {
                return this.obj1;
            }
            case 2: {
                return this.obj2;
            }
            case 3: {
                return this.obj3;
            }
        }
        return this.rest[index - 4];
    }

    public int size() {
        return this.size;
    }

    public int hashCode() {
        Enumeration e = this.getObjects();
        int hashCode = 0;
        while (e.hasMoreElements()) {
            Object o = e.nextElement();
            if (o == null) continue;
            hashCode ^= o.hashCode();
        }
        return hashCode;
    }

    public void addObject(DEREncodable obj) {
        if (obj == null) {
            throw new NullPointerException("obj == null");
        }
        int sz = this.size;
        switch (sz) {
            case 0: {
                this.obj0 = obj;
                break;
            }
            case 1: {
                this.obj1 = obj;
                break;
            }
            case 2: {
                this.obj2 = obj;
                break;
            }
            case 3: {
                this.obj3 = obj;
                break;
            }
            case 4: {
                this.rest = new DEREncodable[5];
                this.rest[0] = obj;
                break;
            }
            default: {
                int index = sz - 4;
                if (index >= this.rest.length) {
                    DEREncodable[] newRest = new DEREncodable[index * 2 + 10];
                    System.arraycopy(this.rest, 0, newRest, 0, this.rest.length);
                    this.rest = newRest;
                }
                this.rest[index] = obj;
                break;
            }
        }
        ++this.size;
    }

    public void setObjectAt(DEREncodable obj, int index) {
        switch (index) {
            case 0: {
                this.obj0 = obj;
                break;
            }
            case 1: {
                this.obj1 = obj;
                break;
            }
            case 2: {
                this.obj2 = obj;
                break;
            }
            case 3: {
                this.obj3 = obj;
                break;
            }
            default: {
                this.rest[index - 4] = obj;
            }
        }
    }

    public abstract void encode(DEROutputStream var1) throws IOException;

    public Enumeration getObjects() {
        return new ASN1CollectionEnumeration(null);
    }

    public void sort() {
        if (this.size <= 1) {
            return;
        }
        boolean swapped = true;
        while (swapped) {
            byte[] a = ASN1Collection.getEncoded(this.getObjectAt(0));
            swapped = false;
            for (int index = 0; index != this.size - 1; ++index) {
                int nextIndex = index + 1;
                byte[] b = ASN1Collection.getEncoded(this.getObjectAt(nextIndex));
                if (ASN1Collection.lessThanOrEqual(a, b)) {
                    a = b;
                    continue;
                }
                DEREncodable o = this.getObjectAt(index);
                this.setObjectAt(this.getObjectAt(nextIndex), index);
                this.setObjectAt(o, nextIndex);
                swapped = true;
            }
        }
    }

    public static boolean lessThanOrEqual(byte[] a, byte[] b) {
        if (a.length <= b.length) {
            for (int i = 0; i != a.length; ++i) {
                int r = b[i] & 0xFF;
                int l = a[i] & 0xFF;
                if (r > l) {
                    return true;
                }
                if (l <= r) continue;
                return false;
            }
            return true;
        }
        for (int i = 0; i != b.length; ++i) {
            int r = b[i] & 0xFF;
            int l = a[i] & 0xFF;
            if (r > l) {
                return true;
            }
            if (l <= r) continue;
            return false;
        }
        return false;
    }

    public static byte[] getEncoded(DEREncodable obj) {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        ASN1OutputStream aOut = new ASN1OutputStream(bOut);
        try {
            aOut.writeObject(obj);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("cannot encode object added to collection");
        }
        return bOut.toByteArray();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        for (int i = 0; i < this.size; ++i) {
            if (i != 0) {
                sb.append(", ");
            }
            sb.append(this.getObjectAt(i));
        }
        sb.append(']');
        return sb.toString();
    }

    public static class 1 {
    }

    public class ASN1CollectionEnumeration
    implements Enumeration {
        public final int origSize;
        public int at;

        public ASN1CollectionEnumeration() {
            this.origSize = ASN1Collection.this.size;
            this.at = 0;
        }

        public boolean hasMoreElements() {
            if (ASN1Collection.this.size != this.origSize) {
                throw new ConcurrentModificationException();
            }
            return this.at < this.origSize;
        }

        public Object nextElement() {
            if (ASN1Collection.this.size != this.origSize) {
                throw new ConcurrentModificationException();
            }
            switch (this.at++) {
                case 0: {
                    return ASN1Collection.this.obj0;
                }
                case 1: {
                    return ASN1Collection.this.obj1;
                }
                case 2: {
                    return ASN1Collection.this.obj2;
                }
                case 3: {
                    return ASN1Collection.this.obj3;
                }
            }
            return ASN1Collection.this.rest[this.at - 5];
        }

        public /* synthetic */ ASN1CollectionEnumeration(1 x1) {
            this();
        }
    }
}

