/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.util.Enumeration;
import org.bouncycastle.asn1.ASN1Collection;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.BERSequence;
import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERSequence;

public abstract class ASN1Sequence
extends ASN1Collection {
    public static ASN1Sequence getInstance(Object obj) {
        if (obj == null || obj instanceof ASN1Sequence) {
            return (ASN1Sequence)obj;
        }
        throw new IllegalArgumentException("unknown object in getInstance");
    }

    public static ASN1Sequence getInstance(ASN1TaggedObject obj, boolean explicit) {
        if (explicit) {
            if (!obj.isExplicit()) {
                throw new IllegalArgumentException("object implicit - explicit expected.");
            }
            return (ASN1Sequence)obj.getObject();
        }
        if (obj.isExplicit()) {
            if (obj instanceof BERTaggedObject) {
                return new BERSequence(obj.getObject());
            }
            return new DERSequence(obj.getObject());
        }
        if (obj.getObject() instanceof ASN1Sequence) {
            return (ASN1Sequence)obj.getObject();
        }
        throw new IllegalArgumentException("unknown object in getInstanceFromTagged");
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DEREncodable)) {
            return false;
        }
        DERObject dObj = ((DEREncodable)o).getDERObject();
        if (!(dObj instanceof ASN1Sequence)) {
            return false;
        }
        ASN1Sequence other = (ASN1Sequence)dObj;
        if (this.size() != other.size()) {
            return false;
        }
        Enumeration s1 = this.getObjects();
        Enumeration s2 = other.getObjects();
        while (s1.hasMoreElements()) {
            Object o1 = s1.nextElement();
            Object o2 = s2.nextElement();
            if (o1 != null && o2 != null) {
                if (o1.equals(o2)) continue;
                return false;
            }
            if (o1 == null && o2 == null) continue;
            return false;
        }
        return true;
    }
}

