/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.IOException;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.DERString;

public class DERIA5String
extends DERObject
implements DERString {
    public String string;

    public static DERIA5String getInstance(Object obj) {
        if (obj == null || obj instanceof DERIA5String) {
            return (DERIA5String)obj;
        }
        if (obj instanceof ASN1OctetString) {
            return new DERIA5String(((ASN1OctetString)obj).getOctets());
        }
        if (obj instanceof ASN1TaggedObject) {
            return DERIA5String.getInstance(((ASN1TaggedObject)obj).getObject());
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + obj.getClass().getName());
    }

    public static DERIA5String getInstance(ASN1TaggedObject obj, boolean explicit) {
        return DERIA5String.getInstance(obj.getObject());
    }

    public DERIA5String(byte[] string2) {
        char[] cs2 = new char[string2.length];
        for (int i = 0; i != cs2.length; ++i) {
            cs2[i] = (char)(string2[i] & 0xFF);
        }
        this.string = new String(cs2);
    }

    public DERIA5String(String string2) {
        this.string = string2;
    }

    public String getString() {
        return this.string;
    }

    public byte[] getOctets() {
        char[] cs2 = this.string.toCharArray();
        byte[] bs = new byte[cs2.length];
        for (int i = 0; i != cs2.length; ++i) {
            bs[i] = (byte)cs2[i];
        }
        return bs;
    }

    public void encode(DEROutputStream out) throws IOException {
        out.writeEncoded(22, this.getOctets());
    }

    public int hashCode() {
        return this.getString().hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof DERIA5String)) {
            return false;
        }
        DERIA5String s = (DERIA5String)o;
        return this.getString().equals(s.getString());
    }
}

