/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.util.ConcurrentModificationException;
import java.util.Enumeration;
import org.bouncycastle.asn1.DERObjectIdentifier;

public class OrderedTable {
    public DERObjectIdentifier key0;
    public DERObjectIdentifier key1;
    public DERObjectIdentifier key2;
    public DERObjectIdentifier key3;
    public Object value0;
    public Object value1;
    public Object value2;
    public Object value3;
    public Object[] rest;
    public int size;

    public void add(DERObjectIdentifier key, Object value) {
        if (key == null) {
            throw new NullPointerException("key == null");
        }
        if (value == null) {
            throw new NullPointerException("value == null");
        }
        int sz = this.size;
        switch (sz) {
            case 0: {
                this.key0 = key;
                this.value0 = value;
                break;
            }
            case 1: {
                this.key1 = key;
                this.value1 = value;
                break;
            }
            case 2: {
                this.key2 = key;
                this.value2 = value;
                break;
            }
            case 3: {
                this.key3 = key;
                this.value3 = value;
                break;
            }
            case 4: {
                this.rest = new Object[10];
                this.rest[0] = key;
                this.rest[1] = value;
                break;
            }
            default: {
                int index = (sz - 4) * 2;
                int index1 = index + 1;
                if (index1 >= this.rest.length) {
                    Object[] newRest = new Object[index1 * 2 + 10];
                    System.arraycopy(this.rest, 0, newRest, 0, this.rest.length);
                    this.rest = newRest;
                }
                this.rest[index] = key;
                this.rest[index1] = value;
                break;
            }
        }
        this.size = sz + 1;
    }

    public int size() {
        return this.size;
    }

    public Object get(DERObjectIdentifier key) {
        int keyHash = key.hashCode();
        int sz = this.size;
        for (int i = 0; i < this.size; ++i) {
            DERObjectIdentifier probe = this.getKey(i);
            if (probe.hashCode() != keyHash || !probe.equals(key)) continue;
            return this.getValue(i);
        }
        return null;
    }

    public DERObjectIdentifier getKey(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(Integer.toString(n));
        }
        switch (n) {
            case 0: {
                return this.key0;
            }
            case 1: {
                return this.key1;
            }
            case 2: {
                return this.key2;
            }
            case 3: {
                return this.key3;
            }
        }
        return (DERObjectIdentifier)this.rest[(n - 4) * 2];
    }

    public Object getValue(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(Integer.toString(n));
        }
        switch (n) {
            case 0: {
                return this.value0;
            }
            case 1: {
                return this.value1;
            }
            case 2: {
                return this.value2;
            }
            case 3: {
                return this.value3;
            }
        }
        return this.rest[(n - 4) * 2 + 1];
    }

    public Enumeration getKeys() {
        return new KeyEnumeration(null);
    }

    public static class 1 {
    }

    public class KeyEnumeration
    implements Enumeration {
        public final int origSize;
        public int at;

        public KeyEnumeration() {
            this.origSize = OrderedTable.this.size;
            this.at = 0;
        }

        public boolean hasMoreElements() {
            if (OrderedTable.this.size != this.origSize) {
                throw new ConcurrentModificationException();
            }
            return this.at < this.origSize;
        }

        public Object nextElement() {
            if (OrderedTable.this.size != this.origSize) {
                throw new ConcurrentModificationException();
            }
            return OrderedTable.this.getKey(this.at++);
        }

        public /* synthetic */ KeyEnumeration(1 x1) {
            this();
        }
    }
}

