/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.x509;

import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.DERBoolean;

public class X509Extension {
    public boolean critical;
    public ASN1OctetString value;

    public X509Extension(DERBoolean critical, ASN1OctetString value) {
        this.critical = critical.isTrue();
        this.value = value;
    }

    public X509Extension(boolean critical, ASN1OctetString value) {
        this.critical = critical;
        this.value = value;
    }

    public boolean isCritical() {
        return this.critical;
    }

    public ASN1OctetString getValue() {
        return this.value;
    }

    public int hashCode() {
        if (this.isCritical()) {
            return this.getValue().hashCode();
        }
        return ~this.getValue().hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof X509Extension)) {
            return false;
        }
        X509Extension other = (X509Extension)o;
        return other.getValue().equals(this.getValue()) && other.isCritical() == this.isCritical();
    }
}

