/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdkmanager.internal.repository;

import com.android.sdkuilib.internal.repository.ISettingsPage;
import java.util.Properties;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class SettingsPage
extends Composite
implements ISettingsPage {
    private ISettingsPage.SettingsChangedCallback mSettingsChangedCallback;
    private Group mProxySettingsGroup;
    private Group mMiscGroup;
    private Button mApplyButton;
    private Label mProxyServerLabel;
    private Label mProxyPortLabel;
    private Text mProxyServerText;
    private Text mProxyPortText;
    private Button mForceHttpCheck;
    private Button mAskAdbRestartCheck;
    private ModifyListener mSetApplyDirty = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            SettingsPage.this.mApplyButton.setEnabled(true);
        }
    };

    public SettingsPage(Composite parent) {
        super(parent, 2048);
        this.createContents(this);
        this.mProxySettingsGroup = new Group((Composite)this, 0);
        this.mProxySettingsGroup.setText("Proxy Settings");
        this.mProxySettingsGroup.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.mProxySettingsGroup.setLayout((Layout)new GridLayout(2, false));
        this.mProxyServerLabel = new Label((Composite)this.mProxySettingsGroup, 0);
        this.mProxyServerLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.mProxyServerLabel.setText("HTTP Proxy Server");
        String tooltip = "The DNS name or IP of the HTTP proxy server to use. When empty, no HTTP proxy is used.";
        this.mProxyServerLabel.setToolTipText(tooltip);
        this.mProxyServerText = new Text((Composite)this.mProxySettingsGroup, 2048);
        this.mProxyServerText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.mProxyServerText.addModifyListener(this.mSetApplyDirty);
        this.mProxyServerText.setToolTipText(tooltip);
        this.mProxyPortLabel = new Label((Composite)this.mProxySettingsGroup, 0);
        this.mProxyPortLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.mProxyPortLabel.setText("HTTP Proxy Port");
        tooltip = "The port of the HTTP proxy server to use. When empty, the default for HTTP or HTTPS is used.";
        this.mProxyPortLabel.setToolTipText(tooltip);
        this.mProxyPortText = new Text((Composite)this.mProxySettingsGroup, 2048);
        this.mProxyPortText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.mProxyPortText.addModifyListener(this.mSetApplyDirty);
        this.mProxyPortText.setToolTipText(tooltip);
        this.mMiscGroup = new Group((Composite)this, 0);
        this.mMiscGroup.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.mMiscGroup.setText("Misc");
        this.mMiscGroup.setLayout((Layout)new GridLayout(2, false));
        this.mForceHttpCheck = new Button((Composite)this.mMiscGroup, 32);
        this.mForceHttpCheck.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.mForceHttpCheck.setText("Force https://... sources to be fetched using http://...");
        this.mForceHttpCheck.setToolTipText("If you are not able to connect to the official Android repository using HTTPS, enable this setting to force accessing it via HTTP.");
        this.mForceHttpCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SettingsPage.this.onForceHttpSelected();
            }
        });
        this.mAskAdbRestartCheck = new Button((Composite)this.mMiscGroup, 32);
        this.mAskAdbRestartCheck.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.mAskAdbRestartCheck.setText("Ask before restarting ADB");
        this.mAskAdbRestartCheck.setToolTipText("When checked, the user will be asked for permission to restart ADB after updating an addon-on package or a tool package.");
        this.mAskAdbRestartCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SettingsPage.this.onForceHttpSelected();
            }
        });
        this.mApplyButton = new Button((Composite)this, 0);
        this.mApplyButton.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.mApplyButton.setText("Save && Apply");
        this.mApplyButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SettingsPage.this.onApplySelected();
            }
        });
        this.postCreate();
    }

    private void createContents(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, false));
    }

    protected void checkSubclass() {
    }

    private void postCreate() {
    }

    public void loadSettings(Properties in_settings) {
        this.mProxyServerText.setText(in_settings.getProperty("http.proxyHost", ""));
        this.mProxyPortText.setText(in_settings.getProperty("http.proxyPort", ""));
        this.mForceHttpCheck.setSelection(Boolean.parseBoolean(in_settings.getProperty("sdkman.force.http")));
        this.mAskAdbRestartCheck.setSelection(Boolean.parseBoolean(in_settings.getProperty("sdkman.ask.adb.restart")));
        this.mApplyButton.setEnabled(false);
    }

    public void retrieveSettings(Properties out_settings) {
        out_settings.setProperty("http.proxyHost", this.mProxyServerText.getText());
        out_settings.setProperty("http.proxyPort", this.mProxyPortText.getText());
        out_settings.setProperty("sdkman.force.http", Boolean.toString(this.mForceHttpCheck.getSelection()));
        out_settings.setProperty("sdkman.ask.adb.restart", Boolean.toString(this.mAskAdbRestartCheck.getSelection()));
    }

    public void setOnSettingsChanged(ISettingsPage.SettingsChangedCallback settingsChangedCallback) {
        this.mSettingsChangedCallback = settingsChangedCallback;
    }

    private void onApplySelected() {
        if (this.mSettingsChangedCallback != null) {
            this.mSettingsChangedCallback.onSettingsChanged((ISettingsPage)this);
            this.mApplyButton.setEnabled(false);
        }
    }

    private void onForceHttpSelected() {
        this.mSetApplyDirty.modifyText(null);
    }
}

