/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib;

import java.util.Properties;

public class AndroidVersion {
    private static final String PROP_API_LEVEL = "AndroidVersion.ApiLevel";
    private static final String PROP_CODENAME = "AndroidVersion.CodeName";
    private final int mApiLevel;
    private final String mCodename;

    public AndroidVersion(int apiLevel, String codename) {
        this.mApiLevel = apiLevel;
        this.mCodename = codename;
    }

    public AndroidVersion(Properties properties, int defaultApiLevel, String defaultCodeName) {
        if (properties == null) {
            this.mApiLevel = defaultApiLevel;
            this.mCodename = defaultCodeName;
        } else {
            this.mApiLevel = Integer.parseInt(properties.getProperty(PROP_API_LEVEL, Integer.toString(defaultApiLevel)));
            this.mCodename = properties.getProperty(PROP_CODENAME, defaultCodeName);
        }
    }

    public void saveProperties(Properties props) {
        props.setProperty(PROP_API_LEVEL, Integer.toString(this.mApiLevel));
        if (this.mCodename != null) {
            props.setProperty(PROP_CODENAME, this.mCodename);
        }
    }

    public int getApiLevel() {
        return this.mApiLevel;
    }

    public String getCodename() {
        return this.mCodename;
    }

    public String getApiString() {
        if (this.mCodename != null) {
            return this.mCodename;
        }
        return Integer.toString(this.mApiLevel);
    }

    public boolean isPreview() {
        return this.mCodename != null;
    }

    public boolean canRun(AndroidVersion appVersion) {
        if (appVersion.mCodename != null) {
            return appVersion.mCodename.equals(this.mCodename);
        }
        return this.mApiLevel >= appVersion.mApiLevel;
    }

    public boolean equals(int apiLevel) {
        return this.mCodename == null && apiLevel == this.mApiLevel;
    }

    public boolean equals(Object obj) {
        if (obj instanceof AndroidVersion) {
            AndroidVersion version = (AndroidVersion)obj;
            if (this.mCodename == null) {
                return version.mCodename == null && this.mApiLevel == version.mApiLevel;
            }
            return this.mCodename.equals(version.mCodename) && this.mApiLevel == version.mApiLevel;
        }
        if (obj instanceof String) {
            if (this.mCodename != null) {
                return this.mCodename.equals(obj);
            }
            try {
                int value = Integer.parseInt((String)obj);
                return value == this.mApiLevel;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return false;
    }

    public int hashCode() {
        if (this.mCodename != null) {
            return this.mCodename.hashCode();
        }
        return this.mApiLevel;
    }
}

