/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.internal.repository;

import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.SdkManager;
import com.android.sdklib.internal.repository.Archive;
import com.android.sdklib.internal.repository.IPackageVersion;
import com.android.sdklib.internal.repository.Package;
import com.android.sdklib.internal.repository.RepoSource;
import com.android.sdklib.internal.repository.XmlParserUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddonPackage
extends Package
implements IPackageVersion {
    private static final String PROP_NAME = "Addon.Name";
    private static final String PROP_VENDOR = "Addon.Vendor";
    private final String mVendor;
    private final String mName;
    private final AndroidVersion mVersion;
    private final Lib[] mLibs;

    AddonPackage(RepoSource source, Node packageNode, Map<String, String> licenses) {
        super(source, packageNode, licenses);
        this.mVendor = XmlParserUtils.getXmlString(packageNode, "vendor");
        this.mName = XmlParserUtils.getXmlString(packageNode, "name");
        int apiLevel = XmlParserUtils.getXmlInt(packageNode, "api-level", 0);
        String codeName = XmlParserUtils.getXmlString(packageNode, "codename");
        if (codeName.length() == 0) {
            codeName = null;
        }
        this.mVersion = new AndroidVersion(apiLevel, codeName);
        this.mLibs = this.parseLibs(XmlParserUtils.getFirstChild(packageNode, "libs"));
    }

    AddonPackage(IAndroidTarget target, Properties props) {
        super(null, props, target.getRevision(), null, target.getDescription(), null, Archive.Os.getCurrentOs(), Archive.Arch.getCurrentArch(), target.getLocation());
        this.mVersion = target.getVersion();
        this.mName = target.getName();
        this.mVendor = target.getVendor();
        IAndroidTarget.IOptionalLibrary[] optLibs = target.getOptionalLibraries();
        if (optLibs == null || optLibs.length == 0) {
            this.mLibs = new Lib[0];
        } else {
            this.mLibs = new Lib[optLibs.length];
            for (int i = 0; i < optLibs.length; ++i) {
                this.mLibs[i] = new Lib(optLibs[i].getName(), optLibs[i].getDescription());
            }
        }
    }

    @Override
    void saveProperties(Properties props) {
        super.saveProperties(props);
        this.mVersion.saveProperties(props);
        if (this.mName != null) {
            props.setProperty(PROP_NAME, this.mName);
        }
        if (this.mVendor != null) {
            props.setProperty(PROP_VENDOR, this.mVendor);
        }
    }

    private Lib[] parseLibs(Node libsNode) {
        ArrayList<Lib> libs = new ArrayList<Lib>();
        if (libsNode != null) {
            String nsUri = libsNode.getNamespaceURI();
            for (Node child = libsNode.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (child.getNodeType() != 1 || !nsUri.equals(child.getNamespaceURI()) || !"lib".equals(child.getLocalName())) continue;
                libs.add(this.parseLib(child));
            }
        }
        return libs.toArray(new Lib[libs.size()]);
    }

    private Lib parseLib(Node libNode) {
        return new Lib(XmlParserUtils.getXmlString(libNode, "name"), XmlParserUtils.getXmlString(libNode, "description"));
    }

    public String getVendor() {
        return this.mVendor;
    }

    public String getName() {
        return this.mName;
    }

    @Override
    public AndroidVersion getVersion() {
        return this.mVersion;
    }

    public Lib[] getLibs() {
        return this.mLibs;
    }

    @Override
    public String getShortDescription() {
        return String.format("%1$s by %2$s, Android API %3$s, revision %4$s", this.getName(), this.getVendor(), this.mVersion.getApiString(), this.getRevision());
    }

    @Override
    public String getLongDescription() {
        String s = this.getDescription();
        if (s == null || s.length() == 0) {
            s = this.getShortDescription();
        }
        if (s.indexOf("revision") == -1) {
            s = s + String.format("\nRevision %1$d", this.getRevision());
        }
        s = s + String.format("\nRequires SDK Platform Android API %1$s", this.mVersion.getApiString());
        return s;
    }

    @Override
    public File getInstallFolder(String osSdkRoot, String suggestedDir, SdkManager sdkManager) {
        File addons = new File(osSdkRoot, "add-ons");
        for (IAndroidTarget target : sdkManager.getTargets()) {
            if (target.isPlatform() || !target.getVersion().equals(this.mVersion) || !target.getName().equals(this.getName()) || !target.getVendor().equals(this.getVendor())) continue;
            return new File(target.getLocation());
        }
        String name = suggestedDir;
        if (suggestedDir == null || suggestedDir.length() == 0) {
            name = String.format("addon-%s-%s-%s", this.getName(), this.getVendor(), this.mVersion.getApiString());
            name = name.toLowerCase();
            name = name.replaceAll("[^a-z0-9_-]+", "_");
            name = name.replaceAll("_+", "_");
        }
        for (int i = 0; i < 100; ++i) {
            String name2 = i == 0 ? name : String.format("%s-%d", name, i);
            File folder = new File(addons, name2);
            if (folder.exists()) continue;
            return folder;
        }
        return null;
    }

    @Override
    public boolean sameItemAs(Package pkg) {
        if (pkg instanceof AddonPackage) {
            AddonPackage newPkg = (AddonPackage)pkg;
            return this.getName().equals(newPkg.getName()) && this.getVendor().equals(newPkg.getVendor()) && this.getVersion().equals(newPkg.getVersion());
        }
        return false;
    }

    public static class Lib {
        private final String mName;
        private final String mDescription;

        public Lib(String name, String description) {
            this.mName = name;
            this.mDescription = description;
        }

        public String getName() {
            return this.mName;
        }

        public String getDescription() {
            return this.mDescription;
        }
    }
}

