/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.internal.repository;

import com.android.sdklib.AndroidVersion;
import com.android.sdklib.SdkManager;
import com.android.sdklib.internal.repository.Archive;
import com.android.sdklib.internal.repository.IPackageVersion;
import com.android.sdklib.internal.repository.Package;
import com.android.sdklib.internal.repository.RepoSource;
import com.android.sdklib.internal.repository.XmlParserUtils;
import java.io.File;
import java.util.Map;
import java.util.Properties;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocPackage
extends Package
implements IPackageVersion {
    private final AndroidVersion mVersion;

    DocPackage(RepoSource source, Node packageNode, Map<String, String> licenses) {
        super(source, packageNode, licenses);
        int apiLevel = XmlParserUtils.getXmlInt(packageNode, "api-level", 0);
        String codeName = XmlParserUtils.getXmlString(packageNode, "codename");
        if (codeName.length() == 0) {
            codeName = null;
        }
        this.mVersion = new AndroidVersion(apiLevel, codeName);
    }

    DocPackage(RepoSource source, Properties props, int apiLevel, String codename, int revision, String license, String description, String descUrl, Archive.Os archiveOs, Archive.Arch archiveArch, String archiveOsPath) {
        super(source, props, revision, license, description, descUrl, archiveOs, archiveArch, archiveOsPath);
        this.mVersion = new AndroidVersion(props, apiLevel, codename);
    }

    @Override
    void saveProperties(Properties props) {
        super.saveProperties(props);
        this.mVersion.saveProperties(props);
    }

    @Override
    public AndroidVersion getVersion() {
        return this.mVersion;
    }

    @Override
    public String getShortDescription() {
        if (this.mVersion.isPreview()) {
            return String.format("Documentation for Android '%1$s' Preview SDK, revision %2$s", this.mVersion.getCodename(), this.getRevision());
        }
        return String.format("Documentation for Android SDK, API %1$d, revision %2$s", this.mVersion.getApiLevel(), this.getRevision());
    }

    @Override
    public String getLongDescription() {
        String s = this.getDescription();
        if (s == null || s.length() == 0) {
            s = this.getShortDescription();
        }
        if (s.indexOf("revision") == -1) {
            s = s + String.format("\nRevision %1$d", this.getRevision());
        }
        return s;
    }

    @Override
    public File getInstallFolder(String osSdkRoot, String suggestedDir, SdkManager sdkManager) {
        return new File(osSdkRoot, "docs");
    }

    @Override
    public boolean sameItemAs(Package pkg) {
        return pkg instanceof DocPackage;
    }

    @Override
    public Package.UpdateInfo canBeUpdatedBy(Package replacementPackage) {
        if (replacementPackage == null) {
            return Package.UpdateInfo.INCOMPATIBLE;
        }
        if (!this.sameItemAs(replacementPackage)) {
            return Package.UpdateInfo.INCOMPATIBLE;
        }
        DocPackage replacementDoc = (DocPackage)replacementPackage;
        AndroidVersion replacementVersion = replacementDoc.getVersion();
        if (replacementVersion.getApiLevel() > this.mVersion.getApiLevel()) {
            return Package.UpdateInfo.UPDATE;
        }
        if (replacementVersion.equals(this.mVersion) ? replacementPackage.getRevision() > this.getRevision() : replacementVersion.getApiLevel() == this.mVersion.getApiLevel() && replacementVersion.isPreview()) {
            return Package.UpdateInfo.UPDATE;
        }
        return Package.UpdateInfo.NOT_UPDATE;
    }
}

