/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.internal.repository;

import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.ISdkLog;
import com.android.sdklib.SdkConstants;
import com.android.sdklib.SdkManager;
import com.android.sdklib.internal.repository.AddonPackage;
import com.android.sdklib.internal.repository.Archive;
import com.android.sdklib.internal.repository.DocPackage;
import com.android.sdklib.internal.repository.ExtraPackage;
import com.android.sdklib.internal.repository.Package;
import com.android.sdklib.internal.repository.PlatformPackage;
import com.android.sdklib.internal.repository.ToolPackage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalSdkParser {
    static final String SOURCE_PROPERTIES = "source.properties";
    private Package[] mPackages;

    public Package[] getPackages() {
        return this.mPackages;
    }

    public void clearPackages() {
        this.mPackages = null;
    }

    public Package[] parseSdk(String osSdkRoot, SdkManager sdkManager, ISdkLog log) {
        ArrayList<Package> packages = new ArrayList<Package>();
        HashSet<File> visited = new HashSet<File>();
        File dir = new File(osSdkRoot, "docs");
        Package pkg = this.scanDoc(dir, log);
        if (pkg != null) {
            packages.add(pkg);
            visited.add(dir);
        }
        if ((pkg = this.scanTools(dir = new File(osSdkRoot, "tools"), log)) != null) {
            packages.add(pkg);
            visited.add(dir);
        }
        for (IAndroidTarget target : sdkManager.getTargets()) {
            Properties props = this.parseProperties(new File(target.getLocation(), SOURCE_PROPERTIES));
            try {
                pkg = target.isPlatform() ? new PlatformPackage(target, props) : new AddonPackage(target, props);
            }
            catch (Exception e) {
                log.error(e, null, new Object[0]);
            }
            if (pkg == null) continue;
            packages.add(pkg);
            visited.add(new File(target.getLocation()));
        }
        this.scanExtra(osSdkRoot, visited, packages, log);
        this.mPackages = packages.toArray(new Package[packages.size()]);
        return this.mPackages;
    }

    private void scanExtra(String osSdkRoot, HashSet<File> visited, ArrayList<Package> packages, ISdkLog log) {
        File root = new File(osSdkRoot);
        for (File dir : root.listFiles()) {
            Properties props;
            if (!dir.isDirectory() || visited.contains(dir) || (props = this.parseProperties(new File(dir, SOURCE_PROPERTIES))) == null) continue;
            try {
                ExtraPackage pkg = new ExtraPackage(null, props, dir.getName(), 0, null, "Tools", null, Archive.Os.getCurrentOs(), Archive.Arch.getCurrentArch(), dir.getPath());
                if (!pkg.isPathValid()) continue;
                packages.add(pkg);
            }
            catch (Exception e) {
                log.error(e, null, new Object[0]);
            }
        }
    }

    private Package scanTools(File toolFolder, ISdkLog log) {
        Properties props = this.parseProperties(new File(toolFolder, SOURCE_PROPERTIES));
        HashSet<String> names = new HashSet<String>();
        for (File file : toolFolder.listFiles()) {
            names.add(file.getName());
        }
        if (!(names.contains(SdkConstants.FN_ADB) && names.contains(SdkConstants.androidCmdName()) && names.contains(SdkConstants.FN_EMULATOR))) {
            return null;
        }
        try {
            ToolPackage pkg = new ToolPackage(null, props, 0, null, "Tools", null, Archive.Os.getCurrentOs(), Archive.Arch.getCurrentArch(), toolFolder.getPath());
            return pkg;
        }
        catch (Exception e) {
            log.error(e, null, new Object[0]);
            return null;
        }
    }

    private Package scanDoc(File docFolder, ISdkLog log) {
        Properties props = this.parseProperties(new File(docFolder, SOURCE_PROPERTIES));
        if (new File(docFolder, "index.html").isFile()) {
            try {
                DocPackage pkg = new DocPackage(null, props, 0, null, 0, null, null, null, Archive.Os.getCurrentOs(), Archive.Arch.getCurrentArch(), docFolder.getPath());
                return pkg;
            }
            catch (Exception e) {
                log.error(e, null, new Object[0]);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties parseProperties(File propsFile) {
        FileInputStream fis = null;
        try {
            if (propsFile.exists()) {
                fis = new FileInputStream(propsFile);
                Properties props = new Properties();
                props.load(fis);
                if (props.size() > 0) {
                    Properties properties = props;
                    return properties;
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }
}

