/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.internal.repository;

import com.android.sdklib.internal.repository.Archive;
import com.android.sdklib.internal.repository.Package;
import com.android.sdklib.internal.repository.RepoSource;
import com.android.sdklib.internal.repository.XmlParserUtils;
import java.util.Map;
import java.util.Properties;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MinToolsPackage
extends Package {
    protected static final String PROP_MIN_TOOLS_REV = "Platform.MinToolsRev";
    private final int mMinToolsRevision;
    public static final int MIN_TOOLS_REV_NOT_SPECIFIED = 0;

    MinToolsPackage(RepoSource source, Node packageNode, Map<String, String> licenses) {
        super(source, packageNode, licenses);
        this.mMinToolsRevision = XmlParserUtils.getXmlInt(packageNode, "min-tools-rev", 0);
    }

    public MinToolsPackage(RepoSource source, Properties props, int revision, String license, String description, String descUrl, Archive.Os archiveOs, Archive.Arch archiveArch, String archiveOsPath) {
        super(source, props, revision, license, description, descUrl, archiveOs, archiveArch, archiveOsPath);
        this.mMinToolsRevision = Integer.parseInt(this.getProperty(props, PROP_MIN_TOOLS_REV, Integer.toString(0)));
    }

    public int getMinToolsRevision() {
        return this.mMinToolsRevision;
    }
}

