/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.emma.report.html.doc;

import com.vladium.emma.report.html.doc.AttributeSet;
import com.vladium.emma.report.html.doc.HTMLWriter;
import com.vladium.emma.report.html.doc.IContent;
import com.vladium.emma.report.html.doc.IElementList;
import com.vladium.emma.report.html.doc.ISimpleElement;
import com.vladium.emma.report.html.doc.Tag;
import com.vladium.emma.report.html.doc.Text;
import java.util.ArrayList;
import java.util.List;

public interface IElement
extends ISimpleElement,
IElementList {
    public IElement setText(String var1, boolean var2);

    public static abstract class Factory {
        public static IElement create(Tag tag) {
            return new ElementImpl(tag, AttributeSet.create());
        }

        public static IElement create(Tag tag, AttributeSet attrs) {
            return new ElementImpl(tag, attrs);
        }

        static class ElementImpl
        extends ISimpleElement.Factory.SimpleElementImpl
        implements IElement {
            protected final List m_contents = new ArrayList();
            private static final boolean DEBUG_HTML = false;

            public String toString() {
                return "<" + this.m_tag.getName() + ">";
            }

            public void emit(HTMLWriter out) {
                String tagName = this.m_tag.getName();
                out.write('<');
                out.write(tagName);
                if (!this.m_attrs.isEmpty()) {
                    out.write(' ');
                    this.m_attrs.emit(out);
                }
                out.write('>');
                for (IContent content : this.m_contents) {
                    content.emit(out);
                }
                out.write("</");
                out.write(tagName);
                out.write('>');
            }

            public IElementList add(IContent content) {
                if (content != null) {
                    this.m_contents.add(content);
                }
                return this;
            }

            public IElementList add(int index, IContent content) {
                if (content != null) {
                    this.m_contents.add(index, content);
                }
                return this;
            }

            public int size() {
                return this.m_contents.size();
            }

            public IElement setText(String text, boolean nbsp) {
                if (text != null) {
                    this.m_contents.clear();
                    this.m_contents.add(new Text(text, nbsp));
                }
                return this;
            }

            ElementImpl(Tag tag, AttributeSet attrs) {
                super(tag, attrs);
            }
        }
    }
}

