/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.util;

import com.vladium.util.ResourceLoader;
import com.vladium.util.XProperties;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;

public abstract class Property {
    private static String s_systemFingerprint;
    private static Properties s_systemProperties;
    private static Properties s_systemRedirects;

    public static boolean toBoolean(String value) {
        if (value == null) {
            return false;
        }
        return value.startsWith("t") || value.startsWith("y");
    }

    public static Properties combine(Properties overrides, Properties base) {
        if (base == null) {
            if (overrides == null) {
                return new XProperties();
            }
            return overrides;
        }
        if (overrides == null) {
            return base;
        }
        XProperties result = new XProperties(base);
        Enumeration<?> overrideNames = overrides.propertyNames();
        while (overrideNames.hasMoreElements()) {
            String n = (String)overrideNames.nextElement();
            String v = overrides.getProperty(n);
            result.setProperty(n, v);
        }
        return result;
    }

    public static Properties getAppProperties(String namespace, ClassLoader loader) {
        if (namespace == null) {
            throw new IllegalArgumentException("null properties: appNameLC");
        }
        Properties appDefaults = Property.getProperties(namespace + "_default.properties", loader);
        String fileName = Property.getSystemProperty(namespace + ".properties");
        File file = fileName != null ? new File(fileName) : null;
        Properties systemFileOverrides = Property.getLazyPropertiesFromFile(file);
        Properties systemOverrides = Property.getSystemProperties(namespace);
        Properties resOverrides = Property.getProperties(namespace + ".properties", loader);
        return Property.combine(resOverrides, Property.combine(systemOverrides, Property.combine(systemFileOverrides, appDefaults)));
    }

    public static Properties getSystemProperties(String systemPrefix) {
        Properties result = s_systemProperties;
        if (result == null) {
            s_systemProperties = result = new SystemPropertyLookup(systemPrefix);
            return result;
        }
        return result;
    }

    public static Properties getSystemPropertyRedirects(Map systemRedirects) {
        Properties result = s_systemRedirects;
        if (result == null) {
            s_systemRedirects = result = new SystemRedirectsLookup(systemRedirects);
            return result;
        }
        return result;
    }

    public static String getSystemFingerprint() {
        if (s_systemFingerprint != null) {
            return s_systemFingerprint;
        }
        StringBuffer s = new StringBuffer();
        int delimiter = 58;
        s.append(Property.getSystemProperty("java.vm.name", ""));
        s.append(':');
        s.append(Property.getSystemProperty("java.vm.version", ""));
        s.append(':');
        s.append(Property.getSystemProperty("java.vm.vendor", ""));
        s.append(':');
        s.append(Property.getSystemProperty("os.name", ""));
        s.append(':');
        s.append(Property.getSystemProperty("os.version", ""));
        s.append(':');
        s.append(Property.getSystemProperty("os.arch", ""));
        s_systemFingerprint = s.toString();
        return s_systemFingerprint;
    }

    public static String getSystemProperty(String key) {
        try {
            return System.getProperty(key);
        }
        catch (SecurityException se) {
            return null;
        }
    }

    public static String getSystemProperty(String key, String def) {
        try {
            return System.getProperty(key, def);
        }
        catch (SecurityException se) {
            return def;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties getProperties(String name) {
        XProperties result = null;
        InputStream in = null;
        try {
            in = ResourceLoader.getResourceAsStream(name);
            if (in != null) {
                result = new XProperties();
                result.load(in);
            }
        }
        catch (Throwable t) {
            result = null;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Throwable ignore) {}
            }
            in = null;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties getProperties(String name, ClassLoader loader) {
        XProperties result = null;
        InputStream in = null;
        try {
            in = ResourceLoader.getResourceAsStream(name, loader);
            if (in != null) {
                result = new XProperties();
                result.load(in);
            }
        }
        catch (Throwable t) {
            result = null;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Throwable ignore) {}
            }
            in = null;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties getPropertiesFromFile(File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("null input: file");
        }
        XProperties result = null;
        InputStream in = null;
        try {
            in = new BufferedInputStream(new FileInputStream(file), 8192);
            result = new XProperties();
            result.load(in);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Throwable throwable) {}
            }
            in = null;
        }
        return result;
    }

    public static Properties getLazyPropertiesFromFile(File file) {
        return new FilePropertyLookup(file);
    }

    private static final class SystemRedirectsLookup
    extends XProperties {
        private final Map m_systemRedirects;

        public String getProperty(String key) {
            return (String)this.get(key);
        }

        public Object get(Object key) {
            String redirect;
            if (!(key instanceof String)) {
                return null;
            }
            String result = (String)super.get(key);
            if (result != null) {
                return result;
            }
            if (this.m_systemRedirects != null && (redirect = (String)this.m_systemRedirects.get(key)) != null && (result = Property.getSystemProperty(redirect, null)) != null) {
                return result;
            }
            return result;
        }

        public synchronized Enumeration keys() {
            Hashtable _propertyNames = new Hashtable();
            if (this.m_systemRedirects != null) {
                for (Object key : this.m_systemRedirects.keySet()) {
                    if (key == null) continue;
                    _propertyNames.put(key, key);
                }
            }
            return _propertyNames.keys();
        }

        SystemRedirectsLookup(Map systemRedirects) {
            this.m_systemRedirects = systemRedirects;
        }
    }

    private static final class SystemPropertyLookup
    extends XProperties {
        private final String m_systemPrefix;

        public String getProperty(String key) {
            return (String)this.get(key);
        }

        public Object get(Object key) {
            if (!(key instanceof String)) {
                return null;
            }
            String result = (String)super.get(key);
            if (result != null) {
                return result;
            }
            if (this.m_systemPrefix != null && (result = Property.getSystemProperty(this.m_systemPrefix.concat((String)key), null)) != null) {
                return result;
            }
            return result;
        }

        public synchronized Enumeration keys() {
            Hashtable<String, String> _propertyNames = new Hashtable<String, String>();
            if (this.m_systemPrefix != null) {
                try {
                    int systemPrefixLength = this.m_systemPrefix.length();
                    Enumeration<?> e = System.getProperties().propertyNames();
                    while (e.hasMoreElements()) {
                        String n = (String)e.nextElement();
                        if (!n.startsWith(this.m_systemPrefix)) continue;
                        String yn = n.substring(systemPrefixLength);
                        _propertyNames.put(yn, yn);
                    }
                }
                catch (SecurityException ignore) {
                    ignore.printStackTrace(System.out);
                }
            }
            return _propertyNames.keys();
        }

        SystemPropertyLookup(String systemPrefix) {
            if (systemPrefix != null && !systemPrefix.endsWith(".")) {
                systemPrefix = systemPrefix.concat(".");
            }
            this.m_systemPrefix = systemPrefix;
        }
    }

    private static final class FilePropertyLookup
    extends XProperties {
        private final File m_src;
        private Properties m_contents;

        public String getProperty(String key) {
            this.faultContents();
            return this.m_contents.getProperty(key);
        }

        public Object get(Object key) {
            this.faultContents();
            return this.m_contents.get(key);
        }

        public Enumeration keys() {
            this.faultContents();
            return this.m_contents.keys();
        }

        FilePropertyLookup(File src) {
            this.m_src = src;
        }

        private synchronized void faultContents() {
            Properties contents = this.m_contents;
            if (contents == null && this.m_src != null) {
                try {
                    contents = Property.getPropertiesFromFile(this.m_src);
                }
                catch (RuntimeException re) {
                    throw re;
                }
                catch (Exception e) {
                    throw new RuntimeException("exception while processing properties file [" + this.m_src.getAbsolutePath() + "]: " + e);
                }
            }
            if (contents == null) {
                contents = new XProperties();
            }
            this.m_contents = contents;
        }
    }
}

