/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.win32.COMBOBOXINFO;
import org.eclipse.swt.internal.win32.LRESULT;
import org.eclipse.swt.internal.win32.MONITORINFO;
import org.eclipse.swt.internal.win32.MSG;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.internal.win32.WINDOWPOS;
import org.eclipse.swt.internal.win32.WNDCLASS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TypedListener;

public class Combo
extends Composite {
    boolean noSelection;
    boolean ignoreDefaultSelection;
    boolean ignoreCharacter;
    boolean ignoreModify;
    boolean ignoreResize;
    boolean lockText;
    int scrollWidth;
    int visibleCount = 5;
    long cbtHook;
    public static final int LIMIT = OS.IsWinNT ? Integer.MAX_VALUE : Short.MAX_VALUE;
    static final int CBID_LIST = 1000;
    static final int CBID_EDIT = 1001;
    static long EditProc;
    static long ListProc;
    static final long ComboProc;
    static final TCHAR ComboClass;

    static {
        ComboClass = new TCHAR(0, "COMBOBOX", true);
        WNDCLASS wNDCLASS = new WNDCLASS();
        OS.GetClassInfo(0L, ComboClass, wNDCLASS);
        ComboProc = wNDCLASS.lpfnWndProc;
    }

    public Combo(Composite composite, int n) {
        super(composite, Combo.checkStyle(n));
        this.style |= 0x100;
    }

    public void add(String string) {
        TCHAR tCHAR;
        int n;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((n = (int)OS.SendMessage(this.handle, 323, 0L, tCHAR = new TCHAR(this.getCodePage(), string, true))) == -1) {
            this.error(14);
        }
        if (n == -2) {
            this.error(14);
        }
        if ((this.style & 0x100) != 0) {
            this.setScrollWidth(tCHAR, true);
        }
    }

    public void add(String string, int n) {
        TCHAR tCHAR;
        int n2;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        int n3 = (int)OS.SendMessage(this.handle, 326, 0L, 0L);
        if (n < 0 || n > n3) {
            this.error(6);
        }
        if ((n2 = (int)OS.SendMessage(this.handle, 330, (long)n, tCHAR = new TCHAR(this.getCodePage(), string, true))) == -2 || n2 == -1) {
            this.error(14);
        }
        if ((this.style & 0x100) != 0) {
            this.setScrollWidth(tCHAR, true);
        }
    }

    public void addModifyListener(ModifyListener modifyListener) {
        this.checkWidget();
        if (modifyListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(modifyListener);
        this.addListener(24, typedListener);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    public void addVerifyListener(VerifyListener verifyListener) {
        this.checkWidget();
        if (verifyListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(verifyListener);
        this.addListener(25, typedListener);
    }

    long callWindowProc(long l, int n, long l2, long l3) {
        if (this.handle == 0L) {
            return 0L;
        }
        if (l == this.handle) {
            switch (n) {
                case 5: {
                    this.ignoreResize = true;
                    long l4 = OS.CallWindowProc(ComboProc, l, n, l2, l3);
                    this.ignoreResize = false;
                    return l4;
                }
            }
            return OS.CallWindowProc(ComboProc, l, n, l2, l3);
        }
        long l5 = OS.GetDlgItem(this.handle, 1001);
        if (l == l5) {
            if (this.lockText && n == 12) {
                return 0L;
            }
            return OS.CallWindowProc(EditProc, l, n, l2, l3);
        }
        long l6 = OS.GetDlgItem(this.handle, 1000);
        if (l == l6) {
            return OS.CallWindowProc(ListProc, l, n, l2, l3);
        }
        return OS.DefWindowProc(l, n, l2, l3);
    }

    long CBTProc(long l, long l2, long l3) {
        if ((int)l == 3) {
            TCHAR tCHAR = new TCHAR(0, 128);
            OS.GetClassName(l2, tCHAR, tCHAR.length());
            String string = tCHAR.toString(0, tCHAR.strlen());
            if (string.equals("Edit") || string.equals("EDIT")) {
                int n = OS.GetWindowLong(l2, -16);
                OS.SetWindowLong(l2, -16, n & 0xFFFFFEFF);
            }
        }
        return OS.CallNextHookEx(this.cbtHook, (int)l, l2, l3);
    }

    boolean checkHandle(long l) {
        return l == this.handle || l == OS.GetDlgItem(this.handle, 1001) || l == OS.GetDlgItem(this.handle, 1000);
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    static int checkStyle(int n) {
        n &= 0xFFFFF7FF;
        n &= 0xFFFFFCFF;
        if (((n = Combo.checkBits(n, 4, 64, 0, 0, 0, 0)) & 0x40) != 0) {
            return n & 0xFFFFFFF7;
        }
        return n;
    }

    public void clearSelection() {
        this.checkWidget();
        OS.SendMessage(this.handle, 322, 0L, -1L);
    }

    public Point computeSize(int n, int n2, boolean bl) {
        int n3;
        long l;
        long l2;
        this.checkWidget();
        int n4 = 0;
        int n5 = 0;
        if (n == -1) {
            l2 = 0L;
            long l3 = OS.GetDC(this.handle);
            l = OS.SendMessage(this.handle, 49, 0L, 0L);
            if (l != 0L) {
                l2 = OS.SelectObject(l3, l);
            }
            int n6 = (int)OS.SendMessage(this.handle, 326, 0L, 0L);
            RECT rECT = new RECT();
            int n7 = 3072;
            if ((this.style & 8) == 0) {
                n7 |= 0x2000;
            }
            int n8 = OS.GetWindowTextLength(this.handle);
            int n9 = this.getCodePage();
            TCHAR tCHAR = new TCHAR(n9, n8 + 1);
            OS.GetWindowText(this.handle, tCHAR, n8 + 1);
            OS.DrawText(l3, tCHAR, n8, rECT, n7);
            n4 = Math.max(n4, rECT.right - rECT.left);
            if ((this.style & 0x100) != 0) {
                n4 = Math.max(n4, this.scrollWidth);
            } else {
                int n10 = 0;
                while (n10 < n6) {
                    n8 = (int)OS.SendMessage(this.handle, 329, (long)n10, 0L);
                    if (n8 != -1) {
                        int n11;
                        if (n8 + 1 > tCHAR.length()) {
                            tCHAR = new TCHAR(n9, n8 + 1);
                        }
                        if ((n11 = (int)OS.SendMessage(this.handle, 328, (long)n10, tCHAR)) != -1) {
                            OS.DrawText(l3, tCHAR, n8, rECT, n7);
                            n4 = Math.max(n4, rECT.right - rECT.left);
                        }
                    }
                    ++n10;
                }
            }
            if (l != 0L) {
                OS.SelectObject(l3, l2);
            }
            OS.ReleaseDC(this.handle, l3);
        }
        if (n2 == -1 && (this.style & 0x40) != 0) {
            int n12 = (int)OS.SendMessage(this.handle, 326, 0L, 0L);
            n3 = (int)OS.SendMessage(this.handle, 340, 0L, 0L);
            n5 = n12 * n3;
        }
        if (n4 == 0) {
            n4 = 64;
        }
        if (n5 == 0) {
            n5 = 64;
        }
        if (n != -1) {
            n4 = n;
        }
        if (n2 != -1) {
            n5 = n2;
        }
        if ((this.style & 8) != 0) {
            n4 += 8;
        } else {
            l = OS.GetDlgItem(this.handle, 1001);
            if (l != 0L) {
                l2 = OS.SendMessage(l, 212, 0L, 0L);
                int n13 = OS.LOWORD(l2) + OS.HIWORD(l2);
                n4 += n13 + 3;
            }
        }
        COMBOBOXINFO cOMBOBOXINFO = new COMBOBOXINFO();
        cOMBOBOXINFO.cbSize = COMBOBOXINFO.sizeof;
        if ((this.style & 0x40) == 0 && !OS.IsWinCE && OS.GetComboBoxInfo(this.handle, cOMBOBOXINFO)) {
            n4 += cOMBOBOXINFO.itemLeft + (cOMBOBOXINFO.buttonRight - cOMBOBOXINFO.buttonLeft);
            n5 = cOMBOBOXINFO.buttonBottom - cOMBOBOXINFO.buttonTop + cOMBOBOXINFO.buttonTop * 2;
        } else {
            n3 = OS.GetSystemMetrics(45);
            n4 += OS.GetSystemMetrics(2) + n3 * 2;
            int n14 = (int)OS.SendMessage(this.handle, 340, -1L, 0L);
            n5 = (this.style & 4) != 0 ? n14 + 6 : (n5 += n14 + 10);
        }
        if ((this.style & 0x40) != 0 && (this.style & 0x100) != 0) {
            n5 += OS.GetSystemMetrics(3);
        }
        return new Point(n4, n5);
    }

    public void copy() {
        this.checkWidget();
        OS.SendMessage(this.handle, 769, 0L, 0L);
    }

    void createHandle() {
        long l;
        if (OS.IsWinCE || (this.style & 0x48) != 0) {
            super.createHandle();
        } else {
            int n = OS.GetCurrentThreadId();
            Callback callback = new Callback(this, "CBTProc", 3);
            l = callback.getAddress();
            if (l == 0L) {
                this.error(3);
            }
            this.cbtHook = OS.SetWindowsHookEx(5, l, 0L, n);
            super.createHandle();
            if (this.cbtHook != 0L) {
                OS.UnhookWindowsHookEx(this.cbtHook);
            }
            this.cbtHook = 0L;
            callback.dispose();
        }
        this.state &= 0xFFFFFEFD;
        long l2 = OS.GetDlgItem(this.handle, 1001);
        if (l2 != 0L && EditProc == 0L) {
            EditProc = OS.GetWindowLongPtr(l2, -4);
        }
        if ((l = OS.GetDlgItem(this.handle, 1000)) != 0L && ListProc == 0L) {
            ListProc = OS.GetWindowLongPtr(l, -4);
        }
        if ((this.style & 0x40) != 0) {
            int n = 52;
            this.SetWindowPos(this.handle, 0L, 0, 0, 16383, 16383, n);
            this.SetWindowPos(this.handle, 0L, 0, 0, 0, 0, n);
        }
    }

    public void cut() {
        this.checkWidget();
        if ((this.style & 8) != 0) {
            return;
        }
        OS.SendMessage(this.handle, 768, 0L, 0L);
    }

    int defaultBackground() {
        return OS.GetSysColor(OS.COLOR_WINDOW);
    }

    void deregister() {
        long l;
        super.deregister();
        long l2 = OS.GetDlgItem(this.handle, 1001);
        if (l2 != 0L) {
            this.display.removeControl(l2);
        }
        if ((l = OS.GetDlgItem(this.handle, 1000)) != 0L) {
            this.display.removeControl(l);
        }
    }

    public void deselect(int n) {
        this.checkWidget();
        int n2 = (int)OS.SendMessage(this.handle, 327, 0L, 0L);
        if (n != n2) {
            return;
        }
        OS.SendMessage(this.handle, 334, -1L, 0L);
        this.sendEvent(24);
    }

    public void deselectAll() {
        this.checkWidget();
        OS.SendMessage(this.handle, 334, -1L, 0L);
        this.sendEvent(24);
    }

    boolean dragDetect(long l, int n, int n2, boolean bl, boolean[] blArray, boolean[] blArray2) {
        long l2;
        if (bl && (this.style & 8) == 0 && (l2 = OS.GetDlgItem(this.handle, 1001)) != 0L) {
            long l3;
            int n3;
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            OS.SendMessage(this.handle, 320, nArray, nArray2);
            if (nArray[0] != nArray2[0] && nArray[0] <= (n3 = OS.LOWORD(OS.SendMessage(l2, 215, 0L, l3 = OS.MAKELPARAM(n, n2)))) && n3 < nArray2[0] && super.dragDetect(l, n, n2, bl, blArray, blArray2)) {
                if (blArray2 != null) {
                    blArray2[0] = true;
                }
                return true;
            }
            return false;
        }
        return super.dragDetect(l, n, n2, bl, blArray, blArray2);
    }

    public String getItem(int n) {
        TCHAR tCHAR;
        int n2;
        this.checkWidget();
        int n3 = (int)OS.SendMessage(this.handle, 329, (long)n, 0L);
        if (n3 != -1 && (n2 = (int)OS.SendMessage(this.handle, 328, (long)n, tCHAR = new TCHAR(this.getCodePage(), n3 + 1))) != -1) {
            return tCHAR.toString(0, n3);
        }
        int n4 = (int)OS.SendMessage(this.handle, 326, 0L, 0L);
        if (n >= 0 && n < n4) {
            this.error(8);
        }
        this.error(6);
        return "";
    }

    public int getItemCount() {
        this.checkWidget();
        int n = (int)OS.SendMessage(this.handle, 326, 0L, 0L);
        if (n == -1) {
            this.error(36);
        }
        return n;
    }

    public int getItemHeight() {
        this.checkWidget();
        int n = (int)OS.SendMessage(this.handle, 340, 0L, 0L);
        if (n == -1) {
            this.error(11);
        }
        return n;
    }

    public String[] getItems() {
        this.checkWidget();
        int n = this.getItemCount();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = this.getItem(n2);
            ++n2;
        }
        return stringArray;
    }

    public boolean getListVisible() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return OS.SendMessage(this.handle, 343, 0L, 0L) != 0L;
        }
        return true;
    }

    String getNameText() {
        return this.getText();
    }

    public void setListVisible(boolean bl) {
        this.checkWidget();
        OS.SendMessage(this.handle, 335, (long)(bl ? 1 : 0), 0L);
    }

    public int getOrientation() {
        this.checkWidget();
        return this.style & 0x6000000;
    }

    public Point getSelection() {
        this.checkWidget();
        if ((this.style & 4) != 0 && (this.style & 8) != 0) {
            return new Point(0, OS.GetWindowTextLength(this.handle));
        }
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.SendMessage(this.handle, 320, nArray, nArray2);
        if (!OS.IsUnicode && OS.IsDBLocale) {
            nArray[0] = this.mbcsToWcsPos(nArray[0]);
            nArray2[0] = this.mbcsToWcsPos(nArray2[0]);
        }
        return new Point(nArray[0], nArray2[0]);
    }

    public int getSelectionIndex() {
        this.checkWidget();
        if (this.noSelection) {
            return -1;
        }
        return (int)OS.SendMessage(this.handle, 327, 0L, 0L);
    }

    public String getText() {
        this.checkWidget();
        int n = OS.GetWindowTextLength(this.handle);
        if (n == 0) {
            return "";
        }
        TCHAR tCHAR = new TCHAR(this.getCodePage(), n + 1);
        OS.GetWindowText(this.handle, tCHAR, n + 1);
        return tCHAR.toString(0, n);
    }

    public int getTextHeight() {
        this.checkWidget();
        COMBOBOXINFO cOMBOBOXINFO = new COMBOBOXINFO();
        cOMBOBOXINFO.cbSize = COMBOBOXINFO.sizeof;
        if ((this.style & 0x40) == 0 && !OS.IsWinCE && OS.GetComboBoxInfo(this.handle, cOMBOBOXINFO)) {
            return cOMBOBOXINFO.buttonBottom - cOMBOBOXINFO.buttonTop + cOMBOBOXINFO.buttonTop * 2;
        }
        int n = (int)OS.SendMessage(this.handle, 340, -1L, 0L);
        if (n == -1) {
            this.error(11);
        }
        return (this.style & 4) != 0 ? n + 6 : n + 10;
    }

    public int getTextLimit() {
        this.checkWidget();
        long l = OS.GetDlgItem(this.handle, 1001);
        if (l == 0L) {
            return LIMIT;
        }
        return (int)OS.SendMessage(l, 213, 0L, 0L) & Integer.MAX_VALUE;
    }

    public int getVisibleItemCount() {
        this.checkWidget();
        return this.visibleCount;
    }

    boolean hasFocus() {
        long l = OS.GetFocus();
        if (l == this.handle) {
            return true;
        }
        if (l == 0L) {
            return false;
        }
        long l2 = OS.GetDlgItem(this.handle, 1001);
        if (l == l2) {
            return true;
        }
        long l3 = OS.GetDlgItem(this.handle, 1000);
        return l == l3;
    }

    public int indexOf(String string) {
        return this.indexOf(string, 0);
    }

    public int indexOf(String string, int n) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (string.length() == 0) {
            int n2 = this.getItemCount();
            int n3 = n;
            while (n3 < n2) {
                if (string.equals(this.getItem(n3))) {
                    return n3;
                }
                ++n3;
            }
            return -1;
        }
        int n4 = (int)OS.SendMessage(this.handle, 326, 0L, 0L);
        if (n < 0 || n >= n4) {
            return -1;
        }
        int n5 = n - 1;
        int n6 = 0;
        TCHAR tCHAR = new TCHAR(this.getCodePage(), string, true);
        do {
            if ((n5 = (int)OS.SendMessage(this.handle, 344, (long)(n6 = n5), tCHAR)) != -1 && n5 > n6) continue;
            return -1;
        } while (!string.equals(this.getItem(n5)));
        return n5;
    }

    int mbcsToWcsPos(int n) {
        if (n <= 0) {
            return 0;
        }
        if (OS.IsUnicode) {
            return n;
        }
        long l = OS.GetDlgItem(this.handle, 1001);
        if (l == 0L) {
            return n;
        }
        int n2 = OS.GetWindowTextLengthA(l);
        if (n2 == 0) {
            return 0;
        }
        if (n >= n2) {
            return n2;
        }
        byte[] byArray = new byte[n2 + 1];
        OS.GetWindowTextA(l, byArray, n2 + 1);
        return OS.MultiByteToWideChar(this.getCodePage(), 1, byArray, n, null, 0);
    }

    public void paste() {
        this.checkWidget();
        if ((this.style & 8) != 0) {
            return;
        }
        OS.SendMessage(this.handle, 770, 0L, 0L);
    }

    void register() {
        long l;
        super.register();
        long l2 = OS.GetDlgItem(this.handle, 1001);
        if (l2 != 0L) {
            this.display.addControl(l2, this);
        }
        if ((l = OS.GetDlgItem(this.handle, 1000)) != 0L) {
            this.display.addControl(l, this);
        }
    }

    public void remove(int n) {
        this.checkWidget();
        this.remove(n, true);
    }

    void remove(int n, boolean bl) {
        int n2;
        int n3;
        int n4;
        TCHAR tCHAR = null;
        if ((this.style & 0x100) != 0) {
            n4 = (int)OS.SendMessage(this.handle, 329, (long)n, 0L);
            if (n4 == -1) {
                n3 = (int)OS.SendMessage(this.handle, 326, 0L, 0L);
                if (n >= 0 && n < n3) {
                    this.error(15);
                }
                this.error(6);
            }
            if ((n3 = (int)OS.SendMessage(this.handle, 328, (long)n, tCHAR = new TCHAR(this.getCodePage(), n4 + 1))) == -1) {
                n2 = (int)OS.SendMessage(this.handle, 326, 0L, 0L);
                if (n >= 0 && n < n2) {
                    this.error(15);
                }
                this.error(6);
            }
        }
        n4 = OS.GetWindowTextLength(this.handle);
        n3 = (int)OS.SendMessage(this.handle, 324, (long)n, 0L);
        if (n3 == -1) {
            n2 = (int)OS.SendMessage(this.handle, 326, 0L, 0L);
            if (n >= 0 && n < n2) {
                this.error(15);
            }
            this.error(6);
        }
        if ((this.style & 0x100) != 0) {
            this.setScrollWidth(tCHAR, true);
        }
        if (bl && n4 != OS.GetWindowTextLength(this.handle)) {
            this.sendEvent(24);
            if (this.isDisposed()) {
                return;
            }
        }
        if ((this.style & 8) != 0 && (n2 = (int)OS.SendMessage(this.handle, 326, 0L, 0L)) == 0) {
            OS.InvalidateRect(this.handle, null, true);
        }
    }

    public void remove(int n, int n2) {
        this.checkWidget();
        if (n > n2) {
            return;
        }
        int n3 = (int)OS.SendMessage(this.handle, 326, 0L, 0L);
        if (n < 0 || n > n2 || n2 >= n3) {
            this.error(6);
        }
        int n4 = OS.GetWindowTextLength(this.handle);
        RECT rECT = null;
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        int n5 = 0;
        if ((this.style & 0x100) != 0) {
            rECT = new RECT();
            l = OS.GetDC(this.handle);
            l3 = OS.SendMessage(this.handle, 49, 0L, 0L);
            if (l3 != 0L) {
                l2 = OS.SelectObject(l, l3);
            }
        }
        int n6 = this.getCodePage();
        int n7 = 3104;
        int n8 = n;
        while (n8 <= n2) {
            int n9;
            int n10;
            TCHAR tCHAR = null;
            if ((this.style & 0x100) != 0 && ((n10 = (int)OS.SendMessage(this.handle, 329, (long)n, 0L)) == -1 || (n9 = (int)OS.SendMessage(this.handle, 328, (long)n, tCHAR = new TCHAR(n6, n10 + 1))) == -1)) break;
            n10 = (int)OS.SendMessage(this.handle, 324, (long)n, 0L);
            if (n10 == -1) {
                this.error(15);
            }
            if ((this.style & 0x100) != 0) {
                OS.DrawText(l, tCHAR, -1, rECT, n7);
                n5 = Math.max(n5, rECT.right - rECT.left);
            }
            ++n8;
        }
        if ((this.style & 0x100) != 0) {
            if (l3 != 0L) {
                OS.SelectObject(l, l2);
            }
            OS.ReleaseDC(this.handle, l);
            this.setScrollWidth(n5, false);
        }
        if (n4 != OS.GetWindowTextLength(this.handle)) {
            this.sendEvent(24);
            if (this.isDisposed()) {
                return;
            }
        }
        if ((this.style & 8) != 0 && (n3 = (int)OS.SendMessage(this.handle, 326, 0L, 0L)) == 0) {
            OS.InvalidateRect(this.handle, null, true);
        }
    }

    public void remove(String string) {
        int n;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((n = this.indexOf(string, 0)) == -1) {
            this.error(5);
        }
        this.remove(n);
    }

    public void removeAll() {
        this.checkWidget();
        OS.SendMessage(this.handle, 331, 0L, 0L);
        this.sendEvent(24);
        if (this.isDisposed()) {
            return;
        }
        if ((this.style & 0x100) != 0) {
            this.setScrollWidth(0);
        }
    }

    public void removeModifyListener(ModifyListener modifyListener) {
        this.checkWidget();
        if (modifyListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(24, modifyListener);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    public void removeVerifyListener(VerifyListener verifyListener) {
        this.checkWidget();
        if (verifyListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(25, verifyListener);
    }

    boolean sendKeyEvent(int n, int n2, long l, long l2, Event event) {
        Object object;
        Object object2;
        if (!super.sendKeyEvent(n, n2, l, l2, event)) {
            return false;
        }
        if ((this.style & 8) != 0) {
            return true;
        }
        if (n != 1) {
            return true;
        }
        if (n2 != 258 && n2 != 256 && n2 != 646) {
            return true;
        }
        if (event.character == '\u0000') {
            return true;
        }
        if (!this.hooks(25) && !this.filters(25)) {
            return true;
        }
        char c = event.character;
        int n3 = event.stateMask;
        switch (n2) {
            case 258: {
                if (c != '\b' && c != '\u007f' && c != '\r' && c != '\t' && c != '\n') break;
            }
            case 256: {
                if ((n3 & 0x70000) == 0) break;
                return false;
            }
        }
        if (OS.GetKeyState(1) < 0) {
            return true;
        }
        String string = "";
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        long l3 = OS.GetDlgItem(this.handle, 1001);
        if (l3 == 0L) {
            return true;
        }
        OS.SendMessage(l3, 176, nArray, nArray2);
        switch (c) {
            case '\b': {
                if (nArray[0] != nArray2[0]) break;
                if (nArray[0] == 0) {
                    return true;
                }
                nArray[0] = nArray[0] - 1;
                if (!OS.IsUnicode && OS.IsDBLocale) {
                    object2 = new int[1];
                    object = new int[1];
                    OS.SendMessage(l3, 177, (long)nArray[0], (long)nArray2[0]);
                    OS.SendMessage(l3, 176, (int[])object2, object);
                    if (nArray[0] != object2[0]) {
                        nArray[0] = nArray[0] - 1;
                    }
                }
                nArray[0] = Math.max(nArray[0], 0);
                break;
            }
            case '\u007f': {
                if (nArray[0] != nArray2[0]) break;
                int n4 = OS.GetWindowTextLength(l3);
                if (nArray[0] == n4) {
                    return true;
                }
                nArray2[0] = nArray2[0] + 1;
                if (!OS.IsUnicode && OS.IsDBLocale) {
                    object = new int[1];
                    int[] nArray3 = new int[1];
                    OS.SendMessage(l3, 177, (long)nArray[0], (long)nArray2[0]);
                    OS.SendMessage(l3, 176, object, nArray3);
                    if (nArray2[0] != nArray3[0]) {
                        nArray2[0] = nArray2[0] + 1;
                    }
                }
                nArray2[0] = Math.min(nArray2[0], n4);
                break;
            }
            case '\r': {
                return true;
            }
            default: {
                if (c != '\t' && c < ' ') {
                    return true;
                }
                string = new String(new char[]{c});
            }
        }
        if ((object2 = this.verifyText(string, nArray[0], nArray2[0], event)) == null) {
            return false;
        }
        if (object2 == string) {
            return true;
        }
        object = new TCHAR(this.getCodePage(), (String)object2, true);
        OS.SendMessage(l3, 177, (long)nArray[0], (long)nArray2[0]);
        OS.SendMessage(l3, 194, 0L, (TCHAR)object);
        return false;
    }

    public void select(int n) {
        this.checkWidget();
        int n2 = (int)OS.SendMessage(this.handle, 326, 0L, 0L);
        if (n >= 0 && n < n2) {
            int n3 = (int)OS.SendMessage(this.handle, 327, 0L, 0L);
            int n4 = (int)OS.SendMessage(this.handle, 334, (long)n, 0L);
            if (n4 != -1 && n4 != n3) {
                this.sendEvent(24);
            }
        }
    }

    void setBackgroundImage(long l) {
        long l2;
        super.setBackgroundImage(l);
        long l3 = OS.GetDlgItem(this.handle, 1001);
        if (l3 != 0L) {
            OS.InvalidateRect(l3, null, true);
        }
        if ((l2 = OS.GetDlgItem(this.handle, 1000)) != 0L) {
            OS.InvalidateRect(l2, null, true);
        }
    }

    void setBackgroundPixel(int n) {
        long l;
        super.setBackgroundPixel(n);
        long l2 = OS.GetDlgItem(this.handle, 1001);
        if (l2 != 0L) {
            OS.InvalidateRect(l2, null, true);
        }
        if ((l = OS.GetDlgItem(this.handle, 1000)) != 0L) {
            OS.InvalidateRect(l, null, true);
        }
    }

    void setBounds(int n, int n2, int n3, int n4, int n5) {
        if ((this.style & 4) != 0) {
            n4 = this.getTextHeight() + this.getItemHeight() * this.visibleCount + 2;
            RECT rECT = new RECT();
            OS.GetWindowRect(this.handle, rECT);
            if (rECT.right - rECT.left != 0 && OS.SendMessage(this.handle, 338, 0L, rECT) != 0L) {
                int n6 = rECT.right - rECT.left;
                int n7 = rECT.bottom - rECT.top;
                if (n6 == n3 && n7 == n4) {
                    n5 |= 1;
                }
            }
            this.SetWindowPos(this.handle, 0L, n, n2, n3, n4, n5);
        } else {
            super.setBounds(n, n2, n3, n4, n5);
        }
    }

    public void setFont(Font font) {
        this.checkWidget();
        super.setFont(font);
        if ((this.style & 0x100) != 0) {
            this.setScrollWidth();
        }
    }

    void setForegroundPixel(int n) {
        long l;
        super.setForegroundPixel(n);
        long l2 = OS.GetDlgItem(this.handle, 1001);
        if (l2 != 0L) {
            OS.InvalidateRect(l2, null, true);
        }
        if ((l = OS.GetDlgItem(this.handle, 1000)) != 0L) {
            OS.InvalidateRect(l, null, true);
        }
    }

    public void setItem(int n, String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        int n2 = this.getSelectionIndex();
        this.remove(n, false);
        if (this.isDisposed()) {
            return;
        }
        this.add(string, n);
        if (n2 != -1) {
            this.select(n2);
        }
    }

    public void setItems(String[] stringArray) {
        this.checkWidget();
        if (stringArray == null) {
            this.error(4);
        }
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n] == null) {
                this.error(5);
            }
            ++n;
        }
        RECT rECT = null;
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        int n2 = 0;
        if ((this.style & 0x100) != 0) {
            rECT = new RECT();
            l = OS.GetDC(this.handle);
            l3 = OS.SendMessage(this.handle, 49, 0L, 0L);
            if (l3 != 0L) {
                l2 = OS.SelectObject(l, l3);
            }
            this.setScrollWidth(0);
        }
        OS.SendMessage(this.handle, 331, 0L, 0L);
        int n3 = this.getCodePage();
        int n4 = 0;
        while (n4 < stringArray.length) {
            String string = stringArray[n4];
            TCHAR tCHAR = new TCHAR(n3, string, true);
            int n5 = (int)OS.SendMessage(this.handle, 323, 0L, tCHAR);
            if (n5 == -1) {
                this.error(14);
            }
            if (n5 == -2) {
                this.error(14);
            }
            if ((this.style & 0x100) != 0) {
                int n6 = 3104;
                OS.DrawText(l, tCHAR, -1, rECT, n6);
                n2 = Math.max(n2, rECT.right - rECT.left);
            }
            ++n4;
        }
        if ((this.style & 0x100) != 0) {
            if (l3 != 0L) {
                OS.SelectObject(l, l2);
            }
            OS.ReleaseDC(this.handle, l);
            this.setScrollWidth(n2 + 3);
        }
        this.sendEvent(24);
    }

    public void setOrientation(int n) {
        int n2;
        this.checkWidget();
        if (OS.IsWinCE) {
            return;
        }
        if (OS.WIN32_VERSION < OS.VERSION(4, 10)) {
            return;
        }
        int n3 = 0x6000000;
        if ((n & n3) == 0 || (n & n3) == n3) {
            return;
        }
        this.style &= ~n3;
        this.style |= n & n3;
        int n4 = OS.GetWindowLong(this.handle, -20);
        if ((this.style & 0x4000000) != 0) {
            this.style |= 0x8000000;
            n4 |= 0x400000;
        } else {
            this.style &= 0xF7FFFFFF;
            n4 &= 0xFFBFFFFF;
        }
        OS.SetWindowLong(this.handle, -20, n4);
        long l = 0L;
        long l2 = 0L;
        COMBOBOXINFO cOMBOBOXINFO = new COMBOBOXINFO();
        cOMBOBOXINFO.cbSize = COMBOBOXINFO.sizeof;
        if (OS.GetComboBoxInfo(this.handle, cOMBOBOXINFO)) {
            l = cOMBOBOXINFO.hwndItem;
            l2 = cOMBOBOXINFO.hwndList;
        }
        if (l != 0L) {
            n2 = OS.GetWindowLong(l, -20);
            int n5 = OS.GetWindowLong(l, -16);
            if ((this.style & 0x4000000) != 0) {
                n2 |= 0x3000;
                n5 |= 2;
            } else {
                n2 &= 0xFFFFCFFF;
                n5 &= 0xFFFFFFFD;
            }
            OS.SetWindowLong(l, -20, n2);
            OS.SetWindowLong(l, -16, n5);
            RECT rECT = new RECT();
            OS.GetWindowRect(l, rECT);
            int n6 = rECT.right - rECT.left;
            int n7 = rECT.bottom - rECT.top;
            OS.GetWindowRect(this.handle, rECT);
            int n8 = rECT.right - rECT.left;
            int n9 = rECT.bottom - rECT.top;
            int n10 = 22;
            this.SetWindowPos(l, 0L, 0, 0, n6 - 1, n7 - 1, n10);
            this.SetWindowPos(this.handle, 0L, 0, 0, n8 - 1, n9 - 1, n10);
            this.SetWindowPos(l, 0L, 0, 0, n6, n7, n10);
            this.SetWindowPos(this.handle, 0L, 0, 0, n8, n9, n10);
            OS.InvalidateRect(this.handle, null, true);
        }
        if (l2 != 0L) {
            n2 = OS.GetWindowLong(l2, -20);
            n2 = (this.style & 0x4000000) != 0 ? (n2 |= 0x400000) : (n2 &= 0xFFBFFFFF);
            OS.SetWindowLong(l2, -20, n2);
        }
    }

    void setScrollWidth() {
        int n = 0;
        RECT rECT = new RECT();
        long l = 0L;
        long l2 = OS.GetDC(this.handle);
        long l3 = OS.SendMessage(this.handle, 49, 0L, 0L);
        if (l3 != 0L) {
            l = OS.SelectObject(l2, l3);
        }
        int n2 = this.getCodePage();
        int n3 = (int)OS.SendMessage(this.handle, 326, 0L, 0L);
        int n4 = 3104;
        int n5 = 0;
        while (n5 < n3) {
            TCHAR tCHAR;
            int n6;
            int n7 = (int)OS.SendMessage(this.handle, 329, (long)n5, 0L);
            if (n7 != -1 && (n6 = (int)OS.SendMessage(this.handle, 328, (long)n5, tCHAR = new TCHAR(n2, n7 + 1))) != -1) {
                OS.DrawText(l2, tCHAR, -1, rECT, n4);
                n = Math.max(n, rECT.right - rECT.left);
            }
            ++n5;
        }
        if (l3 != 0L) {
            OS.SelectObject(l2, l);
        }
        OS.ReleaseDC(this.handle, l2);
        this.setScrollWidth(n + 3);
    }

    void setScrollWidth(int n) {
        this.scrollWidth = n;
        if ((this.style & 0x40) != 0) {
            OS.SendMessage(this.handle, 350, (long)n, 0L);
            return;
        }
        boolean bl = false;
        int n2 = (int)OS.SendMessage(this.handle, 326, 0L, 0L);
        if (n2 > 3) {
            int n3 = 0;
            if (OS.IsWinCE || OS.WIN32_VERSION < OS.VERSION(4, 10)) {
                RECT rECT = new RECT();
                OS.SystemParametersInfo(48, 0, rECT, 0);
                n3 = (rECT.right - rECT.left) / 4;
            } else {
                long l = OS.MonitorFromWindow(this.handle, 2);
                MONITORINFO mONITORINFO = new MONITORINFO();
                mONITORINFO.cbSize = MONITORINFO.sizeof;
                OS.GetMonitorInfo(l, mONITORINFO);
                n3 = (mONITORINFO.rcWork_right - mONITORINFO.rcWork_left) / 4;
            }
            boolean bl2 = bl = n > n3;
        }
        if ((this.style & 8) == 0) {
            this.lockText = true;
        }
        if (bl) {
            OS.SendMessage(this.handle, 352, 0L, 0L);
            OS.SendMessage(this.handle, 350, (long)n, 0L);
        } else {
            OS.SendMessage(this.handle, 352, (long)(n += OS.GetSystemMetrics(3)), 0L);
            OS.SendMessage(this.handle, 350, 0L, 0L);
        }
        if ((this.style & 8) == 0) {
            this.lockText = false;
        }
    }

    void setScrollWidth(TCHAR tCHAR, boolean bl) {
        RECT rECT = new RECT();
        long l = 0L;
        long l2 = OS.GetDC(this.handle);
        long l3 = OS.SendMessage(this.handle, 49, 0L, 0L);
        if (l3 != 0L) {
            l = OS.SelectObject(l2, l3);
        }
        int n = 3104;
        OS.DrawText(l2, tCHAR, -1, rECT, n);
        if (l3 != 0L) {
            OS.SelectObject(l2, l);
        }
        OS.ReleaseDC(this.handle, l2);
        this.setScrollWidth(rECT.right - rECT.left, bl);
    }

    void setScrollWidth(int n, boolean bl) {
        if (bl) {
            if (n <= this.scrollWidth) {
                return;
            }
            this.setScrollWidth(n + 3);
        } else {
            if (n < this.scrollWidth) {
                return;
            }
            this.setScrollWidth();
        }
    }

    public void setSelection(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        int n = point.x;
        int n2 = point.y;
        if (!OS.IsUnicode && OS.IsDBLocale) {
            n = this.wcsToMbcsPos(n);
            n2 = this.wcsToMbcsPos(n2);
        }
        long l = OS.MAKELPARAM(n, n2);
        OS.SendMessage(this.handle, 322, 0L, l);
    }

    public void setText(String string) {
        TCHAR tCHAR;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((this.style & 8) != 0) {
            int n = this.indexOf(string);
            if (n != -1) {
                this.select(n);
            }
            return;
        }
        int n = LIMIT;
        long l = OS.GetDlgItem(this.handle, 1001);
        if (l != 0L) {
            n = (int)OS.SendMessage(l, 213, 0L, 0L) & Integer.MAX_VALUE;
        }
        if (string.length() > n) {
            string = string.substring(0, n);
        }
        if (OS.SetWindowText(this.handle, tCHAR = new TCHAR(this.getCodePage(), string, true))) {
            this.sendEvent(24);
        }
    }

    public void setTextLimit(int n) {
        this.checkWidget();
        if (n == 0) {
            this.error(7);
        }
        OS.SendMessage(this.handle, 321, (long)n, 0L);
    }

    void setToolTipText(Shell shell, String string) {
        long l = OS.GetDlgItem(this.handle, 1001);
        long l2 = OS.GetDlgItem(this.handle, 1000);
        if (l != 0L) {
            shell.setToolTipText(l, string);
        }
        if (l2 != 0L) {
            shell.setToolTipText(l2, string);
        }
        shell.setToolTipText(this.handle, string);
    }

    public void setVisibleItemCount(int n) {
        this.checkWidget();
        if (n < 0) {
            return;
        }
        this.visibleCount = n;
        if ((this.style & 4) != 0) {
            this.forceResize();
            RECT rECT = new RECT();
            OS.GetWindowRect(this.handle, rECT);
            int n2 = 54;
            this.setBounds(0, 0, rECT.right - rECT.left, rECT.bottom - rECT.top, n2);
        }
    }

    void subclass() {
        long l;
        super.subclass();
        long l2 = this.display.windowProc;
        long l3 = OS.GetDlgItem(this.handle, 1001);
        if (l3 != 0L) {
            OS.SetWindowLongPtr(l3, -4, l2);
        }
        if ((l = OS.GetDlgItem(this.handle, 1000)) != 0L) {
            OS.SetWindowLongPtr(l, -4, l2);
        }
    }

    boolean translateTraversal(MSG mSG) {
        switch ((int)mSG.wParam) {
            case 13: 
            case 27: {
                if ((this.style & 4) == 0 || OS.SendMessage(this.handle, 343, 0L, 0L) == 0L) break;
                return false;
            }
        }
        return super.translateTraversal(mSG);
    }

    boolean traverseEscape() {
        if ((this.style & 4) != 0 && OS.SendMessage(this.handle, 343, 0L, 0L) != 0L) {
            OS.SendMessage(this.handle, 335, 0L, 0L);
            return true;
        }
        return super.traverseEscape();
    }

    boolean traverseReturn() {
        if ((this.style & 4) != 0 && OS.SendMessage(this.handle, 343, 0L, 0L) != 0L) {
            OS.SendMessage(this.handle, 335, 0L, 0L);
            return true;
        }
        return super.traverseReturn();
    }

    void unsubclass() {
        long l;
        super.unsubclass();
        long l2 = OS.GetDlgItem(this.handle, 1001);
        if (l2 != 0L && EditProc != 0L) {
            OS.SetWindowLongPtr(l2, -4, EditProc);
        }
        if ((l = OS.GetDlgItem(this.handle, 1000)) != 0L && ListProc != 0L) {
            OS.SetWindowLongPtr(l, -4, ListProc);
        }
    }

    String verifyText(String string, int n, int n2, Event event) {
        Event event2 = new Event();
        event2.text = string;
        event2.start = n;
        event2.end = n2;
        if (event != null) {
            event2.character = event.character;
            event2.keyCode = event.keyCode;
            event2.stateMask = event.stateMask;
        }
        if (!OS.IsUnicode && OS.IsDBLocale) {
            event2.start = this.mbcsToWcsPos(n);
            event2.end = this.mbcsToWcsPos(n2);
        }
        this.sendEvent(25, event2);
        if (!event2.doit || this.isDisposed()) {
            return null;
        }
        return event2.text;
    }

    int wcsToMbcsPos(int n) {
        if (n <= 0) {
            return 0;
        }
        if (OS.IsUnicode) {
            return n;
        }
        long l = OS.GetDlgItem(this.handle, 1001);
        if (l == 0L) {
            return n;
        }
        int n2 = OS.GetWindowTextLengthA(l);
        if (n2 == 0) {
            return 0;
        }
        byte[] byArray = new byte[n2 + 1];
        OS.GetWindowTextA(l, byArray, n2 + 1);
        int n3 = 0;
        int n4 = 0;
        while (n3 < n2) {
            if (n == n4) break;
            if (OS.IsDBCSLeadByte(byArray[n3++])) {
                ++n3;
            }
            ++n4;
        }
        return n3;
    }

    int widgetExtStyle() {
        return super.widgetExtStyle() & 0xFFEFFFFF;
    }

    int widgetStyle() {
        int n = super.widgetStyle() | 0x40 | 0x400 | 0x100000 | 0x200000;
        if ((this.style & 0x40) != 0) {
            return n | 1;
        }
        if ((this.style & 8) != 0) {
            return n | 3;
        }
        return n | 2;
    }

    TCHAR windowClass() {
        return ComboClass;
    }

    long windowProc() {
        return ComboProc;
    }

    long windowProc(long l, int n, long l2, long l3) {
        if (this.handle == 0L) {
            return 0L;
        }
        if (l != this.handle) {
            long l4 = OS.GetDlgItem(this.handle, 1001);
            long l5 = OS.GetDlgItem(this.handle, 1000);
            if (l4 != 0L && l == l4 || l5 != 0L && l == l5) {
                LRESULT lRESULT = null;
                switch (n) {
                    case 258: {
                        lRESULT = this.wmChar(l, l2, l3);
                        break;
                    }
                    case 646: {
                        lRESULT = this.wmIMEChar(l, l2, l3);
                        break;
                    }
                    case 256: {
                        lRESULT = this.wmKeyDown(l, l2, l3);
                        break;
                    }
                    case 257: {
                        lRESULT = this.wmKeyUp(l, l2, l3);
                        break;
                    }
                    case 262: {
                        lRESULT = this.wmSysChar(l, l2, l3);
                        break;
                    }
                    case 260: {
                        lRESULT = this.wmSysKeyDown(l, l2, l3);
                        break;
                    }
                    case 261: {
                        lRESULT = this.wmSysKeyUp(l, l2, l3);
                        break;
                    }
                    case 533: {
                        lRESULT = this.wmCaptureChanged(l, l2, l3);
                        break;
                    }
                    case 515: {
                        lRESULT = this.wmLButtonDblClk(l, l2, l3);
                        break;
                    }
                    case 513: {
                        lRESULT = this.wmLButtonDown(l, l2, l3);
                        break;
                    }
                    case 514: {
                        lRESULT = this.wmLButtonUp(l, l2, l3);
                        break;
                    }
                    case 521: {
                        lRESULT = this.wmMButtonDblClk(l, l2, l3);
                        break;
                    }
                    case 519: {
                        lRESULT = this.wmMButtonDown(l, l2, l3);
                        break;
                    }
                    case 520: {
                        lRESULT = this.wmMButtonUp(l, l2, l3);
                        break;
                    }
                    case 673: {
                        lRESULT = this.wmMouseHover(l, l2, l3);
                        break;
                    }
                    case 675: {
                        lRESULT = this.wmMouseLeave(l, l2, l3);
                        break;
                    }
                    case 512: {
                        lRESULT = this.wmMouseMove(l, l2, l3);
                        break;
                    }
                    case 518: {
                        lRESULT = this.wmRButtonDblClk(l, l2, l3);
                        break;
                    }
                    case 516: {
                        lRESULT = this.wmRButtonDown(l, l2, l3);
                        break;
                    }
                    case 517: {
                        lRESULT = this.wmRButtonUp(l, l2, l3);
                        break;
                    }
                    case 525: {
                        lRESULT = this.wmXButtonDblClk(l, l2, l3);
                        break;
                    }
                    case 523: {
                        lRESULT = this.wmXButtonDown(l, l2, l3);
                        break;
                    }
                    case 524: {
                        lRESULT = this.wmXButtonUp(l, l2, l3);
                        break;
                    }
                    case 15: {
                        lRESULT = this.wmPaint(l, l2, l3);
                        break;
                    }
                    case 123: {
                        lRESULT = this.wmContextMenu(l, l2, l3);
                        break;
                    }
                    case 12: 
                    case 199: 
                    case 768: 
                    case 770: 
                    case 771: 
                    case 772: {
                        if (l != l4) break;
                        lRESULT = this.wmClipboard(l, n, l2, l3);
                    }
                }
                if (lRESULT != null) {
                    return lRESULT.value;
                }
                return this.callWindowProc(l, n, l2, l3);
            }
        }
        if (n == 334 && (this.style & 8) != 0 && (this.hooks(25) || this.filters(25))) {
            String string = this.getText();
            String string2 = null;
            if (l2 == -1L) {
                string2 = "";
            } else if (0L <= l2 && l2 < (long)this.getItemCount()) {
                string2 = this.getItem((int)l2);
            }
            if (string2 != null && !string2.equals(string)) {
                int n2;
                int n3 = OS.GetWindowTextLength(this.handle);
                string = string2;
                if ((string2 = this.verifyText(string2, 0, n3, null)) == null) {
                    return 0L;
                }
                if (!string2.equals(string) && (n2 = this.indexOf(string2)) != -1 && (long)n2 != l2) {
                    return this.callWindowProc(this.handle, 334, n2, l3);
                }
            }
        }
        return super.windowProc(l, n, l2, l3);
    }

    LRESULT WM_CTLCOLOR(long l, long l2) {
        return this.wmColorChild(l, l2);
    }

    LRESULT WM_GETDLGCODE(long l, long l2) {
        long l3 = this.callWindowProc(this.handle, 135, l, l2);
        return new LRESULT(l3 | 1L);
    }

    LRESULT WM_KILLFOCUS(long l, long l2) {
        if ((this.style & 8) != 0) {
            return super.WM_KILLFOCUS(l, l2);
        }
        return null;
    }

    LRESULT WM_LBUTTONDOWN(long l, long l2) {
        int n;
        int n2 = (int)OS.SendMessage(this.handle, 327, 0L, 0L);
        LRESULT lRESULT = super.WM_LBUTTONDOWN(l, l2);
        if (lRESULT == LRESULT.ZERO) {
            return lRESULT;
        }
        if ((this.style & 8) == 0 && n2 != (n = (int)OS.SendMessage(this.handle, 327, 0L, 0L))) {
            this.sendEvent(24);
            if (this.isDisposed()) {
                return LRESULT.ZERO;
            }
            this.sendEvent(13);
            if (this.isDisposed()) {
                return LRESULT.ZERO;
            }
        }
        return lRESULT;
    }

    LRESULT WM_SETFOCUS(long l, long l2) {
        return null;
    }

    LRESULT WM_SIZE(long l, long l2) {
        if (this.ignoreResize) {
            return null;
        }
        if ((this.style & 0x40) != 0) {
            LRESULT lRESULT = super.WM_SIZE(l, l2);
            if (OS.IsWindowVisible(this.handle)) {
                if (OS.IsWinCE) {
                    long l3;
                    long l4 = OS.GetDlgItem(this.handle, 1001);
                    if (l4 != 0L) {
                        OS.InvalidateRect(l4, null, true);
                    }
                    if ((l3 = OS.GetDlgItem(this.handle, 1000)) != 0L) {
                        OS.InvalidateRect(l3, null, true);
                    }
                } else {
                    int n = 133;
                    OS.RedrawWindow(this.handle, null, 0L, n);
                }
            }
            return lRESULT;
        }
        if ((this.style & 8) == 0) {
            this.lockText = true;
        }
        LRESULT lRESULT = super.WM_SIZE(l, l2);
        if ((this.style & 8) == 0) {
            this.lockText = false;
        }
        if ((this.style & 0x100) != 0) {
            this.setScrollWidth(this.scrollWidth);
        }
        return lRESULT;
    }

    LRESULT WM_WINDOWPOSCHANGING(long l, long l2) {
        LRESULT lRESULT = super.WM_WINDOWPOSCHANGING(l, l2);
        if (lRESULT != null) {
            return lRESULT;
        }
        if (OS.IsWinCE) {
            return lRESULT;
        }
        if (!this.getDrawing()) {
            return lRESULT;
        }
        if (!OS.IsWindowVisible(this.handle)) {
            return lRESULT;
        }
        if (this.ignoreResize) {
            WINDOWPOS wINDOWPOS = new WINDOWPOS();
            OS.MoveMemory(wINDOWPOS, l2, WINDOWPOS.sizeof);
            if ((wINDOWPOS.flags & 1) == 0) {
                wINDOWPOS.flags |= 8;
                OS.MoveMemory(l2, wINDOWPOS, WINDOWPOS.sizeof);
                OS.InvalidateRect(this.handle, null, true);
                RECT rECT = new RECT();
                OS.GetWindowRect(this.handle, rECT);
                int n = rECT.right - rECT.left;
                int n2 = rECT.bottom - rECT.top;
                if (n != 0 && n2 != 0) {
                    long l3 = this.parent.handle;
                    long l4 = OS.GetWindow(l3, 5);
                    OS.MapWindowPoints(0L, l3, rECT, 2);
                    long l5 = OS.CreateRectRgn(rECT.left, rECT.top, rECT.right, rECT.bottom);
                    while (l4 != 0L) {
                        if (l4 != this.handle) {
                            OS.GetWindowRect(l4, rECT);
                            OS.MapWindowPoints(0L, l3, rECT, 2);
                            long l6 = OS.CreateRectRgn(rECT.left, rECT.top, rECT.right, rECT.bottom);
                            OS.CombineRgn(l5, l5, l6, 4);
                            OS.DeleteObject(l6);
                        }
                        l4 = OS.GetWindow(l4, 2);
                    }
                    int n3 = 1029;
                    OS.RedrawWindow(l3, null, l5, n3);
                    OS.DeleteObject(l5);
                }
            }
        }
        return lRESULT;
    }

    LRESULT wmChar(long l, long l2, long l3) {
        if (this.ignoreCharacter) {
            return null;
        }
        LRESULT lRESULT = super.wmChar(l, l2, l3);
        if (lRESULT != null) {
            return lRESULT;
        }
        switch ((int)l2) {
            case 9: {
                return LRESULT.ZERO;
            }
            case 13: {
                if (!this.ignoreDefaultSelection) {
                    this.postEvent(14);
                }
                this.ignoreDefaultSelection = false;
            }
            case 27: {
                if ((this.style & 4) == 0 || OS.SendMessage(this.handle, 343, 0L, 0L) != 0L) break;
                return LRESULT.ZERO;
            }
        }
        return lRESULT;
    }

    LRESULT wmClipboard(long l, int n, long l2, long l3) {
        Object object;
        if ((this.style & 8) != 0) {
            return null;
        }
        if (!this.hooks(25) && !this.filters(25)) {
            return null;
        }
        boolean bl = false;
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        String string = null;
        switch (n) {
            case 768: 
            case 771: {
                OS.SendMessage(l, 176, nArray, nArray2);
                if (nArray[0] == nArray2[0]) break;
                string = "";
                bl = true;
                break;
            }
            case 770: {
                OS.SendMessage(l, 176, nArray, nArray2);
                string = this.getClipboardText();
                break;
            }
            case 199: 
            case 772: {
                if (OS.SendMessage(l, 198, 0L, 0L) == 0L) break;
                this.ignoreModify = true;
                OS.CallWindowProc(EditProc, l, n, l2, l3);
                int n2 = OS.GetWindowTextLength(l);
                object = new int[1];
                int[] nArray3 = new int[1];
                OS.SendMessage(l, 176, (int[])object, nArray3);
                if (n2 != 0 && object[0] != nArray3[0]) {
                    TCHAR tCHAR = new TCHAR(this.getCodePage(), n2 + 1);
                    OS.GetWindowText(l, tCHAR, n2 + 1);
                    string = tCHAR.toString((int)object[0], nArray3[0] - object[0]);
                } else {
                    string = "";
                }
                OS.CallWindowProc(EditProc, l, n, l2, l3);
                OS.SendMessage(l, 176, nArray, nArray2);
                this.ignoreModify = false;
                break;
            }
            case 12: {
                nArray2[0] = OS.GetWindowTextLength(l);
                int n2 = OS.IsUnicode ? OS.wcslen(l3) : OS.strlen(l3);
                object = new TCHAR(this.getCodePage(), n2);
                int n3 = ((TCHAR)object).length() * TCHAR.sizeof;
                OS.MoveMemory((TCHAR)object, l3, n3);
                string = ((TCHAR)object).toString(0, n2);
            }
        }
        if (string != null) {
            String string2 = string;
            if ((string = this.verifyText(string, nArray[0], nArray2[0], null)) == null) {
                return LRESULT.ZERO;
            }
            if (!string.equals(string2)) {
                if (bl) {
                    OS.CallWindowProc(EditProc, l, n, l2, l3);
                }
                object = new TCHAR(this.getCodePage(), string, true);
                if (n == 12) {
                    long l4 = OS.GetProcessHeap();
                    int n4 = ((TCHAR)object).length() * TCHAR.sizeof;
                    long l5 = OS.HeapAlloc(l4, 8, n4);
                    OS.MoveMemory(l5, (TCHAR)object, n4);
                    long l6 = OS.CallWindowProc(EditProc, l, n, l2, l5);
                    OS.HeapFree(l4, 0, l5);
                    return new LRESULT(l6);
                }
                OS.SendMessage(l, 194, 0L, (TCHAR)object);
                return LRESULT.ZERO;
            }
        }
        return null;
    }

    LRESULT wmCommandChild(long l, long l2) {
        int n = OS.HIWORD(l);
        switch (n) {
            case 5: {
                if (this.ignoreModify) break;
                this.noSelection = true;
                this.sendEvent(24);
                if (this.isDisposed()) {
                    return LRESULT.ZERO;
                }
                this.noSelection = false;
                break;
            }
            case 1: {
                int n2 = (int)OS.SendMessage(this.handle, 327, 0L, 0L);
                if (n2 != -1) {
                    OS.SendMessage(this.handle, 334, (long)n2, 0L);
                }
                this.sendEvent(24);
                if (this.isDisposed()) {
                    return LRESULT.ZERO;
                }
                this.postEvent(13);
                break;
            }
            case 3: {
                this.sendFocusEvent(15);
                if (!this.isDisposed()) break;
                return LRESULT.ZERO;
            }
            case 4: {
                if ((this.style & 8) != 0) break;
                this.sendFocusEvent(16);
                if (!this.isDisposed()) break;
                return LRESULT.ZERO;
            }
        }
        return super.wmCommandChild(l, l2);
    }

    LRESULT wmIMEChar(long l, long l2, long l3) {
        Display display = this.display;
        display.lastKey = 0;
        display.lastAscii = (int)l2;
        display.lastDead = false;
        display.lastNull = false;
        display.lastVirtual = false;
        if (!this.sendKeyEvent(1, 646, l2, l3)) {
            return LRESULT.ZERO;
        }
        this.ignoreCharacter = true;
        long l4 = this.callWindowProc(l, 646, l2, l3);
        MSG mSG = new MSG();
        int n = 10420227;
        while (OS.PeekMessage(mSG, l, 258, 258, n)) {
            OS.TranslateMessage(mSG);
            OS.DispatchMessage(mSG);
        }
        this.ignoreCharacter = false;
        this.sendKeyEvent(2, 646, l2, l3);
        display.lastAscii = 0;
        display.lastKey = 0;
        return new LRESULT(l4);
    }

    LRESULT wmKeyDown(long l, long l2, long l3) {
        if (this.ignoreCharacter) {
            return null;
        }
        LRESULT lRESULT = super.wmKeyDown(l, l2, l3);
        if (lRESULT != null) {
            return lRESULT;
        }
        this.ignoreDefaultSelection = false;
        if (l2 == 13L && (this.style & 4) != 0 && OS.SendMessage(this.handle, 343, 0L, 0L) != 0L) {
            this.ignoreDefaultSelection = true;
        }
        return lRESULT;
    }

    LRESULT wmSysKeyDown(long l, long l2, long l3) {
        int n = (int)OS.SendMessage(this.handle, 327, 0L, 0L);
        LRESULT lRESULT = super.wmSysKeyDown(l, l2, l3);
        if (lRESULT != null) {
            return lRESULT;
        }
        if ((this.style & 8) == 0 && l2 == 40L) {
            long l4 = this.callWindowProc(l, 260, l2, l3);
            int n2 = (int)OS.SendMessage(this.handle, 327, 0L, 0L);
            if (n != n2) {
                this.sendEvent(24);
                if (this.isDisposed()) {
                    return LRESULT.ZERO;
                }
                this.sendEvent(13);
                if (this.isDisposed()) {
                    return LRESULT.ZERO;
                }
            }
            return new LRESULT(l4);
        }
        return lRESULT;
    }
}

