/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdkstats;

import com.android.prefs.AndroidLocation;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;

public class SdkStatsService {
    private static final long PING_INTERVAL_MSEC = 86400000L;
    private static final String WINDOW_TITLE_TEXT = "Android SDK";
    private static final String HEADER_TEXT = "Thanks for using the Android SDK!";
    private static final String NOTICE_TEXT = "We know you just want to get started but please read this first.";
    public static final String BODY_TEXT = "By choosing to send certain usage statistics to Google, you can help us improve the Android SDK.  These usage statistics let us measure things like active usage of the SDK and let us know things like which versions of the SDK are in use and which tools are the most popular with developers.  This limited data is not associated with personal information about you, is examined on an aggregate basis, and is maintained in accordance with the <a href=\"http://www.google.com/intl/en/privacy.html\">Google Privacy Policy</a>.";
    public static final String CHECKBOX_TEXT = "Send usage statistics to Google.";
    private static final String FOOTER_TEXT = "If you later decide to change this setting, you can do so in the \"ddms\" tool under \"File\" > \"Preferences\" > \"Usage Stats\".";
    private static final String BUTTON_TEXT = "   Proceed   ";
    private static final String[] LINUX_BROWSERS = new String[]{"firefox -remote openurl(%URL%,new-window)", "mozilla -remote openurl(%URL%,new-window)", "firefox %URL%", "mozilla %URL%", "kfmclient openURL %URL%", "opera -newwindow %URL%"};
    public static final String PING_OPT_IN = "pingOptIn";
    public static final String PING_TIME = "pingTime";
    public static final String PING_ID = "pingId";
    private static PreferenceStore sPrefStore;

    public static void ping(final String app, String version, Display display) {
        final String normalVersion = SdkStatsService.normalizeVersion(app, version);
        PreferenceStore prefs = SdkStatsService.getPreferenceStore();
        if (prefs != null) {
            long then;
            if (!prefs.contains(PING_ID)) {
                prefs.setValue(PING_ID, new Random().nextLong());
                prefs.setValue(PING_OPT_IN, SdkStatsService.getUserPermission(display));
                try {
                    prefs.save();
                }
                catch (IOException ioe) {
                    // empty catch block
                }
            }
            if (!prefs.getBoolean(PING_OPT_IN)) {
                return;
            }
            String timePref = "pingTime." + app;
            long now = System.currentTimeMillis();
            if (now - (then = prefs.getLong(timePref)) < 86400000L) {
                return;
            }
            prefs.setValue(timePref, now);
            try {
                prefs.save();
            }
            catch (IOException ioe) {
                // empty catch block
            }
            final long id = prefs.getLong(PING_ID);
            new Thread(){

                public void run() {
                    try {
                        SdkStatsService.actuallySendPing(app, normalVersion, id);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }.start();
        }
    }

    public static synchronized PreferenceStore getPreferenceStore() {
        if (sPrefStore == null) {
            String homeDir = null;
            try {
                homeDir = AndroidLocation.getFolder();
            }
            catch (AndroidLocation.AndroidLocationException e1) {
                // empty catch block
            }
            if (homeDir != null) {
                String rcFileName = homeDir + "ddms.cfg";
                String oldPrefPath = System.getProperty("user.home") + File.separator + ".ddmsrc";
                File oldPrefFile = new File(oldPrefPath);
                if (oldPrefFile.isFile()) {
                    try {
                        PreferenceStore oldStore = new PreferenceStore(oldPrefPath);
                        oldStore.load();
                        oldStore.save((OutputStream)new FileOutputStream(rcFileName), "");
                        oldPrefFile.delete();
                        PreferenceStore newStore = new PreferenceStore(rcFileName);
                        newStore.load();
                        sPrefStore = newStore;
                    }
                    catch (IOException e) {
                        sPrefStore = new PreferenceStore(rcFileName);
                    }
                } else {
                    sPrefStore = new PreferenceStore(rcFileName);
                    try {
                        sPrefStore.load();
                    }
                    catch (IOException e) {
                        System.err.println("Error Loading Preferences");
                    }
                }
            } else {
                sPrefStore = new PreferenceStore();
            }
        }
        return sPrefStore;
    }

    private static void actuallySendPing(String app, String version, long id) throws IOException {
        String osVers;
        String os = System.getProperty("os.name");
        if (os.startsWith("Mac OS")) {
            os = "mac";
            osVers = SdkStatsService.getVersion();
            if (osVers != null) {
                os = os + "-" + osVers;
            }
        } else if (os.startsWith("Windows")) {
            os = "win";
            osVers = SdkStatsService.getVersion();
            if (osVers != null) {
                os = os + "-" + osVers;
            }
        } else {
            os = os.startsWith("Linux") ? "linux" : URLEncoder.encode(os);
        }
        URL url = new URL("http", "tools.google.com", "/service/update?as=androidsdk_" + app + "&id=" + Long.toHexString(id) + "&version=" + version + "&os=" + os);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        if (conn.getResponseCode() != 200 && conn.getResponseCode() != 404) {
            throw new IOException(conn.getResponseMessage() + ": " + url);
        }
    }

    private static String getVersion() {
        String osVers;
        Pattern p = Pattern.compile("(\\d+)\\.(\\d+).*");
        Matcher m = p.matcher(osVers = System.getProperty("os.version"));
        if (m.matches()) {
            return m.group(1) + "." + m.group(2);
        }
        return null;
    }

    private static boolean getUserPermission(Display display) {
        final boolean[] permission = new boolean[]{false};
        boolean dispose = false;
        if (display == null) {
            display = new Display();
            dispose = true;
        }
        final Display currentDisplay = display;
        final boolean disposeDisplay = dispose;
        display.syncExec(new Runnable(){

            public void run() {
                final Shell shell = new Shell(currentDisplay, 2080);
                shell.setText(SdkStatsService.WINDOW_TITLE_TEXT);
                shell.setLayout((Layout)new GridLayout(1, false));
                Label title = new Label((Composite)shell, 0x1000040);
                FontData[] fontdata = title.getFont().getFontData();
                for (int i = 0; i < fontdata.length; ++i) {
                    fontdata[i].setHeight(fontdata[i].getHeight() * 4 / 3);
                }
                title.setFont(new Font((Device)currentDisplay, fontdata));
                title.setLayoutData((Object)new GridData(768));
                title.setText(SdkStatsService.HEADER_TEXT);
                Label notice = new Label((Composite)shell, 64);
                notice.setFont(title.getFont());
                notice.setForeground(new Color((Device)currentDisplay, 255, 0, 0));
                notice.setLayoutData((Object)new GridData(768));
                notice.setText(SdkStatsService.NOTICE_TEXT);
                Link text = new Link((Composite)shell, 64);
                text.setLayoutData((Object)new GridData(768));
                text.setText(SdkStatsService.BODY_TEXT);
                text.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent event) {
                        SdkStatsService.openUrl(event.text);
                    }
                });
                final Button checkbox = new Button((Composite)shell, 32);
                checkbox.setSelection(true);
                checkbox.setText(SdkStatsService.CHECKBOX_TEXT);
                Link footer = new Link((Composite)shell, 64);
                footer.setLayoutData((Object)new GridData(768));
                footer.setText(SdkStatsService.FOOTER_TEXT);
                Button button = new Button((Composite)shell, 8);
                button.setLayoutData((Object)new GridData(64));
                button.setText(SdkStatsService.BUTTON_TEXT);
                button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent event) {
                        permission[0] = checkbox.getSelection();
                        shell.close();
                    }
                });
                Point size = shell.computeSize(450, -1, true);
                Rectangle screen = currentDisplay.getClientArea();
                shell.setBounds(screen.x + screen.width / 2 - size.x / 2, screen.y + screen.height / 2 - size.y / 2, size.x, size.y);
                shell.open();
                while (!shell.isDisposed()) {
                    if (currentDisplay.readAndDispatch()) continue;
                    currentDisplay.sleep();
                }
                if (disposeDisplay) {
                    currentDisplay.dispose();
                }
            }
        });
        return permission[0];
    }

    public static void openUrl(final String url) {
        if (!Program.launch((String)url)) {
            new Thread(){

                public void run() {
                    for (String cmd : LINUX_BROWSERS) {
                        cmd = cmd.replaceAll("%URL%", url);
                        try {
                            Process proc = Runtime.getRuntime().exec(cmd);
                            if (proc.waitFor() != 0) continue;
                            break;
                        }
                        catch (InterruptedException e) {
                            throw new RuntimeException(e);
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                    }
                }
            }.start();
        }
    }

    private static String normalizeVersion(String app, String version) {
        if (!app.matches("\\w+")) {
            throw new IllegalArgumentException("Bad app name: " + app);
        }
        String[] numbers = version.split("\\.");
        if (numbers.length > 4) {
            throw new IllegalArgumentException("Bad version: " + version);
        }
        for (String part : numbers) {
            if (part.matches("\\d+")) continue;
            throw new IllegalArgumentException("Bad version: " + version);
        }
        StringBuffer normal = new StringBuffer(numbers[0]);
        for (int i = 1; i < 4; ++i) {
            normal.append(".").append(i < numbers.length ? numbers[i] : "0");
        }
        return normal.toString();
    }
}

